/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.nio.file.Path;
import java.util.List;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.bundle.AbstractIpsBundleContentIndex;
import org.faktorips.devtools.model.internal.ipsproject.bundle.FolderExplorer;

public class IpsFolderBundleContentIndex
extends AbstractIpsBundleContentIndex {
    private final FolderExplorer explorer;
    private final Path bundleRoot;

    public IpsFolderBundleContentIndex(Path bundleRoot, List<Path> modelFolders) {
        this(modelFolders, bundleRoot, new FolderExplorer());
    }

    protected IpsFolderBundleContentIndex(List<Path> modelFolders, Path bundleRoot, FolderExplorer folderExplorer) {
        this.bundleRoot = bundleRoot;
        this.explorer = folderExplorer;
        this.initFolderStructure(modelFolders, bundleRoot);
    }

    private void initFolderStructure(List<Path> modelFolders, Path bundleRoot) {
        for (Path relativeModelFolder : modelFolders) {
            Path absoluteModelFolder = bundleRoot.resolve(relativeModelFolder);
            this.registerFolder(absoluteModelFolder, relativeModelFolder);
        }
    }

    private void registerFolders(List<Path> absoluteFolders, Path relativeModelPath) {
        for (Path absoluteFolder : absoluteFolders) {
            this.registerFolder(absoluteFolder, relativeModelPath);
        }
    }

    private void registerFolder(Path absoluteFolder, Path relativeModelPath) {
        this.registerPaths(absoluteFolder, relativeModelPath);
        this.registerFolders(this.explorer.getFolders(absoluteFolder), relativeModelPath);
    }

    private void registerPaths(Path absolutePathToFolder, Path relativeModelFolder) {
        List<Path> files = this.explorer.getFiles(absolutePathToFolder);
        for (Path file : files) {
            Path relativeFilePath = PathUtil.makeRelativeTo((Path)file, (Path)this.bundleRoot.resolve(relativeModelFolder));
            this.registerPath(relativeModelFolder, relativeFilePath);
        }
    }
}

