/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.IpsBundleManifest;
import org.faktorips.devtools.model.internal.ipsproject.bundle.AbstractIpsBundle;
import org.faktorips.devtools.model.internal.ipsproject.bundle.IpsJarBundleContentIndex;
import org.faktorips.devtools.model.internal.ipsproject.bundle.JarFileFactory;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.StreamUtil;

public class IpsJarBundle
extends AbstractIpsBundle {
    private final JarFileFactory jarFileFactory;

    public IpsJarBundle(IIpsProject ipsProject, JarFileFactory jarFileFactory) {
        super(ipsProject);
        this.jarFileFactory = jarFileFactory;
    }

    JarFile getJarFile() throws IOException {
        return this.jarFileFactory.createJarFile();
    }

    JarFile getJarFileThrowingRuntimeException() {
        try {
            return this.getJarFile();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    @Override
    public void initBundle() throws IOException {
        JarFile jarFile = this.getJarFile();
        Manifest manifest = jarFile.getManifest();
        if (manifest != null) {
            this.setBundleManifest(new IpsBundleManifest(manifest));
            this.setBundleContentIndex(new IpsJarBundleContentIndex(jarFile, this.getBundleManifest().getObjectDirs()));
        }
    }

    void throwExceptionWhenNotFound(ZipEntry zipEntry, Path path) {
        if (zipEntry == null) {
            throw new IpsException("There is no entry " + path + " in " + this.getLocation());
        }
    }

    InputStream getInputStream(JarFile jarFile, ZipEntry zipEntry) {
        InputStream inputStream = null;
        try {
            inputStream = jarFile.getInputStream(zipEntry);
            return StreamUtil.copy((InputStream)inputStream);
        }
        catch (IOException e) {
            throw this.newRuntimeException("Error while reading jar file " + this.getLocation(), e);
        }
    }

    private RuntimeException newRuntimeException(String message, IOException e) {
        return new RuntimeException(message, e);
    }

    @Override
    public Path getLocation() {
        return this.jarFileFactory.getJarPath();
    }

    @Override
    protected InputStream getResourceAsStream(Path path) {
        JarFile jarFile = this.getJarFileThrowingRuntimeException();
        try {
            String portablePath = PathUtil.toPortableString((Path)path);
            ZipEntry zipEntry = portablePath == null ? null : jarFile.getEntry(portablePath);
            this.throwExceptionWhenNotFound(zipEntry, path);
            InputStream inputStream = this.getInputStream(jarFile, zipEntry);
            return inputStream;
        }
        finally {
            this.jarFileFactory.closeJarFile();
        }
    }

    @Override
    public boolean isFolder() {
        return false;
    }

    public String toString() {
        return this.getLocation().toString();
    }

    @Override
    public Path getResourcePath(Path element) {
        return this.getRootFolder(element).resolve(element);
    }
}

