/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.nio.file.Path;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.Assert;
import org.faktorips.devtools.abstraction.util.PathUtil;
import org.faktorips.devtools.model.internal.ipsproject.bundle.AbstractIpsBundleContentIndex;

public class IpsJarBundleContentIndex
extends AbstractIpsBundleContentIndex {
    public IpsJarBundleContentIndex(JarFile jarFile, List<Path> modelFolders) {
        Assert.isNotNull((Object)jarFile, (String)"jarFile must not be null");
        Assert.isNotNull(modelFolders, (String)"modelFolders must not be null");
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            this.registerJarEntry(jarEntry, modelFolders);
        }
    }

    private final void registerJarEntry(JarEntry jarEntry, List<Path> modelFolders) {
        String pathToFile = jarEntry.getName();
        Path path = Path.of(pathToFile, new String[0]);
        this.registerPath(path, modelFolders);
    }

    protected final void registerPath(Path path, List<Path> modelFolders) {
        for (Path modelPath : modelFolders) {
            if (!path.startsWith(modelPath)) continue;
            Path relativePath = PathUtil.makeRelativeTo((Path)path, (Path)modelPath);
            this.registerPath(modelPath, relativePath);
            return;
        }
    }
}

