/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.bundle;

import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarFile;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.Abstractions;

public class JarFileFactory {
    private static final boolean TRACE_JAR_FILES = Boolean.parseBoolean(Abstractions.getDebugOption((String)"org.faktorips.devtools.model/trace/jarfiles"));
    private static final Map<Path, OpenedJar> CACHE = new ConcurrentHashMap<Path, OpenedJar>();
    private static final int DEFAULT_DELAY_TIME = 5000;
    private static int closeDelay = 5000;
    private final Path jarPath;

    public JarFileFactory(Path jarPath) {
        this.jarPath = jarPath;
    }

    protected void setCloseDelay(int ms) {
        closeDelay = ms;
    }

    public Path getJarPath() {
        return this.jarPath;
    }

    public synchronized JarFile createJarFile() throws IOException {
        OpenedJar openedJar = CACHE.get(this.getJarPath());
        if (openedJar == null) {
            JarFile jarFile = new JarFile(this.getAbsolutePath(this.getJarPath()).toFile());
            openedJar = new OpenedJar(jarFile);
            CACHE.put(this.getJarPath(), openedJar);
            this.trace(MessageFormat.format("Open {0}.", jarFile.getName()));
        }
        return openedJar.getJarFile();
    }

    private void trace(String message) {
        if (TRACE_JAR_FILES) {
            System.out.println("JarFileFactory: " + message);
        }
    }

    Path getAbsolutePath(Path bundlePath) {
        if (this.isWorkspaceRelativePath(bundlePath)) {
            return this.getWorkspaceRelativePath(bundlePath);
        }
        return bundlePath;
    }

    private boolean isWorkspaceRelativePath(Path bundlePath) {
        return Abstractions.getWorkspace().getRoot().getFile(bundlePath).exists();
    }

    private Path getWorkspaceRelativePath(Path bundlePath) {
        AFile file = Abstractions.getWorkspace().getRoot().getFile(bundlePath);
        return file.getLocation();
    }

    public synchronized void closeJarFile() {
        OpenedJar openedJar = CACHE.get(this.getJarPath());
        if (openedJar != null) {
            openedJar.close();
        }
    }

    private class OpenedJar {
        private final JarFile jarFile;
        private volatile long lastCallToClose;
        private volatile Closer closer;

        public OpenedJar(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        public synchronized JarFile getJarFile() {
            if (this.closer != null) {
                JarFileFactory.this.trace(MessageFormat.format("Received a reopen request for {0}. Delaying close.", this.jarFile.getName()));
                this.closer.dontCloseYet();
            }
            return this.jarFile;
        }

        public synchronized void close() {
            JarFileFactory.this.trace(MessageFormat.format("Received close for {0}. Wait {1} ms before doing so.", this.jarFile.getName(), closeDelay));
            this.lastCallToClose = System.currentTimeMillis();
            if (this.closer == null) {
                this.closer = new Closer();
                new Thread((Runnable)this.closer, "Closer for " + this.jarFile.getName()).start();
            } else {
                this.closer.closeIsOkForMe();
            }
        }

        private class Closer
        implements Runnable {
            private AtomicInteger opened = new AtomicInteger(0);

            private Closer() {
            }

            @Override
            public void run() {
                while (true) {
                    if (this.opened.get() <= 0 && OpenedJar.this.lastCallToClose + (long)closeDelay <= System.currentTimeMillis()) {
                        try {
                            OpenedJar.this.jarFile.close();
                            CACHE.remove(((OpenedJar)OpenedJar.this).JarFileFactory.this.jarPath);
                            JarFileFactory.this.trace(MessageFormat.format("Finally closing {0}.", OpenedJar.this.jarFile.getName()));
                            break;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    try {
                        Thread.sleep(closeDelay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }

            protected void dontCloseYet() {
                this.opened.incrementAndGet();
            }

            protected void closeIsOkForMe() {
                this.opened.decrementAndGet();
            }
        }
    }
}

