/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.faktorips.devtools.abstraction.AResourceDelta;
import org.faktorips.devtools.model.IIpsSrcFilesChangeListener;
import org.faktorips.devtools.model.IpsSrcFilesChangedEvent;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.MultiMap;

public abstract class ProductCmptCache {
    private final IIpsProject ipsProject;
    private final MultiMap<String, IIpsSrcFile> prodCmptIpsSrcFilesMap = new MultiMap();
    private final IIpsSrcFilesChangeListener addRemovelistener;
    private State state = State.NEW;

    public ProductCmptCache(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
        this.addRemovelistener = new AddRemoveUpdater(this);
        ipsProject.getIpsModel().addIpsSrcFilesChangedListener(this.addRemovelistener);
    }

    protected abstract String getKey(IIpsSrcFile var1);

    protected synchronized void addProductCmpt(IIpsSrcFile productCmpt) {
        String key = this.getKey(productCmpt);
        if (!this.prodCmptIpsSrcFilesMap.get((Object)key).contains(productCmpt)) {
            this.prodCmptIpsSrcFilesMap.put((Object)key, (Object[])new IIpsSrcFile[]{productCmpt});
        }
    }

    protected synchronized void removeProductCmpt(IIpsSrcFile productCmpt) {
        for (String key : this.prodCmptIpsSrcFilesMap.keySet()) {
            this.prodCmptIpsSrcFilesMap.remove((Object)key, (Object)productCmpt);
        }
    }

    protected synchronized void removeProductCmpt(String key, IIpsSrcFile productCmpt) {
        this.prodCmptIpsSrcFilesMap.remove((Object)key, (Object)productCmpt);
    }

    protected synchronized Collection<IIpsSrcFile> findProductCmptsByKey(String key) {
        if (key == null) {
            return Collections.emptyList();
        }
        this.checkedInit(key);
        return this.prodCmptIpsSrcFilesMap.get((Object)key);
    }

    private synchronized void checkedInit(String key) {
        if (this.requiresInit(key)) {
            this.init();
        }
    }

    private synchronized boolean requiresInit(String key) {
        return this.state != State.INITIALIZED || this.containsNonexistantFiles(key);
    }

    private synchronized boolean containsNonexistantFiles(String key) {
        for (IIpsSrcFile ipsSrcFile : this.prodCmptIpsSrcFilesMap.get((Object)key)) {
            if (ipsSrcFile.exists()) continue;
            return true;
        }
        return false;
    }

    private synchronized void init() {
        this.prodCmptIpsSrcFilesMap.clear();
        List<IIpsSrcFile> allProdCmptIpsSrcFiles = this.ipsProject.findAllIpsSrcFiles(IpsObjectType.PRODUCT_CMPT);
        for (IIpsSrcFile ipsSrcFile : allProdCmptIpsSrcFiles) {
            this.addProductCmpt(ipsSrcFile);
        }
        this.state = State.INITIALIZED;
    }

    public synchronized void clear() {
        this.prodCmptIpsSrcFilesMap.clear();
        this.state = State.NEW;
    }

    public void dispose() {
        this.ipsProject.getIpsModel().removeIpsSrcFilesChangedListener(this.addRemovelistener);
    }

    protected IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    private static final class AddRemoveUpdater
    implements IIpsSrcFilesChangeListener {
        private ProductCmptCache cache;

        public AddRemoveUpdater(ProductCmptCache cache) {
            this.cache = cache;
        }

        @Override
        public void ipsSrcFilesChanged(IpsSrcFilesChangedEvent event) {
            Set<IIpsSrcFile> changedIpsSrcFiles = event.getChangedIpsSrcFiles();
            for (IIpsSrcFile ipsSrcFile : changedIpsSrcFiles) {
                if (!this.isRelevantIpsSrcFile(ipsSrcFile)) continue;
                if (this.isAdd(this.getDelta(event, ipsSrcFile))) {
                    this.cache.addProductCmpt(ipsSrcFile);
                    continue;
                }
                if (!this.isRemove(this.getDelta(event, ipsSrcFile))) continue;
                this.cache.removeProductCmpt(ipsSrcFile);
            }
        }

        private boolean isRelevantIpsSrcFile(IIpsSrcFile ipsSrcFile) {
            return this.isProductCmptSrcFile(ipsSrcFile) && ipsSrcFile.getIpsProject().equals(this.cache.ipsProject);
        }

        private boolean isProductCmptSrcFile(IIpsSrcFile ipsSrcFile) {
            return IpsObjectType.PRODUCT_CMPT.equals(ipsSrcFile.getIpsObjectType());
        }

        private AResourceDelta getDelta(IpsSrcFilesChangedEvent event, IIpsSrcFile ipsSrcFile) {
            return event.getResourceDelta(ipsSrcFile);
        }

        private boolean isAdd(AResourceDelta delta) {
            return delta.getKind() == AResourceDelta.AResourceDeltaKind.ADDED;
        }

        private boolean isRemove(AResourceDelta delta) {
            return delta.getKind() == AResourceDelta.AResourceDeltaKind.REMOVED;
        }
    }

    private static enum State {
        NEW,
        INITIALIZED;

    }
}

