/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.cache;

import java.util.Collection;
import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.ContentsChangeListener;
import org.faktorips.devtools.model.internal.ipsproject.cache.ProductCmptCache;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

public class RuntimeIdCache
extends ProductCmptCache {
    private final ContentsChangeListener changeListener = this::update;

    public RuntimeIdCache(IIpsProject ipsProject) {
        super(ipsProject);
        ipsProject.getIpsModel().addChangeListener(this.changeListener);
    }

    public Collection<IIpsSrcFile> findProductCmptByRuntimeId(String runtimeId) {
        return super.findProductCmptsByKey(runtimeId);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getIpsProject().getIpsModel().removeChangeListener(this.changeListener);
    }

    @Override
    protected String getKey(IIpsSrcFile productCmpt) {
        return productCmpt.getPropertyValue("runtimeId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ContentChangeEvent event) {
        IIpsSrcFile file = event.getIpsSrcFile();
        if (this.isRelevantIpsSrcFile(file)) {
            if (event.getEventType() == 1) {
                RuntimeIdCache runtimeIdCache = this;
                synchronized (runtimeIdCache) {
                    this.removeProductCmpt(file);
                    this.addProductCmpt(file);
                }
            } else {
                event.getPropertyChangeEvents().stream().filter(e -> "runtimeId".equals(e.getPropertyName())).forEach(e -> {
                    RuntimeIdCache runtimeIdCache = this;
                    synchronized (runtimeIdCache) {
                        this.removeProductCmpt((String)e.getOldValue(), event.getIpsSrcFile());
                        this.addProductCmpt(event.getIpsSrcFile());
                    }
                });
            }
        }
    }

    private boolean isRelevantIpsSrcFile(IIpsSrcFile ipsSrcFile) {
        return this.isProductCmptSrcFile(ipsSrcFile) && ipsSrcFile.getIpsProject().equals(this.getIpsProject());
    }

    private boolean isProductCmptSrcFile(IIpsSrcFile ipsSrcFile) {
        return IpsObjectType.PRODUCT_CMPT.equals(ipsSrcFile.getIpsObjectType());
    }
}

