/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.devtools.model.internal.ipsproject.cache.TableContentsStructureCacheUpdater;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.MultiMap;

public class TableContentsStructureCache {
    private volatile State state = State.NEW;
    private final TableStructureMap tableStructureMap = new TableStructureMap();
    private final IIpsProject ipsProject;
    private final TableContentsStructureCacheUpdater updater;

    public TableContentsStructureCache(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        this.ipsProject = ipsProject;
        this.updater = new TableContentsStructureCacheUpdater(this, ipsProject);
        ipsProject.getIpsModel().addIpsSrcFilesChangedListener(this.updater);
    }

    public void dispose() {
        this.ipsProject.getIpsModel().removeIpsSrcFilesChangedListener(this.updater);
    }

    public List<IIpsSrcFile> getTableContents(IIpsSrcFile tableStructure) {
        this.checkedInit();
        return new ArrayList<IIpsSrcFile>(this.tableStructureMap.get(tableStructure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkedInit() {
        if (this.state != State.INITIALIZED) {
            TableContentsStructureCache tableContentsStructureCache = this;
            synchronized (tableContentsStructureCache) {
                if (this.state != State.INITIALIZED) {
                    this.init();
                    this.state = State.INITIALIZED;
                }
            }
        }
    }

    public void init() {
        List<IIpsSrcFile> tableContents = this.ipsProject.findAllIpsSrcFiles(IpsObjectType.TABLE_CONTENTS);
        this.putAllTableContents(tableContents);
    }

    public void clear() {
        this.checkedClear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkedClear() {
        if (this.state != State.NEW) {
            TableContentsStructureCache tableContentsStructureCache = this;
            synchronized (tableContentsStructureCache) {
                if (this.state != State.NEW) {
                    this.tableStructureMap.clear();
                    this.state = State.NEW;
                }
            }
        }
    }

    protected boolean isNew() {
        return this.state == State.NEW;
    }

    protected boolean isInitialized() {
        return this.state == State.INITIALIZED;
    }

    private void putAllTableContents(Collection<IIpsSrcFile> tableContents) {
        for (IIpsSrcFile tableContent : tableContents) {
            this.putTableContent(tableContent);
        }
    }

    public void newTableStructure(IIpsSrcFile tableStructure) {
        for (IIpsSrcFile tableContent : this.tableStructureMap.contentWithInvlidStructure) {
            String tableStructureName = this.getTableStructureName(tableContent);
            if (!Objects.equals(tableStructure.getIpsObjectName(), tableStructureName)) continue;
            this.putTableContent(tableContent);
        }
    }

    public void putTableContent(IIpsSrcFile tableContent) {
        IIpsSrcFile tableStructure = this.getReferencedTableStructure(tableContent);
        this.tableStructureMap.put(tableStructure, tableContent);
    }

    private IIpsSrcFile getReferencedTableStructure(IIpsSrcFile tableContent) {
        String structureName = this.getTableStructureName(tableContent);
        return tableContent.getIpsProject().findIpsSrcFile(new QualifiedNameType(structureName, IpsObjectType.TABLE_STRUCTURE));
    }

    public void tableContentChanged(IIpsSrcFile tableContent) {
        if (this.isOutdated(tableContent)) {
            this.removeTableContent(tableContent);
            this.putTableContent(tableContent);
        }
    }

    private boolean isOutdated(IIpsSrcFile tableContent) {
        IIpsSrcFile tableStructure = this.tableStructureMap.getTableStructure(tableContent);
        return tableStructure == null || !Objects.equals(tableStructure.getName(), this.getTableStructureName(tableContent));
    }

    private String getTableStructureName(IIpsSrcFile tableContent) {
        return tableContent.getPropertyValue("tableStructure");
    }

    public void removeTableStructure(IIpsSrcFile tableStructure) {
        this.tableStructureMap.removeTableStructure(tableStructure);
    }

    public void removeTableContent(IIpsSrcFile tableContent) {
        this.tableStructureMap.removeTableContent(tableContent);
    }

    private static enum State {
        NEW,
        INITIALIZED;

    }

    private static class TableStructureMap {
        private final MultiMap<IIpsSrcFile, IIpsSrcFile> structureToContentMap = MultiMap.createWithSetsAsValues();
        private final ConcurrentHashMap<IIpsSrcFile, IIpsSrcFile> tableContentsToStructure = new ConcurrentHashMap();
        private final Set<IIpsSrcFile> contentWithInvlidStructure = new HashSet<IIpsSrcFile>();

        private TableStructureMap() {
        }

        public Collection<IIpsSrcFile> get(IIpsSrcFile tableStructure) {
            return this.structureToContentMap.get((Object)tableStructure);
        }

        public void clear() {
            this.structureToContentMap.clear();
            this.tableContentsToStructure.clear();
            this.contentWithInvlidStructure.clear();
        }

        public IIpsSrcFile getTableStructure(IIpsSrcFile tableContent) {
            return this.tableContentsToStructure.get(tableContent);
        }

        public synchronized void put(IIpsSrcFile tableStructure, IIpsSrcFile tableContent) {
            if (tableStructure == null) {
                this.contentWithInvlidStructure.add(tableContent);
            } else {
                this.structureToContentMap.put((Object)tableStructure, (Object[])new IIpsSrcFile[]{tableContent});
                this.tableContentsToStructure.put(tableContent, tableStructure);
            }
        }

        public synchronized void removeTableContent(IIpsSrcFile tableContent) {
            IIpsSrcFile tableStructure = this.tableContentsToStructure.get(tableContent);
            if (tableStructure != null) {
                this.structureToContentMap.remove((Object)tableStructure, (Object)tableContent);
            }
            this.tableContentsToStructure.remove(tableContent);
            this.contentWithInvlidStructure.remove(tableContent);
        }

        public synchronized void removeTableStructure(IIpsSrcFile tableStructure) {
            Collection<IIpsSrcFile> list = this.get(tableStructure);
            for (IIpsSrcFile tableContent : list) {
                this.tableContentsToStructure.remove(tableContent);
            }
            this.structureToContentMap.remove((Object)tableStructure);
        }
    }
}

