/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.cache;

import java.util.Set;
import org.faktorips.devtools.abstraction.AResourceDelta;
import org.faktorips.devtools.model.IIpsSrcFilesChangeListener;
import org.faktorips.devtools.model.IpsSrcFilesChangedEvent;
import org.faktorips.devtools.model.internal.ipsproject.cache.TableContentsStructureCache;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPathEntry;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

class TableContentsStructureCacheUpdater
implements IIpsSrcFilesChangeListener {
    private final TableContentsStructureCache cache;
    private final IIpsProject ipsProject;

    public TableContentsStructureCacheUpdater(TableContentsStructureCache cache, IIpsProject ipsProject) {
        this.cache = cache;
        this.ipsProject = ipsProject;
    }

    @Override
    public void ipsSrcFilesChanged(IpsSrcFilesChangedEvent event) {
        Set<IIpsSrcFile> changedIpsSrcFiles = event.getChangedIpsSrcFiles();
        for (IIpsSrcFile ipsSrcFile : changedIpsSrcFiles) {
            OperationKind operationKind = OperationKind.getKind(event.getResourceDelta(ipsSrcFile));
            if (!this.isRelevant(ipsSrcFile)) continue;
            this.handleTableStructureChange(ipsSrcFile, operationKind, this.cache);
            this.handleTableContentChange(ipsSrcFile, operationKind, this.cache);
        }
    }

    private boolean isRelevant(IIpsSrcFile ipsSrcFile) {
        IIpsProject ipsSrcFileProject = ipsSrcFile.getIpsProject();
        IIpsPackageFragment fragment = ipsSrcFile.getIpsPackageFragment();
        return this.ipsProject.equals(ipsSrcFileProject) || this.isReferencingAndReexporting(fragment, ipsSrcFileProject);
    }

    private boolean isReferencingAndReexporting(IIpsPackageFragment fragment, IIpsProject ipsSrcFileProject) {
        if (ipsSrcFileProject == null || fragment == null) {
            return false;
        }
        IIpsObjectPathEntry rootEntry = ipsSrcFileProject.getIpsObjectPath().getEntry(fragment.getRoot().getName());
        return this.ipsProject.isReferencing(ipsSrcFileProject) && rootEntry != null && rootEntry.isReexported();
    }

    private void handleTableStructureChange(IIpsSrcFile ipsSrcFile, OperationKind operation, TableContentsStructureCache tableContentsStructureCache) {
        if (IpsObjectType.TABLE_STRUCTURE.equals(ipsSrcFile.getIpsObjectType())) {
            operation.performTableStructureUpdate(tableContentsStructureCache, ipsSrcFile);
        }
    }

    private void handleTableContentChange(IIpsSrcFile ipsSrcFile, OperationKind operationKind, TableContentsStructureCache tableContentsStructureCache) {
        if (IpsObjectType.TABLE_CONTENTS.equals(ipsSrcFile.getIpsObjectType())) {
            operationKind.performTableContentUpdate(tableContentsStructureCache, ipsSrcFile);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OperationKind {
        ADDED{

            @Override
            public void performTableStructureUpdate(TableContentsStructureCache tableContentsStructureCache, IIpsSrcFile tableStructure) {
                tableContentsStructureCache.newTableStructure(tableStructure);
            }

            @Override
            public void performTableContentUpdate(TableContentsStructureCache tableContentsStructureCache, IIpsSrcFile tableContent) {
                tableContentsStructureCache.putTableContent(tableContent);
            }
        }
        ,
        CHANGED{

            @Override
            public void performTableStructureUpdate(TableContentsStructureCache tableContentsStructureCache, IIpsSrcFile tableStructure) {
            }

            @Override
            public void performTableContentUpdate(TableContentsStructureCache tableContentsStructureCache, IIpsSrcFile tableContent) {
                tableContentsStructureCache.tableContentChanged(tableContent);
            }
        }
        ,
        REMOVED{

            @Override
            public void performTableStructureUpdate(TableContentsStructureCache tableContentsStructureCache, IIpsSrcFile tableStructure) {
                tableContentsStructureCache.removeTableStructure(tableStructure);
            }

            @Override
            public void performTableContentUpdate(TableContentsStructureCache tableContentsStructureCache, IIpsSrcFile tableContent) {
                tableContentsStructureCache.removeTableContent(tableContent);
            }
        };


        public static OperationKind getKind(AResourceDelta resourceDelta) {
            if (resourceDelta.getKind() == AResourceDelta.AResourceDeltaKind.ADDED) {
                return ADDED;
            }
            if (resourceDelta.getKind() == AResourceDelta.AResourceDeltaKind.REMOVED) {
                return REMOVED;
            }
            return CHANGED;
        }

        public abstract void performTableStructureUpdate(TableContentsStructureCache var1, IIpsSrcFile var2);

        public abstract void performTableContentUpdate(TableContentsStructureCache var1, IIpsSrcFile var2);
    }
}

