/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.properties;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsArtefactBuilderSetConfig;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetConfig;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetConfigModel;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetInfo;
import org.faktorips.devtools.model.ipsproject.IIpsBuilderSetPropertyDef;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IpsArtefactBuilderSetConfigModel
implements IIpsArtefactBuilderSetConfigModel {
    private static final String PROPERTY_XML_TAG = "Property";
    private static final String NAME_XML_ATTR = "name";
    private static final String VALUE_XML_ATTR = "value";
    private Map<String, String> properties;
    private Map<String, String> propertiesDescription;

    public IpsArtefactBuilderSetConfigModel() {
        this.properties = new LinkedHashMap<String, String>();
        this.propertiesDescription = new LinkedHashMap<String, String>();
    }

    public IpsArtefactBuilderSetConfigModel(Map<String, String> properties) {
        ArgumentCheck.notNull(properties);
        this.properties = properties;
        this.propertiesDescription = new LinkedHashMap<String, String>();
    }

    @Override
    public final void initFromXml(Element el) {
        this.properties = new LinkedHashMap<String, String>();
        this.propertiesDescription = new LinkedHashMap<String, String>();
        NodeList nl = el.getChildNodes();
        String commentBeforeElement = "";
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node instanceof Comment) {
                commentBeforeElement = ((Comment)node).getData();
            } else if (node.getNodeName().equals(PROPERTY_XML_TAG)) {
                Element propertyEl = (Element)node;
                String key = propertyEl.getAttribute(NAME_XML_ATTR);
                String value = propertyEl.getAttribute(VALUE_XML_ATTR);
                if (!commentBeforeElement.isEmpty()) {
                    this.propertiesDescription.put(key, commentBeforeElement);
                    commentBeforeElement = "";
                } else {
                    this.readOldStyleComment(propertyEl, key);
                }
                this.properties.put(key, value);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readOldStyleComment(Element propertyEl, String key) {
        NodeList propertyElNodeList = propertyEl.getChildNodes();
        int j = 0;
        while (j < propertyElNodeList.getLength()) {
            Node child = propertyElNodeList.item(j);
            Node node = child;
            if (node instanceof Comment) {
                void comment;
                Comment cfr_ignored_0 = (Comment)node;
                Comment cfr_ignored_1 = (Comment)node;
                this.propertiesDescription.put(key, comment.getData());
            }
            ++j;
        }
    }

    @Override
    public String getPropertyDescription(String propertyName) {
        return this.propertiesDescription.get(propertyName);
    }

    @Override
    public String getPropertyValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public void setPropertyValue(String propertyName, String value, String description) {
        ArgumentCheck.notNull((Object)propertyName);
        ArgumentCheck.notNull((Object)value);
        this.properties.put(propertyName, value);
        if (description != null) {
            this.propertiesDescription.put(propertyName, description);
        }
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    @Override
    public final Element toXml(Document doc) {
        Element root = doc.createElement("IpsArtefactBuilderSetConfig");
        Set<String> keys = this.properties.keySet();
        for (String key : keys) {
            String value = this.properties.get(key);
            String description = this.propertiesDescription.get(key);
            if (description != null) {
                Comment comment = doc.createComment(description);
                root.appendChild(comment);
            }
            Element prop = doc.createElement(PROPERTY_XML_TAG);
            root.appendChild(prop);
            prop.setAttribute(NAME_XML_ATTR, key);
            prop.setAttribute(VALUE_XML_ATTR, value);
        }
        return root;
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public IIpsArtefactBuilderSetConfig create(IIpsProject ipsProject, IIpsArtefactBuilderSetInfo builderSetInfo) {
        IIpsBuilderSetPropertyDef[] propertyDefs;
        LinkedHashMap<String, Object> parsedValueMap = new LinkedHashMap<String, Object>();
        for (String name : this.properties.keySet()) {
            String valueAsString;
            IIpsBuilderSetPropertyDef propertyDef = builderSetInfo.getPropertyDefinition(name);
            if (propertyDef == null || !IpsStringUtils.isNotBlank((String)(valueAsString = this.properties.get(name)))) continue;
            Object value = propertyDef.parseValue(valueAsString);
            parsedValueMap.put(name, value);
        }
        IIpsBuilderSetPropertyDef[] iIpsBuilderSetPropertyDefArray = propertyDefs = builderSetInfo.getPropertyDefinitions();
        int n = propertyDefs.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsBuilderSetPropertyDef propertyDef = iIpsBuilderSetPropertyDefArray[n2];
            Object value = parsedValueMap.get(propertyDef.getName());
            if (value == null) {
                parsedValueMap.put(propertyDef.getName(), propertyDef.parseValue(propertyDef.getDisableValue(ipsProject)));
            }
            ++n2;
        }
        return new IpsArtefactBuilderSetConfig(parsedValueMap);
    }

    @Override
    public MessageList validate(IIpsProject ipsProject, IIpsArtefactBuilderSetInfo builderSetInfo) {
        return builderSetInfo.validateIpsArtefactBuilderSetConfig(ipsProject, this);
    }
}

