/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.properties;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.faktorips.devtools.abstraction.ALog;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.builder.EmptyBuilderSet;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsArtefactBuilderSetConfigModel;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsBuilderSetPropertyDef;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetConfigModel;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetInfo;
import org.faktorips.devtools.model.ipsproject.IIpsBuilderSetPropertyDef;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;

public class IpsArtefactBuilderSetInfo
implements IIpsArtefactBuilderSetInfo {
    static final String ARTEFACTBUILDERSET = "artefactbuilderset";
    static final String BUILDER_SET_PROPERTY_DEF = "builderSetPropertyDef";
    private Class<?> builderSetClass;
    private String builderSetId;
    private String builderSetLabel;
    private String namespace;
    private String builderSetClassName;
    private Map<String, IIpsBuilderSetPropertyDef> propertyDefinitions;

    private IpsArtefactBuilderSetInfo(String namespace, String builderSetClassName, String builderSetId, String builderSetLabel, Map<String, IIpsBuilderSetPropertyDef> propertyDefinitions) {
        this.namespace = namespace;
        this.builderSetClassName = builderSetClassName;
        this.builderSetId = builderSetId;
        this.builderSetLabel = builderSetLabel;
        this.propertyDefinitions = propertyDefinitions;
    }

    @Override
    public IIpsArtefactBuilderSet create(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        try {
            IIpsArtefactBuilderSet builderSet = (IIpsArtefactBuilderSet)this.getBuilderSetClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            builderSet.setId(this.getBuilderSetId());
            builderSet.setLabel(this.getBuilderSetLabel());
            builderSet.setIpsProject(ipsProject);
            return builderSet;
        }
        catch (ClassCastException e) {
            IpsLog.log((IStatus)new IpsStatus("The registered builder set " + this.getBuilderSetClass() + " doesn't implement the " + IIpsArtefactBuilderSet.class + " interface.", e));
        }
        catch (Exception e) {
            IpsLog.log((IStatus)new IpsStatus("Unable to instantiate the builder set " + this.getBuilderSetClass(), e));
        }
        return new EmptyBuilderSet();
    }

    @Override
    public IIpsArtefactBuilderSetConfigModel createDefaultConfiguration(IIpsProject ipsProject) {
        IpsArtefactBuilderSetConfigModel configModel = new IpsArtefactBuilderSetConfigModel();
        for (IIpsBuilderSetPropertyDef propertyDef : this.propertyDefinitions.values()) {
            if (!propertyDef.isAvailable(ipsProject)) continue;
            configModel.setPropertyValue(propertyDef.getName(), propertyDef.getDefaultValue(ipsProject), propertyDef.getDescription());
        }
        return configModel;
    }

    private Class<?> getBuilderSetClass() {
        if (this.builderSetClass == null) {
            try {
                this.builderSetClass = Abstractions.isEclipseRunning() ? Platform.getBundle((String)this.namespace).loadClass(this.builderSetClassName) : this.getClass().getClassLoader().loadClass(this.builderSetClassName);
            }
            catch (ClassNotFoundException e) {
                IpsLog.log((IStatus)new IpsStatus("Unable to load the IpsArtefactBuilderSet class " + this.builderSetClassName + " with the id " + this.builderSetId));
            }
        }
        return this.builderSetClass;
    }

    @Override
    public String getBuilderSetId() {
        return this.builderSetId;
    }

    @Override
    public String getBuilderSetLabel() {
        return this.builderSetLabel;
    }

    @Override
    public IIpsBuilderSetPropertyDef getPropertyDefinition(String name) {
        return this.propertyDefinitions.get(name);
    }

    @Override
    public IIpsBuilderSetPropertyDef[] getPropertyDefinitions() {
        return this.propertyDefinitions.values().toArray(new IIpsBuilderSetPropertyDef[this.propertyDefinitions.size()]);
    }

    @Override
    public MessageList validateIpsArtefactBuilderSetConfig(IIpsProject ipsProject, IIpsArtefactBuilderSetConfigModel builderSetConfig) {
        String[] names;
        MessageList msgList = new MessageList();
        String[] stringArray = names = builderSetConfig.getPropertyNames();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Message msg = this.validateIpsBuilderSetPropertyValue(ipsProject, name, builderSetConfig.getPropertyValue(name));
            if (msg != null) {
                msgList.add(msg);
            }
            ++n2;
        }
        return msgList;
    }

    @Override
    public Message validateIpsBuilderSetPropertyValue(IIpsProject ipsProject, String propertyName, String propertyValue) {
        IIpsBuilderSetPropertyDef propertyDef = this.propertyDefinitions.get(propertyName);
        if (propertyDef == null) {
            String text = MessageFormat.format(Messages.IpsArtefactBuilderSetInfo_propertyNotSupported, this.builderSetId, propertyName);
            return new Message("propertyNotSupported", text, Message.ERROR);
        }
        Message msg = propertyDef.validateValue(ipsProject, propertyValue);
        if (msg != null) {
            return msg;
        }
        return null;
    }

    private static final Map<String, IIpsBuilderSetPropertyDef> retrieveBuilderSetProperties(IExtensionRegistry registry, String builderSetId, IIpsModel ipsModel, IConfigurationElement element, ALog logger) {
        IConfigurationElement[] builderSetPropertyDefElements = element.getChildren(BUILDER_SET_PROPERTY_DEF);
        HashMap<String, IIpsBuilderSetPropertyDef> builderSetPropertyDefs = new HashMap<String, IIpsBuilderSetPropertyDef>();
        IConfigurationElement[] iConfigurationElementArray = builderSetPropertyDefElements;
        int n = builderSetPropertyDefElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement builderSetPropertyDefElement = iConfigurationElementArray[n2];
            IIpsBuilderSetPropertyDef propertyDef = IpsBuilderSetPropertyDef.loadExtensions(builderSetPropertyDefElement, registry, builderSetId, logger, ipsModel);
            if (propertyDef != null) {
                builderSetPropertyDefs.put(propertyDef.getName(), propertyDef);
            }
            ++n2;
        }
        return builderSetPropertyDefs;
    }

    public static final void loadExtensions(IExtensionRegistry registry, ALog logger, List<IIpsArtefactBuilderSetInfo> builderSetInfoList, IIpsModel ipsModel) {
        IExtensionPoint point = registry.getExtensionPoint("org.faktorips.devtools.model", ARTEFACTBUILDERSET);
        IExtension[] extensions = point.getExtensions();
        HashSet<String> replacedBuilderSets = new HashSet<String>();
        HashMap<String, String> classNameById = new HashMap<String, String>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] configElements = extension.getConfigurationElements();
            if (configElements.length > 0 && (element = configElements[0]).getName().equals("builderSet")) {
                if (IpsStringUtils.isEmpty((String)extension.getUniqueIdentifier())) {
                    logger.log((IStatus)new IpsStatus("The identifier of the IpsArtefactBuilderSet extension is empty"));
                } else {
                    String builderSetClassName = element.getAttribute("class");
                    if (IpsStringUtils.isEmpty((String)builderSetClassName)) {
                        logger.log((IStatus)new IpsStatus("The class attribute of the IpsArtefactBuilderSet extension with the extension id " + extension.getUniqueIdentifier() + " is not specified."));
                    } else {
                        classNameById.put(extension.getUniqueIdentifier(), builderSetClassName);
                        String replacedBuilderSetClassName = element.getAttribute("replaces");
                        if (IpsStringUtils.isNotBlank((String)replacedBuilderSetClassName)) {
                            replacedBuilderSets.add(replacedBuilderSetClassName);
                        }
                        Map<String, IIpsBuilderSetPropertyDef> builderSetPropertyDefs = IpsArtefactBuilderSetInfo.retrieveBuilderSetProperties(registry, extension.getUniqueIdentifier(), ipsModel, element, logger);
                        builderSetInfoList.add(new IpsArtefactBuilderSetInfo(extension.getNamespaceIdentifier(), builderSetClassName, extension.getUniqueIdentifier(), extension.getLabel(), builderSetPropertyDefs));
                    }
                }
            }
            ++n2;
        }
        Iterator<IIpsArtefactBuilderSetInfo> iterator = builderSetInfoList.iterator();
        while (iterator.hasNext()) {
            if (!replacedBuilderSets.contains(classNameById.get(iterator.next().getBuilderSetId()))) continue;
            iterator.remove();
        }
    }
}

