/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.abstraction.ALog;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsBuilderSetPropertyDef;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.internal.IpsStringUtils;

public class IpsBuilderSetPropertyDef
implements IIpsBuilderSetPropertyDef {
    private String name;
    private String label;
    private String description;
    private String type;
    private String defaultValue;
    private String disableValue;
    private List<String> supportedJdkVersions;
    private List<String> discretePropertyValues;

    @Override
    public String getDefaultValue(IIpsProject ipsProject) {
        return this.defaultValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDisableValue(IIpsProject ipsProject) {
        return this.disableValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public IStatus initialize(IIpsModel ipsModel, Map<String, Object> properties) {
        this.type = (String)properties.get("type");
        this.name = (String)properties.get("name");
        this.defaultValue = (String)properties.get("defaultValue");
        this.description = (String)properties.get("description");
        this.disableValue = (String)properties.get("disableValue");
        this.label = (String)properties.get("label");
        this.discretePropertyValues = (List)properties.get("discreteValues");
        this.supportedJdkVersions = (List)properties.get("jdkComplianceLevels");
        return null;
    }

    @Override
    public Object parseValue(String value) {
        if (value == null) {
            return null;
        }
        switch (this.type) {
            case "string": {
                return value;
            }
            case "boolean": {
                return Boolean.valueOf(value);
            }
            case "integer": {
                return Integer.valueOf(value);
            }
            case "enum": 
            case "extensionPoint": {
                for (String discreteValue : this.discretePropertyValues) {
                    if (!discreteValue.equals(value)) continue;
                    return value;
                }
                return this.disableValue;
            }
        }
        throw new IllegalArgumentException("The provided value \"" + value + "\" cannot be converted into an instance of the type " + this.type + " of this IpsBuilderSetPropertyDef.");
    }

    @Override
    public boolean isAvailable(IIpsProject ipsProject) {
        String optionValue = ipsProject.getJavaProject().getSourceVersion().toString();
        return this.supportedJdkVersions.isEmpty() || this.supportedJdkVersions.contains(optionValue);
    }

    @Override
    public Message validateValue(IIpsProject ipsProject, String value) {
        if (value == null) {
            return null;
        }
        boolean parsable = false;
        switch (this.type) {
            case "string": {
                parsable = Datatype.STRING.isParsable(value);
                break;
            }
            case "boolean": {
                parsable = Datatype.BOOLEAN.isParsable(value);
                break;
            }
            case "integer": {
                parsable = Datatype.INTEGER.isParsable(value);
                break;
            }
            case "enum": 
            case "extensionPoint": {
                for (String discreteValue : this.discretePropertyValues) {
                    if (!discreteValue.equals(value)) continue;
                    parsable = true;
                }
                break;
            }
        }
        if (!parsable) {
            return this.getStandardValidationMessage(value);
        }
        return null;
    }

    protected Message getStandardValidationMessage(String value) {
        return new Message("BUILDER_SET_PROPERTY_DEF-NonParsableValue", Messages.bind(Messages.IpsBuilderSetPropertyDef_NonParsableValue, value, this.type, this.getName()), Message.ERROR);
    }

    @Override
    public String[] getDiscreteValues() {
        return this.discretePropertyValues.toArray(new String[this.discretePropertyValues.size()]);
    }

    @Override
    public boolean hasDiscreteValues() {
        return this.discretePropertyValues.size() != 0;
    }

    private static final void retrieveEnumValues(String type, List<String> discreteValues, IConfigurationElement element) {
        if (!IpsStringUtils.isEmpty((String)type) && "enum".equals(type) && "discreteValues".equals(element.getName())) {
            IConfigurationElement[] values;
            IConfigurationElement[] iConfigurationElementArray = values = element.getChildren();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement value2 = iConfigurationElementArray[n2];
                String value = value2.getAttribute("value");
                if (!IpsStringUtils.isEmpty((String)value)) {
                    discreteValues.add(value);
                }
                ++n2;
            }
        }
    }

    private static final boolean retrieveReferencedExtensionPoint(String type, List<String> discreteValues, IExtensionRegistry registry, String builderSetId, Map<String, Object> properties, IConfigurationElement element, ALog logger) {
        if ("extensionPoint".equals(type)) {
            IExtension[] refExts;
            String extensionPointId = element.getAttribute("extensionPointId");
            if (IpsStringUtils.isEmpty((String)extensionPointId)) {
                logger.log((IStatus)new IpsStatus("If the type attribute of the builder set property " + element.getName() + " of the builder set " + builderSetId + " has the value \"extensionPoint\" then the \"extensionPointId\" attribute has to have a value."));
                return false;
            }
            properties.put("extensionPointId", extensionPointId);
            IExtensionPoint refExtPoint = registry.getExtensionPoint(extensionPointId);
            IExtension[] iExtensionArray = refExts = refExtPoint.getExtensions();
            int n = refExts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension refExt = iExtensionArray[n2];
                discreteValues.add(refExt.getUniqueIdentifier());
                ++n2;
            }
        }
        return true;
    }

    private static final void retrieveJdkComplianceLevels(List<String> jdkComplianceLevelList, IConfigurationElement element) {
        if ("jdkComplianceLevels".equals(element.getName())) {
            IConfigurationElement[] values;
            IConfigurationElement[] iConfigurationElementArray = values = element.getChildren();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement value = iConfigurationElementArray[n2];
                String level = value.getAttribute("value");
                if (!IpsStringUtils.isEmpty((String)level)) {
                    jdkComplianceLevelList.add(level);
                }
                ++n2;
            }
        }
    }

    private static final boolean retrieveProperties(ALog logger, IExtensionRegistry registry, String builderSetId, IConfigurationElement element, Map<String, Object> properties, List<String> discreteValues) {
        String classValue = element.getAttribute("class");
        boolean classValueSpecified = !IpsStringUtils.isEmpty((String)classValue);
        String name = element.getAttribute("name");
        if (!classValueSpecified && IpsStringUtils.isEmpty((String)name)) {
            logger.log((IStatus)new IpsStatus("The required attribute \"name\" of the builder set property " + element.getName() + " of the builder set " + builderSetId + " is missing."));
            return false;
        }
        properties.put("name", name);
        String label = element.getAttribute("label");
        if (!classValueSpecified && IpsStringUtils.isEmpty((String)label)) {
            logger.log((IStatus)new IpsStatus("The required attribute \"label\" of the builder set property " + element.getName() + " of the builder set " + builderSetId + " is missing."));
            return false;
        }
        properties.put("label", label);
        String type = element.getAttribute("type");
        if (!classValueSpecified && IpsStringUtils.isEmpty((String)type)) {
            logger.log((IStatus)new IpsStatus("The required attribute \"type\" of the builder set property " + element.getName() + " of the builder set " + builderSetId + " is missing."));
            return false;
        }
        properties.put("type", type);
        String defaultValue = element.getAttribute("defaultValue");
        properties.put("defaultValue", defaultValue);
        String disableValue = element.getAttribute("disableValue");
        properties.put("disableValue", disableValue);
        String description = element.getAttribute("description");
        properties.put("description", description);
        if (!IpsBuilderSetPropertyDef.retrieveReferencedExtensionPoint(type, discreteValues, registry, builderSetId, properties, element, logger)) {
            return false;
        }
        if (classValueSpecified) {
            try {
                properties.put("class", element.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                logger.log((IStatus)new IpsStatus(e));
            }
        }
        return true;
    }

    public static final IIpsBuilderSetPropertyDef loadExtensions(IConfigurationElement element, IExtensionRegistry registry, String builderSetId, ALog logger, IIpsModel ipsModel) {
        IConfigurationElement[] childs;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList<String> discreteValues = new ArrayList<String>();
        ArrayList<String> jdkComplianceLevelList = new ArrayList<String>();
        if (!IpsBuilderSetPropertyDef.retrieveProperties(logger, registry, builderSetId, element, properties, discreteValues)) {
            return null;
        }
        String type = (String)properties.get("type");
        IConfigurationElement[] iConfigurationElementArray = childs = element.getChildren();
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            IpsBuilderSetPropertyDef.retrieveEnumValues(type, discreteValues, child);
            IpsBuilderSetPropertyDef.retrieveJdkComplianceLevels(jdkComplianceLevelList, child);
            ++n2;
        }
        if ("enum".equals(type) && discreteValues.isEmpty()) {
            logger.log((IStatus)new IpsStatus("If the type attribute of the builder set property " + element.getName() + " of the builder set " + builderSetId + " has the value \"enum\" then discrete values have to be specified."));
        }
        properties.put("discreteValues", discreteValues);
        properties.put("jdkComplianceLevels", jdkComplianceLevelList);
        IIpsBuilderSetPropertyDef propertyDef = (IIpsBuilderSetPropertyDef)properties.remove("class");
        if (propertyDef == null) {
            propertyDef = new IpsBuilderSetPropertyDef();
        }
        try {
            propertyDef.initialize(ipsModel, properties);
        }
        catch (Exception e) {
            logger.log((IStatus)new IpsStatus(e));
            return null;
        }
        return propertyDef;
    }

    public String toString() {
        return "BuilderSetPropertyDefinition: " + this.getName();
    }
}

