/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.properties;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.LinkedHashMap;
import java.util.Map;
import org.faktorips.devtools.model.ipsproject.IIpsFeatureConfiguration;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IpsFeatureConfiguration
implements IIpsFeatureConfiguration {
    static final String FEATURE_CONFIGURATION_ELEMENT = "FeatureConfiguration";
    static final String PROPERTY_ELEMENT = "Property";
    static final String NAME_ATTRIBUTE = "name";
    static final String VALUE_ATTRIBUTE = "value";
    private final Map<String, String> properties = new LinkedHashMap<String, String>();

    @Override
    @CheckForNull
    public String get(String key) {
        return this.properties.get(key);
    }

    public void set(String name, @CheckForNull String value) {
        ArgumentCheck.notNull((Object)name, (Object)"Property name must not be null");
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    Element toXml(Document doc) {
        Element featureConfigurationElement = doc.createElement(FEATURE_CONFIGURATION_ELEMENT);
        for (Map.Entry<String, String> property : this.properties.entrySet()) {
            String value = property.getValue();
            if (IpsStringUtils.isBlank((String)value)) continue;
            Element propertyElement = doc.createElement(PROPERTY_ELEMENT);
            propertyElement.setAttribute(NAME_ATTRIBUTE, property.getKey());
            propertyElement.setAttribute(VALUE_ATTRIBUTE, value);
            featureConfigurationElement.appendChild(propertyElement);
        }
        return featureConfigurationElement;
    }

    void initFromXml(Element featureConfigurationElement) {
        this.properties.clear();
        NodeList propertyElements = featureConfigurationElement.getElementsByTagName(PROPERTY_ELEMENT);
        int i = 0;
        while (i < propertyElements.getLength()) {
            Element propertyElement = (Element)propertyElements.item(i);
            String name = propertyElement.getAttribute(NAME_ATTRIBUTE);
            String value = propertyElement.getAttribute(VALUE_ATTRIBUTE);
            this.set(name, value);
            ++i;
        }
    }
}

