/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.properties;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.JavaClass2DatatypeAdaptor;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.AFile;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IFunctionResolverFactory;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.datatype.IDynamicValueDatatype;
import org.faktorips.devtools.model.internal.XsdValidationHandler;
import org.faktorips.devtools.model.internal.datatype.DynamicValueDatatype;
import org.faktorips.devtools.model.internal.ipsproject.IpsBundleManifest;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPath;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathManifestReader;
import org.faktorips.devtools.model.internal.ipsproject.IpsObjectPathXmlPersister;
import org.faktorips.devtools.model.internal.ipsproject.Messages;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsArtefactBuilderSetConfigModel;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsFeatureConfiguration;
import org.faktorips.devtools.model.internal.ipsproject.properties.PersistenceOptions;
import org.faktorips.devtools.model.internal.ipsproject.properties.SupportedLanguage;
import org.faktorips.devtools.model.internal.productcmpt.NoVersionIdProductCmptNamingStrategyFactory;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetConfigModel;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSetInfo;
import org.faktorips.devtools.model.ipsproject.IIpsFeatureConfiguration;
import org.faktorips.devtools.model.ipsproject.IIpsObjectPath;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.ipsproject.IPersistenceOptions;
import org.faktorips.devtools.model.ipsproject.ISupportedLanguage;
import org.faktorips.devtools.model.ipsproject.ITableColumnNamingStrategy;
import org.faktorips.devtools.model.ipsproject.ITableNamingStrategy;
import org.faktorips.devtools.model.ipsproject.TableContentFormat;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpt.IProductCmptNamingStrategy;
import org.faktorips.devtools.model.productcmpt.IProductCmptNamingStrategyFactory;
import org.faktorips.devtools.model.util.IpsProjectPropertiesForOldVersion;
import org.faktorips.devtools.model.versionmanager.IIpsFeatureVersionManager;
import org.faktorips.fl.AssociationNavigationFunctionsResolver;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.IoUtil;
import org.faktorips.values.Decimal;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IpsProjectProperties
implements IIpsProjectProperties {
    public static final String ATTRIBUTE_CHANGES_IN_TIME_NAMING_CONVENTION = "changesInTimeNamingConvention";
    public static final String TAG_NAME = "IpsProject";
    private static final String ADDITIONAL_SETTINGS_TAG_NAME = "AdditionalSettings";
    private static final String SETTING_TAG_NAME = "Setting";
    private static final String SETTING_ATTRIBUTE_VALUE = "value";
    private static final String SETTING_ATTRIBUTE_NAME = "name";
    private static final String SETTING_ATTRIBUTE_ENABLED = "enabled";
    private static final String SETTING_REFERENCED_PRODUCT_COMPONENTS_ARE_VALID_ON_THIS_GENERATIONS_VALID_FROM_DATE = "referencedProductComponentsAreValidOnThisGenerationsValidFromDate";
    private static final String SETTING_DERIVED_UNION_IS_IMPLEMENTED = "derivedUnionIsImplemented";
    private static final String ATTRIBUTE_PERSISTENT_PROJECT = "persistentProject";
    private static final String SETTING_RULES_WITHOUT_REFERENCE = "rulesWithoutReferencesAllowed";
    private static final String SETTING_SHARED_ASSOCIATIONS = "sharedDetailToMasterAssociations";
    private static final String SETTING_FORMULA_LANGUAGE_LOCALE = "formulaLanguageLocale";
    private static final String SETTING_MARKER_ENUMS = "markerEnums";
    private static final String SETTING_CHANGING_OVER_TIME_DEFAULT = "changingOverTimeDefault";
    private static final String SETTING_INFERRED_TEMPLATE_LINK_THRESHOLD = "inferredTemplateLinkThreshold";
    private static final String SETTING_INFERRED_TEMPLATE_PROPERTY_VALUE_THRESHOLD = "inferredTemplatePropertyValueThreshold";
    private static final String SETTING_DUPLICATE_PRODUCT_COMPONENT_SERVERITY = "duplicateProductComponentSeverity";
    private static final String SETTING_PERSISTENCE_COLUMN_SIZE_CHECKS_SERVERITY = "persistenceColumnSizeChecksSeverity";
    private static final String SETTING_MISSING_DATATYPE_SERVERITY = "missingDatatypeSeverity";
    private static final String SETTING_TABLE_CONTENT_FORMAT = "tableContentFormat";
    private static final String SETTING_GENERATE_VALIDATOR_CLASS_BY_DEFAULT = "generateValidatorClassDefault";
    private static final String SETTING_GENERIC_VALIDATION_BY_DEFAULT = "genericValidationDefault";
    private static final String SETTING_ESCAPE_NON_STANDARD_BLANKS = "escapeNonStandardBlanks";
    private static final String SETTING_VALIDATE_IPS_SCHEMA = "validateIpsSchema";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String RELEASE_EXTENSION_ID_ATTRIBUTE = "releaseExtensionId";
    private static final String PRODUCT_RELEASE_DEPRECATED = "productRelease";
    private static final String PRODUCT_RELEASE = "ProductRelease";
    private static final String VERSION_PROVIDER_ATTRIBUTE = "versionProvider";
    private static final String VERSION_TAG_NAME = "Version";
    private static final String DEFAULT_CURRENCY_ELEMENT = "DefaultCurrency";
    private static final String DEFAULT_CURRENCY_VALUE_ATTR = "value";
    private static final String MARKER_ENUMS_DELIMITER = ";";
    private static final String FEATURE_CONFIGURATIONS_ELEMENT = "FeatureConfigurations";
    private static final String FEATURE_ID_ATTRIBUTE = "featureId";
    private boolean createdFromParsableFileContents = true;
    private boolean modelProject;
    private boolean productDefinitionProject;
    private boolean persistentProject;
    private String version;
    private String releaseExtensionId;
    private String changesInTimeConventionIdForGeneratedCode = "VAA";
    private IProductCmptNamingStrategy productCmptNamingStrategy;
    private String productCmptNamingStrategyId = null;
    private String builderSetId = "";
    private IIpsArtefactBuilderSetConfigModel builderSetConfig = new IpsArtefactBuilderSetConfigModel();
    private IIpsObjectPath path = null;
    private String[] predefinedDatatypesUsed = new String[0];
    private List<Datatype> definedDatatypes = new ArrayList<Datatype>(0);
    private String runtimeIdPrefix = "";
    private boolean derivedUnionIsImplementedRuleEnabled = true;
    private boolean referencedProductComponentsAreValidOnThisGenerationsValidFromDateRuleEnabled = true;
    private boolean rulesWithoutReferencesAllowed = false;
    private boolean sharedDetailToMasterAssociations = false;
    private boolean enableMarkerEnums = true;
    private boolean changingOverTimeDefault = false;
    private boolean generateValidatorClassByDefault = false;
    private boolean genericValidationByDefault = false;
    private boolean escapeNonStandardBlanks = false;
    private boolean validateIpsSchema = true;
    private Decimal inferredTemplateLinkThreshold = Decimal.valueOf((Integer)1);
    private Decimal inferredTemplatePropertyValueThreshold = Decimal.valueOf((Double)0.8);
    private Severity duplicateProductComponentSeverity = Severity.WARNING;
    private Severity persistenceColumnSizeChecksSeverity = Severity.WARNING;
    private Severity missingDatatypeSeverity = Severity.WARNING;
    private TableContentFormat tableContentFormat = TableContentFormat.XML;
    private LinkedHashSet<String> markerEnums = new LinkedHashSet();
    private Map<String, String> requiredFeatures = new HashMap<String, String>();
    private Set<String> resourcesPathExcludedFromTheProductDefiniton = new HashSet<String>(10);
    private long lastPersistentModificationTimestamp;
    private IPersistenceOptions persistenceOptions = new PersistenceOptions();
    private LinkedHashSet<ISupportedLanguage> supportedLanguages = new LinkedHashSet(2);
    private IProductCmptNamingStrategy defaultCmptNamingStrategy;
    private Currency defaultCurrency = Currency.getInstance("EUR");
    private Locale formulaLanguageLocale = Locale.GERMAN;
    private String versionProviderId;
    private final Map<String, IpsFeatureConfiguration> featureConfigurations = new LinkedHashMap<String, IpsFeatureConfiguration>();
    private boolean markerEnumsConfiguredInIpsProjectFile = false;
    private XsdValidationHandler xsdValidationHandler = new XsdValidationHandler();

    public IpsProjectProperties(IIpsProject ipsProject) {
        this.path = new IpsObjectPath(ipsProject);
    }

    public IpsProjectProperties(IIpsProject ipsProject, IpsProjectProperties props) {
        Document doc = XmlUtil.getDocumentBuilder().newDocument();
        Element el = props.toXml(doc);
        this.initFromXml(ipsProject, el);
        this.createdFromParsableFileContents = props.createdFromParsableFileContents;
    }

    public static final IpsProjectProperties createFromXml(IIpsProject ipsProject, Element element) {
        IpsProjectProperties data = new IpsProjectProperties(ipsProject);
        data.initFromXml(ipsProject, element);
        return data;
    }

    @Override
    public MessageList validate(IIpsProject ipsProject) {
        try {
            DynamicValueDatatype[] valuetypes;
            MessageList list = new MessageList();
            if (Abstractions.isEclipseRunning() && this.validateBuilderSetId(ipsProject, list)) {
                this.validateBuilderSetConfig(ipsProject, list);
            }
            this.validateProductCmptNamingStrategy(list);
            this.validateUsedPredefinedDatatype(ipsProject, list);
            this.validateIpsObjectPath(list);
            this.validateRequiredFeatures(list);
            DynamicValueDatatype[] dynamicValueDatatypeArray = valuetypes = this.getDefinedValueDatatypes();
            int n = valuetypes.length;
            int n2 = 0;
            while (n2 < n) {
                DynamicValueDatatype valuetype = dynamicValueDatatypeArray[n2];
                list.add(valuetype.checkReadyToUse());
                ++n2;
            }
            this.validatePersistenceOption(list);
            this.validateVersion(list);
            this.validateSupportedLanguages(list);
            this.validateFeatureConfigurations(list);
            return list;
        }
        catch (RuntimeException e) {
            throw new IpsException((IStatus)new IpsStatus(e));
        }
    }

    private void validatePersistenceOption(MessageList msgList) {
        if (this.isPersistenceSupportEnabled()) {
            String text = MessageFormat.format(Messages.IpsProjectProperties_error_persistenceAndSharedAssociationNotAllowed, SETTING_SHARED_ASSOCIATIONS, ATTRIBUTE_PERSISTENT_PROJECT);
            if (this.isSharedDetailToMasterAssociations()) {
                msgList.add(new Message("IPSPROJECT-invalidOptionalConstraint", text, Message.ERROR, (Object)this));
            }
        }
    }

    private void validateProductCmptNamingStrategy(MessageList msgList) {
        if (this.productCmptNamingStrategy == null) {
            String text = MessageFormat.format(Messages.IpsProjectProperties_unknownNamingStrategy, this.productCmptNamingStrategyId);
            msgList.add(new Message("IPSPROJECT-InvalidProductCmptNamingStrategy", text, Message.ERROR, (Object)this));
        }
    }

    private void validateBuilderSetConfig(IIpsProject ipsProject, MessageList msgList) {
        IIpsArtefactBuilderSetInfo builderSetInfo = ipsProject.getIpsModel().getIpsArtefactBuilderSetInfo(this.builderSetId);
        msgList.add(builderSetInfo.validateIpsArtefactBuilderSetConfig(ipsProject, this.builderSetConfig));
    }

    private void validateRequiredFeatures(MessageList list) {
        IIpsFeatureVersionManager[] managers;
        IIpsFeatureVersionManager[] iIpsFeatureVersionManagerArray = managers = IIpsModelExtensions.get().getIpsFeatureVersionManagers();
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsFeatureVersionManager manager = iIpsFeatureVersionManagerArray[n2];
            if (manager.isRequiredForAllProjects() && this.getMinRequiredVersionNumber(manager.getFeatureId()) == null) {
                String text = MessageFormat.format(Messages.IpsProjectProperties_msgMissingMinFeatureId, manager.getFeatureId());
                list.add(new Message("IPSPROJECT-MissingMinFeatureId", text, Message.ERROR, (Object)this));
            }
            ++n2;
        }
    }

    private void validateUsedPredefinedDatatype(IIpsProject ipsProject, MessageList list) {
        IIpsModel model = ipsProject.getIpsModel();
        String[] stringArray = this.predefinedDatatypesUsed;
        int n = this.predefinedDatatypesUsed.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!model.isPredefinedValueDatatype(element)) {
                String text = MessageFormat.format(Messages.IpsProjectProperties_msgUnknownDatatype, element);
                Message msg = new Message("IPSPROJECT-UnknownPredefinedDatatype", text, Message.ERROR, (Object)this);
                list.add(msg);
            }
            ++n2;
        }
    }

    private boolean validateBuilderSetId(IIpsProject ipsProject, MessageList list) {
        IIpsArtefactBuilderSetInfo builderSetInfo = ipsProject.getIpsModel().getIpsArtefactBuilderSetInfo(this.builderSetId);
        if (builderSetInfo == null) {
            String text = String.valueOf(Messages.IpsProjectProperties_msgUnknownBuilderSetId) + this.builderSetId;
            Message msg = new Message("IPSPROJECT-UnknownBuilderSetId", text, Message.ERROR, (Object)this, new String[]{"builderSetId"});
            list.add(msg);
            return false;
        }
        return true;
    }

    private void validateIpsObjectPath(MessageList list) {
        list.add(this.path.validate());
    }

    private void validateVersion(MessageList list) {
        if (IpsStringUtils.isNotEmpty((String)this.getVersion()) && IpsStringUtils.isNotEmpty((String)this.getVersionProviderId())) {
            list.newError("IPSPROJECT-invalidVersionSetting", Messages.IpsProjectProperties_err_versionOrVersionProvider, new ObjectProperty[]{new ObjectProperty((Object)this, VERSION_ATTRIBUTE), new ObjectProperty((Object)this, "versionProviderId")});
        }
    }

    private void validateSupportedLanguages(MessageList list) {
        this.validateSupportedLanguagesIsoConformity(list);
        this.validateSupportedLanguagesOneDefaultLanguage(list);
    }

    private void validateSupportedLanguagesIsoConformity(MessageList list) {
        String[] isoLanguages = Locale.getISOLanguages();
        List<String> isoLanguagesList = Arrays.asList(isoLanguages);
        for (ISupportedLanguage supportedLanguage : this.supportedLanguages) {
            String languageString = supportedLanguage.getLocale().getLanguage();
            if (isoLanguagesList.contains(languageString)) continue;
            String text = MessageFormat.format(Messages.IpsProjectProperties_msgSupportedLanguageUnknownLocale, languageString);
            Message msg = new Message("IPSPROJECT-SupportedLanguageUnknownLocale", text, Message.ERROR);
            list.add(msg);
            break;
        }
    }

    private void validateSupportedLanguagesOneDefaultLanguage(MessageList list) {
        int defaultLanguageCount = 0;
        for (ISupportedLanguage supportedLanguage : this.supportedLanguages) {
            if (supportedLanguage.isDefaultLanguage()) {
                ++defaultLanguageCount;
            }
            if (defaultLanguageCount != 2) continue;
            String text = Messages.IpsProjectProperties_msgMoreThanOneDefaultLanguage;
            Message msg = new Message("IPSPROJECT-MoreThanOneDefaultLanguage", text, Message.ERROR);
            list.add(msg);
            break;
        }
    }

    private void validateFeatureConfigurations(MessageList list) {
        LinkedHashSet<String> requiredIpsFeatureIds = new LinkedHashSet<String>();
        String[] stringArray = this.getRequiredIpsFeatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String featureId = stringArray[n2];
            requiredIpsFeatureIds.add(featureId);
            ++n2;
        }
        for (Map.Entry<String, IpsFeatureConfiguration> featureConfigurationEntry : this.featureConfigurations.entrySet()) {
            String featureId = featureConfigurationEntry.getKey();
            if (requiredIpsFeatureIds.contains(featureId)) continue;
            String text = MessageFormat.format(Messages.IpsProjectProperties_msgUnknownFeatureIdForConfiguration, featureId);
            Message msg = new Message("IPSPROJECT-FeatureConfigurationUnknownFeature", text, Message.ERROR);
            list.add(msg);
        }
    }

    public boolean isCreatedFromParsableFileContents() {
        return this.createdFromParsableFileContents;
    }

    public void setCreatedFromParsableFileContents(boolean flag) {
        this.createdFromParsableFileContents = flag;
    }

    @Override
    public String getBuilderSetId() {
        return this.builderSetId;
    }

    @Override
    public void setBuilderSetId(String id) {
        ArgumentCheck.notNull((Object)id);
        this.builderSetId = id;
    }

    @Override
    public IIpsObjectPath getIpsObjectPath() {
        return this.path;
    }

    @Override
    public boolean isModelProject() {
        return this.modelProject;
    }

    @Override
    public void setModelProject(boolean modelProject) {
        this.modelProject = modelProject;
    }

    @Override
    public boolean isProductDefinitionProject() {
        return this.productDefinitionProject;
    }

    @Override
    public void setProductDefinitionProject(boolean productDefinitionProject) {
        this.productDefinitionProject = productDefinitionProject;
    }

    @Override
    public IProductCmptNamingStrategy getProductCmptNamingStrategy() {
        if (this.productCmptNamingStrategy == null) {
            return this.defaultCmptNamingStrategy;
        }
        return this.productCmptNamingStrategy;
    }

    @Override
    public void setProductCmptNamingStrategy(IProductCmptNamingStrategy newStrategy) {
        ArgumentCheck.notNull((Object)newStrategy);
        this.productCmptNamingStrategy = newStrategy;
        this.productCmptNamingStrategyId = newStrategy.getExtensionId();
    }

    public void setProductCmptNamingStrategyInternal(IProductCmptNamingStrategy newStrategy, String id) {
        this.productCmptNamingStrategy = newStrategy;
        this.productCmptNamingStrategyId = id;
    }

    @Override
    public void setChangesOverTimeNamingConventionIdForGeneratedCode(String changesInTimeConventionIdForGeneratedCode) {
        this.changesInTimeConventionIdForGeneratedCode = changesInTimeConventionIdForGeneratedCode;
    }

    @Override
    public String getChangesOverTimeNamingConventionIdForGeneratedCode() {
        return this.changesInTimeConventionIdForGeneratedCode;
    }

    @Override
    public void setIpsObjectPath(IIpsObjectPath path) {
        ArgumentCheck.notNull((Object)path);
        this.path = path;
    }

    @Override
    public String[] getPredefinedDatatypesUsed() {
        return this.predefinedDatatypesUsed;
    }

    @Override
    public void setPredefinedDatatypesUsed(String[] datatypes) {
        ArgumentCheck.notNull((Object[])datatypes);
        this.predefinedDatatypesUsed = datatypes;
    }

    @Override
    public void setPredefinedDatatypesUsed(ValueDatatype[] datatypes) {
        ArgumentCheck.notNull((Object[])datatypes);
        this.predefinedDatatypesUsed = new String[datatypes.length];
        int i = 0;
        while (i < datatypes.length) {
            this.predefinedDatatypesUsed[i] = datatypes[i].getQualifiedName();
            ++i;
        }
    }

    @Override
    public List<Datatype> getDefinedDatatypes() {
        return this.definedDatatypes;
    }

    public DynamicValueDatatype[] getDefinedValueDatatypes() {
        ArrayList<DynamicValueDatatype> valuetypes = new ArrayList<DynamicValueDatatype>(this.definedDatatypes.size());
        for (Datatype datatype : this.definedDatatypes) {
            if (!datatype.isValueDatatype()) continue;
            valuetypes.add((DynamicValueDatatype)datatype);
        }
        return valuetypes.toArray(new DynamicValueDatatype[valuetypes.size()]);
    }

    @Override
    public void setDefinedDatatypes(IDynamicValueDatatype[] datatypes) {
        this.definedDatatypes = new ArrayList<Datatype>(datatypes.length);
        IDynamicValueDatatype[] iDynamicValueDatatypeArray = datatypes;
        int n = datatypes.length;
        int n2 = 0;
        while (n2 < n) {
            IDynamicValueDatatype datatype = iDynamicValueDatatypeArray[n2];
            this.definedDatatypes.add((Datatype)datatype);
            ++n2;
        }
    }

    @Override
    public void setDefinedDatatypes(Datatype[] datatypes) {
        this.definedDatatypes = new ArrayList<Datatype>(datatypes.length);
        Datatype[] datatypeArray = datatypes;
        int n = datatypes.length;
        int n2 = 0;
        while (n2 < n) {
            Datatype datatype = datatypeArray[n2];
            this.definedDatatypes.add(datatype);
            ++n2;
        }
    }

    public Element toXml(Document doc) {
        this.createIpsProjectDescriptionComment(doc);
        Element projectEl = doc.createElement(TAG_NAME);
        projectEl.setAttribute("modelProject", "" + this.modelProject);
        projectEl.setAttribute("productDefinitionProject", "" + this.productDefinitionProject);
        projectEl.setAttribute("runtimeIdPrefix", this.runtimeIdPrefix);
        projectEl.setAttribute(ATTRIBUTE_CHANGES_IN_TIME_NAMING_CONVENTION, this.changesInTimeConventionIdForGeneratedCode);
        projectEl.setAttribute(ATTRIBUTE_PERSISTENT_PROJECT, Boolean.toString(this.persistentProject));
        if (this.isValidateIpsSchema()) {
            projectEl.setAttribute("xmlns", "http://www.faktorzehn.org");
            projectEl.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.faktorzehn.org " + org.faktorips.devtools.model.util.XmlUtil.getIpsProjectPropertiesSchemaLocation());
        }
        this.createRequiredIpsFeaturesComment(projectEl);
        Element features = doc.createElement("RequiredIpsFeatures");
        projectEl.appendChild(features);
        for (String key : this.requiredFeatures.keySet()) {
            Element feature = doc.createElement("RequiredIpsFeature");
            features.appendChild(feature);
            feature.setAttribute("id", key);
            feature.setAttribute("minVersion", this.requiredFeatures.get(key));
        }
        this.createIpsArtefactBuilderSetDescriptionComment(projectEl);
        Element builderSetEl = doc.createElement("IpsArtefactBuilderSet");
        projectEl.appendChild(builderSetEl);
        builderSetEl.setAttribute("id", this.builderSetId);
        builderSetEl.appendChild(this.builderSetConfig.toXml(doc));
        if (this.productCmptNamingStrategy != null) {
            this.createProductCmptNamingStrategyDescriptionComment(projectEl);
            projectEl.appendChild(this.productCmptNamingStrategy.toXml(doc));
        }
        IpsObjectPathXmlPersister xmlIpsObjectPathPersistor = new IpsObjectPathXmlPersister();
        this.createDescriptionComment(xmlIpsObjectPathPersistor.getXmlFormatDescription(), projectEl);
        projectEl.appendChild(xmlIpsObjectPathPersistor.store(doc, (IpsObjectPath)this.path));
        this.toXmlDatatypes(doc, projectEl);
        this.toXmlResourcesExcludeFromProdDef(doc, projectEl);
        this.toXmlProductRelease(doc, projectEl);
        this.toXmlVersion(doc, projectEl);
        this.toXmlForAdditionalSettings(doc, projectEl);
        this.toXmlPersistenceOptions(doc, projectEl);
        this.createSupportedLanguagesDescriptionComment(projectEl);
        Element supportedLanguagesEl = doc.createElement("SupportedLanguages");
        projectEl.appendChild(supportedLanguagesEl);
        for (ISupportedLanguage supportedLanguage : this.supportedLanguages) {
            supportedLanguagesEl.appendChild(supportedLanguage.toXml(doc));
        }
        String s = "Setting the default currency for this project using the ISO 4217 code of the currency (e.g. EUR for euro or USD for US Dollar)";
        this.createDescriptionComment(s, projectEl);
        Element defaultCurrencyElement = doc.createElement(DEFAULT_CURRENCY_ELEMENT);
        defaultCurrencyElement.setAttribute("value", this.defaultCurrency.getCurrencyCode());
        projectEl.appendChild(defaultCurrencyElement);
        this.toXmlFeatureConfigurations(doc, projectEl);
        return projectEl;
    }

    private void toXmlDatatypes(Document doc, Element projectEl) {
        this.createDatatypeDescriptionComment(projectEl);
        Element datatypesEl = doc.createElement("Datatypes");
        projectEl.appendChild(datatypesEl);
        Element predefinedTypesEl = doc.createElement("UsedPredefinedDatatypes");
        datatypesEl.appendChild(predefinedTypesEl);
        String[] stringArray = this.predefinedDatatypesUsed;
        int n = this.predefinedDatatypesUsed.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            Element datatypeEl = doc.createElement("Datatype");
            datatypeEl.setAttribute("id", element);
            predefinedTypesEl.appendChild(datatypeEl);
            ++n2;
        }
        Element definedDatatypesEl = doc.createElement("DatatypeDefinitions");
        datatypesEl.appendChild(definedDatatypesEl);
        this.writeDefinedDataTypesToXML(doc, definedDatatypesEl);
    }

    private void toXmlResourcesExcludeFromProdDef(Document doc, Element projectEl) {
        this.createResourcesExcludedFromProductDefinitionComment(projectEl);
        Element resourcesExcludedFromProdDefEl = doc.createElement("ResourcesExcludedFromProductDefinition");
        projectEl.appendChild(resourcesExcludedFromProdDefEl);
        for (String exclResource : this.resourcesPathExcludedFromTheProductDefiniton) {
            Element resourceExcludedEl = doc.createElement("Resource");
            resourceExcludedEl.setAttribute("path", exclResource);
            resourcesExcludedFromProdDefEl.appendChild(resourceExcludedEl);
        }
    }

    private void toXmlProductRelease(Document doc, Element projectEl) {
        this.createProductReleaseComment(projectEl);
        if (IpsStringUtils.isNotEmpty((String)this.releaseExtensionId)) {
            Element release = doc.createElement(PRODUCT_RELEASE);
            release.setAttribute(RELEASE_EXTENSION_ID_ATTRIBUTE, this.releaseExtensionId);
            projectEl.appendChild(release);
        }
    }

    private void toXmlVersion(Document doc, Element projectEl) {
        this.createVersionComment(projectEl);
        if (IpsStringUtils.isNotEmpty((String)this.versionProviderId) || IpsStringUtils.isNotEmpty((String)this.version)) {
            Element release = doc.createElement(VERSION_TAG_NAME);
            if (IpsStringUtils.isNotEmpty((String)this.versionProviderId)) {
                release.setAttribute(VERSION_PROVIDER_ATTRIBUTE, this.versionProviderId);
            }
            if (IpsStringUtils.isNotEmpty((String)this.version)) {
                release.setAttribute(VERSION_ATTRIBUTE, this.version);
            }
            projectEl.appendChild(release);
        }
    }

    private void toXmlForAdditionalSettings(Document doc, Element projectEl) {
        this.createAdditionalSettingsDescriptionComment(projectEl);
        Element additionalSettingsEl = doc.createElement(ADDITIONAL_SETTINGS_TAG_NAME);
        projectEl.appendChild(additionalSettingsEl);
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_DERIVED_UNION_IS_IMPLEMENTED, this.derivedUnionIsImplementedRuleEnabled));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_REFERENCED_PRODUCT_COMPONENTS_ARE_VALID_ON_THIS_GENERATIONS_VALID_FROM_DATE, this.referencedProductComponentsAreValidOnThisGenerationsValidFromDateRuleEnabled));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_RULES_WITHOUT_REFERENCE, this.rulesWithoutReferencesAllowed));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_SHARED_ASSOCIATIONS, this.isSharedDetailToMasterAssociations()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_FORMULA_LANGUAGE_LOCALE, this.formulaLanguageLocale.getLanguage()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_MARKER_ENUMS, this.isMarkerEnumsEnabled(), this.getMarkerEnumsAsString()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_CHANGING_OVER_TIME_DEFAULT, this.isChangingOverTimeDefaultEnabled()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_INFERRED_TEMPLATE_LINK_THRESHOLD, this.getInferredTemplateLinkThreshold().toString()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_INFERRED_TEMPLATE_PROPERTY_VALUE_THRESHOLD, this.getInferredTemplatePropertyValueThreshold().toString()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_DUPLICATE_PRODUCT_COMPONENT_SERVERITY, this.getDuplicateProductComponentSeverity().toString()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_PERSISTENCE_COLUMN_SIZE_CHECKS_SERVERITY, this.getPersistenceColumnSizeChecksSeverity().toString()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_MISSING_DATATYPE_SERVERITY, this.getMissingDatatypeSeverity().toString()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_TABLE_CONTENT_FORMAT, this.getTableContentFormat().name()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_GENERATE_VALIDATOR_CLASS_BY_DEFAULT, this.isGenerateValidatorClassDefaultEnabled()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_GENERIC_VALIDATION_BY_DEFAULT, this.isGenericValidationDefaultEnabled()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_ESCAPE_NON_STANDARD_BLANKS, this.isEscapeNonStandardBlanks()));
        additionalSettingsEl.appendChild(this.createSettingElement(doc, SETTING_VALIDATE_IPS_SCHEMA, this.isValidateIpsSchema()));
    }

    private String getMarkerEnumsAsString() {
        return StringUtils.join(this.getMarkerEnums(), (String)MARKER_ENUMS_DELIMITER);
    }

    private void toXmlPersistenceOptions(Document doc, Element projectEl) {
        this.createPersistenceOptionsDescriptionComment(projectEl);
        Element persistenceOptionsEl = doc.createElement("PersistenceOptions");
        persistenceOptionsEl.setAttribute("maxTableNameLength", String.valueOf(this.getPersistenceOptions().getMaxTableNameLength()));
        persistenceOptionsEl.setAttribute("maxColumnNameLength", String.valueOf(this.getPersistenceOptions().getMaxColumnNameLenght()));
        projectEl.appendChild(persistenceOptionsEl);
        persistenceOptionsEl.setAttribute("allowLazyFetchForSingleValuedAssociations", "" + Boolean.valueOf(this.getPersistenceOptions().isAllowLazyFetchForSingleValuedAssociations()));
        persistenceOptionsEl.setAttribute("maxTableColumnSize", String.valueOf(this.getPersistenceOptions().getMaxTableColumnSize()));
        persistenceOptionsEl.setAttribute("maxTableColumnScale", String.valueOf(this.getPersistenceOptions().getMaxTableColumnScale()));
        persistenceOptionsEl.setAttribute("maxTableColumnPrecision", String.valueOf(this.getPersistenceOptions().getMaxTableColumnPrecision()));
        ITableNamingStrategy tableNamingStrategy = this.getPersistenceOptions().getTableNamingStrategy();
        ITableColumnNamingStrategy tableColumnNamingStrategy = this.getPersistenceOptions().getTableColumnNamingStrategy();
        persistenceOptionsEl.appendChild(tableNamingStrategy.toXml(doc));
        persistenceOptionsEl.appendChild(tableColumnNamingStrategy.toXml(doc));
    }

    private void toXmlFeatureConfigurations(Document doc, Element projectEl) {
        if (!this.featureConfigurations.isEmpty()) {
            Element featureConfigurationsElement = doc.createElement(FEATURE_CONFIGURATIONS_ELEMENT);
            for (Map.Entry<String, IpsFeatureConfiguration> featureConfiguration : this.featureConfigurations.entrySet()) {
                Element featureConfigurationElement = featureConfiguration.getValue().toXml(doc);
                featureConfigurationElement.setAttribute(FEATURE_ID_ATTRIBUTE, featureConfiguration.getKey());
                featureConfigurationsElement.appendChild(featureConfigurationElement);
            }
            projectEl.appendChild(featureConfigurationsElement);
        }
    }

    @Override
    public LinkedHashSet<String> getMarkerEnums() {
        return this.markerEnums;
    }

    @Override
    public void addMarkerEnum(String qualifiedName) {
        ArgumentCheck.notNull((Object)qualifiedName);
        this.getMarkerEnums().add(qualifiedName.trim());
    }

    @Override
    public void removeMarkerEnum(String qualifiedName) {
        ArgumentCheck.notNull((Object)qualifiedName);
        this.getMarkerEnums().remove(qualifiedName);
    }

    @Override
    public boolean isMarkerEnumsEnabled() {
        return this.enableMarkerEnums;
    }

    @Override
    public void setMarkerEnumsEnabled(boolean enabled) {
        this.enableMarkerEnums = enabled;
    }

    private Element createSettingElement(Document doc, String name, boolean enabled) {
        Element constraintElement = doc.createElement(SETTING_TAG_NAME);
        constraintElement.setAttribute(SETTING_ATTRIBUTE_NAME, name);
        constraintElement.setAttribute(SETTING_ATTRIBUTE_ENABLED, Boolean.toString(enabled));
        return constraintElement;
    }

    protected Element createSettingElement(Document doc, String name, String value) {
        Element constraintElement = doc.createElement(SETTING_TAG_NAME);
        constraintElement.setAttribute(SETTING_ATTRIBUTE_NAME, name);
        constraintElement.setAttribute("value", value);
        return constraintElement;
    }

    private Element createSettingElement(Document doc, String name, boolean enable, String value) {
        Element constraintElement = doc.createElement(SETTING_TAG_NAME);
        constraintElement.setAttribute(SETTING_ATTRIBUTE_NAME, name);
        constraintElement.setAttribute(SETTING_ATTRIBUTE_ENABLED, Boolean.toString(enable));
        constraintElement.setAttribute("value", value);
        return constraintElement;
    }

    public void initFromXml(IIpsProject ipsProject, Element element) {
        this.modelProject = Boolean.parseBoolean(element.getAttribute("modelProject"));
        this.productDefinitionProject = Boolean.parseBoolean(element.getAttribute("productDefinitionProject"));
        this.persistentProject = ValueToXmlHelper.isAttributeTrue((Element)element, (String)ATTRIBUTE_PERSISTENT_PROJECT);
        this.runtimeIdPrefix = element.getAttribute("runtimeIdPrefix");
        this.changesInTimeConventionIdForGeneratedCode = element.getAttribute(ATTRIBUTE_CHANGES_IN_TIME_NAMING_CONVENTION);
        this.changesInTimeConventionIdForGeneratedCode = IpsStringUtils.isEmpty((String)this.changesInTimeConventionIdForGeneratedCode) ? "VAA" : this.changesInTimeConventionIdForGeneratedCode;
        Element artefactEl = XmlUtil.getFirstElement((Node)element, (String)"IpsArtefactBuilderSet");
        if (artefactEl != null) {
            this.builderSetId = artefactEl.getAttribute("id");
            Element artefactConfigEl = XmlUtil.getFirstElement((Node)artefactEl, (String)"IpsArtefactBuilderSetConfig");
            if (artefactConfigEl != null) {
                this.builderSetConfig = new IpsArtefactBuilderSetConfigModel();
                this.builderSetConfig.initFromXml(artefactConfigEl);
            }
        } else {
            this.builderSetId = "";
        }
        this.initProductCmptNamingStrategyFromXml(ipsProject, XmlUtil.getFirstElement((Node)element, (String)"ProductCmptNamingStrategy"));
        Element pathEl = XmlUtil.getFirstElement((Node)element, (String)"IpsObjectPath");
        if (pathEl != null) {
            if (this.isUsingManifest(pathEl)) {
                this.createObjectPathFromManifest(ipsProject);
            } else {
                this.path = new IpsObjectPathXmlPersister().read(ipsProject, pathEl);
            }
        } else {
            this.path = new IpsObjectPath(ipsProject);
        }
        Element datatypesEl = XmlUtil.getFirstElement((Node)element, (String)"Datatypes");
        if (datatypesEl == null) {
            this.predefinedDatatypesUsed = new String[0];
            this.definedDatatypes.clear();
            return;
        }
        this.initUsedPredefinedDatatypesFromXml(XmlUtil.getFirstElement((Node)datatypesEl, (String)"UsedPredefinedDatatypes"));
        this.initDefinedDatatypesFromXml(ipsProject, XmlUtil.getFirstElement((Node)datatypesEl, (String)"DatatypeDefinitions"));
        this.initRequiredFeatures(XmlUtil.getFirstElement((Node)element, (String)"RequiredIpsFeatures"));
        this.initResourcesExcludedFromProductDefinition(XmlUtil.getFirstElement((Node)element, (String)"ResourcesExcludedFromProductDefinition"));
        this.initReleaseExtension(XmlUtil.getFirstElement((Node)element, (String)PRODUCT_RELEASE));
        this.initVersion(XmlUtil.getFirstElement((Node)element, (String)VERSION_TAG_NAME));
        this.initAdditionalSettings(element);
        this.initPersistenceOptions(element);
        this.initSupportedLanguages(element);
        this.initDefaultCurrency(element);
        this.initFeatureConfigurations(element);
        this.initCompatibilityMode(element);
    }

    private void initCompatibilityMode(Element element) {
        this.initCompatibilityModelProductRelease(XmlUtil.getFirstElement((Node)element, (String)PRODUCT_RELEASE_DEPRECATED));
    }

    private void initCompatibilityModelProductRelease(Element productReleaseDeprecated) {
        if (productReleaseDeprecated != null) {
            if (IpsStringUtils.isEmpty((String)this.version)) {
                this.version = productReleaseDeprecated.getAttribute(VERSION_ATTRIBUTE);
            }
            if (IpsStringUtils.isEmpty((String)this.releaseExtensionId)) {
                this.releaseExtensionId = productReleaseDeprecated.getAttribute(RELEASE_EXTENSION_ID_ATTRIBUTE);
            }
        }
    }

    private boolean isUsingManifest(Element pathEl) {
        String usingManifest = pathEl.getAttribute("useManifest");
        return Boolean.parseBoolean(usingManifest);
    }

    private void createObjectPathFromManifest(IIpsProject ipsProject) {
        AFile file = ipsProject.getProject().getFile("META-INF/MANIFEST.MF");
        if (file.exists()) {
            this.createObjectPathFromExistingManifest(ipsProject, file);
        } else {
            this.path = new IpsObjectPath(ipsProject);
            this.path.setUsingManifest(true);
        }
    }

    private void createObjectPathFromExistingManifest(IIpsProject ipsProject, AFile file) {
        InputStream contents = null;
        try {
            try {
                contents = file.getContents();
                Manifest manifest = new Manifest(contents);
                IpsBundleManifest bundleManifest = new IpsBundleManifest(manifest);
                this.path = new IpsObjectPathManifestReader(bundleManifest, ipsProject).readIpsObjectPath();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            IoUtil.close((Closeable)contents);
        }
    }

    private void initRequiredFeatures(Element el) {
        this.requiredFeatures = new HashMap<String, String>();
        if (el == null) {
            return;
        }
        NodeList nl = el.getElementsByTagName("RequiredIpsFeature");
        int i = 0;
        while (i < nl.getLength()) {
            Element child = (Element)nl.item(i);
            this.requiredFeatures.put(child.getAttribute("id"), child.getAttribute("minVersion"));
            ++i;
        }
    }

    private void initProductCmptNamingStrategyFromXml(IIpsProject ipsProject, Element el) {
        this.defaultCmptNamingStrategy = new NoVersionIdProductCmptNamingStrategyFactory().newProductCmptNamingStrategy(ipsProject);
        if (el != null) {
            this.productCmptNamingStrategyId = el.getAttribute("id");
            if (IpsStringUtils.isEmpty((String)this.productCmptNamingStrategyId)) {
                return;
            }
            IProductCmptNamingStrategyFactory factory = ipsProject.getIpsModel().getCustomModelExtensions().getProductCmptNamingStrategyFactory(this.productCmptNamingStrategyId);
            if (factory != null) {
                this.productCmptNamingStrategy = factory.newProductCmptNamingStrategy(ipsProject);
                this.productCmptNamingStrategy.initFromXml(el);
            }
        }
    }

    private void initUsedPredefinedDatatypesFromXml(Element element) {
        if (element == null) {
            this.predefinedDatatypesUsed = new String[0];
            return;
        }
        NodeList nl = element.getElementsByTagName("Datatype");
        this.predefinedDatatypesUsed = new String[nl.getLength()];
        int i = 0;
        while (i < nl.getLength()) {
            this.predefinedDatatypesUsed[i] = ((Element)nl.item(i)).getAttribute("id");
            ++i;
        }
    }

    private void initDefinedDatatypesFromXml(IIpsProject ipsProject, Element element) {
        if (element == null) {
            this.definedDatatypes.clear();
            return;
        }
        NodeList nl = element.getElementsByTagName("Datatype");
        this.definedDatatypes = new ArrayList<Datatype>(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            Element el = (Element)nl.item(i);
            Datatype datatype = this.createDefinedDatatype(ipsProject, el);
            this.definedDatatypes.add(datatype);
            ++i;
        }
    }

    private Datatype createDefinedDatatype(IIpsProject ipsProject, Element element) {
        if (!element.hasAttribute("valueObject") || Boolean.parseBoolean(element.getAttribute("valueObject"))) {
            return DynamicValueDatatype.createFromXml(ipsProject, element);
        }
        String javaClass = element.getAttribute("javaClass");
        String qName = element.getAttribute("id");
        return new JavaClass2DatatypeAdaptor(qName, javaClass);
    }

    private void initResourcesExcludedFromProductDefinition(Element element) {
        if (element == null) {
            return;
        }
        NodeList nl = element.getElementsByTagName("Resource");
        int length = nl.getLength();
        int i = 0;
        while (i < length) {
            Element child = (Element)nl.item(i);
            Attr resourcePath = child.getAttributeNode("path");
            if (resourcePath != null && IpsStringUtils.isNotEmpty((String)resourcePath.getValue())) {
                this.resourcesPathExcludedFromTheProductDefiniton.add(resourcePath.getValue());
            }
            ++i;
        }
    }

    private void initReleaseExtension(Element productReleaseElement) {
        if (productReleaseElement == null) {
            return;
        }
        this.version = productReleaseElement.getAttribute(VERSION_ATTRIBUTE);
        this.releaseExtensionId = productReleaseElement.getAttribute(RELEASE_EXTENSION_ID_ATTRIBUTE);
        this.versionProviderId = productReleaseElement.getAttribute(VERSION_PROVIDER_ATTRIBUTE);
    }

    private void initVersion(Element element) {
        if (element == null) {
            return;
        }
        this.version = element.getAttribute(VERSION_ATTRIBUTE);
        this.versionProviderId = element.getAttribute(VERSION_PROVIDER_ATTRIBUTE);
    }

    private void initAdditionalSettings(Element element) {
        Element additionalSettingsEl;
        if (element.hasAttribute("containerRelationIsImplementedRuleEnabled")) {
            this.derivedUnionIsImplementedRuleEnabled = Boolean.parseBoolean(element.getAttribute("containerRelationIsImplementedRuleEnabled"));
        }
        if (element.hasAttribute("derivedUnionIsImplementedRuleEnabled")) {
            this.derivedUnionIsImplementedRuleEnabled = Boolean.parseBoolean(element.getAttribute("derivedUnionIsImplementedRuleEnabled"));
        }
        if ((additionalSettingsEl = XmlUtil.getFirstElement((Node)element, (String)ADDITIONAL_SETTINGS_TAG_NAME)) == null) {
            return;
        }
        NodeList nl = additionalSettingsEl.getElementsByTagName(SETTING_TAG_NAME);
        int length = nl.getLength();
        IpsProjectPropertiesForOldVersion defaultForOld = new IpsProjectPropertiesForOldVersion();
        defaultForOld.add(SETTING_VALIDATE_IPS_SCHEMA, IpsProjectProperties::setValidateIpsSchema, false);
        int i = 0;
        while (i < length) {
            Element child = (Element)nl.item(i);
            if (!this.isInvalidSettingElement(child)) {
                String name = child.getAttribute(SETTING_ATTRIBUTE_NAME);
                boolean enabled = this.isEnabledSetting(child);
                String value = child.getAttribute("value");
                this.applySetting(name, enabled, value);
                this.initFunctionsLanguageLocale(name, value);
                defaultForOld.checkIfFound(name);
            }
            ++i;
        }
        defaultForOld.applyNewValue(this);
        if (!this.markerEnumsConfiguredInIpsProjectFile) {
            this.setMarkerEnumsEnabled(false);
        }
    }

    private boolean isInvalidSettingElement(Element child) {
        return !child.hasAttribute(SETTING_ATTRIBUTE_NAME) || !child.hasAttribute("value") && !child.hasAttribute(SETTING_ATTRIBUTE_ENABLED);
    }

    private boolean isEnabledSetting(Element child) {
        String enabledAttributeValue = child.getAttribute(SETTING_ATTRIBUTE_ENABLED);
        if (IpsStringUtils.isEmpty((String)enabledAttributeValue)) {
            String value = child.getAttribute("value");
            return !Boolean.FALSE.toString().equals(value);
        }
        return Boolean.parseBoolean(enabledAttributeValue);
    }

    private void applySetting(String name, boolean enabled, String value) {
        if (name.equals(SETTING_DERIVED_UNION_IS_IMPLEMENTED)) {
            this.derivedUnionIsImplementedRuleEnabled = enabled;
        } else if (name.equals(SETTING_REFERENCED_PRODUCT_COMPONENTS_ARE_VALID_ON_THIS_GENERATIONS_VALID_FROM_DATE)) {
            this.referencedProductComponentsAreValidOnThisGenerationsValidFromDateRuleEnabled = enabled;
        } else if (name.equals(SETTING_RULES_WITHOUT_REFERENCE)) {
            this.rulesWithoutReferencesAllowed = enabled;
        } else if (name.equals(SETTING_SHARED_ASSOCIATIONS)) {
            this.setSharedDetailToMasterAssociations(enabled);
        } else if (name.equals(SETTING_MARKER_ENUMS)) {
            this.setMarkerEnumsEnabled(enabled);
            this.initMarkerEnums(value);
            this.markerEnumsConfiguredInIpsProjectFile = true;
        } else if (name.equals(SETTING_CHANGING_OVER_TIME_DEFAULT)) {
            this.setChangingOverTimeDefault(enabled);
        } else if (name.equals(SETTING_GENERATE_VALIDATOR_CLASS_BY_DEFAULT)) {
            this.setGenerateValidatorClassDefault(enabled);
        } else if (name.equals(SETTING_GENERIC_VALIDATION_BY_DEFAULT)) {
            this.setGenericValidationDefault(enabled);
        } else if (name.equals(SETTING_ESCAPE_NON_STANDARD_BLANKS)) {
            this.setEscapeNonStandardBlanks(enabled);
        } else if (name.equals(SETTING_INFERRED_TEMPLATE_LINK_THRESHOLD)) {
            this.setInferredTemplateLinkThreshold(Decimal.valueOf((String)value));
        } else if (name.equals(SETTING_INFERRED_TEMPLATE_PROPERTY_VALUE_THRESHOLD)) {
            this.setInferredTemplatePropertyValueThreshold(Decimal.valueOf((String)value));
        } else if (name.equals(SETTING_DUPLICATE_PRODUCT_COMPONENT_SERVERITY)) {
            this.setDuplicateProductComponentSeverity(Severity.valueOf((String)value));
        } else if (name.contentEquals(SETTING_PERSISTENCE_COLUMN_SIZE_CHECKS_SERVERITY)) {
            this.setPersistenceColumnSizeChecksSeverity(Severity.valueOf((String)value));
        } else if (name.contentEquals(SETTING_MISSING_DATATYPE_SERVERITY)) {
            this.setMissingDatatypeSeverity(Severity.valueOf((String)value));
        } else if (name.contentEquals(SETTING_TABLE_CONTENT_FORMAT)) {
            this.setTableContentFormat(TableContentFormat.valueById(value));
        } else if (name.contentEquals(SETTING_VALIDATE_IPS_SCHEMA)) {
            this.setValidateIpsSchema(enabled);
        }
    }

    private void initMarkerEnums(String value) {
        this.getMarkerEnums().clear();
        if (!value.isEmpty()) {
            String[] splitString;
            String[] stringArray = splitString = value.split(MARKER_ENUMS_DELIMITER);
            int n = splitString.length;
            int n2 = 0;
            while (n2 < n) {
                String qualifiedName = stringArray[n2];
                this.addMarkerEnum(qualifiedName.trim());
                ++n2;
            }
        }
    }

    private void initFunctionsLanguageLocale(String name, String value) {
        if (name.equals(SETTING_FORMULA_LANGUAGE_LOCALE) && value != null) {
            this.formulaLanguageLocale = new Locale(value);
        }
    }

    private void initPersistenceOptions(Element element) {
        this.persistenceOptions = new PersistenceOptions(XmlUtil.getFirstElement((Node)element, (String)"PersistenceOptions"));
    }

    private void initSupportedLanguages(Element element) {
        Element supportedLanguagesEl = XmlUtil.getFirstElement((Node)element, (String)"SupportedLanguages");
        if (supportedLanguagesEl != null) {
            int childrenCount = supportedLanguagesEl.getElementsByTagName("SupportedLanguage").getLength();
            int i = 0;
            while (i < childrenCount) {
                SupportedLanguage supportedLanguage = new SupportedLanguage();
                Element childElement = org.faktorips.devtools.model.util.XmlUtil.getElement(supportedLanguagesEl, i);
                supportedLanguage.initFromXml(childElement);
                this.supportedLanguages.add(supportedLanguage);
                ++i;
            }
        }
    }

    private void initDefaultCurrency(Element element) {
        Element defaultCurrencyElement = XmlUtil.getFirstElement((Node)element, (String)DEFAULT_CURRENCY_ELEMENT);
        if (defaultCurrencyElement == null) {
            return;
        }
        String value = defaultCurrencyElement.getAttribute("value");
        this.defaultCurrency = this.readDefaultCurrency(value);
    }

    private Currency readDefaultCurrency(String value) {
        try {
            return Currency.getInstance(value);
        }
        catch (IllegalArgumentException e) {
            return this.defaultCurrency;
        }
    }

    private void initFeatureConfigurations(Element element) {
        Element featureConfigurationsElement = XmlUtil.getFirstElement((Node)element, (String)FEATURE_CONFIGURATIONS_ELEMENT);
        if (featureConfigurationsElement != null) {
            this.featureConfigurations.clear();
            NodeList featureConfigurationElements = featureConfigurationsElement.getElementsByTagName("FeatureConfiguration");
            int i = 0;
            while (i < featureConfigurationElements.getLength()) {
                Element featureConfigurationElement = (Element)featureConfigurationElements.item(i);
                String featureId = featureConfigurationElement.getAttribute(FEATURE_ID_ATTRIBUTE);
                IpsFeatureConfiguration featureConfiguration = new IpsFeatureConfiguration();
                featureConfiguration.initFromXml(featureConfigurationElement);
                this.setFeatureConfiguration(featureId, featureConfiguration);
                ++i;
            }
        }
    }

    private void writeDefinedDataTypesToXML(Document doc, Element parent) {
        for (Datatype datatype : this.definedDatatypes) {
            Element datatypeEl = doc.createElement("Datatype");
            if (datatype.getQualifiedName() != null) {
                datatypeEl.setAttribute("id", datatype.getQualifiedName());
            }
            if (datatype instanceof DynamicValueDatatype) {
                datatypeEl.setAttribute("valueObject", "true");
                ((DynamicValueDatatype)datatype).writeToXml(datatypeEl);
            } else {
                JavaClass2DatatypeAdaptor javaClassDatatype = (JavaClass2DatatypeAdaptor)datatype;
                datatypeEl.setAttribute("valueObject", "false");
                datatypeEl.setAttribute("javaClass", javaClassDatatype.getJavaClassName());
            }
            parent.appendChild(datatypeEl);
        }
    }

    @Override
    public void addDefinedDatatype(IDynamicValueDatatype newDatatype) {
        this.addDefinedDatatype((Datatype)newDatatype);
    }

    @Override
    public void addDefinedDatatype(Datatype newDatatype) {
        int i = 0;
        while (i < this.definedDatatypes.size()) {
            if (this.definedDatatypes.get(i).getQualifiedName() != null && newDatatype.getQualifiedName() != null && this.definedDatatypes.get(i).getQualifiedName().equals(newDatatype.getQualifiedName())) {
                this.definedDatatypes.set(i, newDatatype);
                return;
            }
            ++i;
        }
        this.definedDatatypes.add(newDatatype);
    }

    @Override
    public String getRuntimeIdPrefix() {
        return this.runtimeIdPrefix;
    }

    @Override
    public void setRuntimeIdPrefix(String runtimeIdPrefix) {
        if (runtimeIdPrefix == null) {
            throw new NullPointerException("RuntimeIdPrefix can not be null");
        }
        this.runtimeIdPrefix = runtimeIdPrefix;
    }

    @Override
    public boolean isDerivedUnionIsImplementedRuleEnabled() {
        return this.derivedUnionIsImplementedRuleEnabled;
    }

    @Override
    public void setDerivedUnionIsImplementedRuleEnabled(boolean enabled) {
        this.derivedUnionIsImplementedRuleEnabled = enabled;
    }

    @Override
    public boolean isReferencedProductComponentsAreValidOnThisGenerationsValidFromDateRuleEnabled() {
        return this.referencedProductComponentsAreValidOnThisGenerationsValidFromDateRuleEnabled;
    }

    @Override
    public boolean isRulesWithoutReferencesAllowedEnabled() {
        return this.rulesWithoutReferencesAllowed;
    }

    @Override
    public void setRulesWithoutReferencesAllowedEnabled(boolean enabled) {
        this.rulesWithoutReferencesAllowed = enabled;
    }

    @Override
    public void setSharedDetailToMasterAssociations(boolean sharedDetailToMasterAssociations) {
        this.sharedDetailToMasterAssociations = sharedDetailToMasterAssociations;
    }

    @Override
    public boolean isSharedDetailToMasterAssociations() {
        return this.sharedDetailToMasterAssociations;
    }

    @Override
    public void setReferencedProductComponentsAreValidOnThisGenerationsValidFromDateRuleEnabled(boolean enabled) {
        this.referencedProductComponentsAreValidOnThisGenerationsValidFromDateRuleEnabled = enabled;
    }

    private void createIpsProjectDescriptionComment(Node parentEl) {
        String s = "This XML file contains the properties of the enclosing IPS project. It contains the following " + System.lineSeparator() + " information:" + System.lineSeparator() + "The generator used to transform the model to Java sourcecode and the product definition into the runtime format." + System.lineSeparator() + "The path where to search for model and product definition files. This is basically the same concept as the  Java " + System.lineSeparator() + "classpath. A strategy that defines how to name product components and what names are valid." + System.lineSeparator() + "The datatypes that can be used in the model. Datatypes used in the model fall into two categeories:" + System.lineSeparator() + " * Predefined datatype" + System.lineSeparator() + "   Predefined datatypes are defined by the datatype definition extension. Faktor-IPS predefines datatypes for" + System.lineSeparator() + "   the standard Java classes like Boolean, String, Integer, etc. and some additional types, for example Money." + System.lineSeparator() + "   You can add you own datatype be providing an extension and then use it from every IPS project." + System.lineSeparator() + " * User defined datatype (or dynamic datatype)" + System.lineSeparator() + "   If you want to use a Java class that represents a value as datatype, but do not want to provide an extension for" + System.lineSeparator() + "   it, you can register this class as datatype in this file. See the details in the description of the datatype " + System.lineSeparator() + "   section below how to register the class. Naturally, the class must be available via the project's Java classpath." + System.lineSeparator() + "   It is strongly recommended to provide the class via a JAR file or in a separate Java project." + System.lineSeparator() + " " + System.lineSeparator() + "<IpsProject>" + System.lineSeparator() + "    productDefinitionProject                           True if this project contains elements of the product definition." + System.lineSeparator() + "    modelProject                                       True if this project contains the model or part of it." + System.lineSeparator() + "    runtimeIdPrefix                                    " + System.lineSeparator() + "    " + ATTRIBUTE_CHANGES_IN_TIME_NAMING_CONVENTION + "                      Specifies the naming conventions for changes in time that " + System.lineSeparator() + "                                                       are used throughout the system. Possible values are VAA and PM" + System.lineSeparator() + "    <IpsArtefactBuilderSet/>                           The generator used. Details below." + System.lineSeparator() + "    <IpsObjectPath/>                                   The object path to search for model and product definition" + System.lineSeparator() + "                                                       objects. Details below." + System.lineSeparator() + "    <ProductCmptNamingStrategy/>                       The strategy used for product component names. Details below." + System.lineSeparator() + "    <Datatypes/>                                       The datatypes used in the model. Details below." + System.lineSeparator() + "    <OptionalConstraints/>                             Definition of optional constraints. Details below." + System.lineSeparator() + "    <SupportedLanguages/>                              List of supported natural languages. Details below." + System.lineSeparator() + "</IpsProject>" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl, "    ");
    }

    private void createProductCmptNamingStrategyDescriptionComment(Element parentEl) {
        String s = "Product Component Naming Strategy" + System.lineSeparator() + " " + System.lineSeparator() + "The naming strategy defines the structure of product component names and how characters that are not allowed" + System.lineSeparator() + "in Java identifiers are replaced by the code generator. In order to deal with different versions of " + System.lineSeparator() + "a product you need a strategy to derive the version from the product component name. " + System.lineSeparator() + " " + System.lineSeparator() + "Currently Faktor-IPS includes the following strategy:" + System.lineSeparator() + " * DateBasedProductCmptNamingStrategy" + System.lineSeparator() + "   The product component name is made up of a \"unversioned\" name and a date format for the version id." + System.lineSeparator() + "   <ProductCmptNamingStrategy id=\"org.faktorips.devtools.core.DateBasedProductCmptNamingStrategy\">" + System.lineSeparator() + "       <DateBasedProductCmptNamingStrategy " + System.lineSeparator() + "           dateFormatPattern=\"yyyy-MM\"                           Format of the version id according to" + System.lineSeparator() + "                                                                   java.text.DateFormat" + System.lineSeparator() + "           postfixAllowed=\"true\"                                 True if the date format can be followed by" + System.lineSeparator() + "                                                                   an optional postfix." + System.lineSeparator() + "           versionIdSeparator=\" \">                               The separator between \"unversioned name\"" + System.lineSeparator() + "                                                                   and version id." + System.lineSeparator() + "           <JavaIdentifierCharReplacements>                        Definition replacements for charcacters invalid " + System.lineSeparator() + "                                                                   in Java identifiers." + System.lineSeparator() + "               <Replacement replacedChar=\" \" replacement=\"___\"/> Example: Replace Blank with three underscores" + System.lineSeparator() + "               <Replacement replacedChar=\"-\" replacement=\"__\"/>  Example: Replace Hyphen with two underscores" + System.lineSeparator() + "           </JavaIdentifierCharReplacements>" + System.lineSeparator() + "       </DateBasedProductCmptNamingStrategy>" + System.lineSeparator() + "    </ProductCmptNamingStrategy>" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createDatatypeDescriptionComment(Node parentEl) {
        String s = "Datatypes" + System.lineSeparator() + " " + System.lineSeparator() + "In the datatypes section the value datatypes allowed in the model are defined." + System.lineSeparator() + "See also the discussion at the top this file." + System.lineSeparator() + " " + System.lineSeparator() + "<UsedPredefinedDatatypes>" + System.lineSeparator() + "    <Datatype id=\"Money\"\\>                                 The id of the datatype that should be used." + System.lineSeparator() + "</UsedPredefinedDatatypes>" + System.lineSeparator() + " " + System.lineSeparator() + "<DatatypeDefinitions>" + System.lineSeparator() + "    <Datatype id=\"PaymentMode\"                             The datatype's id used in the model to refer to it." + System.lineSeparator() + "        javaClass=\"org.faktorips.sample.PaymentMode\"       The Java class the datatype represents" + System.lineSeparator() + "        valueObject=\"true|false\"                           True indicates this is a value object (according to the value object pattern.) " + System.lineSeparator() + "        --- the following attributes are only needed for value objects ---" + System.lineSeparator() + "        isEnumType=\"true|false\"                            True if this is an enumeration of values." + System.lineSeparator() + "        valueOfMethod=\"getPaymentMode\"                     Name of the method that takes a String and returns an" + System.lineSeparator() + "                                                              object instance/value. This method has to be static." + System.lineSeparator() + "        isParsableMethod=\"isPaymentMode\"                   Name of the method that evaluates if a given string" + System.lineSeparator() + "                                                              can be parsed to an instance. This method has to be static and" + System.lineSeparator() + "                                                              is optional, if the valueOfMethod throws an Exception in case of an invalid id." + System.lineSeparator() + "        valueToStringMethod=\"toString\"                     Name of the method that transforms an object instance" + System.lineSeparator() + "                                                              to a String (that can be parsed via the valueOfMethod)" + System.lineSeparator() + "        getAllValuesMethod=\"getAllPaymentModes\"            For enums only: The name of the method that returns all values. This method has to be static." + System.lineSeparator() + "        isSupportingNames=\"true\"                           True indicates that a string" + System.lineSeparator() + "                                                              representation for the user other than the one defined by the valueToStringMethod exists." + System.lineSeparator() + "        getNameMethod=\"getName\"                            The name of the method that returns" + System.lineSeparator() + "                                                              the string representation for the user, if" + System.lineSeparator() + "                                                              isSupportingNames=true" + System.lineSeparator() + "        getValueByNameMethod=\"parseName\">                  The name of the method that returns a value for a given string representation for the user," + System.lineSeparator() + "                                                              if isSupportingNames=true. This method has to be static and be compatible to the getNameMethod." + System.lineSeparator() + "        <NullObjectId isNull=\"false\">n</NullObjectId>      Marks a value as a NullObject. This has to be used," + System.lineSeparator() + "                                                              if the Java class implements the null object pattern," + System.lineSeparator() + "                                                              otherwise omitt this element. The element's text" + System.lineSeparator() + "                                                              defines the null object's id. Calling the valueOfMethod" + System.lineSeparator() + "                                                              with this name must return the null object instance. If" + System.lineSeparator() + "                                                              the null object's id is null, leave the text empty" + System.lineSeparator() + "                                                              and set the isNull attribute to true." + System.lineSeparator() + "    </Datatype>" + System.lineSeparator() + "</DatatypeDefinitions>" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createIpsArtefactBuilderSetDescriptionComment(Node parentEl) {
        String s = "Artefact builder set" + System.lineSeparator() + " " + System.lineSeparator() + "In this section the artefact builder set (code generator) is defined. Faktor-IPS comes with a standard builder set." + System.lineSeparator() + "However the build and generation mechanism is completly decoupled from the modeling and product definition capabilities" + System.lineSeparator() + "and you can write your own builders and generators. A different builder set is defined by providing an extension for" + System.lineSeparator() + "the extension point \"org.faktorips.devtools.core.artefactbuilderset\" defined by Faktor-IPS plugin" + System.lineSeparator() + "A builder set is activated for an IPS project by defining the IpsArtefactBuilderSet tag. The attribute \"id\" specifies" + System.lineSeparator() + "the builder set implementation that is registered as an extension. Note: The unique identifier of the extension is to specify." + System.lineSeparator() + "<IpsArtefactBuilderSet id=\"org.faktorips.devtools.stdbuilder.ipsstdbuilderset\"/> A builder set can be configured by specifing a " + System.lineSeparator() + "nested tag <IpsArtefactBuilderSetConfig/>. A configuration contains a set of properties which are specified by nested" + System.lineSeparator() + "<Property name=\"\" value=\"\"/> tags. The possible properties and their values is specific to the selected builder set." + System.lineSeparator() + "The initially generated .ipsproject file contains the set of possible configuration properties for the selected builder set" + System.lineSeparator() + "including their descriptions." + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createRequiredIpsFeaturesComment(Node parentEl) {
        String s = "Required Ips-Features" + System.lineSeparator() + " " + System.lineSeparator() + "In this section, all required features are listed with the minimum version for these features." + System.lineSeparator() + "By default, the feature with id \"org.faktorips.feature\" is always required (because this is the core " + System.lineSeparator() + "feature of Faktor-IPS. Other features can be required if plugins providing extensions for any extension points" + System.lineSeparator() + "defined by Faktor-IPS are used." + System.lineSeparator() + "If a required feature is missing or a required feature has a version less than the minimum version number " + System.lineSeparator() + "this project will not be build (an error is created)." + System.lineSeparator() + " " + System.lineSeparator() + "<RequiredIpsFeatures>" + System.lineSeparator() + "    <RequiredIpsFeature id=\"org.faktorips.feature\"    The id of the required feature." + System.lineSeparator() + "        minVersion=\"0.9.38\"                           The minimum version number of this feature" + System.lineSeparator() + "</RequiredIpsFeatures>" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createResourcesExcludedFromProductDefinitionComment(Node parentEl) {
        String s = "Resources excluded from the product definition" + System.lineSeparator() + " " + System.lineSeparator() + "In this section, all resources which will be excluded (hidden) in the product definition are listed." + System.lineSeparator() + "The resource must be identified by its full path, relative to the project the resource belongs to." + System.lineSeparator() + System.lineSeparator() + " " + System.lineSeparator() + "<ResourcesExcludedFromProductDefinition>" + System.lineSeparator() + "    <Resource path=\"src\"/>" + "              Example: The 1st excluded resource, identified by its path." + System.lineSeparator() + "    <Resource path=\"build/build.xml\"/>" + "  Example: The 2nd excluded resource, identified by its path." + System.lineSeparator() + "</ResourcesExcludedFromProductDefinition>" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createProductReleaseComment(Element parentEl) {
        String s = "Product Release" + System.lineSeparator() + " " + System.lineSeparator() + "In this section, the product defintion release is configured. You could reference an release extension" + System.lineSeparator() + "by specifying the releaseExtensionId. This extension is used by the release builder wizard." + System.lineSeparator() + "The version for the latest release is configured in a separate element below." + "The version of the latest release is also configured in this element. If you use the release builder wizard" + System.lineSeparator() + "you should not set this version manually but using the release builder wizard." + System.lineSeparator() + " " + System.lineSeparator() + "<" + PRODUCT_RELEASE + " " + RELEASE_EXTENSION_ID_ATTRIBUTE + "=\"id-of-the-extension\"" + "/>" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createVersionComment(Element parentEl) {
        String s = VERSION_TAG_NAME + System.lineSeparator() + " " + System.lineSeparator() + "In this section, the version for this project is specified. In alternativ to directly see a version" + System.lineSeparator() + "it is possible to configure a version provider." + System.lineSeparator() + "Examples:" + System.lineSeparator() + "<" + VERSION_TAG_NAME + " " + VERSION_ATTRIBUTE + "=\"1.2.3\"/>" + System.lineSeparator() + "or" + System.lineSeparator() + "<" + VERSION_TAG_NAME + " " + VERSION_PROVIDER_ATTRIBUTE + "=\"org.faktorips.maven.mavenVersionProvider\"/>" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createAdditionalSettingsDescriptionComment(Node parentEl) {
        String s = ADDITIONAL_SETTINGS_TAG_NAME + System.lineSeparator() + " " + System.lineSeparator() + "Some of the settings defined in the Faktor-IPS metamodel are optional." + System.lineSeparator() + "In this section you can enable or disable these additional settings." + System.lineSeparator() + " " + System.lineSeparator() + "<" + ADDITIONAL_SETTINGS_TAG_NAME + ">" + System.lineSeparator() + "    <!-- True if Faktor-IPS checks if all derived unions are implemented in none abstract classes. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " enabled=\"true\"" + " name=\"" + SETTING_DERIVED_UNION_IS_IMPLEMENTED + "\"/>" + System.lineSeparator() + "    <!-- True if Faktor-IPS checks if referenced product components are valid on the effective date " + System.lineSeparator() + "        of the referencing product component generation. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " enabled=\"true\"" + " name=\"" + SETTING_REFERENCED_PRODUCT_COMPONENTS_ARE_VALID_ON_THIS_GENERATIONS_VALID_FROM_DATE + "\"/>" + System.lineSeparator() + "    <!-- True to allow rules without references -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " enabled=\"true\"" + " name=\"" + SETTING_RULES_WITHOUT_REFERENCE + "\"/>" + System.lineSeparator() + "    <!-- True to allow shared associations. Shared associations are detail-to-master associationis that can be used" + System.lineSeparator() + "        by multiple master-to-detail associations-->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " enabled=\"true\"" + " name=\"" + SETTING_SHARED_ASSOCIATIONS + "\"/>" + System.lineSeparator() + "    <!-- Set the language in which the expression language's functions are used. E.g. the 'if' function is called IF in English, but WENN in German." + System.lineSeparator() + "        Only English (en) and German (de) are supported at the moment. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_FORMULA_LANGUAGE_LOCALE + "\" value=\"en\"/>" + System.lineSeparator() + "    <!-- Represents the qualified name of the marker enums seperated by \";\". For further processing only the first entered qualified name will be considered -->" + System.lineSeparator() + "        True to allow usage of marker enums. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " enabled=\"true\"" + " name=\"" + SETTING_MARKER_ENUMS + "\" value=\"markerEnumName\"/>" + System.lineSeparator() + "    <!-- False to set the default state of changing over time flag on product component types to disabled. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " enabled=\"false\"" + " name=\"" + SETTING_CHANGING_OVER_TIME_DEFAULT + "\"/>" + System.lineSeparator() + "    <!-- When inferring a template from multiple product components, Faktor-IPS checks whether a link is used in all or at least many of those product components." + System.lineSeparator() + "        This setting determines, which ratio is considered 'many'. The default value of 1.0 only considers links used by all selected product components.-->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_INFERRED_TEMPLATE_LINK_THRESHOLD + "\" value=\"1.0\"/>" + System.lineSeparator() + "    <!-- When inferring a template from multiple product components, Faktor-IPS checks whether a property value is used in all or at least many of those product components." + System.lineSeparator() + "        This setting determines, which ratio is considered 'many'. The default value of 0.8 only considers values used in at least 80% of all selected product components.-->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_INFERRED_TEMPLATE_PROPERTY_VALUE_THRESHOLD + "\" value=\"0.8\"/>" + System.lineSeparator() + "    <!-- Severity for validation messages when two product components have the same kindId and versionId." + System.lineSeparator() + "        Possible values are ERROR, WARNING, INFO, and NONE. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_DUPLICATE_PRODUCT_COMPONENT_SERVERITY + "\" value=\"ERROR\"/>" + System.lineSeparator() + "    <!-- Severity for validation messages when model and persistence constraints don't match." + System.lineSeparator() + "        Possible values are ERROR, WARNING, INFO, and NONE. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_PERSISTENCE_COLUMN_SIZE_CHECKS_SERVERITY + "\" value=\"ERROR\"/>" + System.lineSeparator() + "    <!-- Severity for validation messages when a custom datatype is used for an attribute but not listed in the <DataTypes> section." + System.lineSeparator() + "        Possible values are ERROR, WARNING, INFO, and NONE. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_MISSING_DATATYPE_SERVERITY + "\" value=\"ERROR\"/>" + System.lineSeparator() + "    <!-- Format for table content data." + System.lineSeparator() + "        Possible values are XML and CSV, where XML is the Faktor-IPS standard and CSV is a more compact form optimised for large tables." + System.lineSeparator() + "        Changing this setting will only affect tables when they are saved the next time. -->" + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_TABLE_CONTENT_FORMAT + "\" value=\"XML\"/>" + System.lineSeparator() + "    <!-- Default value for 'generate validation class' property on new PolicyCmptTypes." + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_GENERATE_VALIDATOR_CLASS_BY_DEFAULT + "\" value=\"true\"/>" + System.lineSeparator() + "    <!-- Whether non-standard blanks such as the non-breaking space should be escaped as XML entities when writing XML files." + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_ESCAPE_NON_STANDARD_BLANKS + "\" value=\"false\"/>" + System.lineSeparator() + "    <!-- Whether Ips-Files should be validated against their XSD schema." + System.lineSeparator() + "    <" + SETTING_TAG_NAME + " name=\"" + SETTING_VALIDATE_IPS_SCHEMA + "\" value=\"true\"/>" + System.lineSeparator() + "</" + ADDITIONAL_SETTINGS_TAG_NAME + ">" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createPersistenceOptionsDescriptionComment(Node parentEl) {
        String s = "PersistenceOptions" + System.lineSeparator() + " " + System.lineSeparator() + "In this section you can adjust parameters relating to the persistence of IPolicyCmptTypes." + System.lineSeparator() + "The table and column naming strategies define how identifier names are transformed into" + System.lineSeparator() + "database table and column names. The attributes maxTableNameLength and maxColumnNameLength" + System.lineSeparator() + "constrain the maximum possible length of a table or column name." + System.lineSeparator() + "The attribute maxTableColumnScale limits the scale of columns representing floating point" + System.lineSeparator() + "numbers while maxTableColumnPrecision limits their precision. The number of characters in a" + System.lineSeparator() + "String column is limited by maxTableColumnSize." + System.lineSeparator() + "All limits are in byte length but are only validated in character length in Faktor-IPS, as the" + System.lineSeparator() + "mapping of multi-byte characters depends on the encoding and database used." + System.lineSeparator() + "The attribute " + "allowLazyFetchForSingleValuedAssociations" + " defines if it is allowed to use lazy fetching " + System.lineSeparator() + "on the association side which holds a single value (to-one relationship side)." + System.lineSeparator() + " " + System.lineSeparator() + "<PersistenceOptions maxColumnNameLength=\"30\" maxTableNameLength=\"30\"" + System.lineSeparator() + "        maxTableColumnPrecision=\"31\"  maxTableColumnScale=\"31\" maxTableColumnSize=\"1000\"" + System.lineSeparator() + "        allowLazyFetchForSingleValuedAssociations=\"true\">" + System.lineSeparator() + "    <TableNamingStrategy id=\"org.faktorips.devtools.model.CamelCaseToUpperUnderscoreTableNamingStrategy\"/>" + System.lineSeparator() + "    <TableColumnNamingStrategy id=\"org.faktorips.devtools.model.CamelCaseToUpperUnderscoreColumnNamingStrategy\"/>" + System.lineSeparator() + "</PersistenceOptions>" + System.lineSeparator() + " " + System.lineSeparator() + "Currently Faktor-IPS includes the strategies CamelCaseToUpperUnderscoreTableNamingStrategy" + System.lineSeparator() + "for tables and CamelCaseToUpperUnderscoreColumnNamingStrategy for columns, example:" + System.lineSeparator() + "    IdentifierName1 -> IDENTIFIER_NAME1" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createSupportedLanguagesDescriptionComment(Node parentEl) {
        String s = "Supported Languages" + System.lineSeparator() + " " + System.lineSeparator() + "This section lists all natural languages that are supported by this IPS project." + System.lineSeparator() + "Each language is identified by it's locale which is the ISO 639 language code, " + System.lineSeparator() + "e.g. 'en' for English." + System.lineSeparator() + "Exactly one supported language must be marked as default language. The default language " + System.lineSeparator() + "will be used if a language is requested that is not supported by this IPS project." + System.lineSeparator() + " " + System.lineSeparator() + "<SupportedLanguages>" + System.lineSeparator() + "    <SupportedLanguage locale=\"en\" defaultLanguage=\"true\"/>" + System.lineSeparator() + "    <SupportedLanguage locale=\"de\"/>" + System.lineSeparator() + "</SupportedLanguages>" + System.lineSeparator();
        this.createDescriptionComment(s, parentEl);
    }

    private void createDescriptionComment(String text, Node parent) {
        this.createDescriptionComment(text, parent, "        ");
    }

    private void createDescriptionComment(String text, Node parent, String indentation) {
        StringBuilder indentedText = new StringBuilder();
        indentedText.append(System.lineSeparator());
        StringTokenizer tokenizer = new StringTokenizer(text, System.lineSeparator());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            indentedText.append(indentation);
            indentedText.append(token);
            indentedText.append(System.lineSeparator());
        }
        indentedText.append(indentation.substring(4));
        Document doc = parent.getOwnerDocument();
        if (doc == null) {
            doc = (Document)parent;
        }
        Comment comment = doc.createComment(indentedText.toString());
        parent.appendChild(comment);
    }

    @Override
    public IIpsArtefactBuilderSetConfigModel getBuilderSetConfig() {
        return this.builderSetConfig;
    }

    @Override
    public void setBuilderSetConfig(IIpsArtefactBuilderSetConfigModel config) {
        ArgumentCheck.notNull((Object)config);
        this.builderSetConfig = config;
    }

    @Override
    public String[] getRequiredIpsFeatureIds() {
        return this.requiredFeatures.keySet().toArray(new String[this.requiredFeatures.size()]);
    }

    @Override
    public String getMinRequiredVersionNumber(String featureId) {
        return this.requiredFeatures.get(featureId);
    }

    @Override
    public void setMinRequiredVersionNumber(String featureId, String version) {
        this.requiredFeatures.put(featureId, version);
    }

    @Override
    public void addResourcesPathExcludedFromTheProductDefiniton(String resourcesPath) {
        this.resourcesPathExcludedFromTheProductDefiniton.add(resourcesPath);
    }

    @Override
    public boolean isResourceExcludedFromProductDefinition(String location) {
        return this.resourcesPathExcludedFromTheProductDefiniton.contains(location);
    }

    @Override
    public Set<String> getResourcesPathExcludedFromTheProductDefiniton() {
        return this.resourcesPathExcludedFromTheProductDefiniton;
    }

    @Override
    public void setResourcesPathExcludedFromTheProductDefiniton(Set<String> resourcesPathExcludedFromTheProductDefiniton) {
        this.resourcesPathExcludedFromTheProductDefiniton = resourcesPathExcludedFromTheProductDefiniton;
    }

    @Override
    public long getLastPersistentModificationTimestamp() {
        return this.lastPersistentModificationTimestamp;
    }

    @Override
    public void setLastPersistentModificationTimestamp(long timestamp) {
        this.lastPersistentModificationTimestamp = timestamp;
    }

    @Override
    public boolean isPersistenceSupportEnabled() {
        return this.persistentProject;
    }

    @Override
    public void setPersistenceSupport(boolean persistentProject) {
        this.persistentProject = persistentProject;
    }

    @Override
    public IPersistenceOptions getPersistenceOptions() {
        return this.persistenceOptions;
    }

    @Override
    public ITableColumnNamingStrategy getTableColumnNamingStrategy() {
        return this.getPersistenceOptions().getTableColumnNamingStrategy();
    }

    @Override
    public ITableNamingStrategy getTableNamingStrategy() {
        return this.getPersistenceOptions().getTableNamingStrategy();
    }

    @Override
    public void setTableColumnNamingStrategy(ITableColumnNamingStrategy newStrategy) {
        this.getPersistenceOptions().setTableColumnNamingStrategy(newStrategy);
    }

    @Override
    public void setTableNamingStrategy(ITableNamingStrategy newStrategy) {
        this.getPersistenceOptions().setTableNamingStrategy(newStrategy);
    }

    public void setPersistenceOptions(IPersistenceOptions persistenceOptions) {
        this.persistenceOptions = persistenceOptions;
    }

    @Override
    public Set<ISupportedLanguage> getSupportedLanguages() {
        return Collections.unmodifiableSet(this.supportedLanguages);
    }

    @Override
    public ISupportedLanguage getSupportedLanguage(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        for (ISupportedLanguage supportedLanguage : this.supportedLanguages) {
            if (!supportedLanguage.getLocale().equals(locale)) continue;
            return supportedLanguage;
        }
        return null;
    }

    @Override
    public boolean isSupportedLanguage(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        for (ISupportedLanguage supportedLanguage : this.supportedLanguages) {
            if (!supportedLanguage.getLocale().getLanguage().equals(locale.getLanguage())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ISupportedLanguage getDefaultLanguage() {
        for (ISupportedLanguage supportedLanguage : this.supportedLanguages) {
            if (!supportedLanguage.isDefaultLanguage()) continue;
            return supportedLanguage;
        }
        if (!this.supportedLanguages.isEmpty()) {
            return (ISupportedLanguage)this.supportedLanguages.iterator().next();
        }
        return new SupportedLanguage(IIpsModel.get().getMultiLanguageSupport().getLocalizationLocale(), true);
    }

    @Override
    public void setDefaultLanguage(Locale locale) {
        ISupportedLanguage language = this.getSupportedLanguage(locale);
        if (language == null) {
            throw new IllegalArgumentException("There is no supported language with the locale '" + locale + "'.");
        }
        this.setDefaultLanguage(language);
    }

    @Override
    public void setDefaultLanguage(ISupportedLanguage language) {
        this.clearDefaultLanguage();
        ((SupportedLanguage)language).setDefaultLanguage(true);
    }

    private void clearDefaultLanguage() {
        ISupportedLanguage currentDefaultLanguage = this.getDefaultLanguage();
        ((SupportedLanguage)currentDefaultLanguage).setDefaultLanguage(false);
    }

    @Override
    public void addSupportedLanguage(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        this.supportedLanguages.add(new SupportedLanguage(locale));
    }

    @Override
    public void removeSupportedLanguage(ISupportedLanguage supportedLanguage) {
        ArgumentCheck.notNull((Object)supportedLanguage);
        this.supportedLanguages.remove(supportedLanguage);
    }

    @Override
    public void removeSupportedLanguage(Locale locale) {
        ISupportedLanguage language = this.getSupportedLanguage(locale);
        if (language != null) {
            this.supportedLanguages.remove(language);
        }
    }

    @Override
    public void setDefaultCurrency(Currency defaultCurrency) {
        this.defaultCurrency = defaultCurrency;
    }

    @Override
    public Currency getDefaultCurrency() {
        return this.defaultCurrency;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersionProviderId() {
        return this.versionProviderId;
    }

    @Override
    public void setVersionProviderId(String versionProviderId) {
        this.versionProviderId = versionProviderId;
    }

    @Override
    public String getReleaseExtensionId() {
        return this.releaseExtensionId;
    }

    @Override
    public void setReleaseExtensionId(String releaseExtensionId) {
        this.releaseExtensionId = releaseExtensionId;
    }

    @Override
    public boolean isActive(IFunctionResolverFactory<?> factory) {
        return !(factory instanceof AssociationNavigationFunctionsResolver);
    }

    @Override
    public Locale getFormulaLanguageLocale() {
        return this.formulaLanguageLocale;
    }

    @Override
    public void setFormulaLanguageLocale(Locale locale) {
        this.formulaLanguageLocale = locale;
    }

    @Override
    public boolean isChangingOverTimeDefaultEnabled() {
        return this.changingOverTimeDefault;
    }

    @Override
    public void setChangingOverTimeDefault(boolean enabled) {
        this.changingOverTimeDefault = enabled;
    }

    @Override
    public boolean isGenerateValidatorClassDefaultEnabled() {
        return this.generateValidatorClassByDefault;
    }

    @Override
    public void setGenerateValidatorClassDefault(boolean enabled) {
        this.generateValidatorClassByDefault = enabled;
    }

    @Override
    public boolean isGenericValidationDefaultEnabled() {
        return this.genericValidationByDefault;
    }

    @Override
    public void setGenericValidationDefault(boolean enabled) {
        this.genericValidationByDefault = enabled;
    }

    @Override
    public boolean isEscapeNonStandardBlanks() {
        return this.escapeNonStandardBlanks;
    }

    @Override
    public void setEscapeNonStandardBlanks(boolean enabled) {
        this.escapeNonStandardBlanks = enabled;
    }

    @Override
    public Decimal getInferredTemplateLinkThreshold() {
        return this.inferredTemplateLinkThreshold;
    }

    @Override
    public void setInferredTemplateLinkThreshold(Decimal inferredTemplateLinkThreshold) {
        this.inferredTemplateLinkThreshold = inferredTemplateLinkThreshold;
    }

    @Override
    public Decimal getInferredTemplatePropertyValueThreshold() {
        return this.inferredTemplatePropertyValueThreshold;
    }

    @Override
    public void setInferredTemplatePropertyValueThreshold(Decimal inferredTemplatePropertyValueThreshold) {
        this.inferredTemplatePropertyValueThreshold = inferredTemplatePropertyValueThreshold;
    }

    @Override
    @CheckForNull
    public IIpsFeatureConfiguration getFeatureConfiguration(String featureId) {
        return this.featureConfigurations.get(featureId);
    }

    public void setFeatureConfiguration(String featureId, IpsFeatureConfiguration featureConfiguration) {
        ArgumentCheck.notNull((Object)featureId, (Object)"featureId must not be null");
        ArgumentCheck.notNull((Object)featureConfiguration, (Object)"featureConfiguration must not be null");
        this.featureConfigurations.put(featureId, featureConfiguration);
    }

    @Override
    public Severity getDuplicateProductComponentSeverity() {
        return this.duplicateProductComponentSeverity;
    }

    @Override
    public void setDuplicateProductComponentSeverity(Severity duplicateProductComponentSeverity) {
        this.duplicateProductComponentSeverity = duplicateProductComponentSeverity;
    }

    @Override
    public Severity getPersistenceColumnSizeChecksSeverity() {
        return this.persistenceColumnSizeChecksSeverity;
    }

    @Override
    public void setPersistenceColumnSizeChecksSeverity(Severity persistenceColumnSizeChecksSeverity) {
        this.persistenceColumnSizeChecksSeverity = persistenceColumnSizeChecksSeverity;
    }

    @Override
    public TableContentFormat getTableContentFormat() {
        return this.tableContentFormat;
    }

    @Override
    public void setTableContentFormat(TableContentFormat tableContentFormat) {
        this.tableContentFormat = tableContentFormat;
    }

    @Override
    public boolean isValidateIpsSchema() {
        return this.validateIpsSchema;
    }

    @Override
    public void setValidateIpsSchema(boolean validateIpsSchema) {
        this.validateIpsSchema = validateIpsSchema;
    }

    public XsdValidationHandler getXsdValidationHandler() {
        return this.xsdValidationHandler;
    }

    public void setXsdValidationHandler(XsdValidationHandler xsdValidationHandler) {
        this.xsdValidationHandler = xsdValidationHandler;
    }

    @Override
    public Severity getMissingDatatypeSeverity() {
        return this.missingDatatypeSeverity;
    }

    @Override
    public void setMissingDatatypeSeverity(Severity missingDatatypeSeverity) {
        this.missingDatatypeSeverity = missingDatatypeSeverity;
    }
}

