/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.properties;

import org.faktorips.devtools.model.internal.pctype.CamelCaseToUpperUnderscoreColumnNamingStrategy;
import org.faktorips.devtools.model.internal.pctype.CamelCaseToUpperUnderscoreTableNamingStrategy;
import org.faktorips.devtools.model.ipsproject.IPersistenceOptions;
import org.faktorips.devtools.model.ipsproject.ITableColumnNamingStrategy;
import org.faktorips.devtools.model.ipsproject.ITableNamingStrategy;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PersistenceOptions
implements IPersistenceOptions {
    private ITableColumnNamingStrategy tableColumnNamingStrategy = new CamelCaseToUpperUnderscoreColumnNamingStrategy();
    private ITableNamingStrategy tableNamingStrategy = new CamelCaseToUpperUnderscoreTableNamingStrategy();
    private int maxColumnNameLength = 30;
    private int maxTableNameLength = 30;
    private boolean allowLazyFetchForSingleValuedAssociations = true;
    private int maxTableColumnScale = 31;
    private int maxTableColumnPrecision = 31;
    private int maxTableColumnSize = 1000;
    private int minTableColumnScale = 1;
    private int minTableColumnPrecision = 1;
    private int minTableColumnSize = 1;

    public PersistenceOptions() {
        this(null);
    }

    public PersistenceOptions(Element element) {
        String id;
        if (element == null || !element.getTagName().equals("PersistenceOptions")) {
            return;
        }
        this.maxColumnNameLength = Integer.parseInt(element.getAttribute("maxColumnNameLength"));
        this.maxTableNameLength = Integer.parseInt(element.getAttribute("maxTableNameLength"));
        this.allowLazyFetchForSingleValuedAssociations = Boolean.parseBoolean(element.getAttribute("allowLazyFetchForSingleValuedAssociations"));
        this.maxTableColumnSize = this.getValueOrDefault(element, "maxTableColumnSize", this.maxTableColumnSize);
        this.maxTableColumnScale = this.getValueOrDefault(element, "maxTableColumnScale", this.maxTableColumnScale);
        this.maxTableColumnPrecision = this.getValueOrDefault(element, "maxTableColumnPrecision", this.maxTableColumnPrecision);
        NodeList elementsByTagName = element.getElementsByTagName("TableNamingStrategy");
        if (elementsByTagName.getLength() > 0 && (id = ((Element)elementsByTagName.item(0)).getAttribute("id")).equals("org.faktorips.devtools.model.CamelCaseToUpperUnderscoreTableNamingStrategy")) {
            this.tableNamingStrategy = new CamelCaseToUpperUnderscoreTableNamingStrategy();
        }
        if ((elementsByTagName = element.getElementsByTagName("TableColumnNamingStrategy")).getLength() > 0 && (id = ((Element)elementsByTagName.item(0)).getAttribute("id")).equals("org.faktorips.devtools.model.CamelCaseToUpperUnderscoreColumnNamingStrategy")) {
            this.tableColumnNamingStrategy = new CamelCaseToUpperUnderscoreColumnNamingStrategy();
        }
    }

    private int getValueOrDefault(Element element, String attrName, int defaultValue) {
        String attributeValue = element.getAttribute(attrName);
        if (attributeValue == null || attributeValue.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(attributeValue);
    }

    @Override
    public int getMaxColumnNameLenght() {
        return this.maxColumnNameLength;
    }

    @Override
    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    @Override
    public ITableColumnNamingStrategy getTableColumnNamingStrategy() {
        return this.tableColumnNamingStrategy;
    }

    @Override
    public ITableNamingStrategy getTableNamingStrategy() {
        return this.tableNamingStrategy;
    }

    @Override
    public void setTableColumnNamingStrategy(ITableColumnNamingStrategy newStrategy) {
        ArgumentCheck.notNull((Object)newStrategy);
        this.tableColumnNamingStrategy = newStrategy;
    }

    @Override
    public void setTableNamingStrategy(ITableNamingStrategy newStrategy) {
        ArgumentCheck.notNull((Object)newStrategy);
        this.tableNamingStrategy = newStrategy;
    }

    @Override
    public void setMaxColumnNameLength(int length) {
        ArgumentCheck.isTrue((length > 0 ? 1 : 0) != 0);
        this.maxColumnNameLength = length;
    }

    @Override
    public void setMaxTableNameLength(int length) {
        ArgumentCheck.isTrue((length > 0 ? 1 : 0) != 0);
        this.maxTableNameLength = length;
    }

    @Override
    public boolean isAllowLazyFetchForSingleValuedAssociations() {
        return this.allowLazyFetchForSingleValuedAssociations;
    }

    @Override
    public void setAllowLazyFetchForSingleValuedAssociations(boolean allowLazyFetchForSingleValuedAssociations) {
        this.allowLazyFetchForSingleValuedAssociations = allowLazyFetchForSingleValuedAssociations;
    }

    @Override
    public int getMaxTableColumnScale() {
        return this.maxTableColumnScale;
    }

    @Override
    public int getMaxTableColumnPrecision() {
        return this.maxTableColumnPrecision;
    }

    @Override
    public int getMaxTableColumnSize() {
        return this.maxTableColumnSize;
    }

    @Override
    public int getMinTableColumnScale() {
        return this.minTableColumnScale;
    }

    @Override
    public int getMinTableColumnPrecision() {
        return this.minTableColumnPrecision;
    }

    @Override
    public int getMinTableColumnSize() {
        return this.minTableColumnSize;
    }

    @Override
    public void setMaxTableColumnScale(int scale) {
        this.maxTableColumnScale = scale;
    }

    @Override
    public void setMaxTableColumnPrecision(int precision) {
        this.maxTableColumnPrecision = precision;
    }

    @Override
    public void setMaxTableColumnSize(int size) {
        this.maxTableColumnSize = size;
    }
}

