/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.ipsproject.properties;

import java.util.Locale;
import java.util.Objects;
import org.faktorips.devtools.model.ipsproject.ISupportedLanguage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedLanguage
implements ISupportedLanguage {
    private Locale locale;
    private boolean defaultLanguage;

    public SupportedLanguage() {
    }

    public SupportedLanguage(Locale locale) {
        this(locale, false);
    }

    public SupportedLanguage(Locale locale, boolean defaultLanguage) {
        this.locale = locale;
        this.defaultLanguage = defaultLanguage;
    }

    @Override
    public String getLanguageName() {
        return this.getLocale().getDisplayLanguage();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(boolean defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public int hashCode() {
        return Objects.hash(this.locale);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SupportedLanguage other = (SupportedLanguage)obj;
        return Objects.equals(this.locale, other.locale);
    }

    @Override
    public void initFromXml(Element element) {
        this.locale = new Locale(element.getAttribute("locale"));
        this.defaultLanguage = Boolean.parseBoolean(element.getAttribute("defaultLanguage"));
    }

    @Override
    public Element toXml(Document doc) {
        Element element = doc.createElement("SupportedLanguage");
        element.setAttribute("locale", this.locale.getLanguage());
        if (this.defaultLanguage) {
            element.setAttribute("defaultLanguage", String.valueOf(this.defaultLanguage));
        }
        return element;
    }

    public String toString() {
        return this.locale + (this.defaultLanguage ? "*" : "");
    }
}

