/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.method;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.abstraction.util.JavaConventions;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObjectPart;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.internal.method.Messages;
import org.faktorips.devtools.model.internal.method.Parameter;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.method.IBaseMethod;
import org.faktorips.devtools.model.method.IParameter;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.util.StringBuilderJoiner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseMethod
extends BaseIpsObjectPart
implements IBaseMethod {
    public static final String XML_ELEMENT_NAME = "Method";
    private IpsObjectPartCollection<IParameter> parameters = new IpsObjectPartCollection<IParameter>(this, Parameter.class, IParameter.class, "Parameter");
    private String datatype = "void";

    public BaseMethod(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.valueChanged(oldName, this.name);
    }

    @Override
    public String getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(String newDatatype) {
        String oldDatatype = this.getDatatype();
        this.datatype = newDatatype;
        this.valueChanged(oldDatatype, newDatatype, "datatype");
    }

    @Override
    public IParameter newParameter() {
        return this.parameters.newPart();
    }

    @Override
    public IParameter newParameter(String datatype, String name) {
        IParameter param = this.newParameter();
        param.setDatatype(datatype);
        param.setName(name);
        return param;
    }

    @Override
    public int getNumOfParameters() {
        return this.parameters.size();
    }

    @Override
    public IParameter[] getParameters() {
        return (IParameter[])this.parameters.toArray(new IParameter[this.parameters.size()]);
    }

    @Override
    public String[] getParameterNames() {
        String[] names = new String[this.parameters.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.parameters.getPart(i).getName();
            ++i;
        }
        return names;
    }

    @Override
    public List<Datatype> getParameterDatatypes() {
        ArrayList<Datatype> parameterDatatypes = new ArrayList<Datatype>();
        IParameter[] iParameterArray = this.getParameters();
        int n = iParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParameter parameter = iParameterArray[n2];
            Datatype parameterDatatype = parameter.findDatatype(this.getIpsProject());
            if (parameterDatatype != null) {
                parameterDatatypes.add(parameterDatatype);
            }
            ++n2;
        }
        return parameterDatatypes;
    }

    @Override
    public int[] moveParameters(int[] indexes, boolean up) {
        return this.parameters.moveParts(indexes, up);
    }

    public IParameter getParameter(int i) {
        return this.parameters.getPart(i);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(XML_ELEMENT_NAME);
    }

    @Override
    public String getSignatureString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        builder.append('(');
        StringBuilderJoiner.join((StringBuilder)builder, (Object[])this.getParameters(), p -> {
            StringBuilder stringBuilder2 = builder.append(p.getDatatype());
        });
        builder.append(')');
        return builder.toString();
    }

    @Override
    protected void validateThis(MessageList result, IIpsProject ipsProject) {
        super.validateThis(result, ipsProject);
        if (IpsStringUtils.isEmpty((String)this.getName())) {
            result.add(new Message("METHOD-noName", Messages.Method_msg_NameEmpty, Message.ERROR, (Object)this, new String[]{"name"}));
        } else {
            Runtime.Version sourceVersion = ipsProject.getJavaProject().getSourceVersion();
            if (!JavaConventions.validateName((String)this.getName(), (Runtime.Version)sourceVersion)) {
                result.add(new Message("METHOD-InvalidMethodname", Messages.Method_msg_InvalidMethodname, Message.ERROR, (Object)this, new String[]{"name"}));
            }
        }
        ValidationUtils.checkDatatypeReference(this.getDatatype(), true, this, "datatype", "", result, ipsProject);
        this.validateMultipleParameterNames(result);
    }

    private void validateMultipleParameterNames(MessageList msgList) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        HashSet<String> multipleNames = new HashSet<String>();
        IParameter[] iParameterArray = this.getParameters();
        int n = iParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParameter p = iParameterArray[n2];
            if (parameterNames.contains(p.getName())) {
                multipleNames.add(p.getName());
            }
            parameterNames.add(p.getName());
            ++n2;
        }
        if (multipleNames.isEmpty()) {
            return;
        }
        for (String paramName : multipleNames) {
            ArrayList<ObjectProperty> objProps = new ArrayList<ObjectProperty>();
            int j = 0;
            while (j < parameterNames.size()) {
                if (((String)parameterNames.get(j)).equals(paramName)) {
                    objProps.add(new ObjectProperty((Object)this.getParameter(j), "parameters", j));
                }
                ++j;
            }
            ObjectProperty[] objectProperties = objProps.toArray(new ObjectProperty[objProps.size()]);
            String text = MessageFormat.format(Messages.Method_duplicateParamName, paramName);
            msgList.add(new Message("METHOD-multipleUseOfSameParameterName", text, Message.ERROR, objectProperties));
        }
    }

    @Override
    public void initFromXml(Element element) {
        super.initFromXml(element);
        this.removeDeprecationWithoutChangeEvent();
    }

    @Override
    public void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.name = element.getAttribute("name");
        this.initDatatype(element);
    }

    private void initDatatype(Element element) {
        String datatypeElement = element.getAttribute("datatype");
        if (datatypeElement != null) {
            this.datatype = datatypeElement;
        }
    }

    @Override
    public Datatype findDatatype(IIpsProject ipsProject) {
        return ipsProject.findDatatype(this.getDatatype());
    }

    @Override
    public boolean isSameSignature(IBaseMethod other) {
        if (!this.getName().equals(other.getName()) || this.getNumOfParameters() != other.getNumOfParameters()) {
            return false;
        }
        IParameter[] otherParams = other.getParameters();
        int i = 0;
        while (i < this.getNumOfParameters()) {
            if (!this.getParameter(i).getDatatype().equals(otherParams[i].getDatatype())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("datatype", this.getDatatype());
        element.setAttribute("name", this.getName());
    }

    public void synchronizeName() {
        this.name = this.getParent().getName();
    }

    @Override
    public int getJavaModifier() {
        return 1;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("BaseMethod: ");
        buffer.append(this.getName());
        buffer.append(": ");
        buffer.append(this.getDatatype());
        buffer.append(' ');
        buffer.append(this.getName());
        buffer.append('(');
        StringBuilderJoiner.join((StringBuilder)buffer, (Object[])this.getParameters(), p -> {
            buffer.append(p.getDatatype());
            buffer.append(' ');
            buffer.append(p.getName());
        });
        buffer.append(')');
        return buffer.toString();
    }
}

