/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.method;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.dependency.DatatypeDependency;
import org.faktorips.devtools.model.internal.method.BaseMethod;
import org.faktorips.devtools.model.internal.type.Messages;
import org.faktorips.devtools.model.internal.type.TypePart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.method.IBaseMethod;
import org.faktorips.devtools.model.method.IParameter;
import org.faktorips.devtools.model.type.IMethod;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Method
extends TypePart
implements IMethod {
    private boolean abstractFlag = false;
    private final BaseMethod method;

    public Method(IType parent, String id) {
        super(parent, id);
        this.method = new BaseMethod(this, id);
    }

    @Override
    public void setName(String newName) {
        this.method.setName(newName);
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isAbstract() {
        return this.abstractFlag;
    }

    @Override
    public void setAbstract(boolean newValue) {
        boolean oldValue = this.isAbstract();
        this.abstractFlag = newValue;
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public String getDatatype() {
        return this.method.getDatatype();
    }

    @Override
    public Datatype findDatatype(IIpsProject ipsProject) {
        return this.method.findDatatype(ipsProject);
    }

    @Override
    public void setDatatype(String newDatatype) {
        this.method.setDatatype(newDatatype);
    }

    @Override
    public int getJavaModifier() {
        return this.getModifier().getJavaModifier();
    }

    @Override
    public IMethod findOverridingMethod(IType typeToSearchFrom, IIpsProject ipsProject) {
        if (!typeToSearchFrom.isSubtypeOf(this.getType(), ipsProject)) {
            return null;
        }
        OverridingMethodFinder finder = new OverridingMethodFinder(ipsProject);
        finder.start(typeToSearchFrom);
        return finder.overridingMethod;
    }

    @Override
    public IMethod findOverriddenMethod(IIpsProject ipsProject) {
        OverridingMethodFinder finder = new OverridingMethodFinder(ipsProject);
        finder.start(this.getType());
        return finder.overridingMethod;
    }

    @Override
    public boolean isSameSignature(IBaseMethod other) {
        return this.method.isSameSignature(other);
    }

    @Override
    public boolean overrides(IMethod other) {
        return !this.equals(other) && this.isSameSignature(other) && this.getType().isSubtypeOf(other.getType(), other.getIpsProject());
    }

    @Override
    public String getSignatureString() {
        return this.method.getSignatureString();
    }

    @Override
    public void initFromXml(Element element) {
        this.method.initFromXml(element);
        super.initFromXml(element);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.initAbstractFromXml(element);
    }

    private void initAbstractFromXml(Element element) {
        this.abstractFlag = XmlUtil.getBooleanAttributeOrFalse(element, "abstract");
    }

    @Override
    protected Element createElement(Document doc) {
        return this.method.toXml(doc);
    }

    @Override
    protected void propertiesToXml(Element newElement) {
        super.propertiesToXml(newElement);
        if (this.abstractFlag) {
            newElement.setAttribute("abstract", Boolean.toString(this.isAbstract()));
        }
    }

    @Override
    protected void validateThis(MessageList result, IIpsProject ipsProject) {
        super.validateThis(result, ipsProject);
        result.add(this.method.validate(ipsProject));
        if (this.isAbstract() && !this.getType().isAbstract()) {
            result.add(new Message("", MessageFormat.format(Messages.TypeMethod_msg_abstractMethodError, this.getName()), Message.ERROR, (Object)this, new String[]{"abstract"}));
        }
        if (this.validateDuplicateMethodInSameType(result)) {
            this.validateOverriddenMethod(result, ipsProject);
        }
    }

    private void validateOverriddenMethod(MessageList list, IIpsProject ipsProject) {
        IMethod overridden = this.findOverriddenMethod(ipsProject);
        if (overridden == null) {
            return;
        }
        this.validateModifierOfOverriddenMethod(list, overridden);
        this.validateReturnTypeOfOverriddenMethod(list, overridden, ipsProject);
    }

    private void validateModifierOfOverriddenMethod(MessageList list, IMethod overridden) {
        if (!this.getModifier().equals((Object)overridden.getModifier())) {
            list.add(Message.newError((String)"METHOD-modifierNotEqual", (String)MessageFormat.format(Messages.TypeMethod_msg_modifierOverriddenNotEqual, overridden.getModifier().getId()), (Object)this, (String[])new String[]{"modifier"}));
        }
    }

    private void validateReturnTypeOfOverriddenMethod(MessageList list, IMethod overridden, IIpsProject ipsProject) {
        Datatype returnType = this.findDatatype(ipsProject);
        if (returnType == null) {
            return;
        }
        Datatype overriddenReturnType = overridden.findDatatype(ipsProject);
        if (!returnType.equals(overriddenReturnType)) {
            String text = MessageFormat.format(Messages.TypeMethod_incompatbileReturnType, overridden.getType().getUnqualifiedName(), overridden.getSignatureString());
            Message msg = Message.newError((String)"METHOD-returnTypeIsIncompatibleWithOverriddenMethod", (String)text, (Object)this, (String[])new String[]{"datatype"});
            list.add(msg);
        }
    }

    private boolean validateDuplicateMethodInSameType(MessageList msgList) {
        List<IMethod> methods = this.getType().getMethods();
        String thisSignature = this.getSignatureString();
        for (IBaseMethod iBaseMethod : methods) {
            if (this.equals(iBaseMethod) || !iBaseMethod.getSignatureString().equals(thisSignature)) continue;
            msgList.add(new Message("METHOD-duplicateSignature", Messages.TypeMethod_duplicateSignature, Message.ERROR, (Object)this));
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getType().getQualifiedName());
        builder.append(": ");
        builder.append(this.method.toString());
        return builder.toString();
    }

    public void dependsOn(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        DatatypeDependency dependency = new DatatypeDependency(this.getType().getQualifiedNameType(), this.getDatatype());
        dependencies.add(dependency);
        this.addDetails(details, dependency, this, "datatype");
        IParameter[] iParameterArray = this.getParameters();
        int n = iParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParameter parameter = iParameterArray[n2];
            dependency = new DatatypeDependency(this.getType().getQualifiedNameType(), parameter.getDatatype());
            dependencies.add(dependency);
            this.addDetails(details, dependency, parameter, "datatype");
            ++n2;
        }
    }

    @Override
    public IParameter[] getParameters() {
        return this.method.getParameters();
    }

    @Override
    public String[] getParameterNames() {
        return this.method.getParameterNames();
    }

    @Override
    public List<Datatype> getParameterDatatypes() {
        return this.method.getParameterDatatypes();
    }

    @Override
    public int getNumOfParameters() {
        return this.method.getNumOfParameters();
    }

    @Override
    public IParameter newParameter() {
        return this.method.newParameter();
    }

    @Override
    public IParameter newParameter(String datatype, String name) {
        return this.method.newParameter(datatype, name);
    }

    @Override
    public int[] moveParameters(int[] indices, boolean up) {
        return this.method.moveParameters(indices, up);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Method other = (Method)obj;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getParent(), other.getParent());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
    }

    class OverridingMethodFinder
    extends TypeHierarchyVisitor<IType> {
        private IMethod overridingMethod;

        public OverridingMethodFinder(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(IType currentType) {
            IMethod match = currentType.getMatchingMethod(Method.this);
            if (match != null && match != Method.this) {
                this.overridingMethod = match;
                return false;
            }
            return true;
        }
    }
}

