/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.method;

import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.method.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.method.IParameter;
import org.faktorips.devtools.model.method.IParameterContainer;
import org.faktorips.fl.ExprCompiler;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Parameter
extends AtomicIpsObjectPart
implements IParameter {
    static final String TAG_NAME = "Parameter";
    private String datatype = "";

    public Parameter(IParameterContainer container, String id) {
        super(container, id);
    }

    @Override
    public IParameterContainer getParameterContainer() {
        return (IParameterContainer)this.getParent();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.valueChanged(oldName, this.name);
    }

    @Override
    public void setDatatype(String type) {
        String oldType = this.datatype;
        this.datatype = type;
        this.valueChanged(oldType, this.datatype);
    }

    @Override
    public String getDatatype() {
        return this.datatype;
    }

    @Override
    public Datatype findDatatype(IIpsProject ipsProject) {
        return ipsProject.findDatatype(this.datatype);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.name = element.getAttribute("name");
        this.datatype = element.getAttribute("datatype");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("name", this.name);
        element.setAttribute("datatype", this.datatype);
    }

    @Override
    protected void validateThis(MessageList result, IIpsProject ipsProject) {
        super.validateThis(result, ipsProject);
        if (IpsStringUtils.isEmpty((String)this.name)) {
            result.add(new Message("", Messages.Parameter_msg_NameEmpty, Message.ERROR, (Object)this, new String[]{"name"}));
        } else {
            Message msg = ipsProject.getNamingConventions().validateIfValidJavaIdentifier(this.getName(), Messages.Parameter_msg_InvalidParameterName, this, ipsProject);
            if (msg == null && !ExprCompiler.isValidIdentifier((String)this.getName())) {
                msg = new Message("", Messages.Parameter_msg_InvalidParameterName, Message.ERROR, (Object)this, new String[]{"name"});
            }
            result.add(msg);
        }
        ValidationUtils.checkDatatypeReference(this.datatype, false, this, "datatype", "", result, ipsProject);
    }
}

