/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype;

import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.ITableNamingStrategy;
import org.faktorips.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CamelCaseToUpperUnderscoreTableNamingStrategy
implements ITableNamingStrategy {
    public static final String EXTENSION_ID = "org.faktorips.devtools.model.CamelCaseToUpperUnderscoreTableNamingStrategy";
    private IIpsProject ipsProject;

    @Override
    public String getTableName(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("Cannot derive a table identifier from null.");
        }
        return this.toUnderscoreUppercase(baseName);
    }

    @Override
    public String getTableName(String baseName, int maxLength) {
        if (baseName == null) {
            throw new NullPointerException("Cannot derive a table identifier from null.");
        }
        if (maxLength <= 0) {
            throw new RuntimeException("Maximum length must be positive.");
        }
        String derivedName = this.toUnderscoreUppercase(baseName);
        return derivedName.substring(0, Math.min(derivedName.length(), maxLength));
    }

    @Override
    public void setIpsProject(IIpsProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.ipsProject = project;
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    @Override
    public void initFromXml(Element el) {
    }

    @Override
    public Element toXml(Document doc) {
        Element strategyEl = doc.createElement("TableNamingStrategy");
        strategyEl.setAttribute("id", EXTENSION_ID);
        return strategyEl;
    }

    @Override
    public void validate(String name) {
    }

    private String toUnderscoreUppercase(String baseName) {
        String underscoredName = StringUtil.camelCaseToUnderscore((String)baseName, (boolean)false);
        return underscoredName.toUpperCase();
    }
}

