/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.DependencyType;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPartCollection;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.internal.pctype.PolicyCmptTypeAssociation;
import org.faktorips.devtools.model.internal.pctype.PolicyCmptTypeAttribute;
import org.faktorips.devtools.model.internal.pctype.PolicyCmptTypeMethod;
import org.faktorips.devtools.model.internal.pctype.ValidationRule;
import org.faktorips.devtools.model.internal.pctype.persistence.PersistentTypeInfo;
import org.faktorips.devtools.model.internal.type.DuplicatePropertyNameValidator;
import org.faktorips.devtools.model.internal.type.Type;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.ITableNamingStrategy;
import org.faktorips.devtools.model.pctype.AttributeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeMethod;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.pctype.persistence.IPersistentTypeInfo;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.type.AssociationType;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IMethod;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public class PolicyCmptType
extends Type
implements IPolicyCmptType {
    private boolean configurableByProductCmptType = false;
    private boolean generateValidatorClass = this.getIpsProject() == null ? false : this.getIpsProject().getReadOnlyProperties().isGenerateValidatorClassDefaultEnabled();
    private String productCmptType = "";
    private boolean forceExtensionCompilationUnitGeneration = false;
    private IpsObjectPartCollection<IValidationRule> rules;
    private IPersistentTypeInfo persistenceTypeInfo;
    private IpsObjectPartCollection<IPolicyCmptTypeMethod> methods = new IpsObjectPartCollection<IPolicyCmptTypeMethod>(this, PolicyCmptTypeMethod.class, IPolicyCmptTypeMethod.class, "Method");
    private IpsObjectPartCollection<IPolicyCmptTypeAssociation> associations = new IpsObjectPartCollection<IPolicyCmptTypeAssociation>(this, PolicyCmptTypeAssociation.class, IPolicyCmptTypeAssociation.class, "Association");
    private IpsObjectPartCollection<IPolicyCmptTypeAttribute> attributes = new IpsObjectPartCollection<IPolicyCmptTypeAttribute>(this, PolicyCmptTypeAttribute.class, IPolicyCmptTypeAttribute.class, "Attribute");

    public PolicyCmptType(IIpsSrcFile file) {
        super(file);
        this.rules = new IpsObjectPartCollection<IValidationRule>(this, ValidationRule.class, IValidationRule.class, "ValidationRuleDef");
        this.internalInitPersistenceTypeInfo();
    }

    protected IpsObjectPartCollection<IPolicyCmptTypeAssociation> getAssociationPartCollection() {
        return this.associations;
    }

    protected IpsObjectPartCollection<IPolicyCmptTypeAttribute> getAttributesPartCollection() {
        return this.attributes;
    }

    protected IpsObjectPartCollection<IPolicyCmptTypeMethod> getMethodPartCollection() {
        return this.methods;
    }

    @Override
    public IPolicyCmptTypeAssociation getAssociation(String name) {
        return (IPolicyCmptTypeAssociation)super.getAssociation(name);
    }

    @Override
    public IPolicyCmptTypeAssociation getAssociationByRoleNamePlural(String roleNamePlural) {
        return (IPolicyCmptTypeAssociation)super.getAssociationByRoleNamePlural(roleNamePlural);
    }

    @Override
    public String getProductCmptType() {
        return this.productCmptType;
    }

    @Override
    public boolean isConfigurableByProductCmptType() {
        return this.configurableByProductCmptType;
    }

    @Override
    public boolean isGenerateValidatorClass() {
        return this.generateValidatorClass;
    }

    @Override
    public void setGenerateValidatorClass(boolean newValue) {
        boolean oldValue = this.generateValidatorClass;
        this.generateValidatorClass = newValue;
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public void setConfigurableByProductCmptType(boolean newValue) {
        boolean oldValue = this.configurableByProductCmptType;
        this.configurableByProductCmptType = newValue;
        if (!this.configurableByProductCmptType) {
            this.setProductCmptType("");
        }
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return ipsProject.findProductCmptType(this.getProductCmptType());
    }

    @Override
    public void setProductCmptType(String newName) {
        ArgumentCheck.notNull((Object)newName);
        String oldName = this.productCmptType;
        this.productCmptType = newName;
        this.valueChanged(oldName, newName);
    }

    @Override
    public boolean isForceExtensionCompilationUnitGeneration() {
        return this.forceExtensionCompilationUnitGeneration;
    }

    @Override
    public void setForceExtensionCompilationUnitGeneration(boolean flag) {
        boolean oldValue = this.forceExtensionCompilationUnitGeneration;
        this.forceExtensionCompilationUnitGeneration = flag;
        this.valueChanged(oldValue, this.forceExtensionCompilationUnitGeneration);
    }

    @Override
    public boolean isExtensionCompilationUnitGenerated() {
        if (this.forceExtensionCompilationUnitGeneration || this.getNumOfRules() > 0) {
            return true;
        }
        for (IMethod iMethod : this.methods) {
            if (iMethod.isAbstract()) continue;
            return true;
        }
        for (IAttribute iAttribute : this.attributes) {
            IPolicyCmptTypeAttribute attribute = (IPolicyCmptTypeAttribute)iAttribute;
            if (!(attribute.getAttributeType() == AttributeType.DERIVED_BY_EXPLICIT_METHOD_CALL ? !attribute.isProductRelevant() : attribute.getAttributeType() == AttributeType.DERIVED_ON_THE_FLY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IPolicyCmptTypeAttribute> getPolicyCmptTypeAttributes() {
        return this.attributes.asList();
    }

    @Override
    public List<IProductCmptProperty> getProductCmptProperties(ProductCmptPropertyType propertyType) {
        ArrayList<IProductCmptProperty> properties = new ArrayList<IProductCmptProperty>();
        if (propertyType == null || propertyType.equals((Object)ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE)) {
            this.collectAttributeProductCmptProperties(properties);
        }
        if (propertyType == null || propertyType.equals((Object)ProductCmptPropertyType.VALIDATION_RULE)) {
            this.collectValidationRuleProductCmptProperties(properties);
        }
        return properties;
    }

    private void collectAttributeProductCmptProperties(List<IProductCmptProperty> properties) {
        for (IPolicyCmptTypeAttribute attribute : this.getPolicyCmptTypeAttributes()) {
            if (!attribute.isProductRelevant() || !attribute.isChangeable()) continue;
            properties.add(attribute);
        }
    }

    private void collectValidationRuleProductCmptProperties(List<IProductCmptProperty> properties) {
        for (IValidationRule validationRule : this.getValidationRules()) {
            if (!validationRule.isConfigurableByProductComponent()) continue;
            properties.add(validationRule);
        }
    }

    @Override
    public IPolicyCmptTypeAttribute getPolicyCmptTypeAttribute(String name) {
        return (IPolicyCmptTypeAttribute)this.getAttribute(name);
    }

    @Override
    public IPolicyCmptTypeAttribute findPolicyCmptTypeAttribute(String name, IIpsProject ipsProject) {
        return (IPolicyCmptTypeAttribute)this.findAttribute(name, ipsProject);
    }

    @Override
    public IPolicyCmptTypeAttribute newPolicyCmptTypeAttribute() {
        return (IPolicyCmptTypeAttribute)this.newAttribute();
    }

    @Override
    public IPolicyCmptTypeAttribute newPolicyCmptTypeAttribute(String name) {
        IPolicyCmptTypeAttribute attribute = this.newPolicyCmptTypeAttribute();
        attribute.setName(name);
        return attribute;
    }

    @Override
    public boolean isAggregateRoot() {
        IsAggregrateRootVisitor visitor = new IsAggregrateRootVisitor(this.getIpsProject());
        visitor.start(this);
        return visitor.isRoot();
    }

    @Override
    public boolean isDependantType() {
        return !this.isAggregateRoot();
    }

    @Override
    public List<IPolicyCmptTypeAssociation> getPolicyCmptTypeAssociations() {
        return this.associations.asList();
    }

    @Override
    public IPolicyCmptTypeAssociation newPolicyCmptTypeAssociation() {
        return (IPolicyCmptTypeAssociation)this.newAssociation();
    }

    @Override
    public List<IValidationRule> getValidationRules() {
        return this.rules.asList();
    }

    @Override
    public IValidationRule getValidationRule(String ruleName) {
        return this.rules.getPartByName(ruleName);
    }

    @Override
    public IValidationRule newRule() {
        return this.rules.newPart();
    }

    @Override
    public int getNumOfRules() {
        return this.rules.size();
    }

    @Override
    public int[] moveRules(int[] indexes, boolean up) {
        return this.rules.moveParts(indexes, up);
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return IpsObjectType.POLICY_CMPT_TYPE;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.configurableByProductCmptType = XmlUtil.getBooleanAttributeOrFalse(element, "configurableByProductCmptType");
        this.generateValidatorClass = XmlUtil.getBooleanAttributeOrFalse(element, "generateValidatorClass");
        this.productCmptType = XmlUtil.getAttributeOrEmptyString(element, "productCmptType");
        this.forceExtensionCompilationUnitGeneration = XmlUtil.getBooleanAttributeOrFalse(element, "forceExtensionCompilationUnitGeneration");
    }

    @Override
    protected void propertiesToXml(Element newElement) {
        super.propertiesToXml(newElement);
        if (this.configurableByProductCmptType) {
            newElement.setAttribute("configurableByProductCmptType", "" + this.configurableByProductCmptType);
        }
        if (this.generateValidatorClass) {
            newElement.setAttribute("generateValidatorClass", "" + this.generateValidatorClass);
        }
        if (IpsStringUtils.isNotEmpty((String)this.productCmptType)) {
            newElement.setAttribute("productCmptType", this.productCmptType);
        }
        if (this.forceExtensionCompilationUnitGeneration) {
            newElement.setAttribute("forceExtensionCompilationUnitGeneration", "" + this.forceExtensionCompilationUnitGeneration);
        }
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        this.validateProductSide(list, ipsProject);
        this.validateDuplicateRulesNames(list);
        this.validateSameGenerateValidatorClassSetting(list);
    }

    private void validateSameGenerateValidatorClassSetting(MessageList list) {
        this.getSupertypeHierarchy().getAllSupertypes(this).stream().map(IPolicyCmptType.class::cast).filter(t -> t.isGenerateValidatorClass() ^ this.isGenerateValidatorClass()).findAny().map(typeWithDifferentSetting -> MessageFormat.format(Messages.PolicyCmptType_msgDifferentGenerateValidatorClassSetting, typeWithDifferentSetting.getQualifiedName())).map(text -> new Message("POLICYCMPTTYPE-DifferentGenerateValidatorClassSettingInHierarchy", text, Message.ERROR, (Object)this, new String[]{"generateValidatorClass"})).ifPresent(message -> list.add(message));
    }

    private void validateProductSide(MessageList list, IIpsProject ipsProject) {
        IPolicyCmptType superPolicyCmptType;
        if (this.isConfigurableByProductCmptType()) {
            if (IpsStringUtils.isEmpty((String)this.productCmptType)) {
                String text = Messages.PolicyCmptType_msg_ProductCmptTypeNameMissing;
                list.add(new Message("POLICYCMPTTYPE-ProductCmptTypeNameMissing", text, Message.ERROR, (Object)this, new String[]{"productCmptType"}));
            } else {
                IProductCmptType productCmptTypeObj = (IProductCmptType)ValidationUtils.checkAndGetIpsObjectReference(this.productCmptType, IpsObjectType.PRODUCT_CMPT_TYPE, Messages.PolicyCmptType_productCmptType, this, "productCmptType", "POLICYCMPTTYPE-ProductCmptTypeNotFound", list, ipsProject);
                if (productCmptTypeObj != null && productCmptTypeObj.findPolicyCmptType(ipsProject) != this) {
                    String text = MessageFormat.format(Messages.PolicyCmptType_TheTypeDoesNotConfigureThisType, this.productCmptType);
                    list.add(new Message("POLICYCMPTTYPE-ProductCmptTypeDoesNotConfigureThisType", text, Message.ERROR, (Object)this, new String[]{"productCmptType"}));
                }
            }
        }
        if (!this.isConfigurableByProductCmptType() && (superPolicyCmptType = (IPolicyCmptType)this.findSupertype(ipsProject)) != null && superPolicyCmptType.isConfigurableByProductCmptType()) {
            list.add(new Message("POLICYCMPTTYPE-SupertypeProductRelevantForcesThisTypeIsProductRelevant", Messages.PolicyCmptType_msgSubtypeConfigurableWhenSupertypeConfigurable, Message.ERROR, (Object)this, new String[]{"configurableByProductCmptType"}));
        }
    }

    public void validateDuplicateRulesNames(MessageList msgList) {
        for (IValidationRule rule : this.getValidationRules()) {
            CheckValidationRuleVisitor visitor = new CheckValidationRuleVisitor(this.getIpsProject(), rule, msgList);
            visitor.start(this);
        }
    }

    @Override
    protected List<IAssociation> findAssociationsForTargetAndAssociationTypeInternal(String target, AssociationType associationType, IIpsProject project) {
        List<IAssociation> result = super.findAssociationsForTargetAndAssociationTypeInternal(target, associationType, project);
        if (this.getIpsProject().getReadOnlyProperties().isSharedDetailToMasterAssociations()) {
            IPolicyCmptType targetType = project.findPolicyCmptType(target);
            for (IPolicyCmptTypeAssociation association : this.getAssociationPartCollection()) {
                IType sharedTarget;
                if (!association.isSharedAssociation() || !targetType.isSubtypeOf(sharedTarget = association.findTarget(this.getIpsProject()), this.getIpsProject())) continue;
                result.add(association);
            }
        }
        return result;
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        HashSet<IDependency> dependencies = new HashSet<IDependency>();
        if (!IpsStringUtils.isEmpty((String)this.getProductCmptType())) {
            IpsObjectDependency dependency = IpsObjectDependency.createConfiguredByDependency(this.getQualifiedNameType(), new QualifiedNameType(this.getProductCmptType(), IpsObjectType.PRODUCT_CMPT_TYPE));
            dependencies.add(dependency);
            this.addDetails(details, dependency, this, "productCmptType");
        }
        this.dependsOnAddValidationDependency(dependencies);
        if (!this.isConfigurableByProductCmptType()) {
            for (IPolicyCmptTypeAssociation association : this.getPolicyCmptTypeAssociations()) {
                if (!association.isConstrainedByProductStructure(this.getIpsProject())) continue;
                IpsObjectDependency dependency = IpsObjectDependency.createReferenceDependency(this.getQualifiedNameType(), new QualifiedNameType(association.getMatchingAssociationSource(), IpsObjectType.PRODUCT_CMPT_TYPE));
                dependencies.add(dependency);
                this.addDetails(details, dependency, association, "matchingAssociationSource");
            }
        }
        super.dependsOn(dependencies, details);
        return dependencies.toArray(new IDependency[dependencies.size()]);
    }

    private void dependsOnAddValidationDependency(Set<IDependency> dependencies) {
        dependencies.add(IpsObjectDependency.create(this.getQualifiedNameType(), new QualifiedNameType(this.getQualifiedName(), IpsObjectType.PRODUCT_CMPT_TYPE), DependencyType.VALIDATION));
    }

    @Override
    public IPersistentTypeInfo getPersistenceTypeInfo() {
        return this.persistenceTypeInfo;
    }

    @Override
    public boolean isPersistentEnabled() {
        return this.getPersistenceTypeInfo() != null && this.getPersistenceTypeInfo().isEnabled();
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        if (xmlTag.getTagName().equals("Persistence")) {
            return this.newPersistentTypeInfoInternal(id);
        }
        return super.newPartThis(xmlTag, id);
    }

    @Override
    public IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (partType == PersistentTypeInfo.class) {
            return this.newPersistentTypeInfoInternal(this.getNextPartId());
        }
        return super.newPartThis(partType);
    }

    private IIpsObjectPart newPersistentTypeInfoInternal(String id) {
        this.persistenceTypeInfo = new PersistentTypeInfo(this, id);
        return this.persistenceTypeInfo;
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (IPersistentTypeInfo.class.isAssignableFrom(part.getClass())) {
            this.persistenceTypeInfo = (IPersistentTypeInfo)part;
            return true;
        }
        return super.addPartThis(part);
    }

    @Override
    protected void reinitPartCollectionsThis() {
        super.reinitPartCollectionsThis();
        this.internalInitPersistenceTypeInfo();
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (PersistentTypeInfo.class.isAssignableFrom(part.getClass())) {
            this.persistenceTypeInfo = this.newPart(PersistentTypeInfo.class);
            return true;
        }
        return super.removePartThis(part);
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        IIpsElement[] superChildren = super.getChildrenThis();
        if (this.persistenceTypeInfo != null) {
            ArrayList<IIpsElement> children = new ArrayList<IIpsElement>(Arrays.asList(superChildren));
            children.add(this.persistenceTypeInfo);
            return children.toArray(new IIpsElement[children.size()]);
        }
        return superChildren;
    }

    @Override
    public void initPersistentTypeInfo() {
        if (!this.getIpsProject().isPersistenceSupportEnabled()) {
            throw new IpsException((IStatus)new IpsStatus("Cannot initialize persistence information because the IPS Project is not persistent."));
        }
        ITableNamingStrategy tableNamingStrategy = this.getIpsProject().getTableNamingStrategy();
        IPolicyCmptType rootEntity = this.persistenceTypeInfo.findRootEntity();
        if (rootEntity != null && rootEntity != this) {
            IPolicyCmptType pcSupertype = (IPolicyCmptType)this.findSupertype(this.getIpsProject());
            if (pcSupertype != null && pcSupertype.isPersistentEnabled()) {
                IPersistentTypeInfo pcSupertypeInfo = pcSupertype.getPersistenceTypeInfo();
                this.persistenceTypeInfo.setInheritanceStrategy(pcSupertypeInfo.getInheritanceStrategy());
                if (pcSupertypeInfo.getInheritanceStrategy() == IPersistentTypeInfo.InheritanceStrategy.JOINED_SUBCLASS) {
                    this.persistenceTypeInfo.setTableName(tableNamingStrategy.getTableName(this.getName()));
                } else {
                    this.persistenceTypeInfo.setTableName(tableNamingStrategy.getTableName(pcSupertype.getName()));
                }
                this.persistenceTypeInfo.setDiscriminatorDatatype(pcSupertypeInfo.getDiscriminatorDatatype());
            } else {
                this.persistenceTypeInfo.setTableName(tableNamingStrategy.getTableName(this.getName()));
                this.persistenceTypeInfo.setDiscriminatorValue(this.getName());
            }
        } else {
            this.persistenceTypeInfo.setDefinesDiscriminatorColumn(true);
            this.persistenceTypeInfo.setTableName(tableNamingStrategy.getTableName(this.getName()));
            this.persistenceTypeInfo.setDiscriminatorValue(this.getName());
        }
    }

    private void internalInitPersistenceTypeInfo() {
        IIpsProject ipsProject = this.getIpsProject();
        if (ipsProject == null || !ipsProject.isPersistenceSupportEnabled()) {
            this.persistenceTypeInfo = null;
            return;
        }
        this.newPart(PersistentTypeInfo.class);
    }

    @Override
    protected void checkDerivedUnionIsImplemented(IAssociation association, List<IAssociation> candidateSubsets, MessageList msgList) {
        super.checkDerivedUnionIsImplemented(association, candidateSubsets, msgList);
        if (!association.isDerivedUnion()) {
            IPolicyCmptTypeAssociation policyCmptTypeAssociation = (IPolicyCmptTypeAssociation)association;
            if (!policyCmptTypeAssociation.isInverseOfDerivedUnion()) {
                return;
            }
            if (!this.isInverseSubsetted(policyCmptTypeAssociation, candidateSubsets)) {
                String text = MessageFormat.format(Messages.PolicyCmptType_msgInverseDerivedUnionNotSepcified, association.getName(), association.getType().getQualifiedName());
                msgList.add(new Message("Type-MustSpecifyInverseDerivedUnion", text, Message.ERROR, (Object)this, new String[]{"abstract"}));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInverseSubsetted(IPolicyCmptTypeAssociation inverseOfDerivedUnion, List<IAssociation> candidateSubsets) {
        IPolicyCmptTypeAssociation derivedUnion = inverseOfDerivedUnion.findInverseAssociation(this.getIpsProject());
        if (derivedUnion == null) {
            return false;
        }
        for (IAssociation candidate : candidateSubsets) {
            IPolicyCmptTypeAssociation inverseAssociationOfCandidate;
            void policyCmptTypeAssociation;
            IAssociation iAssociation = candidate;
            if (!(iAssociation instanceof IPolicyCmptTypeAssociation)) continue;
            IPolicyCmptTypeAssociation cfr_ignored_0 = (IPolicyCmptTypeAssociation)iAssociation;
            IPolicyCmptTypeAssociation cfr_ignored_1 = (IPolicyCmptTypeAssociation)iAssociation;
            if (!policyCmptTypeAssociation.isCompositionDetailToMaster() || (inverseAssociationOfCandidate = policyCmptTypeAssociation.findInverseAssociation(this.getIpsProject())) == null) continue;
            if (inverseAssociationOfCandidate.getSubsettedDerivedUnion().equals(derivedUnion.getName())) {
                return true;
            }
            if (!this.getIpsProject().getReadOnlyProperties().isSharedDetailToMasterAssociations() || !inverseAssociationOfCandidate.equals(derivedUnion)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IValidationRule> findAllValidationRules(IIpsProject ipsProject) {
        AllValidationRulesFinder finder = new AllValidationRulesFinder(ipsProject, true);
        finder.start(this);
        return finder.getValidationRules();
    }

    @Override
    public IValidationRule findValidationRule(String ruleName, IIpsProject ipsProject) {
        ValidationRuleForNameFinder finder = new ValidationRuleForNameFinder(ruleName, ipsProject);
        finder.start(this);
        return finder.getValidationRule();
    }

    @Override
    public String getCaption(Locale locale) {
        return Messages.PolicyCmptType_caption;
    }

    @Override
    public DuplicatePropertyNameValidator createDuplicatePropertyNameValidator(IIpsProject ipsProject) {
        return new PolicyCmptTypeDuplicatePropertyNameValidator(ipsProject);
    }

    @Override
    public List<IValidationRule> overrideValidationRules(List<? extends IValidationRule> validationRules) {
        ArrayList<IValidationRule> newRules = new ArrayList<IValidationRule>(validationRules.size());
        for (IValidationRule iValidationRule : validationRules) {
            IValidationRule override = this.rules.newPart(iValidationRule);
            override.setName(iValidationRule.getName());
            override.setOverriding(true);
            newRules.add(override);
        }
        return newRules;
    }

    @Override
    public List<IValidationRule> findOverrideValidationRuleCandidates(IIpsProject ipsProject) {
        IType foundSupertype = this.findSupertype(ipsProject);
        if (foundSupertype == null) {
            return new ArrayList<IValidationRule>();
        }
        HashMap<String, IValidationRule> toExclude = new HashMap<String, IValidationRule>();
        for (IValidationRule rule : this.getValidationRules()) {
            if (!rule.isOverriding()) continue;
            toExclude.put(rule.getName(), rule);
        }
        List<IValidationRule> allRules = this.getSupertypeHierarchy().getAllRules(foundSupertype);
        ArrayList<IValidationRule> rulesToOverride = new ArrayList<IValidationRule>();
        for (IValidationRule candidate : allRules) {
            if (toExclude.containsKey(candidate.getName()) || candidate.isCheckValueAgainstValueSetRule() && candidate.getValidatedAttributes().length == 1 && this.getPolicyCmptTypeAttribute(candidate.getValidatedAttributeAt(0)) == null) continue;
            rulesToOverride.add(candidate);
        }
        return rulesToOverride;
    }

    private static class AllValidationRulesFinder
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private final List<IValidationRule> rules;
        private final boolean superTypeFirst;

        public AllValidationRulesFinder(IIpsProject ipsProject, boolean superTypeFirst) {
            super(ipsProject);
            this.superTypeFirst = superTypeFirst;
            this.rules = new ArrayList<IValidationRule>();
        }

        public List<IValidationRule> getValidationRules() {
            return this.rules;
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            List<IValidationRule> definedRules = currentType.getValidationRules();
            if (this.superTypeFirst) {
                this.rules.addAll(0, definedRules);
            } else {
                this.rules.addAll(definedRules);
            }
            return true;
        }
    }

    private static class CheckValidationRuleVisitor
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private IValidationRule rule;
        private MessageList msgList;

        public CheckValidationRuleVisitor(IIpsProject ipsProject, IValidationRule rule, MessageList msgList) {
            super(ipsProject);
            this.rule = rule;
            this.msgList = msgList;
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            String text;
            for (IValidationRule validationRule : currentType.getValidationRules()) {
                if (validationRule == this.rule || !validationRule.getName().equals(this.rule.getName()) || this.rule.overrides(validationRule)) continue;
                text = Messages.PolicyCmptType_msgDuplicateRuleName;
                this.msgList.add(new Message("VALIDATIONRULE-DuplicateRuleName", text, Message.ERROR, (Object)this.rule, new String[]{"name"}));
            }
            for (IMethod method : currentType.getMethods()) {
                if (method.getNumOfParameters() != 0 || !method.getName().equals(this.rule.getName())) continue;
                text = MessageFormat.format(Messages.PolicyCmptType_msgRuleMethodNameConflict, this.rule.getName());
                this.msgList.add(new Message("VALIDATIONRULE-ValidationRuleMethodNameConflict", text, Message.ERROR, (Object)this.rule, new String[]{"name"}));
            }
            return true;
        }
    }

    private static class IsAggregrateRootVisitor
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private boolean root = true;

        public IsAggregrateRootVisitor(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            List<IPolicyCmptTypeAssociation> relations = currentType.getPolicyCmptTypeAssociations();
            for (IPolicyCmptTypeAssociation each : relations) {
                if (!each.getAssociationType().isCompositionDetailToMaster()) continue;
                this.root = false;
                return false;
            }
            return true;
        }

        public boolean isRoot() {
            return this.root;
        }
    }

    private static class PolicyCmptTypeDuplicatePropertyNameValidator
    extends DuplicatePropertyNameValidator {
        public PolicyCmptTypeDuplicatePropertyNameValidator(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(IType currentType) {
            super.visit(currentType);
            IProductCmptType matchingType = this.getMatchingType(currentType);
            if (matchingType != null) {
                String name = matchingType.getUnqualifiedName();
                this.add(name, new ObjectProperty((Object)currentType, "productCmptType"));
            }
            return true;
        }

        @Override
        protected IProductCmptType getMatchingType(IType currentType) {
            return ((IPolicyCmptType)currentType).findProductCmptType(this.getIpsProject());
        }

        @Override
        protected String getObjectKindNamePlural(ObjectProperty invalidObjProperty) {
            IIpsObjectPartContainer objectPartContainer = (IIpsObjectPartContainer)invalidObjProperty.getObject();
            if (objectPartContainer instanceof IPolicyCmptType && invalidObjProperty.getProperty().equals("productCmptType")) {
                return org.faktorips.devtools.model.internal.productcmpttype.Messages.ProductCmptType_pluralCaption;
            }
            return super.getObjectKindNamePlural(invalidObjProperty);
        }
    }

    private static class ValidationRuleForNameFinder
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private IValidationRule foundRule = null;
        private final String ruleName;

        public ValidationRuleForNameFinder(String ruleName, IIpsProject ipsProject) {
            super(ipsProject);
            this.ruleName = ruleName;
        }

        public IValidationRule getValidationRule() {
            return this.foundRule;
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            List<IValidationRule> definedRules = currentType.getValidationRules();
            for (IValidationRule rule : definedRules) {
                if (!rule.getName().equals(this.ruleName)) continue;
                this.foundRule = rule;
                return false;
            }
            return true;
        }
    }
}

