/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.internal.pctype.PolicyCmptType;
import org.faktorips.devtools.model.internal.pctype.persistence.PersistentAssociationInfo;
import org.faktorips.devtools.model.internal.type.Association;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.pctype.persistence.IPersistentAssociationInfo;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.AssociationType;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PolicyCmptTypeAssociation
extends Association
implements IPolicyCmptTypeAssociation {
    private boolean qualified = false;
    private boolean configurable = true;
    private String inverseAssociation = "";
    private boolean sharedAssociation;
    private String matchingAssociationSource = "";
    private String matchingAssociationName = "";
    private IPersistentAssociationInfo persistenceAssociationInfo;

    public PolicyCmptTypeAssociation(IPolicyCmptType pcType, String id) {
        super(pcType, id);
        if (pcType.getIpsProject().isPersistenceSupportEnabled()) {
            this.persistenceAssociationInfo = this.newPart(PersistentAssociationInfo.class);
        }
    }

    @Override
    public IPolicyCmptType getPolicyCmptType() {
        return (PolicyCmptType)this.getIpsObject();
    }

    @Override
    public boolean isConstrain() {
        AssociationType associationType = this.getAssociationType();
        if (associationType.isCompositionDetailToMaster()) {
            return this.isConstrainedInverse();
        }
        return super.isConstrain();
    }

    private boolean isConstrainedInverse() {
        IPolicyCmptTypeAssociation foundInverseAssociation = this.findInverseAssociation(this.getIpsProject());
        if (foundInverseAssociation != null && foundInverseAssociation.isCompositionMasterToDetail()) {
            return foundInverseAssociation.isConstrain();
        }
        return false;
    }

    @Override
    public boolean isComposition() {
        return this.getAssociationType().isCompositionDetailToMaster() || this.getAssociationType().isCompositionMasterToDetail();
    }

    @Override
    public boolean isCompositionMasterToDetail() {
        return this.getAssociationType().isCompositionMasterToDetail();
    }

    @Override
    public boolean isCompositionDetailToMaster() {
        return this.getAssociationType().isCompositionDetailToMaster();
    }

    @Override
    public boolean isDerivedUnionApplicable() {
        return (this.isAssoziation() || this.isCompositionMasterToDetail()) && !this.isConstrain();
    }

    @Override
    public boolean isInverseOfDerivedUnion() {
        if (!this.isCompositionDetailToMaster()) {
            return false;
        }
        IPolicyCmptTypeAssociation masterToDetail = this.findInverseAssociation(this.getIpsProject());
        if (masterToDetail == null) {
            return false;
        }
        return masterToDetail.isDerivedUnion();
    }

    @Override
    public void setAssociationType(AssociationType newType) {
        if (newType.isCompositionDetailToMaster()) {
            this.setSubsettedDerivedUnion("");
            this.setDerivedUnionInternal(false);
            this.qualified = false;
            this.setMinCardinalityInternal(0);
            this.setMaxCardinalityInternal(1);
        }
        super.setAssociationType(newType);
    }

    @Override
    public IPolicyCmptType findTargetPolicyCmptType(IIpsProject ipsProject) {
        return ipsProject.findPolicyCmptType(this.getTarget());
    }

    @Override
    public boolean isConstrainedByProductStructure(IIpsProject ipsProject) {
        return this.findMatchingProductCmptTypeAssociation(ipsProject) != null;
    }

    @Override
    public IProductCmptTypeAssociation findMatchingProductCmptTypeAssociation(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.matchingAssociationName) || IpsStringUtils.isEmpty((String)this.getMatchingAssociationSource())) {
            return this.findDefaultMatchingProductCmptTypeAssociation(ipsProject);
        }
        IProductCmptType productCmptType = ipsProject.findProductCmptType(this.getMatchingAssociationSource());
        if (productCmptType == null) {
            return null;
        }
        return (IProductCmptTypeAssociation)productCmptType.findAssociation(this.matchingAssociationName, ipsProject);
    }

    @Override
    public IProductCmptTypeAssociation findDefaultMatchingProductCmptTypeAssociation(IIpsProject ipsProject) {
        if (this.getAssociationType().isCompositionDetailToMaster()) {
            return null;
        }
        IProductCmptType productCmptType = this.getPolicyCmptType().findProductCmptType(ipsProject);
        if (productCmptType == null) {
            return null;
        }
        IPolicyCmptType targetType = this.findTargetPolicyCmptType(ipsProject);
        if (targetType == null) {
            return null;
        }
        List<IAssociation> candidates = productCmptType.getAssociationsForTarget(targetType.getProductCmptType());
        int index = this.getAssociationIndex();
        if (index >= candidates.size()) {
            return null;
        }
        return (IProductCmptTypeAssociation)candidates.get(index);
    }

    private int getAssociationIndex() {
        ArrayList<IPolicyCmptTypeAssociation> allAssociationsForTheTargetType = new ArrayList<IPolicyCmptTypeAssociation>();
        List<IPolicyCmptTypeAssociation> ass = this.getPolicyCmptType().getPolicyCmptTypeAssociations();
        for (IPolicyCmptTypeAssociation as : ass) {
            if (!this.getTarget().equals(as.getTarget())) continue;
            allAssociationsForTheTargetType.add(as);
        }
        int index = 0;
        Iterator it = allAssociationsForTheTargetType.iterator();
        while (it.hasNext()) {
            if (it.next() == this) {
                return index;
            }
            ++index;
        }
        throw new RuntimeException("Can't get index of association " + this);
    }

    @Override
    public boolean isQualified() {
        return this.qualified;
    }

    @Override
    public void setQualified(boolean newValue) {
        boolean oldValue = this.qualified;
        this.qualified = newValue;
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public boolean isQualificationPossible(IIpsProject ipsProject) {
        if (!this.isCompositionMasterToDetail()) {
            return false;
        }
        IPolicyCmptType targetType = this.findTargetPolicyCmptType(ipsProject);
        return targetType != null && targetType.isConfigurableByProductCmptType();
    }

    @Override
    public String findQualifierCandidate(IIpsProject ipsProject) {
        IPolicyCmptType targetType = this.findTargetPolicyCmptType(ipsProject);
        if (targetType == null || !targetType.isConfigurableByProductCmptType()) {
            return "";
        }
        return targetType.getProductCmptType();
    }

    @Override
    public IProductCmptType findQualifier(IIpsProject ipsProject) {
        if (!this.qualified) {
            return null;
        }
        return ipsProject.findProductCmptType(this.findQualifierCandidate(ipsProject));
    }

    @Override
    public String getInverseAssociation() {
        return this.inverseAssociation;
    }

    @Override
    public boolean hasInverseAssociation() {
        return IpsStringUtils.isNotEmpty((String)this.inverseAssociation);
    }

    @Override
    public void setInverseAssociation(String newRelation) {
        String oldValue = this.inverseAssociation;
        this.inverseAssociation = newRelation;
        this.valueChanged(oldValue, newRelation);
    }

    @Override
    public IPolicyCmptTypeAssociation findInverseAssociation(IIpsProject ipsProject) {
        if (this.isSharedAssociation()) {
            return null;
        }
        String searchedAssociation = this.inverseAssociation;
        IPolicyCmptType target = this.findTargetPolicyCmptType(ipsProject);
        if (target == null) {
            return null;
        }
        List<IAssociation> associations = target.getAssociations();
        if (IpsStringUtils.isEmpty((String)searchedAssociation)) {
            return null;
        }
        for (IAssociation association : associations) {
            if (!association.getName().equals(searchedAssociation)) continue;
            return (IPolicyCmptTypeAssociation)association;
        }
        return null;
    }

    @Override
    public IPolicyCmptTypeAssociation newInverseAssociation() {
        IPolicyCmptType targetPolicyCmptType = this.findTargetPolicyCmptType(this.getIpsProject());
        if (targetPolicyCmptType == null) {
            throw new IpsException((IStatus)new IpsStatus("Target policy component type of association " + this.getName() + " not found."));
        }
        IPolicyCmptTypeAssociation newInverseAssociation = targetPolicyCmptType.newPolicyCmptTypeAssociation();
        newInverseAssociation.setTarget(this.getPolicyCmptType().getQualifiedName());
        newInverseAssociation.setAssociationType(this.getAssociationType().getCorrespondingAssociationType());
        newInverseAssociation.setTargetRoleSingular(newInverseAssociation.getDefaultTargetRoleSingular());
        this.setInverseAssociation(newInverseAssociation.getName());
        newInverseAssociation.setInverseAssociation(this.getName());
        IPolicyCmptTypeAssociation derivedUnionAssociation = (IPolicyCmptTypeAssociation)this.findSubsettedDerivedUnion(this.getIpsProject());
        if (this.isAssoziation() && derivedUnionAssociation != null) {
            newInverseAssociation.setSubsettedDerivedUnion(derivedUnionAssociation.getInverseAssociation());
        }
        if (this.isAssoziation() && this.isDerivedUnion()) {
            newInverseAssociation.setDerivedUnion(true);
        }
        return newInverseAssociation;
    }

    @Override
    public void setSharedAssociation(boolean sharedAssociation) {
        boolean oldValue = this.sharedAssociation;
        this.sharedAssociation = sharedAssociation;
        this.valueChanged(oldValue, sharedAssociation);
    }

    @Override
    public boolean isSharedAssociation() {
        return this.getAssociationType().isCompositionDetailToMaster() && this.getIpsProject().getReadOnlyProperties().isSharedDetailToMasterAssociations() && this.sharedAssociation;
    }

    @Override
    public IPolicyCmptTypeAssociation findSharedAssociationHost(IIpsProject ipsProject) {
        Association.AssociationHierarchyVisitor visitor = new Association.AssociationHierarchyVisitor(ipsProject){

            @Override
            protected boolean continueVisiting() {
                return ((IPolicyCmptTypeAssociation)this.getLastVisited()).isSharedAssociation();
            }
        };
        visitor.start(this);
        IPolicyCmptTypeAssociation associationHostCandidate = (IPolicyCmptTypeAssociation)visitor.getSuperAssociation();
        if (associationHostCandidate != null && associationHostCandidate.getTarget().equals(this.getTarget()) && associationHostCandidate.getAssociationType().isCompositionDetailToMaster()) {
            return associationHostCandidate;
        }
        return null;
    }

    @Override
    public void setMatchingAssociationSource(String matchingAssociationSource) {
        String oldSource = this.matchingAssociationSource;
        this.matchingAssociationSource = matchingAssociationSource;
        this.valueChanged(oldSource, matchingAssociationSource);
    }

    @Override
    public String getMatchingAssociationSource() {
        if (this.getPolicyCmptType().isConfigurableByProductCmptType()) {
            return this.getPolicyCmptType().getProductCmptType();
        }
        return this.matchingAssociationSource;
    }

    @Override
    public void setMatchingAssociationName(String matchingAssociationName) {
        String oldName = this.matchingAssociationName;
        this.matchingAssociationName = matchingAssociationName;
        this.valueChanged(oldName, this.matchingAssociationName);
    }

    @Override
    public String getMatchingAssociationName() {
        return this.matchingAssociationName;
    }

    @Override
    public void setConfigurable(boolean configurable) {
        boolean oldValue = this.configurable;
        this.configurable = configurable;
        this.valueChanged(oldValue, configurable);
    }

    @Override
    public boolean isConfigurable() {
        return this.configurable;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        if (this.getMaxCardinality() != 1 && this.getAssociationType() == AssociationType.COMPOSITION_DETAIL_TO_MASTER) {
            String text = Messages.Association_msg_DetailToMasterAssociationMustHaveMaxCardinality1;
            list.add(new Message("PolicyCmptTypeRelation-MaxCardinalityMustBe1ForReverseCombosition", text, Message.ERROR, (Object)this, new String[]{"maxCardinality", "associationType"}));
        }
        this.validateDerivedUnion(list, ipsProject);
        this.validateInverseRelation(list, ipsProject);
        this.validateMatchingAssociation(list, ipsProject);
        this.validateConstrainedAssociation(list, ipsProject);
    }

    private void validateDerivedUnion(MessageList list, IIpsProject ipsProject) {
        IAssociation unionAss = this.findSubsettedDerivedUnion(ipsProject);
        if (unionAss instanceof IPolicyCmptTypeAssociation) {
            this.checkForDerivedUnionInverseAssociationMismatch((IPolicyCmptTypeAssociation)unionAss, list, ipsProject);
        }
    }

    private void checkForDerivedUnionInverseAssociationMismatch(IPolicyCmptTypeAssociation derivedUnion, MessageList list, IIpsProject ipsProject) {
        IPolicyCmptTypeAssociation inverseAss = this.findInverseAssociation(ipsProject);
        if (inverseAss == null || this.isComposition() || inverseAss.isComposition()) {
            return;
        }
        IPolicyCmptTypeAssociation inverseRelationOfContainerRel = derivedUnion.findInverseAssociation(ipsProject);
        if (inverseRelationOfContainerRel == null) {
            return;
        }
        IAssociation derivedUnionOfInverseRel = inverseAss.findSubsettedDerivedUnion(ipsProject);
        if (derivedUnionOfInverseRel == null || derivedUnionOfInverseRel != inverseRelationOfContainerRel) {
            String text = MessageFormat.format(Messages.Association_msg_InverseAssociationInconsistentWithDerivedUnion, derivedUnion);
            list.add(new Message("PolicyCmptTypeRelation-InverseAssociationInconsistentWithDerivedUnion", text, Message.ERROR, (Object)this, new String[]{"subsettedDerivedUnion"}));
        }
    }

    private void validateInverseRelation(MessageList list, IIpsProject ipsProject) {
        String text;
        if (!this.validateInverseCompositionDetailToMaster(list) || !this.validateEmptyInverseAssociation(list, ipsProject)) {
            return;
        }
        IPolicyCmptTypeAssociation inverseAss = this.findInverseAssociation(ipsProject);
        if (inverseAss == null) {
            String text2 = MessageFormat.format(Messages.Association_msg_AssociationNotFoundInTarget, this.inverseAssociation, this.getTarget());
            list.add(new Message("PolicyCmptTypeRelation-ReverseRelationNotInTarget", text2, Message.ERROR, (Object)this, new String[]{"inverseAssociation"}));
            return;
        }
        if (!this.checkInverseAssociation(this.getIpsProject(), this, inverseAss)) {
            text = Messages.Association_msg_InverseAssociationMismatch;
            list.add(new Message("PolicyCmptTypeRelation-InverseRelationMismatch", text, Message.ERROR, (Object)this, new String[]{"inverseAssociation"}));
        }
        if (!this.validateInverseAssociationToAssociation(list, inverseAss)) {
            return;
        }
        this.validateInverseMasterToDetailAndDetailToMaster(list, inverseAss);
        if (this.getAssociationType().isAssoziation() && this.isDerivedUnion() != inverseAss.isDerivedUnion()) {
            text = Messages.Association_msg_InverseAssociationMustBeMarkedAsDerivedUnionToo;
            list.add(new Message("PolicyCmptTypeRelation-ReverseRelationOfContainerRelationMustBeContainerRelationToo", text, Message.ERROR, (Object)this, new String[]{"inverseAssociation"}));
        }
    }

    private boolean validateEmptyInverseAssociation(MessageList list, IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.inverseAssociation)) {
            if (this.isSubsetOfADerivedUnion()) {
                IPolicyCmptTypeAssociation subsettedDerivedUnion = (IPolicyCmptTypeAssociation)this.findSubsettedDerivedUnion(ipsProject);
                if (subsettedDerivedUnion == null) {
                    return false;
                }
                if (IpsStringUtils.isNotEmpty((String)subsettedDerivedUnion.getInverseAssociation())) {
                    String text = Messages.PolicyCmptTypeAssociation_Association_msg_InverseAssociationMustNotBeEmptyIfDerivedUnionHasInverse;
                    list.add(new Message("PolicyCmptTypeRelation-SubsettedDerivedUnionInverseMustBeExistsIfInverseDerivedUnionExists", text, Message.ERROR, (Object)this, new String[]{"inverseAssociation"}));
                }
            }
            return false;
        }
        return true;
    }

    private void validateInverseMasterToDetailAndDetailToMaster(MessageList list, IPolicyCmptTypeAssociation inverseAss) {
        if (!(this.getAssociationType().isAssoziation() || this.isAssociationTypeMToDAndInverAssociationDToM(inverseAss) || this.isAssociationTypeDToMAndInverAssociationMToD(inverseAss))) {
            String code;
            String text;
            if (this.getAssociationType().isCompositionMasterToDetail()) {
                text = Messages.PolicyCmptTypeAssociation_Association_msg_InverseOfMasterToDetailMustBeADetailToMaster;
                code = "PolicyCmptTypeRelation-InverseMasterToDetailTypeMissmatch";
            } else {
                text = Messages.PolicyCmptTypeAssociation_InverseOfDetailToMasterMustBeAMasterToDetail;
                code = "PolicyCmptTypeRelation-InverseDetailToMasterTypeMissmatch";
            }
            list.add(new Message(code, text, Message.ERROR, (Object)this, new String[]{"inverseAssociation"}));
        }
    }

    private boolean isAssociationTypeMToDAndInverAssociationDToM(IPolicyCmptTypeAssociation inverseAss) {
        return this.getAssociationType().isCompositionMasterToDetail() && inverseAss.isCompositionDetailToMaster();
    }

    private boolean isAssociationTypeDToMAndInverAssociationMToD(IPolicyCmptTypeAssociation inverseAss) {
        return this.getAssociationType().isCompositionDetailToMaster() && inverseAss.isCompositionMasterToDetail();
    }

    private boolean validateInverseAssociationToAssociation(MessageList list, IPolicyCmptTypeAssociation inverseAss) {
        if (!(inverseAss.isAssoziation() && this.getAssociationType().isAssoziation() || !inverseAss.isAssoziation() && !this.getAssociationType().isAssoziation())) {
            String text = Messages.Association_msg_InverseAssociationMustBeOfTypeAssociation;
            list.add(new Message("PolicyCmptTypeRelation-InverseAssociationTypeMissmatch", text, Message.ERROR, (Object)this, new String[]{"inverseAssociation"}));
            return false;
        }
        return true;
    }

    private boolean validateInverseCompositionDetailToMaster(MessageList list) {
        if (this.getAssociationType().isCompositionDetailToMaster()) {
            String text = Messages.PolicyCmptTypeAssociation_Association_msg_InverseAssociationMustNotBeEmpty;
            Message errorMessage = Message.newError((String)"PolicyCmptTypeRelation-InverseAssociationMustBeSetIfTypeIsDetailToMaster", (String)text, (Object)this, (String[])new String[]{"inverseAssociation"});
            if (this.isSharedAssociation()) {
                IPolicyCmptTypeAssociation superAssociation = this.findSharedAssociationHost(this.getIpsProject());
                if (superAssociation == null) {
                    list.add(Message.newError((String)"PolicyCmptTypeRelation-invalidSharedAssociation", (String)Messages.PolicyCmptTypeAssociation_sharedAssociation_noAssociationHost, (Object)this, (String[])new String[]{"sharedAssociation"}));
                    return false;
                }
                if (!superAssociation.isInverseOfDerivedUnion()) {
                    list.add(Message.newError((String)"PolicyCmptTypeRelation-invalidSharedAssociation", (String)Messages.PolicyCmptTypeAssociation_sharedAssociation_invalidAssociationHost, (Object)this, (String[])new String[]{"sharedAssociation"}));
                }
                return false;
            }
            if (IpsStringUtils.isEmpty((String)this.inverseAssociation)) {
                list.add(errorMessage);
                return false;
            }
        }
        return true;
    }

    private boolean checkInverseAssociation(IIpsProject ipsProject, IPolicyCmptTypeAssociation association, IPolicyCmptTypeAssociation inverseAss) {
        if (inverseAss.getInverseAssociation().equals(association.getName()) && inverseAss.getTarget().equals(association.getType().getQualifiedName())) {
            return true;
        }
        if (inverseAss.isSharedAssociation()) {
            IPolicyCmptTypeAssociation sharedAssociationHost = inverseAss.findSharedAssociationHost(inverseAss.getIpsProject());
            if (sharedAssociationHost == null) {
                return false;
            }
            IPolicyCmptTypeAssociation subsettedDerivedUnion = (IPolicyCmptTypeAssociation)association.findSubsettedDerivedUnion(ipsProject);
            if (subsettedDerivedUnion == null) {
                return false;
            }
            return this.checkInverseAssociation(ipsProject, subsettedDerivedUnion, sharedAssociationHost);
        }
        return false;
    }

    private void validateMatchingAssociation(MessageList list, IIpsProject ipsProject) {
        if (!this.getPolicyCmptType().isConfigurableByProductCmptType() && IpsStringUtils.isNotEmpty((String)this.getMatchingAssociationSource())) {
            IProductCmptType matchingProdCmptType = ipsProject.findProductCmptType(this.getMatchingAssociationSource());
            if (matchingProdCmptType == null) {
                list.add(new Message("PolicyCmptTypeRelation-MatchingAssociationInvalidSource", Messages.PolicyCmptTypeAssociation_error_MatchingAssociationInvalidSourceForConfiguredType, Message.ERROR, (Object)this, new String[]{"matchingAssociationSource"}));
                return;
            }
            IPolicyCmptType matchingPolicyCmptType = matchingProdCmptType.findPolicyCmptType(ipsProject);
            boolean found = this.findCorrectMatchingPolicyCmptTypeRecoursive(matchingPolicyCmptType, ipsProject, new HashSet<IPolicyCmptType>());
            if (!found) {
                list.add(new Message("PolicyCmptTypeRelation-MatchingAssociationInvalidSource", Messages.PolicyCmptTypeAssociation_error_MatchingAssociationInvalidSourceForNotConfiguredType, Message.ERROR, (Object)this, new String[]{"matchingAssociationSource"}));
                return;
            }
        }
        IProductCmptTypeAssociation matchingAssociation = this.findMatchingProductCmptTypeAssociation(ipsProject);
        if (IpsStringUtils.isNotEmpty((String)this.matchingAssociationSource) && IpsStringUtils.isNotEmpty((String)this.matchingAssociationName) && matchingAssociation == null) {
            list.add(new Message("PolicyCmptTypeRelation-MatchingAssociationNotFound", MessageFormat.format(Messages.PolicyCmptTypeAssociation_error_matchingAssociatonNotFound, this.getMatchingAssociationName(), this.getMatchingAssociationSource()), Message.ERROR, (Object)this, new String[]{"matchingAssociationName", "matchingAssociationSource"}));
        } else if (matchingAssociation != null && !this.equals(matchingAssociation.findMatchingPolicyCmptTypeAssociation(ipsProject))) {
            list.add(new Message("PolicyCmptTypeRelation-MatchingAssociationIsInvalid", MessageFormat.format(Messages.PolicyCmptTypeAssociation_error_MatchingAssociationInvalid, this.getMatchingAssociationName(), this.getMatchingAssociationSource()), Message.ERROR, (Object)this, new String[]{"matchingAssociationName", "matchingAssociationSource"}));
        }
    }

    private void validateConstrainedAssociation(MessageList list, IIpsProject ipsProject) {
        IAssociation constrainedAssociation;
        if (this.isConstrain() && (constrainedAssociation = this.findConstrainedAssociation(ipsProject)) != null && this.isQualified() != constrainedAssociation.isQualified()) {
            list.newError("PolicyCmptTypeRelation-ConstrainQualifierNotMatch", Messages.PolicyCmptTypeAssociation_errorMsg_constrainedPropertyQualifiedMismatch, new ObjectProperty[]{new ObjectProperty((Object)this, "constrain"), new ObjectProperty((Object)this, "qualified")});
        }
    }

    boolean findCorrectMatchingPolicyCmptTypeRecoursive(IPolicyCmptType parentPolicyCmptType, IIpsProject ipsProject, Set<IPolicyCmptType> visited) {
        if (parentPolicyCmptType == null || !visited.add(parentPolicyCmptType)) {
            return false;
        }
        for (IPolicyCmptTypeAssociation association : parentPolicyCmptType.getPolicyCmptTypeAssociations()) {
            if (!association.isCompositionMasterToDetail() || !this.getPolicyCmptType().getQualifiedName().equals(association.getTarget())) continue;
            return true;
        }
        for (IPolicyCmptTypeAssociation association : parentPolicyCmptType.getPolicyCmptTypeAssociations()) {
            IPolicyCmptType nextParent = (IPolicyCmptType)association.findTarget(ipsProject);
            if (!this.findCorrectMatchingPolicyCmptTypeRecoursive(nextParent, ipsProject, visited)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Association");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.qualified = XmlUtil.getBooleanAttributeOrFalse(element, "qualified");
        this.inverseAssociation = XmlUtil.getAttributeOrEmptyString(element, "inverseAssociation");
        this.sharedAssociation = XmlUtil.getBooleanAttributeOrFalse(element, "sharedAssociation");
        this.matchingAssociationName = XmlUtil.getAttributeOrEmptyString(element, "matchingAssociationName");
        this.matchingAssociationSource = XmlUtil.getAttributeOrEmptyString(element, "matchingAssociationSource");
        this.configurable = element.hasAttribute("configurable") ? Boolean.parseBoolean(element.getAttribute("configurable")) : true;
    }

    @Override
    protected void propertiesToXml(Element newElement) {
        super.propertiesToXml(newElement);
        if (this.qualified) {
            newElement.setAttribute("qualified", "" + this.qualified);
        }
        if (IpsStringUtils.isNotEmpty((String)this.inverseAssociation)) {
            newElement.setAttribute("inverseAssociation", this.inverseAssociation);
        }
        if (this.sharedAssociation) {
            newElement.setAttribute("sharedAssociation", Boolean.toString(this.sharedAssociation));
        }
        if (IpsStringUtils.isNotEmpty((String)this.matchingAssociationName)) {
            newElement.setAttribute("matchingAssociationName", this.matchingAssociationName);
        }
        if (IpsStringUtils.isNotEmpty((String)this.matchingAssociationSource)) {
            newElement.setAttribute("matchingAssociationSource", this.getMatchingAssociationSource());
        }
        newElement.setAttribute("configurable", Boolean.toString(this.isConfigurable()));
    }

    @Override
    public IPersistentAssociationInfo getPersistenceAssociatonInfo() {
        return this.persistenceAssociationInfo;
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof IPersistentAssociationInfo) {
            this.persistenceAssociationInfo = (IPersistentAssociationInfo)part;
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        if (xmlTag.getTagName().equals("PersistenceAssociation")) {
            this.persistenceAssociationInfo = new PersistentAssociationInfo(this, id);
            return this.persistenceAssociationInfo;
        }
        return null;
    }

    @Override
    public IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (partType.isAssignableFrom(PersistentAssociationInfo.class)) {
            return new PersistentAssociationInfo(this, this.getNextPartId());
        }
        return null;
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        if (this.persistenceAssociationInfo != null) {
            return new IIpsElement[]{this.persistenceAssociationInfo};
        }
        return new IIpsElement[0];
    }

    @Override
    protected void reinitPartCollectionsThis() {
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        return false;
    }

    @Override
    public IAssociation findMatchingAssociation() {
        return this.findMatchingProductCmptTypeAssociation(this.getIpsProject());
    }
}

