/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.internal.pctype.persistence.PersistentAttributeInfo;
import org.faktorips.devtools.model.internal.productcmpttype.ChangingOverTimePropertyValidator;
import org.faktorips.devtools.model.internal.type.Attribute;
import org.faktorips.devtools.model.internal.util.StringUtils;
import org.faktorips.devtools.model.internal.valueset.UnrestrictedValueSet;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.AttributeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.pctype.persistence.IPersistentAttributeInfo;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeMethod;
import org.faktorips.devtools.model.type.AttributeProperty;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.util.DatatypeUtil;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.devtools.model.valueset.IEnumValueSet;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PolicyCmptTypeAttribute
extends Attribute
implements IPolicyCmptTypeAttribute {
    protected static final String TAG_NAME = "Attribute";
    private boolean valueSetConfiguredByProduct;
    private boolean relevanceConfiguredByProduct;
    private boolean genericValidationEnabled = this.getIpsProject() == null ? false : this.getIpsProject().getReadOnlyProperties().isGenericValidationDefaultEnabled();
    private AttributeType attributeType = AttributeType.CHANGEABLE;
    private IValueSet valueSet = new UnrestrictedValueSet(this, this.getNextPartId());
    private String computationMethodSignature = "";
    private IPersistentAttributeInfo persistenceAttributeInfo;

    public PolicyCmptTypeAttribute(IPolicyCmptType pcType, String id) {
        super(pcType, id);
        if (pcType.getIpsProject().isPersistenceSupportEnabled()) {
            this.persistenceAttributeInfo = this.newPart(PersistentAttributeInfo.class);
        }
    }

    @Override
    public IPolicyCmptType getPolicyCmptType() {
        return (IPolicyCmptType)this.getIpsObject();
    }

    @Override
    public void setAttributeType(AttributeType newType) {
        AttributeType oldType = this.attributeType;
        this.attributeType = newType;
        this.valueChanged((Object)oldType, (Object)newType);
    }

    @Override
    public IValidationRule findValueSetRule(IIpsProject ipsProject) {
        List<IValidationRule> rules = this.getPolicyCmptType().getValidationRules();
        for (IValidationRule rule : rules) {
            String[] attributes;
            String[] stringArray = attributes = rule.getValidatedAttributes();
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                if (attribute.equals(this.getName()) && rule.isCheckValueAgainstValueSetRule()) {
                    return rule;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public IValidationRule createValueSetRule() {
        IValidationRule rule = this.findValueSetRule(this.getIpsProject());
        if (rule != null) {
            return rule;
        }
        rule = this.getPolicyCmptType().newRule();
        rule.setName(this.getProposalValueSetRuleName());
        rule.addValidatedAttribute(this.getName());
        rule.setMessageCode(this.getProposalMsgCodeForValueSetRule());
        rule.setCheckValueAgainstValueSetRule(true);
        rule.setValidatedAttrSpecifiedInSrc(false);
        return rule;
    }

    @Override
    public void deleteValueSetRule() {
        IValidationRule rule = this.findValueSetRule(this.getIpsProject());
        if (rule != null) {
            rule.delete();
        }
    }

    @Override
    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    @Override
    public boolean isChangeable() {
        return this.getAttributeType() == AttributeType.CHANGEABLE;
    }

    @Override
    public String getPropertyDatatype() {
        return this.getDatatype();
    }

    @Override
    public boolean isDerived() {
        return this.getAttributeType().isDerived();
    }

    @Override
    public IProductCmptTypeMethod findComputationMethod(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.computationMethodSignature)) {
            return null;
        }
        IProductCmptType productCmptType = this.findProductCmptType(ipsProject);
        if (productCmptType == null) {
            return null;
        }
        return (IProductCmptTypeMethod)productCmptType.findMethod(this.computationMethodSignature, ipsProject);
    }

    @Override
    public boolean isProductRelevant() {
        return this.isValueSetConfiguredByProduct() || this.isRelevanceConfiguredByProduct();
    }

    @Override
    public boolean isValueSetConfiguredByProduct() {
        return this.valueSetConfiguredByProduct;
    }

    @Override
    public boolean isRelevanceConfiguredByProduct() {
        return this.relevanceConfiguredByProduct;
    }

    @Override
    public void setProductRelevant(boolean newValue) {
        this.setValueSetConfiguredByProduct(newValue);
    }

    private void updateProductRelevant(boolean oldProductRelevant) {
        boolean noLongerProductRelevant;
        boolean productRelevant = this.isProductRelevant();
        boolean bl = noLongerProductRelevant = oldProductRelevant != productRelevant && !productRelevant;
        if (noLongerProductRelevant) {
            this.computationMethodSignature = "";
        }
        this.valueChanged(oldProductRelevant, this.valueSetConfiguredByProduct, "productRelevant");
    }

    @Override
    public void setValueSetConfiguredByProduct(boolean valueSetConfiguredByProduct) {
        boolean oldProductRelevant = this.isProductRelevant();
        boolean oldValue = this.valueSetConfiguredByProduct;
        this.valueSetConfiguredByProduct = valueSetConfiguredByProduct;
        this.valueChanged(oldValue, valueSetConfiguredByProduct, "valueSetConfiguredByProduct");
        this.updateProductRelevant(oldProductRelevant);
    }

    @Override
    public void setRelevanceConfiguredByProduct(boolean relevanceConfiguredByProduct) {
        boolean oldProductRelevant = this.isProductRelevant();
        boolean oldValue = this.relevanceConfiguredByProduct;
        this.relevanceConfiguredByProduct = relevanceConfiguredByProduct;
        this.valueChanged(oldValue, relevanceConfiguredByProduct, "relevanceConfiguredByProduct");
        this.updateProductRelevant(oldProductRelevant);
    }

    @Override
    public IValueSet getValueSet() {
        return this.valueSet;
    }

    @Override
    public List<ValueSetType> getAllowedValueSetTypes(IIpsProject ipsProject) {
        ValueDatatype datatype = this.findDatatype(ipsProject);
        List<ValueSetType> types = ipsProject.getValueSetTypes(datatype);
        if (this.isEnumValueSetIllegal(datatype)) {
            types.remove((Object)ValueSetType.ENUM);
        }
        return types;
    }

    private boolean isEnumValueSetIllegal(ValueDatatype datatype) {
        return !this.isProductRelevant() && DatatypeUtil.isExtensibleEnumType((Datatype)datatype);
    }

    @Override
    public void setValueSetType(ValueSetType type) {
        if (this.valueSet != null && type == this.valueSet.getValueSetType()) {
            return;
        }
        this.valueSet = type.newValueSet(this, this.getNextPartId());
        this.objectHasChanged();
    }

    @Override
    public IValueSet changeValueSetType(ValueSetType newType) {
        this.setValueSetType(newType);
        return this.valueSet;
    }

    @Override
    public boolean isValueSetUpdateable() {
        return true;
    }

    @Override
    public String getComputationMethodSignature() {
        return this.computationMethodSignature;
    }

    @Override
    public void setComputationMethodSignature(String newMethodName) {
        String oldName = this.computationMethodSignature;
        this.computationMethodSignature = newMethodName;
        this.valueChanged(oldName, newMethodName);
    }

    @Override
    protected void validateThis(MessageList result, IIpsProject ipsProject) {
        super.validateThis(result, ipsProject);
        this.validateProductRelevant(result, ipsProject);
        this.validateOverwrite(result, ipsProject);
        if (this.getValueDatatype() != null) {
            this.validateValueSetType(result);
        }
        if (!this.getValueSet().isAbstract()) {
            this.validateValueSet(result);
        }
        this.validateChangingOverTimeFlag(result);
        this.validateAbstractDatatype(result);
    }

    private void validateProductRelevant(MessageList result, IIpsProject ipsProject) {
        if (this.isProductRelevant()) {
            String text;
            if (!this.getPolicyCmptType().isConfigurableByProductCmptType()) {
                text = Messages.Attribute_msgAttributeCantBeProductRelevantIfTypeIsNot;
                result.add(new Message("ATTRIBUTE-AttributeCantBeProductRelevantIfTypeIsNot", text, Message.ERROR, (Object)this, this.productRelevantProperties(new String[0])));
            }
            if (this.isDerived()) {
                if (IpsStringUtils.isEmpty((String)this.computationMethodSignature)) {
                    text = MessageFormat.format(Messages.PolicyCmptTypeAttribute_msg_ComputationMethodSignatureIsMissing, this.getName());
                    result.add(new Message("ATTRIBUTE-ComputationMethodNotSpecified", text, Message.ERROR, (Object)this, new String[]{"computationMethodSignature"}));
                } else {
                    IProductCmptTypeMethod computationMethod = this.findComputationMethod(ipsProject);
                    if (computationMethod == null) {
                        String text2 = Messages.PolicyCmptTypeAttribute_msg_ComputationMethodSignatureDoesNotExists;
                        result.add(new Message("ATTRIBUTE-ComputationMethodDoesNotExist", text2, Message.ERROR, (Object)this, new String[]{"computationMethodSignature"}));
                    } else {
                        ValueDatatype attributeDataype = this.findDatatype(ipsProject);
                        if (attributeDataype != null && !attributeDataype.equals(computationMethod.findDatatype(ipsProject))) {
                            String text3 = Messages.PolicyCmptTypeAttribute_msg_ComputationMethodSignatureHasADifferentDatatype;
                            result.add(new Message("ATTRIBUTE-CompuationMethodHasWrongDatatype", text3, Message.ERROR, (Object)this, new String[]{"datatype", "computationMethodSignature"}));
                        }
                    }
                }
            }
        }
    }

    private void validateChangingOverTimeFlag(MessageList result) {
        if (!this.isProductRelevant() || !this.isChangeable()) {
            return;
        }
        ChangingOverTimePropertyValidator propertyValidator = new ChangingOverTimePropertyValidator(this);
        propertyValidator.validateTypeDoesNotAcceptChangingOverTime(result);
    }

    private boolean isAllowedValueSet(IValueSet valueSet) {
        if (valueSet == null) {
            return false;
        }
        return this.getAllowedValueSetTypes(this.getIpsProject()).contains((Object)valueSet.getValueSetType());
    }

    private void validateOverwrite(MessageList result, IIpsProject ipsProject) {
        IPolicyCmptTypeAttribute superAttr;
        if (this.isOverwrite() && (superAttr = (IPolicyCmptTypeAttribute)this.findOverwrittenAttribute(ipsProject)) != null) {
            String text;
            if (!(this.attributeType.equals((Object)superAttr.getAttributeType()) || superAttr.getAttributeType() == AttributeType.DERIVED_ON_THE_FLY && this.attributeType == AttributeType.CHANGEABLE)) {
                text = Messages.PolicyCmptTypeAttribute_TypeOfOverwrittenAttributeCantBeChanged;
                result.add(new Message("ATTRIBUTE-OverwrittenAttributeDifferentType", text, Message.ERROR, (Object)this, new String[]{"attributeType"}));
            }
            if (superAttr.isGenericValidationEnabled() && !this.isGenericValidationEnabled()) {
                text = Messages.PolicyCmptTypeAttribute_OverwrittenAttributeDisabledGenericValidation;
                result.add(new Message("ATTRIBUTE-OverwrittenAttributeDisabledGenericValidation", text, Message.ERROR, (Object)this, new String[]{"genericValidation"}));
            }
        }
    }

    private void validateValueSetType(MessageList result) {
        if (!this.isAllowedValueSet(this.getValueSet())) {
            String messageText = MessageFormat.format(Messages.PolicyCmptTypeAttribute_msg_IllegalValueSetType, this.getValueSet() == null ? "" : StringUtils.quote(this.getValueSet().getValueSetType().getName()));
            result.add(new Message("ATTRIBUTE-IllegalValueSetType", messageText, Message.ERROR, (Object)this, new String[]{"valueSet"}));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateValueSet(MessageList result) {
        IValueSet iValueSet = this.getValueSet();
        if (iValueSet instanceof IEnumValueSet) {
            void enumValueSet;
            IEnumValueSet iEnumValueSet = (IEnumValueSet)iValueSet;
            IEnumValueSet cfr_ignored_0 = (IEnumValueSet)iValueSet;
            if (!enumValueSet.isContainsNull() && this.isProductRelevant() && enumValueSet.isEmpty()) {
                String messageText = MessageFormat.format(Messages.PolicyCmptTypeAttribute_msg_EmptyMandatoryValueSet, this);
                result.add(new Message("ATTRIBUTE-EmptyMandatoryValueSet", messageText, Message.WARNING, (Object)this, new String[]{"valueSet"}));
            }
        }
    }

    @Override
    protected void validateDefaultValue(ValueDatatype valueDatatype, MessageList result, IIpsProject ipsProject) {
        super.validateDefaultValue(valueDatatype, result, ipsProject);
        if (this.isDefaultValueForbidden(valueDatatype)) {
            this.expectNoDefaultValue(result);
        }
    }

    private boolean isDefaultValueForbidden(ValueDatatype valueDatatype) {
        return DatatypeUtil.isExtensibleEnumType((Datatype)valueDatatype) && !this.isProductRelevant();
    }

    private void expectNoDefaultValue(MessageList result) {
        if (this.getDefaultValue() != null) {
            result.newError("ATTRIBUTE-ValueNotParsableInvalidDatatype", Messages.PolicyCmptTypeAttribute_msg_defaultValueExtensibleEnumType, (Object)this, new String[]{"defaultValue"});
        }
    }

    private void validateAbstractDatatype(MessageList result) {
        ValueDatatype datatype = this.findDatatype(this.getIpsProject());
        if (datatype != null && datatype.isAbstract()) {
            if (AttributeType.CONSTANT == this.getAttributeType()) {
                result.newError("ATTRIBUTE-ConstantCantBeAbstract", Messages.PolicyCmptTypeAttribute_msg_ConstantCantBeAbstract, (Object)this, new String[]{"attributeType", "datatype"});
            }
            if (this.isProductRelevant()) {
                result.newError("ATTRIBUTE-AbstractCantBeProductRelevant", MessageFormat.format(Messages.PolicyCmptTypeAttribute_msg_AbstractCantBeProductRelevant, this.getName(), datatype.getName()), (Object)this, this.productRelevantProperties("datatype"));
            }
        }
    }

    @Override
    protected void validateAbstractDatatype(MessageList result, IIpsProject ipsProject) {
        if (this.isProductRelevant()) {
            super.validateAbstractDatatype(result, ipsProject);
        }
    }

    private String[] productRelevantProperties(String ... otherProperties) {
        ArrayList<String> properties = new ArrayList<String>();
        String[] stringArray = otherProperties;
        int n = otherProperties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            properties.add(property);
            ++n2;
        }
        properties.add("productRelevant");
        if (this.valueSetConfiguredByProduct) {
            properties.add("valueSetConfiguredByProduct");
        }
        if (this.relevanceConfiguredByProduct) {
            properties.add("relevanceConfiguredByProduct");
        }
        return properties.toArray(new String[0]);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        boolean productRelevant = ValueToXmlHelper.isAttributeTrue((Element)element, (String)"productRelevant");
        this.valueSetConfiguredByProduct = XmlUtil.getBooleanAttributeOrFalse(element, "valueSetConfiguredByProduct") || productRelevant;
        this.relevanceConfiguredByProduct = XmlUtil.getBooleanAttributeOrFalse(element, "relevanceConfiguredByProduct");
        this.attributeType = AttributeType.getAttributeType(element.getAttribute("attributeType"));
        this.computationMethodSignature = XmlUtil.getAttributeOrEmptyString(element, "computationMethodSignature");
        this.genericValidationEnabled = XmlUtil.getBooleanAttributeOrFalse(element, "genericValidation");
    }

    @Override
    protected void initPropertyDefaultChangingOverTime() {
        IProductCmptType productCmptType = this.findProductCmptType(this.getIpsProject());
        boolean changingOverTime = productCmptType == null ? true : productCmptType.isChangingOverTime();
        this.setProperty(AttributeProperty.CHANGING_OVER_TIME, changingOverTime);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (this.valueSetConfiguredByProduct) {
            element.setAttribute("valueSetConfiguredByProduct", "" + this.valueSetConfiguredByProduct);
        }
        if (this.relevanceConfiguredByProduct) {
            element.setAttribute("relevanceConfiguredByProduct", "" + this.relevanceConfiguredByProduct);
        }
        element.setAttribute("attributeType", this.attributeType.getId());
        if (IpsStringUtils.isNotEmpty((String)this.computationMethodSignature)) {
            element.setAttribute("computationMethodSignature", this.computationMethodSignature);
        }
        if (this.genericValidationEnabled) {
            element.setAttribute("genericValidation", "" + this.genericValidationEnabled);
        }
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof IValueSet) {
            this.valueSet = (IValueSet)part;
            return true;
        }
        if (part instanceof IPersistentAttributeInfo) {
            this.persistenceAttributeInfo = (IPersistentAttributeInfo)part;
            return true;
        }
        return false;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        if (xmlTag.getNodeName().equals("ValueSet")) {
            this.valueSet = ValueSetType.newValueSet(xmlTag, this, id);
            return this.valueSet;
        }
        if (xmlTag.getTagName().equals("PersistenceAttribute")) {
            return this.newPersistentAttributeInfoInternal(id);
        }
        return null;
    }

    private IIpsObjectPart newPersistentAttributeInfoInternal(String id) {
        this.persistenceAttributeInfo = new PersistentAttributeInfo(this, id);
        return this.persistenceAttributeInfo;
    }

    @Override
    public IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (partType.isAssignableFrom(PersistentAttributeInfo.class)) {
            return new PersistentAttributeInfo(this, this.getNextPartId());
        }
        return null;
    }

    @Override
    protected void reinitPartCollectionsThis() {
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part == this.valueSet) {
            this.valueSet = new UnrestrictedValueSet(this, this.getNextPartId());
            return true;
        }
        if (part == this.persistenceAttributeInfo) {
            this.persistenceAttributeInfo = this.newPart(PersistentAttributeInfo.class);
        }
        return false;
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        ArrayList<IIpsObjectPart> children = new ArrayList<IIpsObjectPart>(2);
        if (this.valueSet != null) {
            children.add(this.valueSet);
        }
        if (this.persistenceAttributeInfo != null) {
            children.add(this.persistenceAttributeInfo);
        }
        return children.toArray(new IIpsElement[children.size()]);
    }

    public ValueDatatype getValueDatatype() {
        ValueDatatype type = this.findDatatype(this.getIpsProject());
        if (type != null) {
            return type;
        }
        return null;
    }

    @Override
    public void setValueSetCopy(IValueSet source) {
        IValueSet oldset = this.valueSet;
        this.valueSet = source.copy(this, this.getNextPartId());
        this.valueChanged(oldset, this.valueSet);
    }

    @Override
    public String getProposalValueSetRuleName() {
        return PolicyCmptTypeAttribute.getProposalValueSetRuleName(this.getName());
    }

    public static String getProposalValueSetRuleName(String attributeName) {
        return MessageFormat.format(Messages.Attribute_proposalForRuleName, org.apache.commons.lang3.StringUtils.capitalize((String)attributeName));
    }

    @Override
    public String getProposalMsgCodeForValueSetRule() {
        return PolicyCmptTypeAttribute.getProposalMsgCodeForValueSetRule(this.getName());
    }

    public static String getProposalMsgCodeForValueSetRule(String attributeName) {
        return MessageFormat.format(Messages.Attribute_proposalForMsgCode, attributeName.toUpperCase());
    }

    @Override
    public String getPropertyName() {
        if (this.isProductRelevant()) {
            return this.name;
        }
        return "";
    }

    @Override
    public ProductCmptPropertyType getProductCmptPropertyType() {
        return ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE;
    }

    @Override
    public List<PropertyValueType> getPropertyValueTypes() {
        return Arrays.asList(PropertyValueType.CONFIGURED_VALUESET, PropertyValueType.CONFIGURED_DEFAULT);
    }

    @Override
    public IPersistentAttributeInfo getPersistenceAttributeInfo() {
        return this.persistenceAttributeInfo;
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return this.getPolicyCmptType().findProductCmptType(ipsProject);
    }

    @Override
    public boolean isPolicyCmptTypeProperty() {
        return true;
    }

    @Override
    public boolean isPropertyFor(IPropertyValue propertyValue) {
        return this.getProductCmptPropertyType().isMatchingPropertyValue(this.getPropertyName(), propertyValue);
    }

    @Override
    public boolean isChangingOverTimeValidationNecessary() {
        return this.isProductRelevant() && this.getAttributeType().equals((Object)AttributeType.CHANGEABLE);
    }

    @Override
    public boolean isGenericValidationEnabled() {
        return this.genericValidationEnabled;
    }

    @Override
    public void setGenericValidationEnabled(boolean genericValidationEnabled) {
        boolean oldGenericValidationEnabled = this.isGenericValidationEnabled();
        this.genericValidationEnabled = genericValidationEnabled;
        this.valueChanged(oldGenericValidationEnabled, genericValidationEnabled);
    }
}

