/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.internal.InternationalStringXmlHelper;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.internal.pctype.PolicyCmptType;
import org.faktorips.devtools.model.internal.pctype.ValidationRuleMessageText;
import org.faktorips.devtools.model.internal.productcmpttype.ChangingOverTimePropertyValidator;
import org.faktorips.devtools.model.internal.type.TypePart;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.AttributeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.pctype.IValidationRuleMessageText;
import org.faktorips.devtools.model.pctype.MessageSeverity;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IOverridableElement;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.util.MarkerEnumUtil;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.values.LocalizedString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValidationRule
extends TypePart
implements IValidationRule {
    private static final String XML_TAG_VALIDATED_ATTRIBUTE = "ValidatedAttribute";
    private static final String XML_TAG_MARKERS = "Markers";
    private static final String XML_TAG_MARKER = "Marker";
    private final ValidationRuleMessageText msgText;
    private String msgCode = "";
    private List<String> validatedAttributes = new ArrayList<String>();
    private MessageSeverity msgSeverity = MessageSeverity.ERROR;
    private boolean validatedAttrSpecifiedInSrc = false;
    private boolean configurableByProductComponent = false;
    private boolean activatedByDefault = true;
    private boolean changingOverTime = true;
    private List<String> markers = new ArrayList<String>();
    private boolean checkValueAgainstValueSetRule = false;
    private boolean overrides;

    public ValidationRule(IPolicyCmptType pcType, String id) {
        super(pcType, id);
        this.msgText = new ValidationRuleMessageText($ -> this.objectHasChanged());
        this.initDefaultChangingOverTime();
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.valueChanged(oldName, newName);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        ValidationUtils.checkStringPropertyNotEmpty(this.name, "name", this, "name", "", list);
        if (IpsStringUtils.isEmpty((String)this.msgCode)) {
            String text = Messages.ValidationRule_msgCodeShouldBeProvided;
            Message msg = new Message("VALIDATIONRULE-MsgCodeShouldntBeEmpty", text, Message.ERROR, (Object)this, new String[]{"messageCode"});
            list.add(msg);
        }
        this.validateValidatedAttribute(list, ipsProject);
        this.validateCheckValueAgainstValueSet(list);
        this.validateNoLineSeperators(list);
        this.validateReplacementParameters(ipsProject, list);
        this.validateMarker(list, ipsProject);
        this.validateChangingOverTimeFlag(list);
        this.validateOverridingValidationRule(list, ipsProject);
    }

    private void validateOverridingValidationRule(MessageList result, IIpsProject ipsProject) {
        if (this.overrides) {
            IValidationRule superRule = this.findOverwrittenValidationRule(ipsProject);
            if (superRule == null) {
                String text = MessageFormat.format(Messages.ValidationRule_msgNothingToOverwrite, this.getName());
                result.add(new Message("VALIDATIONRULE-NothingToOverwrite", text, Message.ERROR, (Object)this, new String[]{"overriding", "name"}));
            } else {
                this.validateAgainstOverwrittenValidationRule(result, superRule);
            }
        }
    }

    private void validateAgainstOverwrittenValidationRule(MessageList result, IValidationRule superRule) {
        if (this.isChangingOverTime() != superRule.isChangingOverTime()) {
            result.add(new Message("VALIDATIONRULE-OverwrittenRuleDifferentChangeOverTime", Messages.ValidationRule_msgOverwritten_ChangingOverTimeAttribute_different, Message.ERROR, (Object)this, new String[]{"changingOverTime"}));
        }
    }

    private void validateChangingOverTimeFlag(MessageList result) {
        if (!this.isConfigurableByProductComponent()) {
            return;
        }
        ChangingOverTimePropertyValidator propertyValidator = new ChangingOverTimePropertyValidator(this);
        propertyValidator.validateTypeDoesNotAcceptChangingOverTime(result);
    }

    private void validateMarker(MessageList list, IIpsProject ipsProject) {
        MarkerEnumUtil markerEnumUtil = new MarkerEnumUtil(ipsProject);
        Set<String> definedMarkerIds = markerEnumUtil.getDefinedMarkerIds();
        Set<String> usedMarkerIds = this.getUsedMarkerIds();
        usedMarkerIds.removeAll(definedMarkerIds);
        if (!usedMarkerIds.isEmpty()) {
            String text = MessageFormat.format(Messages.ValidationRule_msg_InvalidMarkerId, usedMarkerIds, markerEnumUtil.getMarkerEnumTypeName());
            Message msg = new Message("VALIDATIONRULE-MsgInvalidMarkerID", text, Message.ERROR, (Object)this, new String[]{"messageCode"});
            list.add(msg);
        }
    }

    private Set<String> getUsedMarkerIds() {
        LinkedHashSet<String> usedMarkerIds = new LinkedHashSet<String>();
        for (String usedMarker : this.markers) {
            usedMarkerIds.add(usedMarker);
        }
        return usedMarkerIds;
    }

    private void validateCheckValueAgainstValueSet(MessageList msgList) {
        if (this.isCheckValueAgainstValueSetRule()) {
            String attributeName = this.getValidatedAttributeAt(0);
            IPolicyCmptTypeAttribute attribute = this.getPolicyCmptType().getPolicyCmptTypeAttribute(attributeName);
            if (attribute == null) {
                String text = MessageFormat.format(Messages.ValidationRule_msgMissingAttribute, attributeName);
                msgList.add(new Message("", text, Message.ERROR, (Object)this, new String[]{"checkValueAgainstValueSetRule"}));
            } else if (ValueSetType.UNRESTRICTED.equals((Object)attribute.getValueSet().getValueSetType()) && attribute.getValueSet().isContainsNull() && !attribute.isProductRelevant()) {
                String text = Messages.ValidationRule_msgValueSetRule;
                msgList.add(new Message("", text, Message.ERROR, (Object)this, new String[]{"checkValueAgainstValueSetRule"}));
            }
        }
    }

    private PolicyCmptType getPolicyCmptType() {
        return (PolicyCmptType)this.getIpsObject();
    }

    private void validateValidatedAttribute(MessageList list, IIpsProject ipsProject) {
        String text;
        List<IAttribute> attributes = this.getPolicyCmptType().getSupertypeHierarchy().getAllAttributes(this.getPolicyCmptType());
        HashSet<String> attributeNames = new HashSet<String>(attributes.size());
        for (IAttribute attribute : attributes) {
            attributeNames.add(attribute.getName());
        }
        int i = 0;
        while (i < this.validatedAttributes.size()) {
            String validatedAttribute = this.validatedAttributes.get(i);
            if (!attributeNames.contains(validatedAttribute)) {
                text = Messages.ValidationRule_msgUndefinedAttribute;
                list.add(new Message("VALIDATIONRULE-UndefinedAttribute", text, Message.ERROR, new ObjectProperty((Object)this, "validatedAttributes", i)));
            } else {
                IPolicyCmptTypeAttribute attribute = this.getPolicyCmptType().findPolicyCmptTypeAttribute(validatedAttribute, ipsProject);
                if (attribute.getAttributeType() == AttributeType.CONSTANT) {
                    list.add(new Message("VALIDATIONRULE-ConstantAttributesCantBeValidated", Messages.ValidationRule_ConstantAttributesCantBeValidated, Message.ERROR, new ObjectProperty((Object)this, "validatedAttributes", i)));
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.validatedAttributes.size() - 1) {
            int r = i + 1;
            while (r < this.validatedAttributes.size()) {
                if (this.validatedAttributes.get(i).equals(this.validatedAttributes.get(r))) {
                    text = Messages.ValidationRule_msgDuplicateEntries;
                    list.add(new Message("", text, Message.WARNING, new ObjectProperty[]{new ObjectProperty((Object)this, "validatedAttributes", i), new ObjectProperty((Object)this, "validatedAttributes", r)}));
                }
                ++r;
            }
            ++i;
        }
    }

    private void validateNoLineSeperators(MessageList list) {
        for (LocalizedString localizedString : this.msgText.values()) {
            String message = localizedString.getValue();
            if (!IpsStringUtils.isNotEmpty((String)System.lineSeparator()) || message.indexOf(System.lineSeparator()) == -1) continue;
            String text = MessageFormat.format(Messages.ValidationRule_msgNoNewlineAllowed, localizedString.getLocale().getDisplayLanguage());
            list.add(new Message("VALIDATIONRULE-NoNewlineAllowed", text, Message.ERROR, (Object)this, new String[]{"messageText"}));
        }
    }

    private void validateReplacementParameters(IIpsProject ipsProject, MessageList list) {
        this.msgText.validateReplacementParameters(ipsProject, list);
    }

    @Override
    public IValidationRuleMessageText getMessageText() {
        return this.msgText;
    }

    @Override
    public String getMessageCode() {
        return this.msgCode;
    }

    @Override
    public void setMessageCode(String newCode) {
        String oldCode = this.msgCode;
        this.msgCode = newCode;
        this.valueChanged(oldCode, this.msgCode);
    }

    @Override
    public MessageSeverity getMessageSeverity() {
        return this.msgSeverity;
    }

    @Override
    public void setMessageSeverity(MessageSeverity newSeverity) {
        MessageSeverity oldSeverity = this.msgSeverity;
        this.msgSeverity = newSeverity;
        this.valueChanged((Object)oldSeverity, (Object)this.msgSeverity);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("ValidationRuleDef");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.initDefaultChangingOverTime();
        this.name = element.getAttribute("name");
        this.msgCode = element.getAttribute("messageCode");
        this.msgSeverity = MessageSeverity.getMessageSeverity(element.getAttribute("messageSeverity"));
        this.checkValueAgainstValueSetRule = XmlUtil.getBooleanAttributeOrFalse(element, "checkValueAgainstValueSetRule");
        this.validatedAttrSpecifiedInSrc = XmlUtil.getBooleanAttributeOrFalse(element, "validatedAttrSpecifiedInSrc");
        this.configurableByProductComponent = XmlUtil.getBooleanAttributeOrFalse(element, "configurableByProductComponent");
        this.overrides = XmlUtil.getBooleanAttributeOrFalse(element, "overriding");
        if (element.hasAttribute("changingOverTime")) {
            this.changingOverTime = Boolean.parseBoolean(element.getAttribute("changingOverTime"));
        }
        this.activatedByDefault = element.hasAttribute("activatedByDefault") ? Boolean.parseBoolean(element.getAttribute("activatedByDefault")) : true;
        NodeList nl = element.getChildNodes();
        this.validatedAttributes.clear();
        this.markers.clear();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                Element subElement = (Element)nl.item(i);
                this.initChildrenFor(XML_TAG_VALIDATED_ATTRIBUTE, this.validatedAttributes, subElement);
                this.initChildrenForMarkers(subElement);
                if (subElement.getNodeName().equals("MessageText")) {
                    InternationalStringXmlHelper.initFromXml(this.msgText, subElement);
                }
            }
            ++i;
        }
    }

    private void initChildrenFor(String elementType, List<String> childElements, Element subElement) {
        if (subElement.getNodeName().equals(elementType)) {
            childElements.add(subElement.getAttribute("name"));
        }
    }

    private void initChildrenForMarkers(Element subElement) {
        if (subElement.getNodeName().equals(XML_TAG_MARKERS)) {
            NodeList childNodes = subElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                if (childNodes.item(i) instanceof Element) {
                    this.initChildrenFor(XML_TAG_MARKER, this.markers, (Element)childNodes.item(i));
                }
                ++i;
            }
        }
    }

    private void initDefaultChangingOverTime() {
        IProductCmptType productCmptType = this.findProductCmptType(this.getIpsProject());
        this.changingOverTime = productCmptType != null && productCmptType.isChangingOverTime();
    }

    @Override
    protected void propertiesToXml(Element newElement) {
        super.propertiesToXml(newElement);
        newElement.setAttribute("name", this.name);
        newElement.setAttribute("messageCode", this.msgCode);
        newElement.setAttribute("messageSeverity", this.msgSeverity.getId());
        if (this.overrides) {
            newElement.setAttribute("overriding", "" + this.overrides);
        }
        if (this.checkValueAgainstValueSetRule) {
            newElement.setAttribute("checkValueAgainstValueSetRule", String.valueOf(this.checkValueAgainstValueSetRule));
        }
        if (this.validatedAttrSpecifiedInSrc) {
            newElement.setAttribute("validatedAttrSpecifiedInSrc", String.valueOf(this.validatedAttrSpecifiedInSrc));
        }
        if (this.configurableByProductComponent) {
            newElement.setAttribute("configurableByProductComponent", String.valueOf(this.configurableByProductComponent));
        }
        newElement.setAttribute("activatedByDefault", String.valueOf(this.activatedByDefault));
        newElement.setAttribute("changingOverTime", String.valueOf(this.changingOverTime));
        this.appendChildrenFor(XML_TAG_VALIDATED_ATTRIBUTE, this.validatedAttributes, newElement);
        this.appendChildrenForMarkers(newElement);
        InternationalStringXmlHelper.toXml(this.msgText, newElement, "MessageText");
    }

    private void appendChildrenFor(String elementType, List<String> childElements, Element newElement) {
        Document doc = newElement.getOwnerDocument();
        for (String childElement : childElements) {
            Element element = doc.createElement(elementType);
            element.setAttribute("name", childElement);
            newElement.appendChild(element);
        }
    }

    private void appendChildrenForMarkers(Element newElement) {
        if (!this.markers.isEmpty()) {
            Document doc = newElement.getOwnerDocument();
            Element markersRootElement = doc.createElement(XML_TAG_MARKERS);
            newElement.appendChild(markersRootElement);
            this.appendChildrenFor(XML_TAG_MARKER, this.markers, markersRootElement);
        }
    }

    @Override
    public String addValidatedAttribute(String attributeName) {
        ArgumentCheck.notNull((Object)this, (Object)attributeName);
        this.validatedAttributes.add(attributeName);
        this.objectHasChanged();
        return attributeName;
    }

    @Override
    public String[] getValidatedAttributes() {
        return this.validatedAttributes.toArray(new String[this.validatedAttributes.size()]);
    }

    @Override
    public void removeValidatedAttribute(int index) {
        this.validatedAttributes.remove(index);
        this.objectHasChanged();
    }

    @Override
    public String getValidatedAttributeAt(int index) {
        return this.validatedAttributes.get(index);
    }

    @Override
    public void setValidatedAttributeAt(int index, String attributeName) {
        String oldValue = this.getValidatedAttributeAt(index);
        this.validatedAttributes.set(index, attributeName);
        this.valueChanged(oldValue, attributeName);
    }

    @Override
    public boolean isValidatedAttrSpecifiedInSrc() {
        return this.validatedAttrSpecifiedInSrc;
    }

    @Override
    public void setValidatedAttrSpecifiedInSrc(boolean validatedAttrSpecifiedInSrc) {
        boolean oldValue = this.validatedAttrSpecifiedInSrc;
        this.validatedAttrSpecifiedInSrc = validatedAttrSpecifiedInSrc;
        this.valueChanged(oldValue, validatedAttrSpecifiedInSrc);
    }

    @Override
    public boolean isCheckValueAgainstValueSetRule() {
        return this.checkValueAgainstValueSetRule;
    }

    @Override
    public void setCheckValueAgainstValueSetRule(boolean isAttributeValueValidationRule) {
        boolean oldValue = this.isCheckValueAgainstValueSetRule();
        this.checkValueAgainstValueSetRule = isAttributeValueValidationRule;
        this.valueChanged(oldValue, isAttributeValueValidationRule);
    }

    @Override
    public boolean isConfigurableByProductComponent() {
        IPolicyCmptType type = (IPolicyCmptType)this.getIpsObject();
        if (type == null || !type.isConfigurableByProductCmptType()) {
            return false;
        }
        return this.configurableByProductComponent;
    }

    @Override
    public void setConfigurableByProductComponent(boolean configurable) {
        boolean oldValue = this.isConfigurableByProductComponent();
        this.configurableByProductComponent = configurable;
        this.valueChanged(oldValue, configurable);
    }

    @Override
    public boolean isActivatedByDefault() {
        return this.activatedByDefault;
    }

    @Override
    public void setActivatedByDefault(boolean activated) {
        boolean oldValue = this.isActivatedByDefault();
        this.activatedByDefault = activated;
        this.valueChanged(oldValue, activated);
    }

    @Override
    public ProductCmptPropertyType getProductCmptPropertyType() {
        return ProductCmptPropertyType.VALIDATION_RULE;
    }

    @Override
    public List<PropertyValueType> getPropertyValueTypes() {
        return Arrays.asList(PropertyValueType.VALIDATION_RULE_CONFIG);
    }

    @Override
    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public String getQualifiedRuleName() {
        IIpsObject ipsObject = this.getIpsObject();
        String qualifiedName = ipsObject.getQualifiedName();
        String ruleName = this.getName();
        return String.valueOf(qualifiedName) + "-" + ruleName;
    }

    @Override
    public boolean isChangingOverTime() {
        return this.changingOverTime;
    }

    @Override
    public void setChangingOverTime(boolean changingOverTime) {
        boolean oldVal = this.changingOverTime;
        this.changingOverTime = changingOverTime;
        this.valueChanged(oldVal, changingOverTime, "changingOverTime");
    }

    @Override
    public String getPropertyDatatype() {
        return ValueDatatype.BOOLEAN.getName();
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return this.getPolicyCmptType().findProductCmptType(ipsProject);
    }

    @Override
    public boolean isPolicyCmptTypeProperty() {
        return true;
    }

    @Override
    public boolean isPropertyFor(IPropertyValue propertyValue) {
        return this.getProductCmptPropertyType().isMatchingPropertyValue(this.getPropertyName(), propertyValue);
    }

    @Override
    public List<String> getMarkers() {
        return this.markers;
    }

    @Override
    public void setMarkers(List<String> newMarkers) {
        List<String> oldMarkers = this.markers;
        this.markers = newMarkers;
        this.valueChanged(oldMarkers, newMarkers, "markers");
    }

    @Override
    public boolean overrides(IValidationRule other) {
        return !this.equals(other) && this.getType().isSubtypeOf(other.getType(), other.getIpsProject());
    }

    @Override
    public boolean isOverriding() {
        return this.overrides;
    }

    @Override
    public void setOverriding(boolean overwrites) {
        boolean old = this.overrides;
        this.overrides = overwrites;
        this.valueChanged(old, overwrites, "overriding");
    }

    @Override
    public IValidationRule findOverwrittenValidationRule(IIpsProject ipsProject) throws IpsException {
        IPolicyCmptType supertype = (IPolicyCmptType)((IType)this.getIpsObject()).findSupertype(ipsProject);
        if (supertype == null) {
            return null;
        }
        IValidationRule candidate = supertype.findValidationRule(this.name, ipsProject);
        if (candidate == this) {
            return null;
        }
        return candidate;
    }

    @Override
    public IOverridableElement findOverriddenElement(IIpsProject ipsProject) {
        return this.findOverwrittenValidationRule(ipsProject);
    }
}

