/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype;

import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import org.faktorips.devtools.model.internal.InternationalString;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IValidationRuleMessageText;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.values.LocalizedString;

public class ValidationRuleMessageText
extends InternationalString
implements IValidationRuleMessageText {
    public ValidationRuleMessageText() {
    }

    public ValidationRuleMessageText(PropertyChangeListener listener) {
        super(listener);
    }

    @Override
    public LinkedHashSet<String> getReplacementParameters() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (LocalizedString localizedString : this.values()) {
            String text = localizedString.getValue();
            result.addAll(this.extractParameters(text));
        }
        return result;
    }

    public void validateReplacementParameters(IIpsProject ipsProject, MessageList list) {
        LocalizedString defaultLocaleString = this.get(ipsProject.getReadOnlyProperties().getDefaultLanguage().getLocale());
        LinkedHashSet<String> defaultLocalParameters = this.extractParameters(defaultLocaleString.getValue());
        for (LocalizedString localizedString : this.values()) {
            if (localizedString.equals((Object)defaultLocaleString)) continue;
            LinkedHashSet<String> thisLocaleParameters = this.extractParameters(localizedString.getValue());
            for (String param : thisLocaleParameters) {
                if (!defaultLocalParameters.add(param)) continue;
                list.add(new Message("VALIDATIONRULE-InvalidTextParameter", MessageFormat.format(Messages.ValidationRuleMessageText_warning_invalidParameter, param, localizedString.getLocale().getDisplayLanguage()), Message.WARNING));
            }
        }
    }

    private LinkedHashSet<String> extractParameters(String text) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Matcher matcher = REPLACEMENT_PARAMETER_REGEXT.matcher(text);
        while (matcher.find()) {
            String parameterName = matcher.group();
            result.add(parameterName);
        }
        return result;
    }
}

