/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype.persistence;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.internal.pctype.persistence.PersistentTypePartInfo;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.ITableColumnNamingStrategy;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.pctype.persistence.IPersistentAssociationInfo;
import org.faktorips.devtools.model.pctype.persistence.IPersistentTypeInfo;
import org.faktorips.devtools.model.util.PersistenceUtil;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Element;

public class PersistentAssociationInfo
extends PersistentTypePartInfo
implements IPersistentAssociationInfo {
    private boolean ownerOfManyToManyAssociation = false;
    private boolean orphanRemoval;
    private boolean cascadeTypeOverwriteDefault;
    private boolean cascadeTypePersist;
    private boolean cascadeTypeMerge;
    private boolean cascadeTypeRemove;
    private boolean cascadeTypeRefresh;
    private String joinTableName = "";
    private String targetColumnName = "";
    private String sourceColumnName = "";
    private String joinColumnName = "";
    private boolean joinColumnNullable = true;
    private IPersistentAssociationInfo.FetchType fetchType = IPersistentAssociationInfo.FetchType.LAZY;
    private IPolicyCmptTypeAssociation policyComponentTypeAssociation;

    public PersistentAssociationInfo(IPolicyCmptTypeAssociation policyComponentTypeAssociation, String id) {
        super(policyComponentTypeAssociation, id);
        this.policyComponentTypeAssociation = policyComponentTypeAssociation;
        ITableColumnNamingStrategy tableColumnNamingStrategy = this.getIpsProject().getTableColumnNamingStrategy();
        this.sourceColumnName = tableColumnNamingStrategy.getTableColumnName(this.getPolicyComponentTypeAssociation().getName());
        this.targetColumnName = tableColumnNamingStrategy.getTableColumnName(this.getPolicyComponentTypeAssociation().getName());
    }

    @Override
    public IPersistentAssociationInfo.FetchType getFetchType() {
        return this.fetchType;
    }

    @Override
    public String getJoinTableName() {
        return this.joinTableName;
    }

    @Override
    public String getSourceColumnName() {
        return this.sourceColumnName;
    }

    @Override
    public String getTargetColumnName() {
        return this.targetColumnName;
    }

    @Override
    public String getJoinColumnName() {
        return this.joinColumnName;
    }

    @Override
    public boolean isJoinColumnNullable() {
        return this.joinColumnNullable;
    }

    @Override
    public boolean isOwnerOfManyToManyAssociation() {
        return this.ownerOfManyToManyAssociation;
    }

    @Override
    public boolean isOrphanRemoval() {
        return this.orphanRemoval;
    }

    @Override
    public boolean isCascadeTypeOverwriteDefault() {
        return this.cascadeTypeOverwriteDefault;
    }

    @Override
    public void setCascadeTypeOverwriteDefault(boolean cascadeTypeOverwriteDefault) {
        if (!cascadeTypeOverwriteDefault) {
            this.initDefaultsCascadeTypes();
        }
        boolean oldValue = this.cascadeTypeOverwriteDefault;
        this.cascadeTypeOverwriteDefault = cascadeTypeOverwriteDefault;
        this.valueChanged(oldValue, cascadeTypeOverwriteDefault);
    }

    @Override
    public void initDefaultsCascadeTypes() {
        boolean isManyToOne;
        IPolicyCmptTypeAssociation invAssociation = this.getPolicyComponentTypeAssociation().findInverseAssociation(this.getPolicyComponentTypeAssociation().getIpsProject());
        IPersistentAssociationInfo.RelationshipType relationship = null;
        relationship = invAssociation == null ? this.evalUnidirectionalRelationShipType() : this.evalBidirectionalRelationShipType(invAssociation);
        boolean isAssociation = this.getPolicyComponentTypeAssociation().isAssoziation();
        boolean isChildToParentComposition = this.getPolicyComponentTypeAssociation().isCompositionDetailToMaster();
        boolean bl = isManyToOne = relationship == IPersistentAssociationInfo.RelationshipType.MANY_TO_ONE;
        if (isAssociation || isChildToParentComposition || isManyToOne) {
            this.setAllCascadeTypes(false);
        } else {
            this.setAllCascadeTypes(true);
        }
    }

    private void setAllCascadeTypes(boolean enabled) {
        this.cascadeTypeMerge = enabled;
        this.cascadeTypeRefresh = enabled;
        this.cascadeTypeRemove = enabled;
        this.cascadeTypePersist = enabled;
    }

    @Override
    public boolean isCascadeTypePersist() {
        return this.cascadeTypePersist;
    }

    @Override
    public void setCascadeTypePersist(boolean cascadeTypePersist) {
        boolean oldValue = this.cascadeTypePersist;
        this.cascadeTypePersist = cascadeTypePersist;
        this.valueChanged(oldValue, cascadeTypePersist);
    }

    @Override
    public boolean isCascadeTypeMerge() {
        return this.cascadeTypeMerge;
    }

    @Override
    public void setCascadeTypeMerge(boolean cascadeTypeMerge) {
        boolean oldValue = this.cascadeTypeMerge;
        this.cascadeTypeMerge = cascadeTypeMerge;
        this.valueChanged(oldValue, cascadeTypeMerge);
    }

    @Override
    public boolean isCascadeTypeRemove() {
        return this.cascadeTypeRemove;
    }

    @Override
    public void setCascadeTypeRemove(boolean cascadeTypeRemove) {
        boolean oldValue = this.cascadeTypeRemove;
        this.cascadeTypeRemove = cascadeTypeRemove;
        this.valueChanged(oldValue, cascadeTypeRemove);
    }

    @Override
    public boolean isCascadeTypeRefresh() {
        return this.cascadeTypeRefresh;
    }

    @Override
    public void setCascadeTypeRefresh(boolean cascadeTypeRefresh) {
        boolean oldValue = this.cascadeTypeRefresh;
        this.cascadeTypeRefresh = cascadeTypeRefresh;
        this.valueChanged(oldValue, cascadeTypeRefresh);
    }

    @Override
    public boolean isBidirectional() {
        return this.getPolicyComponentTypeAssociation().hasInverseAssociation();
    }

    @Override
    public boolean isCascading() {
        return this.getPolicyComponentTypeAssociation().isAssoziation() || this.getPolicyComponentTypeAssociation().isComposition();
    }

    @Override
    public boolean isJoinTableRequired() {
        return this.isJoinTableRequired(this.getPolicyComponentTypeAssociation().findInverseAssociation(this.getPolicyComponentTypeAssociation().getIpsProject()));
    }

    public boolean isJoinTableRequired(IPolicyCmptTypeAssociation inverseAssociation) {
        boolean isInverseAssociationOneToMany;
        boolean isOneToManyAssociation = this.getPolicyComponentTypeAssociation().is1ToMany();
        if (this.isUnidirectional()) {
            return false;
        }
        boolean bl = isInverseAssociationOneToMany = inverseAssociation != null && inverseAssociation.is1ToMany();
        return isOneToManyAssociation && isInverseAssociationOneToMany;
    }

    @Override
    public boolean isOrphanRemovalRequired() {
        return this.getPolicyComponentTypeAssociation().isCompositionMasterToDetail();
    }

    @Override
    public boolean isUnidirectional() {
        return !this.getPolicyComponentTypeAssociation().hasInverseAssociation();
    }

    @Override
    public void setFetchType(IPersistentAssociationInfo.FetchType fetchType) {
        ArgumentCheck.notNull((Object)((Object)fetchType));
        IPersistentAssociationInfo.FetchType oldValue = this.fetchType;
        this.fetchType = fetchType;
        this.valueChanged((Object)oldValue, (Object)fetchType);
    }

    @Override
    public void setJoinTableName(String newJoinTableName) {
        ArgumentCheck.notNull((Object)newJoinTableName);
        String oldValue = this.joinTableName;
        this.joinTableName = newJoinTableName;
        this.valueChanged(oldValue, this.joinTableName);
    }

    @Override
    public void setSourceColumnName(String newSourceColumnName) {
        ArgumentCheck.notNull((Object)newSourceColumnName);
        String oldValue = this.sourceColumnName;
        this.sourceColumnName = newSourceColumnName;
        this.valueChanged(oldValue, this.sourceColumnName);
    }

    @Override
    public void setTargetColumnName(String newTargetColumnName) {
        ArgumentCheck.notNull((Object)newTargetColumnName);
        String oldValue = this.targetColumnName;
        this.targetColumnName = newTargetColumnName;
        this.valueChanged(oldValue, this.targetColumnName);
    }

    @Override
    public void setJoinColumnName(String newJoinColumnName) {
        ArgumentCheck.notNull((Object)newJoinColumnName);
        String oldValue = this.joinColumnName;
        this.joinColumnName = newJoinColumnName;
        this.valueChanged(oldValue, this.joinColumnName);
    }

    @Override
    public void setJoinColumnNullable(boolean nullable) {
        boolean oldValue = this.joinColumnNullable;
        this.joinColumnNullable = nullable;
        this.valueChanged(oldValue, this.joinColumnNullable);
    }

    @Override
    public void setOwnerOfManyToManyAssociation(boolean ownerOfManyToManyAssociation) {
        if (!ownerOfManyToManyAssociation) {
            this.setJoinTableName("");
            this.setTargetColumnName("");
            this.setSourceColumnName("");
        } else {
            this.setJoinColumnName("");
        }
        boolean oldValue = this.ownerOfManyToManyAssociation;
        this.ownerOfManyToManyAssociation = ownerOfManyToManyAssociation;
        this.valueChanged(oldValue, ownerOfManyToManyAssociation);
    }

    @Override
    public void setOrphanRemoval(boolean orphanRemoval) {
        boolean oldValue = this.orphanRemoval;
        this.orphanRemoval = orphanRemoval;
        this.valueChanged(oldValue, orphanRemoval);
    }

    public boolean isForeignKeyColumnCreatedOnTargetSide(IPolicyCmptTypeAssociation inverseAssociation) {
        return inverseAssociation == null && this.getPolicyComponentTypeAssociation().is1ToManyIgnoringQualifier();
    }

    @Override
    public boolean isForeignKeyColumnDefinedOnTargetSide() {
        return this.isForeignKeyColumnDefinedOnTargetSide(this.getPolicyComponentTypeAssociation().findInverseAssociation(this.getPolicyComponentTypeAssociation().getIpsProject()));
    }

    public boolean isForeignKeyColumnDefinedOnTargetSide(IPolicyCmptTypeAssociation inverseAssociation) {
        if (inverseAssociation == null) {
            return false;
        }
        if (this.getPolicyComponentTypeAssociation().isAssoziation() && inverseAssociation.is1To1() && IpsStringUtils.isNotEmpty((String)inverseAssociation.getPersistenceAssociatonInfo().getJoinColumnName())) {
            return true;
        }
        return !this.isJoinColumnRequired(inverseAssociation);
    }

    public boolean isJoinColumnRequired(IPolicyCmptTypeAssociation inverseAssociation) {
        if (this.isJoinColumnImpossible(inverseAssociation)) {
            return false;
        }
        if (this.isUnidirectional() || this.isBidirectional() && inverseAssociation == null) {
            return true;
        }
        IPersistentAssociationInfo.RelationshipType relType = this.evalBidirectionalRelationShipType(inverseAssociation);
        if (relType == IPersistentAssociationInfo.RelationshipType.ONE_TO_ONE) {
            return this.isJoinColumnRequiredForOneToOne(inverseAssociation);
        }
        if (relType == IPersistentAssociationInfo.RelationshipType.MANY_TO_MANY || relType == IPersistentAssociationInfo.RelationshipType.ONE_TO_MANY) {
            return false;
        }
        if (relType == IPersistentAssociationInfo.RelationshipType.MANY_TO_ONE) {
            return true;
        }
        throw new RuntimeException("'Unsupported relationship type: " + relType.toString());
    }

    private boolean isJoinColumnImpossible(IPolicyCmptTypeAssociation inverseAssociation) {
        if (this.getPolicyComponentTypeAssociation().isDerivedUnion() || inverseAssociation != null && inverseAssociation.isDerivedUnion()) {
            return true;
        }
        return this.isOwnerOfManyToManyAssociation();
    }

    private boolean isJoinColumnRequiredForOneToOne(IPolicyCmptTypeAssociation inverseAssociation) {
        return !this.getPolicyComponentTypeAssociation().isCompositionMasterToDetail() && (inverseAssociation == null || !this.getPolicyComponentTypeAssociation().isAssoziation() || !IpsStringUtils.isNotEmpty((String)inverseAssociation.getPersistenceAssociatonInfo().getJoinColumnName()));
    }

    @Override
    public IPersistentAssociationInfo.RelationshipType evalUnidirectionalRelationShipType() {
        if (this.getPolicyComponentTypeAssociation().is1ToMany()) {
            return IPersistentAssociationInfo.RelationshipType.ONE_TO_MANY;
        }
        if (this.getPolicyComponentTypeAssociation().is1To1()) {
            return IPersistentAssociationInfo.RelationshipType.ONE_TO_ONE;
        }
        return IPersistentAssociationInfo.RelationshipType.UNKNOWN;
    }

    @Override
    public IPersistentAssociationInfo.RelationshipType evalBidirectionalRelationShipType(IPolicyCmptTypeAssociation inverseAssociation) {
        if (inverseAssociation == null) {
            return IPersistentAssociationInfo.RelationshipType.UNKNOWN;
        }
        if (this.getPolicyComponentTypeAssociation().is1ToMany() && inverseAssociation.is1ToMany()) {
            return IPersistentAssociationInfo.RelationshipType.MANY_TO_MANY;
        }
        if (this.getPolicyComponentTypeAssociation().is1ToMany() && inverseAssociation.is1To1()) {
            return IPersistentAssociationInfo.RelationshipType.ONE_TO_MANY;
        }
        if (this.getPolicyComponentTypeAssociation().is1To1() && inverseAssociation.is1ToMany()) {
            return IPersistentAssociationInfo.RelationshipType.MANY_TO_ONE;
        }
        if (this.getPolicyComponentTypeAssociation().is1To1() && inverseAssociation.is1To1()) {
            return IPersistentAssociationInfo.RelationshipType.ONE_TO_ONE;
        }
        return IPersistentAssociationInfo.RelationshipType.UNKNOWN;
    }

    @Override
    public IPolicyCmptTypeAssociation getPolicyComponentTypeAssociation() {
        return this.policyComponentTypeAssociation;
    }

    @Override
    public void initDefaults() {
        this.fetchType = this.getPolicyComponentTypeAssociation().is1ToManyIgnoringQualifier() ? IPersistentAssociationInfo.FetchType.LAZY : IPersistentAssociationInfo.FetchType.EAGER;
        this.setOrphanRemoval(this.isOrphanRemovalRequired());
        this.initDefaultsCascadeTypes();
    }

    @Override
    protected String getXmlTag() {
        return "PersistenceAssociation";
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.ownerOfManyToManyAssociation = XmlUtil.getBooleanAttributeOrFalse(element, "ownerOfManyToManyAssociation");
        this.sourceColumnName = element.getAttribute("sourceColumnName");
        this.targetColumnName = element.getAttribute("targetColumnName");
        this.joinTableName = element.getAttribute("joinTableName");
        this.fetchType = IPersistentAssociationInfo.FetchType.valueOf(element.getAttribute("fetchType"));
        this.joinColumnName = element.getAttribute("joinColumnName");
        String strJoinColumnNullable = element.getAttribute("joinColumnNullable");
        this.joinColumnNullable = strJoinColumnNullable == null || strJoinColumnNullable.length() == 0 ? true : Boolean.parseBoolean(strJoinColumnNullable);
        this.orphanRemoval = XmlUtil.getBooleanAttributeOrFalse(element, "orphanRemoval");
        this.cascadeTypeOverwriteDefault = XmlUtil.getBooleanAttributeOrFalse(element, "cascadeTypeOverwriteDefault");
        this.cascadeTypePersist = XmlUtil.getBooleanAttributeOrFalse(element, "cascadeTypePersist");
        this.cascadeTypeRefresh = XmlUtil.getBooleanAttributeOrFalse(element, "cascadeTypeRefresh");
        this.cascadeTypeMerge = XmlUtil.getBooleanAttributeOrFalse(element, "cascadeTypeMerge");
        this.cascadeTypeRemove = XmlUtil.getBooleanAttributeOrFalse(element, "cascadeTypeRemove");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (this.ownerOfManyToManyAssociation) {
            element.setAttribute("ownerOfManyToManyAssociation", Boolean.toString(this.ownerOfManyToManyAssociation));
        }
        element.setAttribute("sourceColumnName", this.sourceColumnName);
        element.setAttribute("targetColumnName", this.targetColumnName);
        element.setAttribute("joinTableName", this.joinTableName);
        element.setAttribute("fetchType", String.valueOf((Object)this.fetchType));
        element.setAttribute("joinColumnName", this.joinColumnName);
        element.setAttribute("joinColumnNullable", Boolean.toString(this.joinColumnNullable));
        if (this.orphanRemoval) {
            element.setAttribute("orphanRemoval", Boolean.toString(this.orphanRemoval));
        }
        if (this.cascadeTypeOverwriteDefault) {
            element.setAttribute("cascadeTypeOverwriteDefault", Boolean.toString(this.cascadeTypeOverwriteDefault));
        }
        if (this.cascadeTypeMerge) {
            element.setAttribute("cascadeTypeMerge", Boolean.toString(this.cascadeTypeMerge));
        }
        if (this.cascadeTypePersist) {
            element.setAttribute("cascadeTypePersist", Boolean.toString(this.cascadeTypePersist));
        }
        if (this.cascadeTypeRemove) {
            element.setAttribute("cascadeTypeRemove", Boolean.toString(this.cascadeTypeRemove));
        }
        if (this.cascadeTypeRefresh) {
            element.setAttribute("cascadeTypeRefresh", Boolean.toString(this.cascadeTypeRefresh));
        }
    }

    @Override
    protected void validateThis(MessageList msgList, IIpsProject ipsProject) {
        if (!this.getPolicyComponentTypeAssociation().getPolicyCmptType().isPersistentEnabled()) {
            return;
        }
        IPolicyCmptTypeAssociation inverseAssociation = null;
        if (this.isBidirectional()) {
            inverseAssociation = this.getPolicyComponentTypeAssociation().findInverseAssociation(this.getPolicyComponentTypeAssociation().getIpsProject());
        }
        this.validateTransientMismatch(msgList, inverseAssociation);
        if (this.isTransient()) {
            return;
        }
        this.validateJoinColumn(msgList, inverseAssociation);
        this.validateJoinTable(msgList, inverseAssociation);
        this.validateLazyFetchOnSingleValuedAssociation(msgList, ipsProject, inverseAssociation);
        this.validateCascadeType(msgList);
        super.validateThis(msgList, ipsProject);
    }

    private void validateLazyFetchOnSingleValuedAssociation(MessageList msgList, IIpsProject ipsProject, IPolicyCmptTypeAssociation inverseAssociation) {
        if (ipsProject.getReadOnlyProperties().getPersistenceOptions().isAllowLazyFetchForSingleValuedAssociations()) {
            return;
        }
        IPersistentAssociationInfo.RelationshipType relationshipType = IPersistentAssociationInfo.RelationshipType.UNKNOWN;
        relationshipType = inverseAssociation == null ? this.evalUnidirectionalRelationShipType() : this.evalBidirectionalRelationShipType(inverseAssociation);
        if ((relationshipType == IPersistentAssociationInfo.RelationshipType.MANY_TO_ONE || relationshipType == IPersistentAssociationInfo.RelationshipType.ONE_TO_ONE) && IPersistentAssociationInfo.FetchType.LAZY == this.getFetchType()) {
            msgList.add(new Message("PERSISTENCEASSOCIATION-LazyFetchForSingleValuedAssociationsAllowed", Messages.PersistentAssociationInfo_msgLazyFetchNotSupported, Message.ERROR, (Object)this, new String[]{"fetchType"}));
        }
    }

    private void validateJoinColumn(MessageList msgList, IPolicyCmptTypeAssociation inverseAssociation) {
        if (this.isJoinColumnRequired(inverseAssociation)) {
            this.validateJoinColumn(msgList, false);
        } else {
            this.validateJoinColumn(msgList, true);
        }
    }

    private void validateTransientMismatch(MessageList msgList, IPolicyCmptTypeAssociation inverseAssociation) {
        boolean transientMismatch = false;
        if (inverseAssociation == null) {
            return;
        }
        if (this.isTransient() || !this.isPersistentTypeEntity(this.getPolicyComponentTypeAssociation())) {
            if (inverseAssociation.getPersistenceAssociatonInfo().isTransient()) {
                return;
            }
            if (this.isPersistentTypeEntity(inverseAssociation)) {
                transientMismatch = true;
            }
        } else if (inverseAssociation.getPersistenceAssociatonInfo().isTransient() || !this.isPersistentTypeEntity(inverseAssociation)) {
            transientMismatch = true;
        }
        if (transientMismatch) {
            msgList.add(new Message("PERSISTENCEASSOCIATION-TransientMismatch", Messages.PersistentAssociationInfo_msgTransientMismatch, Message.ERROR, (Object)this, new String[]{"transient"}));
        }
    }

    private boolean isPersistentTypeEntity(IPolicyCmptTypeAssociation association) {
        return association.getPolicyCmptType().getPersistenceTypeInfo().getPersistentType() == IPersistentTypeInfo.PersistentType.ENTITY;
    }

    private void validateJoinTable(MessageList msgList, IPolicyCmptTypeAssociation inverseAssociation) {
        if (inverseAssociation == null) {
            return;
        }
        if (!this.isJoinTableRequired(inverseAssociation) && this.isOwnerOfManyToManyAssociation()) {
            msgList.add(new Message("PERSISTENCEASSOCIATION-OwnerOfAssociationMustNotGiven", Messages.PersistentAssociationInfo_msgOwningSideManyToManyNotAllowed, Message.ERROR, (Object)this, new String[]{"ownerOfManyToManyAssociation"}));
            return;
        }
        this.validateJoinTableDetails(msgList, inverseAssociation);
        if (this.isJoinTableRequired(inverseAssociation) && !this.isOwnerOfManyToManyAssociation() && !inverseAssociation.getPersistenceAssociatonInfo().isOwnerOfManyToManyAssociation()) {
            msgList.add(new Message("PERSISTENCEASSOCIATION-OwnerOfAssociationMismatch", Messages.PersistentAssociationInfo_msgOwningSideMissing, Message.ERROR, (Object)this, new String[]{"ownerOfManyToManyAssociation"}));
        } else if (this.isJoinTableRequired(inverseAssociation) && this.isOwnerOfManyToManyAssociation() && inverseAssociation.getPersistenceAssociatonInfo().isOwnerOfManyToManyAssociation()) {
            msgList.add(new Message("PERSISTENCEASSOCIATION-OwnerOfAssociationMismatch", Messages.PersistentAssociationInfo_msgOwningSideManyToManyMarkedOnBothSides, Message.ERROR, (Object)this, new String[]{"ownerOfManyToManyAssociation"}));
        }
    }

    private void validateJoinColumn(MessageList msgList, boolean mustBeEmpty) {
        this.validateEmptyAndValidDatabaseIdentifier(msgList, mustBeEmpty, "PERSISTENCEASSOCIATION-JoinColumnNameEmpty", "PERSISTENCEASSOCIATION-JoinColumnNameInvalid", "joinColumnName", this.joinColumnName, Messages.PersistentAssociationInfo_joinColumnName);
        if (!mustBeEmpty) {
            this.validateMaxColumnNameLength(msgList, this.joinColumnName, Messages.PersistentAssociationInfo_joinColumnName, "PERSISTENCEASSOCIATION-JoinColumnNameInvalid", "joinColumnName");
        }
    }

    private void validateJoinTableDetails(MessageList msgList, IPolicyCmptTypeAssociation inverseAssociation) {
        this.validateJoinTableDetails(msgList, !this.isJoinTableRequired(inverseAssociation) || !this.isOwnerOfManyToManyAssociation());
    }

    private void validateJoinTableDetails(MessageList msgList, boolean mustBeEmpty) {
        this.validateEmptyAndValidDatabaseIdentifier(msgList, mustBeEmpty, "PERSISTENCEASSOCIATION-JoinTableNameEmpty", "PERSISTENCEASSOCIATION-JoinTableNameInvalid", "joinTableName", this.joinTableName, Messages.PersistentAssociationInfo_joinTableName);
        this.validateEmptyAndValidDatabaseIdentifier(msgList, mustBeEmpty, "PERSISTENCEASSOCIATION-SourceColumnNameEmpty", "PERSISTENCEASSOCIATION-SourceColumnNameInvalid", "sourceColumnName", this.sourceColumnName, Messages.PersistentAssociationInfo_sourceColumnName);
        this.validateEmptyAndValidDatabaseIdentifier(msgList, mustBeEmpty, "PERSISTENCEASSOCIATION-TargteColumnNameEmpty", "PERSISTENCEASSOCIATION-TargetColumnNameInvalid", "targetColumnName", this.targetColumnName, Messages.PersistentAssociationInfo_tagetColumnName);
        if (!mustBeEmpty) {
            this.validateMaxColumnNameLength(msgList, this.sourceColumnName, Messages.PersistentAssociationInfo_sourceColumnName, "PERSISTENCEASSOCIATION-SourceColumnNameInvalid", "sourceColumnName");
            this.validateMaxColumnNameLength(msgList, this.targetColumnName, Messages.PersistentAssociationInfo_tagetColumnName, "PERSISTENCEASSOCIATION-TargetColumnNameInvalid", "targetColumnName");
        }
        if (!mustBeEmpty) {
            int maxTableNameLenght = this.getIpsProject().getReadOnlyProperties().getPersistenceOptions().getMaxTableNameLength();
            if (this.joinTableName.length() > maxTableNameLenght) {
                msgList.add(new Message("PERSISTENCEASSOCIATION-JoinTableNameInvalid", MessageFormat.format(Messages.PersistentAssociationInfo_msgJoinTableNameExceedsMaximumLength, this.joinTableName.length(), maxTableNameLenght), Message.ERROR, (Object)this, new String[]{"joinTableName"}));
            }
        }
    }

    private void validateMaxColumnNameLength(MessageList msgList, String columnName, String propertyName, String messageCode, String property) {
        int maxColumnNameLenght = this.getIpsProject().getReadOnlyProperties().getPersistenceOptions().getMaxColumnNameLenght();
        if (columnName.length() > maxColumnNameLenght) {
            msgList.add(new Message(messageCode, MessageFormat.format(Messages.PersistentAssociationInfo_msgMaxLengthExceeds, propertyName, columnName.length(), maxColumnNameLenght), Message.ERROR, (Object)this, new String[]{property}));
        }
    }

    private void validateEmptyAndValidDatabaseIdentifier(MessageList msgList, boolean mustBeEmpty, String msgCodeEmpty, String msgCodeInValid, String property, String value, String propertyName) {
        String emptyText = null;
        emptyText = mustBeEmpty ? MessageFormat.format(Messages.PersistentAssociationInfo_msgMustBeEmpty, propertyName) : MessageFormat.format(Messages.PersistentAssociationInfo_msgMustNotBeEmpty, propertyName);
        if (mustBeEmpty && !IpsStringUtils.isEmpty((String)value) || !mustBeEmpty && IpsStringUtils.isEmpty((String)value)) {
            msgList.add(new Message(msgCodeEmpty, emptyText, Message.ERROR, (Object)this, new String[]{property}));
        } else if (!mustBeEmpty && !PersistenceUtil.isValidDatabaseIdentifier(value)) {
            String invalidText = MessageFormat.format(Messages.PersistentAssociationInfo_msgIsInvalid, propertyName);
            msgList.add(new Message(msgCodeInValid, invalidText, Message.ERROR, (Object)this, new String[]{property}));
        }
    }

    private void validateCascadeType(MessageList msgList) {
        if (this.getPolicyComponentTypeAssociation().isCompositionDetailToMaster()) {
            ArrayList<String> invalidProperties = new ArrayList<String>();
            if (this.cascadeTypeMerge) {
                invalidProperties.add("cascadeTypeMerge");
            }
            if (this.cascadeTypePersist) {
                invalidProperties.add("cascadeTypePersist");
            }
            if (this.cascadeTypeRemove) {
                invalidProperties.add("cascadeTypeRemove");
            }
            if (this.cascadeTypeRefresh) {
                invalidProperties.add("cascadeTypeRefresh");
            }
            if (!invalidProperties.isEmpty()) {
                msgList.add(new Message("PERSISTENCEASSOCIATION-ChildToParentCascadeType", Messages.PersistentAssociationInfo_msgChildToParentCascadeType, Message.ERROR, (Object)this, invalidProperties.toArray(new String[0])));
            }
        }
    }
}

