/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype.persistence;

import java.text.MessageFormat;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.datatype.classtypes.StringDatatype;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.internal.pctype.persistence.PersistentTypePartInfo;
import org.faktorips.devtools.model.internal.valueset.StringLengthValueSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IPersistenceOptions;
import org.faktorips.devtools.model.pctype.AttributeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.pctype.persistence.IPersistableTypeConverter;
import org.faktorips.devtools.model.pctype.persistence.IPersistentAttributeInfo;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.StringUtil;
import org.w3c.dom.Element;

public class PersistentAttributeInfo
extends PersistentTypePartInfo
implements IPersistentAttributeInfo {
    private String tableColumnName = "";
    private boolean tableColumnNullable = true;
    private boolean tableColumnUnique;
    private int tableColumnSize = 255;
    private int tableColumnPrecision = 16;
    private int tableColumnScale = 2;
    private String converterQualifiedClassName = "";
    private String sqlColumnDefinition = "";
    private IPersistentAttributeInfo.DateTimeMapping temporalMapping = IPersistentAttributeInfo.DateTimeMapping.DATE_ONLY;
    private IPolicyCmptTypeAttribute policyComponentTypeAttribute;

    public PersistentAttributeInfo(IPolicyCmptTypeAttribute policyComponentTypeAttribute, String id) {
        super(policyComponentTypeAttribute, id);
        this.policyComponentTypeAttribute = policyComponentTypeAttribute;
    }

    @Override
    public String getTableColumnName() {
        return this.tableColumnName;
    }

    @Override
    public boolean getTableColumnNullable() {
        return this.tableColumnNullable;
    }

    @Override
    public int getTableColumnPrecision() {
        return this.tableColumnPrecision;
    }

    @Override
    public int getTableColumnScale() {
        return this.tableColumnScale;
    }

    @Override
    public int getTableColumnSize() {
        return this.tableColumnSize;
    }

    @Override
    public boolean getTableColumnUnique() {
        return this.tableColumnUnique;
    }

    @Override
    public String getConverterQualifiedClassName() {
        return this.converterQualifiedClassName;
    }

    @Override
    public String getSqlColumnDefinition() {
        return this.sqlColumnDefinition;
    }

    @Override
    public void setTableColumnConverter(IPersistableTypeConverter newConverter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTableColumnName(String newTableColumnName) {
        ArgumentCheck.notNull((Object)newTableColumnName);
        String oldValue = this.tableColumnName;
        this.tableColumnName = newTableColumnName;
        this.valueChanged(oldValue, this.tableColumnName);
    }

    @Override
    public void setTableColumnNullable(boolean nullable) {
        boolean oldValue = this.tableColumnNullable;
        this.tableColumnNullable = nullable;
        this.valueChanged(oldValue, nullable);
    }

    @Override
    public void setTableColumnPrecision(int precision) {
        int oldValue = this.tableColumnPrecision;
        this.tableColumnPrecision = precision;
        this.valueChanged(oldValue, precision);
    }

    @Override
    public void setTableColumnScale(int scale) {
        int oldValue = this.tableColumnScale;
        this.tableColumnScale = scale;
        this.valueChanged(oldValue, scale);
    }

    @Override
    public void setTableColumnSize(int newTableColumnSize) {
        int oldValue = this.tableColumnSize;
        this.tableColumnSize = newTableColumnSize;
        this.valueChanged(oldValue, newTableColumnSize);
    }

    @Override
    public void setTableColumnUnique(boolean unique) {
        boolean oldValue = this.tableColumnUnique;
        this.tableColumnUnique = unique;
        this.valueChanged(oldValue, unique);
    }

    @Override
    public void setConverterQualifiedClassName(String converterQualifiedClassName) {
        ArgumentCheck.notNull((Object)converterQualifiedClassName);
        String oldValue = this.converterQualifiedClassName;
        this.converterQualifiedClassName = converterQualifiedClassName;
        this.valueChanged(oldValue, converterQualifiedClassName);
    }

    @Override
    public void setSqlColumnDefinition(String sqlColumnDefinition) {
        ArgumentCheck.notNull((Object)sqlColumnDefinition);
        String oldValue = this.sqlColumnDefinition;
        this.sqlColumnDefinition = sqlColumnDefinition;
        this.valueChanged(oldValue, sqlColumnDefinition);
    }

    @Override
    public IPolicyCmptTypeAttribute getPolicyComponentTypeAttribute() {
        return this.policyComponentTypeAttribute;
    }

    @Override
    public boolean isPersistentAttribute() {
        AttributeType attrType = this.getPolicyComponentTypeAttribute().getAttributeType();
        return attrType == AttributeType.CHANGEABLE || attrType == AttributeType.DERIVED_BY_EXPLICIT_METHOD_CALL;
    }

    @Override
    public IPersistentAttributeInfo.DateTimeMapping getTemporalMapping() {
        return this.temporalMapping;
    }

    @Override
    public void setTemporalMapping(IPersistentAttributeInfo.DateTimeMapping temporalType) {
        IPersistentAttributeInfo.DateTimeMapping oldValue = this.temporalMapping;
        this.temporalMapping = temporalType;
        this.valueChanged((Object)oldValue, (Object)this.temporalMapping);
    }

    @Override
    protected String getXmlTag() {
        return "PersistenceAttribute";
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.tableColumnName = element.getAttribute("tableColumnName");
        this.tableColumnSize = Integer.parseInt(element.getAttribute("tableColumnSize"));
        this.tableColumnScale = Integer.parseInt(element.getAttribute("tableColumnScale"));
        this.tableColumnPrecision = Integer.parseInt(element.getAttribute("tableColumnPrecision"));
        this.tableColumnUnique = XmlUtil.getBooleanAttributeOrFalse(element, "tableColumnUnique");
        this.tableColumnNullable = Boolean.parseBoolean(element.getAttribute("tableColumnNullable"));
        this.temporalMapping = IPersistentAttributeInfo.DateTimeMapping.valueOf(element.getAttribute("temporalMapping"));
        this.sqlColumnDefinition = element.getAttribute("sqlColumnDefinition");
        this.converterQualifiedClassName = element.getAttribute("converterQualifiedClassName");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("tableColumnName", this.tableColumnName);
        element.setAttribute("tableColumnSize", String.valueOf(this.tableColumnSize));
        element.setAttribute("tableColumnScale", String.valueOf(this.tableColumnScale));
        element.setAttribute("tableColumnPrecision", String.valueOf(this.tableColumnPrecision));
        if (this.tableColumnUnique) {
            element.setAttribute("tableColumnUnique", String.valueOf(this.tableColumnUnique));
        }
        element.setAttribute("tableColumnNullable", String.valueOf(this.tableColumnNullable));
        element.setAttribute("temporalMapping", String.valueOf((Object)this.temporalMapping));
        element.setAttribute("sqlColumnDefinition", this.sqlColumnDefinition);
        element.setAttribute("converterQualifiedClassName", this.converterQualifiedClassName);
    }

    @Override
    protected void validateThis(MessageList msgList, IIpsProject ipsProject) {
        if (!IpsStringUtils.isBlank((String)this.tableColumnName) && AttributeType.DERIVED_ON_THE_FLY.equals((Object)this.getPolicyComponentTypeAttribute().getAttributeType())) {
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceattrColnameMustBeEmpty", Messages.PersistentAttributeInfo_msgColumnNameMustBeEmpty, Message.ERROR, (Object)this, new String[]{"tableColumnName"}));
        }
        this.validateWhitespaceInTableColumnName(msgList);
        if (!this.isPersistentAttribute() || this.isTransient() || !this.getPolicyComponentTypeAttribute().getPolicyCmptType().isPersistentEnabled() || this.getPolicyComponentTypeAttribute().isOverwrite()) {
            return;
        }
        if (IpsStringUtils.isBlank((String)this.tableColumnName) && !this.getPolicyComponentTypeAttribute().isOverwrite()) {
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceAttrColumnNameEmpty", Messages.PersistentAttributeInfo_msgEmptyColumnName, Message.ERROR, (Object)this, new String[]{"tableColumnName"}));
        }
        this.validateStringLengthRestrictionsInModel(msgList, ipsProject);
        this.validateTableColumnNullableMatchesValueSet(msgList, ipsProject);
        this.validateUsingPersistentOptions(msgList, ipsProject);
        int maxColumnNameLenght = this.getIpsProject().getReadOnlyProperties().getPersistenceOptions().getMaxColumnNameLenght();
        if (IpsStringUtils.isNotBlank((String)this.tableColumnName) && this.tableColumnName.length() > maxColumnNameLenght) {
            msgList.add(new Message("PERSISTENCEATTRIBUTE-ColumnNameExceedsMaxLength", MessageFormat.format(Messages.PersistentAttributeInfo_msgColumnNameLengthExceedsMaximumLength, this.tableColumnName.length(), maxColumnNameLenght), Message.ERROR, (Object)this, new String[]{"tableColumnName"}));
        }
        super.validateThis(msgList, ipsProject);
    }

    private void validateWhitespaceInTableColumnName(MessageList msgList) {
        if (StringUtil.containsWhitespace((String)this.getTableColumnName())) {
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceattrColnameMustNotContainWhitespaceCharacters", Messages.PersistentAttributeInfo_msgColumnNameMustNotContainWhitespaceCharacters, Message.ERROR, (Object)this, new String[]{"tableColumnName"}));
        }
    }

    private void validateTableColumnNullableMatchesValueSet(MessageList msgList, IIpsProject ipsProject) {
        IValueSet valueSet = this.policyComponentTypeAttribute.getValueSet();
        String severityFromProperties = ipsProject.getReadOnlyProperties().getPersistenceColumnSizeChecksSeverity().toString();
        if ("NONE".equals(severityFromProperties)) {
            return;
        }
        if (valueSet != null && valueSet.isContainsNull() && !this.getTableColumnNullable()) {
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceAttrColumnNullableDoesNotMatchModel", Messages.PersistentAttributeInfo_msgColumnNullableDoesNotMatchModel, Severity.valueOf((String)severityFromProperties), new ObjectProperty[]{new ObjectProperty((Object)this, "tableColumnNullable"), new ObjectProperty((Object)valueSet, "containsNull")}));
        }
    }

    private void validateStringLengthRestrictionsInModel(MessageList msgList, IIpsProject ipsProject) {
        StringLengthValueSet sValueSet;
        ValueDatatype valueDatatype = this.policyComponentTypeAttribute.findValueDatatype(ipsProject);
        if (!(valueDatatype instanceof StringDatatype)) {
            return;
        }
        String severityFromProperties = ipsProject.getReadOnlyProperties().getPersistenceColumnSizeChecksSeverity().toString();
        if ("NONE".equals(severityFromProperties)) {
            return;
        }
        IValueSet valueSet = this.policyComponentTypeAttribute.getValueSet();
        if (valueSet == null || valueSet.isUnrestricted()) {
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceattrModelContainsNoLengthRestriction", MessageFormat.format(Messages.PersistentAttributeInfo_msgColumnSizeNotRestrictedInModel, this.getTableColumnSize()), Severity.valueOf((String)severityFromProperties), (Object)this, new String[]{"tableColumnSize"}));
        } else if (valueSet.isStringLength() && ((sValueSet = (StringLengthValueSet)valueSet).getParsedMaximumLength() == null || sValueSet.getParsedMaximumLength() > this.getTableColumnSize())) {
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceAttrModelExceedsColumnSize", MessageFormat.format(Messages.PersistentAttributeInfo_msgModelExceedsColumnSize, sValueSet.getMaximumLength(), this.getTableColumnSize()), Severity.valueOf((String)severityFromProperties), new ObjectProperty[]{new ObjectProperty((Object)this, "tableColumnSize"), new ObjectProperty((Object)sValueSet, "maximumLength")}));
        }
    }

    private void validateUsingPersistentOptions(MessageList msgList, IIpsProject ipsProject) {
        String text;
        IPersistenceOptions pOpt = ipsProject.getReadOnlyProperties().getPersistenceOptions();
        int minTableColumnSize = pOpt.getMinTableColumnSize();
        int maxTableColumnSize = pOpt.getMaxTableColumnSize();
        int minTableColumnPrecision = pOpt.getMinTableColumnPrecision();
        int maxTableColumnPrecision = pOpt.getMaxTableColumnPrecision();
        int minTableColumnScale = pOpt.getMinTableColumnScale();
        int maxTableColumnScale = pOpt.getMaxTableColumnScale();
        if (this.tableColumnSize < minTableColumnSize || this.tableColumnSize > maxTableColumnSize) {
            text = MessageFormat.format(Messages.PersistentAttributeInfo_msgColumnSizeExceedsTheLimit, minTableColumnSize, maxTableColumnSize);
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceAttrColumnOutOfBounds", text, Message.ERROR, (Object)this, new String[]{"tableColumnSize"}));
        }
        if (this.tableColumnPrecision < minTableColumnPrecision || this.tableColumnPrecision > maxTableColumnPrecision) {
            text = MessageFormat.format(Messages.PersistentAttributeInfo_msgColumnPrecisionExceedsTheLimit, minTableColumnPrecision, maxTableColumnPrecision);
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceAttrColumnOutOfBounds", text, Message.ERROR, (Object)this, new String[]{"tableColumnPrecision"}));
        }
        if (this.tableColumnScale < minTableColumnScale || this.tableColumnScale > maxTableColumnScale) {
            text = MessageFormat.format(Messages.PersistentAttributeInfo_msgColumnScaleExceedsTheLimit, minTableColumnScale, maxTableColumnScale);
            msgList.add(new Message("PERSISTENCEATTRIBUTE-PersistenceAttrColumnOutOfBounds", text, Message.ERROR, (Object)this, new String[]{"tableColumnScale"}));
        }
    }
}

