/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype.persistence;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.internal.pctype.persistence.PersistentAssociationInfo;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.pctype.persistence.IPersistentAssociationInfo;
import org.faktorips.devtools.model.pctype.persistence.IPersistentTypeInfo;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.devtools.model.util.PersistenceUtil;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PersistentTypeInfo
extends AtomicIpsObjectPart
implements IPersistentTypeInfo {
    private String tableName = "";
    private IPersistentTypeInfo.InheritanceStrategy inheritanceStrategy = IPersistentTypeInfo.InheritanceStrategy.SINGLE_TABLE;
    private String discriminatorValue = "";
    private IPersistentTypeInfo.DiscriminatorDatatype discriminatorDatatype = IPersistentTypeInfo.DiscriminatorDatatype.STRING;
    private String discriminatorColumnName = "";
    private Integer discriminatorColumnLength = 3;
    private IPersistentTypeInfo.PersistentType persistentType = IPersistentTypeInfo.PersistentType.NONE;
    private boolean definesDiscriminatorColumn = false;
    private boolean useTableDefinedInSupertype = false;

    public PersistentTypeInfo(IPolicyCmptType pcType, String id) {
        super(pcType, id);
    }

    @Override
    public IPersistentTypeInfo.PersistentType getPersistentType() {
        return this.persistentType;
    }

    @Override
    public boolean isEnabled() {
        return this.persistentType == IPersistentTypeInfo.PersistentType.ENTITY || this.persistentType == IPersistentTypeInfo.PersistentType.MAPPED_SUPERCLASS;
    }

    @Override
    public boolean isDefinesDiscriminatorColumn() {
        return this.definesDiscriminatorColumn;
    }

    @Override
    public void setPersistentType(IPersistentTypeInfo.PersistentType persistentType) {
        if (persistentType != IPersistentTypeInfo.PersistentType.ENTITY) {
            this.setTableName("");
            this.setDefinesDiscriminatorColumn(false);
            this.setDiscriminatorValue("");
        }
        IPersistentTypeInfo.PersistentType oldValue = this.persistentType;
        this.persistentType = persistentType;
        this.valueChanged((Object)oldValue, (Object)persistentType, "persistentType");
    }

    @Override
    public void setDefinesDiscriminatorColumn(boolean definesDiscriminatorColumn) {
        if (!definesDiscriminatorColumn) {
            this.setDiscriminatorColumnName("");
        }
        boolean oldValue = this.definesDiscriminatorColumn;
        this.definesDiscriminatorColumn = definesDiscriminatorColumn;
        this.valueChanged(oldValue, definesDiscriminatorColumn, "definesDiscriminatorColumn");
    }

    @Override
    public void setUseTableDefinedInSupertype(boolean useTableDefinedInSupertype) {
        this.setTableName("");
        boolean oldValue = this.useTableDefinedInSupertype;
        this.useTableDefinedInSupertype = useTableDefinedInSupertype;
        this.valueChanged(oldValue, useTableDefinedInSupertype, "useTableDefinedInSupertype");
    }

    @Override
    public boolean isUseTableDefinedInSupertype() {
        return this.useTableDefinedInSupertype;
    }

    @Override
    public String getDiscriminatorColumnName() {
        return this.discriminatorColumnName;
    }

    @Override
    public IPersistentTypeInfo.DiscriminatorDatatype getDiscriminatorDatatype() {
        return this.discriminatorDatatype;
    }

    @Override
    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public IPersistentTypeInfo.InheritanceStrategy getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Integer getDiscriminatorColumnLength() {
        return this.discriminatorColumnLength;
    }

    @Override
    public void setDiscriminatorColumnLength(Integer newDiscriminatorColumnLength) {
        Integer oldValue = this.discriminatorColumnLength;
        this.discriminatorColumnLength = newDiscriminatorColumnLength;
        this.valueChanged(oldValue, newDiscriminatorColumnLength, "discriminatorColumnLength");
    }

    @Override
    public void setDiscriminatorColumnName(String newDiscriminatorColumnName) {
        ArgumentCheck.notNull((Object)newDiscriminatorColumnName);
        String oldValue = this.discriminatorColumnName;
        this.discriminatorColumnName = newDiscriminatorColumnName;
        this.valueChanged(oldValue, newDiscriminatorColumnName, "discriminatorColumnName");
    }

    @Override
    public void setDiscriminatorDatatype(IPersistentTypeInfo.DiscriminatorDatatype newDescriminatorDatatype) {
        ArgumentCheck.notNull((Object)((Object)newDescriminatorDatatype));
        IPersistentTypeInfo.DiscriminatorDatatype oldValue = this.discriminatorDatatype;
        this.discriminatorDatatype = newDescriminatorDatatype;
        this.valueChanged((Object)oldValue, (Object)newDescriminatorDatatype, "discriminatorDatatype");
    }

    @Override
    public void setDiscriminatorValue(String newDescriminatorValue) {
        ArgumentCheck.notNull((Object)newDescriminatorValue);
        String oldValue = this.discriminatorValue;
        this.discriminatorValue = newDescriminatorValue;
        this.valueChanged(oldValue, newDescriminatorValue, "discriminatorValue");
    }

    @Override
    public void setInheritanceStrategy(IPersistentTypeInfo.InheritanceStrategy newStrategy) {
        ArgumentCheck.notNull((Object)((Object)newStrategy));
        IPersistentTypeInfo.InheritanceStrategy oldValue = this.inheritanceStrategy;
        this.setInheritanceStrategyInternal(newStrategy);
        this.valueChanged((Object)oldValue, (Object)newStrategy, "inheritanceStrategy");
    }

    public void setInheritanceStrategyInternal(IPersistentTypeInfo.InheritanceStrategy newStrategy) {
        if (IPersistentTypeInfo.InheritanceStrategy.SINGLE_TABLE.equals((Object)newStrategy) && !this.isRootEntity()) {
            this.useTableDefinedInSupertype = true;
            this.tableName = "";
        }
        this.inheritanceStrategy = newStrategy;
    }

    @Override
    public void setTableName(String newTableName) {
        ArgumentCheck.notNull((Object)newTableName);
        String oldValue = this.tableName;
        this.tableName = newTableName;
        this.valueChanged(oldValue, this.tableName, "tableName");
    }

    public boolean isSecondaryTableNameRequired() {
        return false;
    }

    @Override
    public void validateThis(MessageList msgList, IIpsProject ipsProject) {
        if (this.persistentType == IPersistentTypeInfo.PersistentType.NONE) {
            return;
        }
        RooEntityFinder rootEntityFinder = new RooEntityFinder(ipsProject);
        rootEntityFinder.start(this.getPolicyCmptType());
        this.validateInheritanceStrategy(msgList, rootEntityFinder.rooEntity, ipsProject);
        this.validateTableName(msgList, rootEntityFinder.rooEntity);
        this.validateDiscriminator(msgList, rootEntityFinder.rooEntity);
        this.validateUniqueColumnNameInHierarchy(msgList);
    }

    private void validateInheritanceStrategy(MessageList msgList, IPolicyCmptType rooEntity, IIpsProject ipsProject) {
        IPolicyCmptType pcType = this.getPolicyCmptType();
        if (!pcType.hasSupertype()) {
            return;
        }
        if (!this.isRootEntity(rooEntity) && IPersistentTypeInfo.InheritanceStrategy.SINGLE_TABLE.equals((Object)this.inheritanceStrategy) && !this.useTableDefinedInSupertype) {
            String text = MessageFormat.format(Messages.PersistentTypeInfo_msgTableNameOfRootEntityMustBeUsed, this.inheritanceStrategy.toString());
            msgList.add(new Message("PERSISTENCETYPE-MustUseTableFromRootEntity", text, Message.ERROR, (Object)this, new String[]{"useTableDefinedInSupertype"}));
        }
        new InheritanceStrategyMismatchVisitor(ipsProject, this, msgList).start(pcType);
    }

    private void validateTableName(MessageList msgList, IPolicyCmptType rootEntity) {
        if (this.getPersistentType() == IPersistentTypeInfo.PersistentType.MAPPED_SUPERCLASS) {
            if (!IpsStringUtils.isEmpty((String)this.tableName)) {
                msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeTableNameInvalid", Messages.PersistentTypeInfo_msgTableNameMustBeEmptyMappedSuperclass, Message.ERROR, (Object)this, new String[]{"tableName"}));
            }
            return;
        }
        if (this.isUseTableDefinedInSupertype()) {
            if (IpsStringUtils.isEmpty((String)this.getPolicyCmptType().getSupertype())) {
                msgList.add(new Message("PERSISTENCETYPE-msgcodeUseTableDefinedInSupertypeNotAllowed", Messages.PersistentTypeInfo_msgUseTableDefInSupertypIsNotAllowed, Message.ERROR, (Object)this, new String[]{"useTableDefinedInSupertype"}));
                return;
            }
            if (!IpsStringUtils.isEmpty((String)this.tableName)) {
                msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeTableNameInvalid", Messages.PersistentTypeInfo_msgTableNameMustBeEmptyBecauseNameDefinedInSupertypeShouldBeUsed, Message.ERROR, (Object)this, new String[]{"tableName"}));
                return;
            }
        }
        this.validateMaxTableNameLength(msgList);
        if (this.inheritanceStrategy != IPersistentTypeInfo.InheritanceStrategy.SINGLE_TABLE) {
            if (IpsStringUtils.isNotEmpty((String)this.getPolicyCmptType().getSupertype()) && this.getPolicyCmptType().getAttributes().size() == 0) {
                return;
            }
            this.validateTableNameValidIdentifier(msgList);
            return;
        }
        if (this.isRootEntity(rootEntity)) {
            this.validateTableNameValidIdentifier(msgList);
            return;
        }
        this.validateTableNameSingleInheritance(msgList);
    }

    private void validateTableNameSingleInheritance(MessageList msgList) {
        if (!IpsStringUtils.isEmpty((String)this.tableName)) {
            String text = MessageFormat.format(Messages.PersistentTypeInfo_msgTableNameMustBeEmptyNotRootEntityAndInhStrategyIs, this.inheritanceStrategy.toString());
            msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeTableNameInvalid", text, Message.ERROR, (Object)this, new String[]{"tableName"}));
        }
    }

    private void validateMaxTableNameLength(MessageList msgList) {
        int maxTableNameLenght = this.getIpsProject().getReadOnlyProperties().getPersistenceOptions().getMaxTableNameLength();
        if (IpsStringUtils.isNotBlank((String)this.tableName) && this.tableName.length() > maxTableNameLenght) {
            msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeTableNameInvalid", MessageFormat.format(Messages.PersistentTypeInfo_msgTableNameExceedsMaximumLength, this.tableName.length(), maxTableNameLenght), Message.ERROR, (Object)this, new String[]{"tableName"}));
        }
    }

    private void validateTableNameValidIdentifier(MessageList msgList) {
        if (this.isUseTableDefinedInSupertype()) {
            return;
        }
        if (!PersistenceUtil.isValidDatabaseIdentifier(this.tableName)) {
            msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeTableNameInvalid", Messages.PersistentTypeInfo_msgTableNameInvalid, Message.ERROR, (Object)this, new String[]{"tableName"}));
        }
    }

    @Override
    public IPolicyCmptType findRootEntity() {
        RooEntityFinder rooEntityFinder = new RooEntityFinder(this.getIpsProject());
        rooEntityFinder.start(this.getPolicyCmptType());
        return rooEntityFinder.rooEntity;
    }

    private void validateDiscriminator(MessageList msgList, IPolicyCmptType rootEntity) {
        this.validatePersistentType(msgList);
        this.validateDefinesDiscriminatorColumn(msgList);
        if (!(rootEntity != null && this.validateRootEntityNotDefined(msgList, rootEntity) && this.validateDefinesDiscriminatorColumnAndRootEntryNotNull(msgList, rootEntity) && this.validateDiscriminatorEmptinessOrConformity(msgList, rootEntity))) {
            return;
        }
        if (!this.validateMaxDiscriminatorLength(msgList, rootEntity)) {
            return;
        }
        this.validatePolicyCmptType(msgList);
    }

    private boolean validateMaxDiscriminatorLength(MessageList msgList, IPolicyCmptType rootEntity) {
        Integer maxDiscriminatorColumnLength = rootEntity.getPersistenceTypeInfo().getDiscriminatorColumnLength();
        if (maxDiscriminatorColumnLength != null && this.getDiscriminatorValue().length() > maxDiscriminatorColumnLength) {
            String text = MessageFormat.format(Messages.PersistentTypeInfo_msgDiscriminatorValueTooLong, maxDiscriminatorColumnLength);
            msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid", text, Message.ERROR, (Object)this, new String[]{"discriminatorValue"}));
            return false;
        }
        return true;
    }

    private boolean validateDiscriminatorEmptinessOrConformity(MessageList msgList, IPolicyCmptType rootEntity) {
        boolean discriminatorValueMustBeEmpty = this.isDiscrValueEmpty(rootEntity);
        if (!discriminatorValueMustBeEmpty) {
            if (IpsStringUtils.isEmpty((String)this.discriminatorValue)) {
                String text = Messages.PersistentTypeInfo_msgDiscriminatorValueMustNotBeEmpty;
                msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid", text, Message.ERROR, (Object)this, new String[]{"discriminatorValue"}));
                return false;
            }
        } else if (!IpsStringUtils.isEmpty((String)this.discriminatorValue)) {
            String text = Messages.PersistentTypeInfo_msgDiscriminatorValueMustBeEmpty;
            msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid", text, Message.ERROR, (Object)this, new String[]{"discriminatorValue"}));
            return false;
        }
        if (!rootEntity.getPersistenceTypeInfo().isDefinesDiscriminatorColumn()) {
            return false;
        }
        if (!discriminatorValueMustBeEmpty && !rootEntity.getPersistenceTypeInfo().getDiscriminatorDatatype().isParsableToDiscriminatorDatatype(this.discriminatorValue)) {
            String text = Messages.PersistentTypeInfo_msgDiscriminatorValueNotConform;
            msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid", text, Message.ERROR, (Object)this, new String[]{"discriminatorValue"}));
            return false;
        }
        return true;
    }

    private boolean validateDefinesDiscriminatorColumnAndRootEntryNotNull(MessageList msgList, IPolicyCmptType rootEntity) {
        if (this.isDefinesDiscriminatorColumnAndRootEntryNotNull(rootEntity)) {
            String text = Messages.PersistentTypeInfo_msgDiscriminatorDefinitionNotAllowedNotRootEntity;
            msgList.add(new Message("PERSISTENCETYPE-definitionOfDiscriminatorNotAllowed", text, Message.ERROR, (Object)this, new String[]{"definesDiscriminatorColumn"}));
            return false;
        }
        return true;
    }

    private boolean validateRootEntityNotDefined(MessageList msgList, IPolicyCmptType rootEntity) {
        if (this.checkIsRootEntityNotDefined(rootEntity)) {
            String text = MessageFormat.format(Messages.PersistentTypeInfo_msgDiscriminatorMustBeDefinedInTheRootEntity, rootEntity.getUnqualifiedName());
            msgList.add(new Message("PERSISTENCETYPE-definitionOfDiscriminatorMissing", text, Message.ERROR, (Object)this, new String[]{"definesDiscriminatorColumn"}));
            return false;
        }
        return true;
    }

    private boolean isDefinesDiscriminatorColumnAndRootEntryNotNull(IPolicyCmptType rootEntity) {
        return this.isDefinesDiscriminatorColumn() && rootEntity != this.getPolicyCmptType();
    }

    private boolean isDiscrValueEmpty(IPolicyCmptType rootEntity) {
        return this.getPolicyCmptType().isAbstract() || !rootEntity.getPersistenceTypeInfo().isDefinesDiscriminatorColumn();
    }

    private boolean checkIsRootEntityNotDefined(IPolicyCmptType rootEntity) {
        return rootEntity != this.getPolicyCmptType() && !rootEntity.getPersistenceTypeInfo().isDefinesDiscriminatorColumn() && this.isInheritanceStrategySingleTableOrJoinedSubclass() && this.getPolicyCmptType().getAttributes().size() > 0;
    }

    private boolean isInheritanceStrategySingleTableOrJoinedSubclass() {
        return this.inheritanceStrategy == IPersistentTypeInfo.InheritanceStrategy.SINGLE_TABLE || this.inheritanceStrategy == IPersistentTypeInfo.InheritanceStrategy.JOINED_SUBCLASS;
    }

    private void validateDefinesDiscriminatorColumn(MessageList msgList) {
        if (!this.isDefinesDiscriminatorColumn()) {
            if (IpsStringUtils.isNotEmpty((String)this.discriminatorColumnName)) {
                String text = Messages.PersistentTypeInfo_msgDiscriminatorDefinitionNotAllowedTypeNotDefDiscrColumn;
                msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid", text, Message.ERROR, (Object)this, new String[]{"discriminatorColumnName"}));
            }
        } else if (this.isDefinesDiscriminatorColumn() && !PersistenceUtil.isValidDatabaseIdentifier(this.discriminatorColumnName)) {
            String text = Messages.PersistentTypeInfo_msgDiscriminatorColumnNameIsInvalid;
            msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid", text, Message.ERROR, (Object)this, new String[]{"discriminatorColumnName"}));
        }
    }

    private void validatePolicyCmptType(MessageList msgList) {
        IPolicyCmptType pcType = this.getPolicyCmptType();
        if (!pcType.isAbstract()) {
            DiscriminatorValidator dValidator = new DiscriminatorValidator(this.getIpsProject(), this);
            dValidator.start(pcType);
            if (dValidator.conflictingTypeInfo != null) {
                msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid", dValidator.errorMessage, Message.ERROR, (Object)this, new String[]{dValidator.errorProperty}));
            }
        }
    }

    private void validatePersistentType(MessageList msgList) {
        if (this.getPersistentType() == IPersistentTypeInfo.PersistentType.MAPPED_SUPERCLASS) {
            String text;
            if (this.isDefinesDiscriminatorColumn()) {
                text = Messages.PersistentTypeInfo_msgDiscriminatorDefinitionNotAllowedBecauseMappedSuperclass;
                msgList.add(new Message("PERSISTENCETYPE-definitionOfDiscriminatorNotAllowed", text, Message.ERROR, (Object)this, new String[]{"definesDiscriminatorColumn"}));
            }
            if (IpsStringUtils.isNotEmpty((String)this.discriminatorValue)) {
                text = Messages.PersistentTypeInfo_msgDiscriminatorValueMustBeEmptyBecauseMappedSuperclass;
                msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid", text, Message.ERROR, (Object)this, new String[]{"definesDiscriminatorColumn"}));
            }
        }
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Persistence");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("tableName", this.tableName);
        element.setAttribute("inheritanceStrategy", "" + (Object)((Object)this.inheritanceStrategy));
        element.setAttribute("discriminatorColumnName", this.discriminatorColumnName);
        if (this.discriminatorColumnLength != null) {
            element.setAttribute("discriminatorColumnLength", "" + this.discriminatorColumnLength);
        }
        element.setAttribute("discriminatorDatatype", "" + (Object)((Object)this.discriminatorDatatype));
        element.setAttribute("discriminatorValue", this.discriminatorValue);
        if (this.definesDiscriminatorColumn) {
            element.setAttribute("definesDiscriminatorColumn", Boolean.toString(this.definesDiscriminatorColumn));
        }
        if (this.useTableDefinedInSupertype) {
            element.setAttribute("useTableDefinedInSupertype", Boolean.toString(this.useTableDefinedInSupertype));
        }
        element.setAttribute("persistentType", "" + (Object)((Object)this.persistentType));
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.tableName = element.getAttribute("tableName");
        this.inheritanceStrategy = IPersistentTypeInfo.InheritanceStrategy.valueOf(element.getAttribute("inheritanceStrategy"));
        this.discriminatorColumnName = element.getAttribute("discriminatorColumnName");
        this.discriminatorDatatype = IPersistentTypeInfo.DiscriminatorDatatype.valueOf(element.getAttribute("discriminatorDatatype"));
        String discriminatorColumnLengthString = element.getAttribute("discriminatorColumnLength");
        this.discriminatorColumnLength = IpsStringUtils.isNotBlank((String)discriminatorColumnLengthString) ? Integer.valueOf(Integer.parseInt(discriminatorColumnLengthString)) : null;
        this.discriminatorValue = element.getAttribute("discriminatorValue");
        this.initPersistentTypeWithWorkaround(element);
        this.definesDiscriminatorColumn = XmlUtil.getBooleanAttributeOrFalse(element, "definesDiscriminatorColumn");
        this.useTableDefinedInSupertype = XmlUtil.getBooleanAttributeOrFalse(element, "useTableDefinedInSupertype");
    }

    private void initPersistentTypeWithWorkaround(Element element) {
        String attrPersistentType = element.getAttribute("persistentType");
        this.persistentType = IpsStringUtils.isNotEmpty((String)attrPersistentType) ? IPersistentTypeInfo.PersistentType.valueOf(attrPersistentType) : (Boolean.parseBoolean(element.getAttribute("enabled")) ? IPersistentTypeInfo.PersistentType.ENTITY : IPersistentTypeInfo.PersistentType.NONE);
    }

    @Override
    public IPolicyCmptType getPolicyCmptType() {
        return (IPolicyCmptType)this.getIpsObject();
    }

    private void validateUniqueColumnNameInHierarchy(MessageList msgList) {
        ColumnNameCollector columnNameCollector = new ColumnNameCollector(this.getIpsProject());
        columnNameCollector.start(this.getPolicyCmptType());
        Map<String, Object> persistentObjectesBySameColumnName = columnNameCollector.getPersistentObjectesBySameColumnName();
        for (String columnName : persistentObjectesBySameColumnName.keySet()) {
            this.addMessagesDuplicateColumnName(msgList, columnName, persistentObjectesBySameColumnName.get(columnName));
        }
    }

    private void addMessagesDuplicateColumnName(MessageList msgList, String columnName, Object objectOrObjectsUseSameColumnName) {
        if (objectOrObjectsUseSameColumnName instanceof List) {
            List objectsUseSameColumnName = (List)objectOrObjectsUseSameColumnName;
            String objectsAsString = "";
            for (ObjectProperty objectProperty : objectsUseSameColumnName) {
                objectsAsString = String.valueOf(objectsAsString) + this.objectPropertyAsString(objectProperty);
            }
            for (ObjectProperty objectProperty : objectsUseSameColumnName) {
                if (this.getPolicyCmptTypeFromObjectProperty(objectProperty).getPersistenceTypeInfo() != this) continue;
                String objAsString = StringUtils.strip((String)objectsAsString.replace(this.objectPropertyAsString(objectProperty), ""), (String)", ");
                String message = objAsString.length() == 0 ? "" : Messages.PersistentTypeInfo_msgFoundDuplicateColumnNameIn;
                this.addMessageDuplicateColumnName(msgList, objectProperty, String.valueOf(columnName) + MessageFormat.format(message, objAsString));
            }
        }
    }

    private IPolicyCmptType getPolicyCmptTypeFromObjectProperty(ObjectProperty objectProperty) {
        return (IPolicyCmptType)((IIpsObjectPart)objectProperty.getObject()).getIpsObject();
    }

    private String objectPropertyAsString(ObjectProperty objectProperty) {
        return MessageFormat.format(" {0}#{1}, ", this.getPolicyCmptTypeFromObjectProperty(objectProperty).getUnqualifiedName(), objectProperty.getProperty());
    }

    private void addMessageDuplicateColumnName(MessageList msgList, ObjectProperty objectProperty, String detailText) {
        msgList.add(new Message("PERSISTENCETYPE-PersistenceAttrColumnNameDuplicate", MessageFormat.format(Messages.PersistentTypeInfo_msgDuplicateColumnName, detailText), Message.ERROR, objectProperty));
    }

    private boolean isRootEntity() {
        RooEntityFinder rootEntityFinder = new RooEntityFinder(this.getIpsProject());
        rootEntityFinder.start(this.getPolicyCmptType());
        return this.isRootEntity(rootEntityFinder.rooEntity);
    }

    private boolean isRootEntity(IPolicyCmptType rootEntity) {
        return this.getPolicyCmptType() == rootEntity;
    }

    private static class ColumnNameCollector
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private Map<String, Object> persistentObjectesBySameColumnName = new HashMap<String, Object>();

        public ColumnNameCollector(IIpsProject ipsProject) {
            super(ipsProject);
        }

        public Map<String, Object> getPersistentObjectesBySameColumnName() {
            return this.persistentObjectesBySameColumnName;
        }

        private boolean isPersistentAttribute(IPolicyCmptTypeAttribute attribute) {
            return attribute.getPersistenceAttributeInfo().isPersistentAttribute();
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            IPersistentTypeInfo.InheritanceStrategy currentInheritanceStrategy = currentType.getPersistenceTypeInfo().getInheritanceStrategy();
            List<IPolicyCmptTypeAttribute> policyCmptTypeAttributes = currentType.getPolicyCmptTypeAttributes();
            for (IPolicyCmptTypeAttribute currentAttribute : policyCmptTypeAttributes) {
                if (currentAttribute.isOverwrite() && currentInheritanceStrategy == IPersistentTypeInfo.InheritanceStrategy.SINGLE_TABLE || !this.isPersistentAttribute(currentAttribute)) continue;
                this.addIfNotEmpty(currentAttribute.getPersistenceAttributeInfo().getTableColumnName(), new ObjectProperty((Object)currentAttribute.getPersistenceAttributeInfo(), "tableColumnName"));
            }
            this.collectAssociationColumnsIfExists(currentType);
            return currentInheritanceStrategy != IPersistentTypeInfo.InheritanceStrategy.JOINED_SUBCLASS;
        }

        private void addColumnName(String columnName, ObjectProperty objectProperty) {
            if (IpsStringUtils.isEmpty((String)columnName)) {
                return;
            }
            Object objectOrObjectsSameColumnName = this.persistentObjectesBySameColumnName.get(columnName);
            if (objectOrObjectsSameColumnName == null) {
                this.persistentObjectesBySameColumnName.put(columnName, objectProperty);
            } else {
                ArrayList<ObjectProperty> objectsUseSameColumnName = null;
                if (objectOrObjectsSameColumnName instanceof ObjectProperty) {
                    objectsUseSameColumnName = new ArrayList<ObjectProperty>();
                    this.persistentObjectesBySameColumnName.put(columnName, objectsUseSameColumnName);
                    objectsUseSameColumnName.add((ObjectProperty)objectOrObjectsSameColumnName);
                } else {
                    objectsUseSameColumnName = (ArrayList<ObjectProperty>)objectOrObjectsSameColumnName;
                }
                objectsUseSameColumnName.add(objectProperty);
            }
        }

        private void collectAssociationColumnsIfExists(IPolicyCmptType currentType) {
            List<IPolicyCmptTypeAssociation> policyCmptTypeAssociations = currentType.getPolicyCmptTypeAssociations();
            for (IPolicyCmptTypeAssociation policyCmptTypeAssociation : policyCmptTypeAssociations) {
                if (policyCmptTypeAssociation.isConstrain()) continue;
                IPersistentAssociationInfo pAssInfo = policyCmptTypeAssociation.getPersistenceAssociatonInfo();
                if (IpsStringUtils.isBlank((String)policyCmptTypeAssociation.getInverseAssociation()) && ((PersistentAssociationInfo)pAssInfo).isForeignKeyColumnCreatedOnTargetSide(null)) continue;
                this.addIfNotEmpty(pAssInfo.getJoinColumnName(), new ObjectProperty((Object)pAssInfo, "joinColumnName"));
                this.addIfNotEmpty(pAssInfo.getSourceColumnName(), new ObjectProperty((Object)pAssInfo, "sourceColumnName"));
                this.addIfNotEmpty(pAssInfo.getTargetColumnName(), new ObjectProperty((Object)pAssInfo, "targetColumnName"));
            }
        }

        private void addIfNotEmpty(String columnName, ObjectProperty objectProperty) {
            if (IpsStringUtils.isNotEmpty((String)columnName)) {
                this.addColumnName(columnName, objectProperty);
            }
        }
    }

    private static final class DiscriminatorValidator
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private final IPersistentTypeInfo.InheritanceStrategy inheritanceStrategy;
        private final List<String> discriminatorValues = new ArrayList<String>();
        private IPersistentTypeInfo conflictingTypeInfo;
        private String errorMessage;
        private String errorProperty;

        public DiscriminatorValidator(IIpsProject ipsProject, IPersistentTypeInfo typeInfo) {
            super(ipsProject);
            this.inheritanceStrategy = typeInfo.getInheritanceStrategy();
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            IPersistentTypeInfo currentTypeInfo = currentType.getPersistenceTypeInfo();
            if (currentType.isAbstract()) {
                return true;
            }
            if (this.inheritanceStrategy != IPersistentTypeInfo.InheritanceStrategy.SINGLE_TABLE && this.inheritanceStrategy != IPersistentTypeInfo.InheritanceStrategy.JOINED_SUBCLASS) {
                return false;
            }
            if (this.discriminatorValues.contains(currentTypeInfo.getDiscriminatorValue())) {
                this.conflictingTypeInfo = currentTypeInfo;
                this.errorMessage = MessageFormat.format(Messages.PersistentTypeInfo_msgDiscriminatorAlreadyDefined, currentTypeInfo.getDiscriminatorValue(), currentType.getUnqualifiedName());
                this.errorProperty = "discriminatorValue";
                return false;
            }
            this.discriminatorValues.add(currentTypeInfo.getDiscriminatorValue());
            return true;
        }
    }

    private final class InheritanceStrategyMismatchVisitor
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private final MessageList msgList;
        private final PersistentTypeInfo persistentTypeInfo;

        private InheritanceStrategyMismatchVisitor(IIpsProject ipsProject, PersistentTypeInfo persistentTypeInfo2, MessageList msgList) {
            super(ipsProject);
            this.persistentTypeInfo = persistentTypeInfo2;
            this.msgList = msgList;
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            IPersistentTypeInfo.InheritanceStrategy supertypeStrategy = currentType.getPersistenceTypeInfo().getInheritanceStrategy();
            if (supertypeStrategy == PersistentTypeInfo.this.inheritanceStrategy || currentType.getPersistenceTypeInfo().getPersistentType() != IPersistentTypeInfo.PersistentType.ENTITY) {
                return true;
            }
            String text = MessageFormat.format(Messages.PersistentTypeInfo_msgInvalidInheritanceStratedyCombination, new Object[]{currentType.getUnqualifiedName(), supertypeStrategy, this.persistentTypeInfo.getIpsObject().getUnqualifiedName(), PersistentTypeInfo.this.inheritanceStrategy});
            this.msgList.add(new Message("PERSISTENCETYPE-PersistenceTypeInheritanceStrategyInvalid", text, Message.ERROR, (Object)this.persistentTypeInfo, new String[]{"inheritanceStrategy"}));
            return false;
        }
    }

    private static class RooEntityFinder
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private IPolicyCmptType rooEntity = null;

        public RooEntityFinder(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            IPersistentTypeInfo persistenceTypeInfo = currentType.getPersistenceTypeInfo();
            if (IpsStringUtils.isEmpty((String)currentType.getSupertype())) {
                if (persistenceTypeInfo.getPersistentType() == IPersistentTypeInfo.PersistentType.ENTITY) {
                    this.rooEntity = currentType;
                }
                return false;
            }
            if (persistenceTypeInfo.getPersistentType() == IPersistentTypeInfo.PersistentType.ENTITY) {
                this.rooEntity = currentType;
            }
            return true;
        }
    }
}

