/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.pctype.persistence;

import java.text.MessageFormat;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.persistence.IPersistentTypePartInfo;
import org.faktorips.devtools.model.util.PersistenceUtil;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PersistentTypePartInfo
extends AtomicIpsObjectPart
implements IPersistentTypePartInfo {
    private boolean transientPart = false;
    private String indexName = "";

    public PersistentTypePartInfo(IIpsObjectPart parent, String id) {
        super(parent, id);
    }

    @Override
    public boolean isTransient() {
        return this.transientPart;
    }

    @Override
    public void setTransient(boolean transientPart) {
        boolean oldValue = this.transientPart;
        this.transientPart = transientPart;
        this.valueChanged(oldValue, transientPart);
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public void setIndexName(String newIndexName) {
        String oldIndexName = this.indexName;
        this.indexName = newIndexName;
        this.valueChanged(oldIndexName, this.indexName);
    }

    @Override
    public boolean isIndexNameDefined() {
        return IpsStringUtils.isNotEmpty((String)this.indexName);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(this.getXmlTag());
    }

    protected abstract String getXmlTag();

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.transientPart = XmlUtil.getBooleanAttributeOrFalse(element, "transient");
        this.indexName = element.getAttribute("indexName");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        if (this.transientPart) {
            element.setAttribute("transient", Boolean.toString(this.transientPart));
        }
        element.setAttribute("indexName", this.indexName);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        this.validateIndexName(list);
    }

    private void validateIndexName(MessageList msgList) {
        if (this.isIndexNameDefined() && !PersistenceUtil.isValidDatabaseIdentifier(this.indexName)) {
            String text = MessageFormat.format(Messages.PersistentInfo_msgIndexNameIsInvalid, this.indexName);
            msgList.add(Message.newError((String)"IPSOBJECTPARTCONTAINER-IndexNameInvalid", (String)text, (Object)this, (String[])new String[]{"indexName"}));
        }
    }
}

