/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptNamingStrategy;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractProductCmptNamingStrategy
implements IProductCmptNamingStrategy {
    private String separator;
    private HashMap<Character, String> specialCharReplacements = new HashMap();
    private IIpsProject ipsProject;

    public AbstractProductCmptNamingStrategy() {
        this("");
    }

    public AbstractProductCmptNamingStrategy(String separator) {
        this.separator = separator;
        this.putSpecialCharReplacement('-', "__");
        this.putSpecialCharReplacement(' ', "___");
    }

    @Override
    public void setIpsProject(IIpsProject project) {
        if (project == null) {
            throw new NullPointerException();
        }
        this.ipsProject = project;
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.ipsProject;
    }

    public void setVersionIdSeparator(String separator) {
        this.separator = separator;
    }

    public String getVersionIdSeparator() {
        return this.separator;
    }

    public void putSpecialCharReplacement(char specialChar, String replacement) {
        if (specialChar == '.') {
            throw new IllegalArgumentException("The dot (.) is prohibited in names, as it is used to separate name and package information in qualified names.");
        }
        if (replacement == null) {
            this.specialCharReplacements.remove(Character.valueOf(specialChar));
        } else {
            this.specialCharReplacements.put(Character.valueOf(specialChar), replacement);
        }
    }

    public String getReplacement(char c) {
        return this.specialCharReplacements.get(Character.valueOf(c));
    }

    public char[] getReplacedCharacters() {
        char[] chars = new char[this.specialCharReplacements.size()];
        int i = 0;
        Iterator<Character> it = this.specialCharReplacements.keySet().iterator();
        while (it.hasNext()) {
            chars[i] = it.next().charValue();
            ++i;
        }
        return chars;
    }

    @Override
    public String getProductCmptName(String constantPart, String versionId) {
        return String.valueOf(constantPart) + this.separator + versionId;
    }

    @Override
    public String getKindId(String productCmptName) {
        int index = productCmptName.lastIndexOf(this.separator);
        if (index == -1) {
            throw new IllegalArgumentException("Can't get constant part from " + productCmptName + ", separator not found!");
        }
        return productCmptName.substring(0, index);
    }

    @Override
    public String getVersionId(String productCmptName) {
        int index = productCmptName.lastIndexOf(this.separator);
        if (index == -1) {
            throw new IllegalArgumentException("Can't get constant part from " + productCmptName + ", separator not found!");
        }
        return productCmptName.substring(index + this.separator.length());
    }

    @Override
    public String getNextName(IProductCmpt productCmpt, GregorianCalendar validFrom) {
        String part = this.getKindId(productCmpt.getName());
        return String.valueOf(part) + this.separator + this.getNextVersionId(productCmpt, validFrom);
    }

    @Override
    public MessageList validate(String name) {
        int separatorCount;
        MessageList list = new MessageList();
        if (this.separator.length() > 0 && (separatorCount = StringUtils.countMatches((CharSequence)name, (CharSequence)this.separator)) == 0) {
            String text = MessageFormat.format(Messages.AbstractProductCmptNamingStrategy_msgNoVersionSeparator, name);
            Message msg = Message.newError((String)"ProductCmptNamingStrategy-VersionSeparatorIsMissing", (String)text);
            list.add(msg);
            return list;
        }
        list.add(this.validateKindId(this.getKindId(name)));
        list.add(this.validateVersionId(this.getVersionId(name)));
        return list;
    }

    @Override
    public MessageList validateKindId(String kindId) {
        MessageList list = new MessageList();
        if (IpsStringUtils.isEmpty((String)kindId)) {
            Message msg = Message.newError((String)"ProductCmptNamingStrategy-KindIdIsEmpty", (String)Messages.AbstractProductCmptNamingStrategy_emptyKindId);
            list.add(msg);
            return list;
        }
        try {
            this.getJavaClassIdentifier(kindId);
        }
        catch (IllegalArgumentException e) {
            Message msg = Message.newError((String)"ProductCmptNamingStrategy-IllegalCharacters", (String)Messages.AbstractProductCmptNamingStrategy_msgIllegalChar);
            list.add(msg);
        }
        return list;
    }

    @Override
    public String getJavaClassIdentifier(String name) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (this.isSpecialChar(c)) {
                sb.append(this.getReplacement(c));
            } else {
                sb.append(c);
            }
            ++i;
        }
        String identifier = sb.toString();
        MessageList status = ValidationUtils.validateJavaTypeName(identifier);
        if (status.isEmpty() || status.getSeverity() == Severity.WARNING) {
            return identifier;
        }
        throw new IllegalArgumentException("Name " + name + " can't be transformed to a valid Java class name");
    }

    private boolean isSpecialChar(char c) {
        return this.specialCharReplacements.containsKey(Character.valueOf(c));
    }

    @Override
    public final void initFromXml(Element el) {
        Element subEl = XmlUtil.getFirstElement(el);
        this.separator = subEl.getAttribute("versionIdSeparator");
        this.initSubclassFromXml(subEl);
        Element replacementsEl = XmlUtil.getFirstElement(subEl, "JavaIdentifierCharReplacements");
        if (replacementsEl == null) {
            return;
        }
        this.specialCharReplacements.clear();
        NodeList nl = replacementsEl.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeName().equals("Replacement")) {
                Element replacementEl = (Element)nl.item(i);
                String replacedChar = replacementEl.getAttribute("replacedChar");
                String replacement = replacementEl.getAttribute("replacement");
                this.putSpecialCharReplacement(replacedChar.charAt(0), replacement);
            }
            ++i;
        }
    }

    protected abstract void initSubclassFromXml(Element var1);

    @Override
    public final Element toXml(Document doc) {
        Element el = doc.createElement("ProductCmptNamingStrategy");
        el.setAttribute("id", this.getExtensionId());
        Element subEl = this.toXmlSubclass(doc);
        subEl.setAttribute("versionIdSeparator", this.separator);
        el.appendChild(subEl);
        char[] chars = this.getReplacedCharacters();
        if (chars.length == 0) {
            return el;
        }
        Element replacementsEl = doc.createElement("JavaIdentifierCharReplacements");
        subEl.appendChild(replacementsEl);
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Element replacementEl = doc.createElement("Replacement");
            replacementsEl.appendChild(replacementEl);
            replacementEl.setAttribute("replacedChar", "" + c);
            replacementEl.setAttribute("replacement", this.getReplacement(c));
            ++n2;
        }
        return el;
    }

    protected abstract Element toXmlSubclass(Document var1);

    @Override
    public boolean sameRuntimeId(String runtimeId1, String runtimeId2) {
        return runtimeId1.equals(runtimeId2);
    }

    public int hashCode() {
        return Objects.hash(this.ipsProject, this.separator, this.specialCharReplacements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProductCmptNamingStrategy other = (AbstractProductCmptNamingStrategy)obj;
        return Objects.equals(this.ipsProject, other.ipsProject) && Objects.equals(this.separator, other.separator) && Objects.equals(this.specialCharReplacements, other.specialCharReplacements);
    }

    @Override
    public MessageList validateRuntimeId(String runtimeId) {
        MessageList result = new MessageList();
        if (IpsStringUtils.isEmpty((String)runtimeId)) {
            String text = MessageFormat.format(Messages.DefaultRuntimeIdStrategy_msgRuntimeIdNotValid, runtimeId);
            result.add(new Message("ProductCmptNamingStrategy-InvalidRuntimeIdFormat", text, Message.ERROR, (Object)this));
        }
        return result;
    }
}

