/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import org.faktorips.devtools.model.ContentChangeEvent;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.ipsobject.IpsSrcFileContent;
import org.faktorips.devtools.model.internal.productcmpt.DelegatingValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.IValueHolderValidator;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.AttributeValueType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractValueHolder<T>
implements IValueHolder<T> {
    public static final String XML_ATTRIBUTE_VALUE_TYPE = "valueType";
    private final IAttributeValue parent;

    public AbstractValueHolder(IAttributeValue parent) {
        this.parent = parent;
    }

    @Override
    public IAttributeValue getParent() {
        return this.parent;
    }

    protected void objectHasChanged(Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (oldValue == null || !oldValue.equals(newValue)) {
            ContentChangeEvent event = ContentChangeEvent.newPartChangedEvent(this.getParent());
            IpsSrcFileContent content = IIpsModel.get().getIpsSrcFileContent(this.getParent().getIpsSrcFile());
            if (content != null) {
                content.ipsObjectChanged(event);
            }
        }
    }

    @Override
    public boolean isValid(IIpsProject ipsProject) {
        return this.getValidationResultSeverity(ipsProject) != Severity.ERROR;
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.parent.getIpsProject();
    }

    @Override
    public Severity getValidationResultSeverity(IIpsProject ipsProject) {
        return this.validate(ipsProject).getSeverity();
    }

    @Override
    public Element toXml(Document doc) {
        Element valueEl = doc.createElement("Value");
        if (this.isNullValue()) {
            valueEl.setAttribute("isNull", Boolean.toString(this.isNullValue()));
        }
        if (AttributeValueType.MULTI_VALUE.equals((Object)this.getType())) {
            valueEl.setAttribute(XML_ATTRIBUTE_VALUE_TYPE, this.getType().getXmlTypeName());
        }
        this.contentToXml(valueEl, doc);
        return valueEl;
    }

    protected abstract void contentToXml(Element var1, Document var2);

    protected abstract AttributeValueType getType();

    public static IValueHolder<?> initValueHolder(IAttributeValue attributeValue, Element valueEl) {
        AttributeValueType attributeValueType = AttributeValueType.getType(valueEl);
        IValueHolder newValueInstance = attributeValueType.newHolderInstance(attributeValue);
        newValueInstance.initFromXml(valueEl);
        return newValueInstance;
    }

    @Override
    public IValueHolder<?> copy(IAttributeValue parent) {
        Element element = this.toXml(XmlUtil.getDocumentBuilder().newDocument());
        return AbstractValueHolder.initValueHolder(parent, element);
    }

    public String toString() {
        return "ValueHolder: " + this.getStringValue();
    }

    @Override
    public boolean equalsValueHolder(IValueHolder<?> o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof DelegatingValueHolder) {
            return this.equals(((DelegatingValueHolder)o).getDelegate());
        }
        return this.equals(o);
    }

    protected abstract IValueHolderValidator newValidator(IAttributeValue var1, IIpsProject var2);
}

