/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.AssociationType;

public class AggregateRootFinder {
    private final Set<String> nonRootCmpts = new HashSet<String>();
    private final Map<String, IProductCmpt> potentialRootCmpts = new ConcurrentHashMap<String, IProductCmpt>(64, 0.75f, 1);
    private final IIpsProject ipsProject;

    public AggregateRootFinder(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
    }

    public List<IProductCmpt> findAggregateRoots() {
        List<IIpsSrcFile> prodCmptSrcFiles = this.getIpsProject().findAllIpsSrcFiles(IpsObjectType.PRODUCT_CMPT);
        return this.findAggregateRootsFromSrcFiles(prodCmptSrcFiles);
    }

    protected void resetIndices() {
        this.nonRootCmpts.clear();
        this.potentialRootCmpts.clear();
    }

    private List<IProductCmpt> findAggregateRootsFromSrcFiles(List<IIpsSrcFile> prodCmptSrcFiles) {
        List<IProductCmpt> prodCmpts = this.getProductCmpts(prodCmptSrcFiles);
        return this.findAggregateRoots(prodCmpts);
    }

    protected List<IProductCmpt> getProductCmpts(List<IIpsSrcFile> prodCmptSrcFiles) {
        ArrayList<IProductCmpt> prodCmpts = new ArrayList<IProductCmpt>();
        for (IIpsSrcFile srcFile : prodCmptSrcFiles) {
            IProductCmpt productCmpt = (IProductCmpt)srcFile.getIpsObject();
            prodCmpts.add(productCmpt);
        }
        return prodCmpts;
    }

    private List<IProductCmpt> findAggregateRoots(List<IProductCmpt> prodCmpts) {
        this.resetIndices();
        this.indexAllProductComponents(prodCmpts);
        return this.getIndexedRootCmpts();
    }

    protected void indexAllProductComponents(List<IProductCmpt> prodCmpts) {
        for (IProductCmpt prodCmpt : prodCmpts) {
            if (!this.isRegisteredChild(prodCmpt)) {
                this.registerAsPotentialRoot(prodCmpt);
            }
            this.processLinks(prodCmpt);
        }
    }

    protected boolean isRegisteredChild(IProductCmpt prodCmpt) {
        String qName = prodCmpt.getQualifiedName();
        return this.nonRootCmpts.contains(qName);
    }

    protected void registerAsPotentialRoot(IProductCmpt prodCmpt) {
        this.potentialRootCmpts.put(prodCmpt.getQualifiedName(), prodCmpt);
    }

    private void processLinks(IProductCmpt prodCmpt) {
        List<IProductCmptLink> links = this.getChangingAndStaticLinksFor(prodCmpt);
        for (IProductCmptLink link : links) {
            this.processTarget(prodCmpt, link);
        }
    }

    protected List<IProductCmptLink> getChangingAndStaticLinksFor(IProductCmpt prodCmpt) {
        List allLinks = prodCmpt.getLinksAsList();
        for (IProductCmptGeneration gen : prodCmpt.getProductCmptGenerations()) {
            allLinks.addAll(gen.getLinksAsList());
        }
        return allLinks;
    }

    protected void processTarget(IProductCmpt prodCmpt, IProductCmptLink link) {
        if (this.isComposition(link)) {
            String targetName = link.getTarget();
            this.removeFromPotentialRoots(prodCmpt, targetName);
        }
    }

    private boolean isComposition(IProductCmptLink link) {
        IProductCmptTypeAssociation association = link.findAssociation(this.getIpsProject());
        return association.getAssociationType() == AssociationType.AGGREGATION;
    }

    private void removeFromPotentialRoots(IProductCmpt sourceProdCmpt, String targetName) {
        if (!this.isSelfReferencing(sourceProdCmpt, targetName)) {
            this.removeFromPotentialRoots(targetName);
        }
    }

    protected boolean isSelfReferencing(IProductCmpt prodCmpt, String targetName) {
        return prodCmpt.getQualifiedName().equals(targetName);
    }

    protected void removeFromPotentialRoots(String targetName) {
        this.potentialRootCmpts.remove(targetName);
        this.nonRootCmpts.add(targetName);
    }

    private List<IProductCmpt> getIndexedRootCmpts() {
        return new ArrayList<IProductCmpt>(this.potentialRootCmpts.values());
    }

    private IIpsProject getIpsProject() {
        return this.ipsProject;
    }
}

