/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.productcmpt.AbstractSimplePropertyValue;
import org.faktorips.devtools.model.internal.productcmpt.AbstractValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.DelegatingValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.SingleValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.deltaentries.HiddenAttributeMismatchEntry;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueFinder;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueSettings;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.AttributeValueType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeValue
extends AbstractSimplePropertyValue
implements IAttributeValue {
    public static final String TAG_NAME = "AttributeValue";
    private String attribute;
    private IValueHolder<?> valueHolder;
    private final TemplateValueSettings templateValueSettings;

    public AttributeValue(IPropertyValueContainer parent, String id) {
        this(parent, id, "");
    }

    public AttributeValue(IPropertyValueContainer parent, String id, String attribute) {
        super(parent, id);
        ArgumentCheck.notNull((Object)attribute);
        this.attribute = attribute;
        this.templateValueSettings = new TemplateValueSettings(this);
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    public String getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(String newAttribute) {
        String oldAttr = this.attribute;
        this.name = this.attribute = newAttribute;
        this.valueChanged(oldAttr, this.attribute);
    }

    @Override
    public IValueHolder<?> getValueHolder() {
        if (this.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            return this.findTemplateValueHolder();
        }
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return this.getUndefinedValueHolder();
        }
        return this.valueHolder;
    }

    public IValueHolder<?> getValueHolderInternal() {
        return this.valueHolder;
    }

    private IValueHolder<?> findTemplateValueHolder() {
        IAttributeValue templateAttribute = this.findTemplateProperty(this.getIpsProject());
        if (templateAttribute == null || templateAttribute.getValueHolder() == null) {
            return this.valueHolder;
        }
        return DelegatingValueHolder.of(this, templateAttribute.getValueHolder());
    }

    private IValueHolder<?> getUndefinedValueHolder() {
        IProductCmptTypeAttribute typeAttribute = this.findAttribute(this.getIpsProject());
        if (typeAttribute == null) {
            return new SingleValueHolder(this);
        }
        return AttributeValueType.getTypeFor(typeAttribute).newHolderInstance(this);
    }

    @Override
    public void setValueHolder(IValueHolder<?> newValue) {
        IValueHolder<?> oldValue = this.valueHolder;
        this.setValueHolderInternal(newValue);
        this.valueChanged(oldValue, newValue);
    }

    public void setValueHolderInternal(IValueHolder<?> newValue) {
        this.valueHolder = newValue;
    }

    @Override
    public String getPropertyName() {
        return this.attribute;
    }

    @Override
    public IProductCmptProperty findProperty(IIpsProject ipsProject) {
        return this.findAttribute(ipsProject);
    }

    @Override
    public PropertyValueType getPropertyValueType() {
        return PropertyValueType.ATTRIBUTE_VALUE;
    }

    @Override
    public String getPropertyValue() {
        if (this.getValueHolder() != null) {
            return this.getValueHolder().getStringValue();
        }
        return null;
    }

    @Override
    public IProductCmptTypeAttribute findAttribute(IIpsProject ipsProject) {
        IProductCmptType type = this.getPropertyValueContainer().findProductCmptType(ipsProject);
        if (type == null) {
            return null;
        }
        return type.findProductCmptTypeAttribute(this.attribute, ipsProject);
    }

    @Override
    public IAttributeValue findTemplateProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.findTemplateValue(this, IAttributeValue.class);
    }

    @Override
    public boolean hasTemplateForProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.hasTemplateForValue(this, IAttributeValue.class);
    }

    @Override
    public TemplateValueStatus getTemplateValueStatus() {
        return this.templateValueSettings.getStatus();
    }

    @Override
    public void setTemplateValueStatus(TemplateValueStatus newStatus) {
        if (newStatus == TemplateValueStatus.DEFINED) {
            this.valueHolder = this.getValueHolder().copy(this);
        }
        TemplateValueStatus oldValue = this.templateValueSettings.getStatus();
        this.templateValueSettings.setStatus(newStatus);
        this.objectHasChanged(new PropertyChangeEvent(this, "templateValueStatus", (Object)oldValue, (Object)newStatus));
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.attribute = element.getAttribute("attribute");
        Element valueEl = XmlUtil.getFirstElement((Node)element, (String)"Value");
        this.valueHolder = AbstractValueHolder.initValueHolder(this, valueEl);
        this.templateValueSettings.initPropertiesFromXml(element);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("attribute", this.attribute);
        Document ownerDocument = element.getOwnerDocument();
        if (this.getValueHolder() != null) {
            Element valueElement = this.getValueHolder().toXml(ownerDocument);
            element.appendChild(valueElement);
        }
        this.templateValueSettings.propertiesToXml(element);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        IProductCmptTypeAttribute attr = this.findAttribute(ipsProject);
        if (attr == null) {
            String typeLabel = this.getPropertyValueContainer().getProductCmptType();
            IProductCmptType productCmptType = this.getPropertyValueContainer().findProductCmptType(ipsProject);
            if (productCmptType != null) {
                typeLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(productCmptType);
            }
            String text = MessageFormat.format(Messages.AttributeValue_attributeNotFound, this.attribute, typeLabel);
            list.add(new Message("ATTRIBUTEVALUE-UnknownAttribute", text, Message.ERROR, (Object)this, new String[]{"attribute"}));
            return;
        }
        if (attr.isMultiValueAttribute() != this.getValueHolder().isMultiValue()) {
            String hint = Messages.AttributeValue_msg_validateValueHolder_hint;
            String text = attr.isMultiValueAttribute() ? String.valueOf(Messages.AttributeValue_msg_validateValueHolder_multiValue) + hint : String.valueOf(Messages.AttributeValue_msg_validateValueHolder_singleValue) + hint;
            list.add(new Message("ATTRIBUTEVALUE-InvalidValueHolder", text, Message.ERROR, (Object)this, new String[]{"valueHolder"}));
        }
        if (this.getTemplateValueStatus() != TemplateValueStatus.UNDEFINED) {
            list.add(this.getValueHolder().validate(ipsProject));
            this.attrIsHiddenMismatch(attr, list);
        }
        list.add(this.templateValueSettings.validate(this, ipsProject));
    }

    private void attrIsHiddenMismatch(IProductCmptTypeAttribute attr, MessageList list) {
        HiddenAttributeMismatchEntry attributeEntry = new HiddenAttributeMismatchEntry(this, attr);
        if (attributeEntry.isMismatch()) {
            String text = MessageFormat.format(Messages.AttributeValue_HiddenAttributeMismatch, attr.getDefaultValue(), attributeEntry.getPropertyName(), attributeEntry.getCurrentAttributeValue());
            list.add(new Message("ATTRIBUTEVALUE-HiddenAttribute", text, Message.ERROR));
        }
    }

    @Override
    public String getName() {
        return this.attribute;
    }

    @Override
    public String getCaption(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        String caption = null;
        IProductCmptTypeAttribute foundAttribute = this.findAttribute(this.getIpsProject());
        if (foundAttribute != null) {
            caption = foundAttribute.getLabelValueFromThisOrSuper(locale);
        }
        return caption;
    }

    @Override
    public String getLastResortCaption() {
        return StringUtils.capitalize((String)this.attribute);
    }

    @Override
    public String toString() {
        return String.valueOf(this.attribute) + "=" + this.getPropertyValue();
    }
}

