/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.Locale;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.internal.productcmpt.AbstractSimplePropertyValue;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueSettings;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.AttributeType;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpt.IConfigElement;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Element;

public abstract class ConfigElement
extends AbstractSimplePropertyValue
implements IConfigElement {
    private final TemplateValueSettings templateValueSettings;
    private String policyAttribute = "";

    public ConfigElement(IPropertyValueContainer parent, String policyAttribute, String id) {
        super(parent, id);
        this.policyAttribute = policyAttribute;
        this.templateValueSettings = new TemplateValueSettings(this);
    }

    @Override
    public String getPropertyName() {
        return this.getPolicyCmptTypeAttribute();
    }

    @Override
    public String getName() {
        return this.getPropertyName();
    }

    @Override
    public IProductCmptProperty findProperty(IIpsProject ipsProject) {
        return this.findPcTypeAttribute(ipsProject);
    }

    @Override
    public String getPolicyCmptTypeAttribute() {
        return this.policyAttribute;
    }

    @Override
    public void setPolicyCmptTypeAttribute(String policyCmptTypeAttribute) {
        String oldAttribute = this.policyAttribute;
        this.policyAttribute = policyCmptTypeAttribute;
        this.valueChanged(oldAttribute, this.policyAttribute, "policyCmptTypeAttribute");
    }

    @Override
    public IPolicyCmptTypeAttribute findPcTypeAttribute(IIpsProject ipsProject) {
        IPolicyCmptType pcType = this.getPropertyValueContainer().findPolicyCmptType(ipsProject);
        if (pcType == null) {
            return null;
        }
        return pcType.findPolicyCmptTypeAttribute(this.getPolicyCmptTypeAttribute(), ipsProject);
    }

    @Override
    public ValueDatatype findValueDatatype(IIpsProject ipsProject) {
        IPolicyCmptTypeAttribute a = this.findPcTypeAttribute(ipsProject);
        if (a != null) {
            return a.findDatatype(ipsProject);
        }
        return null;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        IPolicyCmptTypeAttribute attribute = this.validateReferenceToAttribute(list, ipsProject);
        if (attribute == null) {
            return;
        }
        list.add(this.templateValueSettings.validate(this, ipsProject));
        boolean isDatatypeValid = this.validateDatatype(list, ipsProject, attribute);
        if (!isDatatypeValid) {
            return;
        }
        if (this.isValidateContent(attribute)) {
            this.validateContent(list, ipsProject, attribute);
        }
    }

    private IPolicyCmptTypeAttribute validateReferenceToAttribute(MessageList list, IIpsProject ipsProject) {
        IPolicyCmptTypeAttribute attribute = this.findPcTypeAttribute(ipsProject);
        if (attribute == null) {
            IPolicyCmptType policyCmptType = this.getPropertyValueContainer().findPolicyCmptType(ipsProject);
            if (policyCmptType == null) {
                String text = MessageFormat.format(Messages.ConfigElement_policyCmptTypeNotFound, this.getPolicyCmptTypeAttribute());
                list.add(new Message("CONFIGELEMENT-UnknownAttribute", text, Message.ERROR, (Object)this, new String[]{"policyCmptTypeAttribute"}));
            } else {
                String policyCmptTypeLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(policyCmptType);
                String text = MessageFormat.format(Messages.ConfigElement_msgAttrNotDefined, this.getPolicyCmptTypeAttribute(), policyCmptTypeLabel);
                list.add(new Message("CONFIGELEMENT-UnknownAttribute", text, Message.ERROR, (Object)this, new String[]{"policyCmptTypeAttribute"}));
            }
        }
        return attribute;
    }

    private boolean validateDatatype(MessageList list, IIpsProject ipsProject, IPolicyCmptTypeAttribute attribute) {
        ValueDatatype valueDatatype = attribute.findDatatype(ipsProject);
        Object[] params = new Object[]{attribute.getDatatype(), attribute.getName(), attribute.getPolicyCmptType().getName()};
        if (valueDatatype == null) {
            String text = MessageFormat.format(Messages.ConfigElement_msgUnknownDatatype, params);
            Severity severity = ipsProject.getReadOnlyProperties().getMissingDatatypeSeverity();
            list.add(new Message("CONFIGELEMENT-UnknownDatatype", text, severity, (Object)this, new String[]{"policyCmptTypeAttribute"}));
            return false;
        }
        if (valueDatatype.checkReadyToUse().containsErrorMsg()) {
            String text = MessageFormat.format(Messages.ConfigElement_msgInvalidDatatype, params);
            list.add(new Message("CONFIGELEMENT-InvalidDatatype", text, Message.ERROR, (Object)this, new String[]{"policyCmptTypeAttribute"}));
            return false;
        }
        return true;
    }

    protected boolean isValidateContent(IPolicyCmptTypeAttribute attribute) {
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return false;
        }
        return attribute.getAttributeType() == AttributeType.CHANGEABLE || attribute.getAttributeType() == AttributeType.CONSTANT;
    }

    protected abstract void validateContent(MessageList var1, IIpsProject var2, IPolicyCmptTypeAttribute var3) throws IpsException;

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.policyAttribute = element.getAttribute("attribute");
        if (IpsStringUtils.isEmpty((String)this.policyAttribute) && element.getParentNode() instanceof Element) {
            this.policyAttribute = ((Element)element.getParentNode()).getAttribute("attribute");
        }
        this.templateValueSettings.initPropertiesFromXml(element);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("attribute", this.getPolicyCmptTypeAttribute());
        this.templateValueSettings.propertiesToXml(element);
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        return null;
    }

    @Override
    protected void reinitPartCollectionsThis() {
    }

    public ValueDatatype getValueDatatype() {
        return this.findValueDatatype(this.getIpsProject());
    }

    public String getAttributeLabel(Locale locale) {
        String labelValue;
        IPolicyCmptTypeAttribute attribute = this.findPcTypeAttribute(this.getIpsProject());
        if (attribute != null && locale != null && IpsStringUtils.isNotEmpty((String)(labelValue = attribute.getLabelValue(locale)))) {
            return labelValue;
        }
        return this.getPropertyName();
    }

    @Override
    public TemplateValueStatus getTemplateValueStatus() {
        return this.templateValueSettings.getStatus();
    }

    @Override
    public void setTemplateValueStatus(TemplateValueStatus newStatus) {
        if (newStatus == TemplateValueStatus.DEFINED) {
            this.templateValueChanged();
        }
        TemplateValueStatus oldValue = this.templateValueSettings.getStatus();
        this.templateValueSettings.setStatus(newStatus);
        this.objectHasChanged(new PropertyChangeEvent(this, "templateValueStatus", (Object)oldValue, (Object)newStatus));
    }

    @Override
    public IPropertyValueContainer getPropertyValueContainer() {
        return (IPropertyValueContainer)this.getParent();
    }

    protected abstract void templateValueChanged();
}

