/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import java.util.Locale;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.productcmpt.ConfigElement;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueFinder;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpt.IConfiguredDefault;
import org.faktorips.devtools.model.productcmpt.IConfiguredValueSet;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfiguredDefault
extends ConfigElement
implements IConfiguredDefault {
    public static final String LEGACY_TAG_NAME = "Value";
    public static final String TAG_NAME = "ConfiguredDefault";
    private String value = "";

    public ConfiguredDefault(IPropertyValueContainer parent, String policyAttribute, String id) {
        super(parent, policyAttribute, id);
    }

    @Override
    public IConfiguredDefault findTemplateProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.findTemplateValue(this, IConfiguredDefault.class);
    }

    @Override
    public boolean hasTemplateForProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.hasTemplateForValue(this, IConfiguredDefault.class);
    }

    @Override
    public PropertyValueType getPropertyValueType() {
        return PropertyValueType.CONFIGURED_DEFAULT;
    }

    @Override
    public String getValue() {
        if (this.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            return this.findTemplateValue();
        }
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return "";
        }
        return this.value;
    }

    private String findTemplateValue() {
        IConfiguredDefault templateConfigElement = this.findTemplateProperty(this.getIpsProject());
        if (templateConfigElement == null) {
            return this.value;
        }
        return templateConfigElement.getValue();
    }

    @Override
    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        this.valueChanged(oldValue, this.value);
    }

    @Override
    public String getPropertyValue() {
        return this.getValue();
    }

    @Override
    protected void validateContent(MessageList list, IIpsProject ipsProject, IPolicyCmptTypeAttribute attribute) {
        ValueDatatype valueDatatype = attribute.findDatatype(ipsProject);
        String valueToValidate = this.getValue();
        if (ValidationUtils.checkParsable(valueDatatype, valueToValidate, attribute, MessageFormat.format(Messages.ConfiguredDefault_caption, attribute), list)) {
            this.validateValueVsValueSet(valueDatatype, ipsProject, list);
        }
    }

    private void validateValueVsValueSet(ValueDatatype valueDatatype, IIpsProject ipsProject, MessageList list) {
        String valueToValidate = this.getValue();
        IValueSet valueSetToValidate = this.getValueSet();
        if (IpsStringUtils.isNotBlank((String)valueToValidate) && valueSetToValidate != null && !valueSetToValidate.containsValue(valueToValidate, ipsProject)) {
            String formattedValue = IIpsModelExtensions.get().getModelPreferences().getDatatypeFormatter().formatValue(valueDatatype, valueToValidate);
            list.add(new Message("CONFIGUREDDEFAULT-ValueNotInValueSet", MessageFormat.format(Messages.ConfiguredDefault_msgValueNotInValueset, formattedValue), Message.ERROR, (Object)this, new String[]{"value"}));
        }
    }

    @Override
    public IValueSet getValueSet() {
        IPropertyValueContainer parent = this.getPropertyValueContainer();
        IConfiguredValueSet propertyValue = parent.getPropertyValue(this.getPropertyName(), IConfiguredValueSet.class);
        if (propertyValue == null) {
            return null;
        }
        return propertyValue.getValueSet();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        if (LEGACY_TAG_NAME.equals(element.getNodeName())) {
            super.initPropertiesFromXml(element, this.getNextPartId());
        } else {
            super.initPropertiesFromXml(element, id);
        }
        this.value = ValueToXmlHelper.getValueFromElement((Element)element);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        ValueToXmlHelper.setValue((String)this.getValue(), (Element)element);
    }

    @Override
    protected void templateValueChanged() {
        this.value = this.getValue();
    }

    @Override
    public String getCaption(Locale locale) {
        return MessageFormat.format(Messages.ConfiguredDefault_caption, this.getAttributeLabel(locale));
    }

    @Override
    public String getLastResortCaption() {
        return MessageFormat.format(Messages.ConfiguredDefault_caption, this.getAttributeLabel(null));
    }

    public String getValueInternal() {
        return this.value;
    }
}

