/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ValueSetNullIncompatibleValidator;
import org.faktorips.devtools.model.internal.productcmpt.ConfigElement;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueFinder;
import org.faktorips.devtools.model.internal.valueset.DelegatingValueSet;
import org.faktorips.devtools.model.internal.valueset.UnrestrictedValueSet;
import org.faktorips.devtools.model.internal.valueset.ValueSet;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpt.IConfiguredValueSet;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.valueset.IEnumValueSet;
import org.faktorips.devtools.model.valueset.IStringLengthValueSet;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.ValueSetType;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfiguredValueSet
extends ConfigElement
implements IConfiguredValueSet {
    public static final String LEGACY_TAG_NAME = "ValueSet";
    public static final String TAG_NAME = "ConfiguredValueSet";
    private IValueSet valueSet = new UnrestrictedValueSet(this, this.getNextPartId());

    public ConfiguredValueSet(IPropertyValueContainer parent, String policyAttribute, String id) {
        super(parent, policyAttribute, id);
    }

    @Override
    public IConfiguredValueSet findTemplateProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.findTemplateValue(this, IConfiguredValueSet.class);
    }

    public IValueSet getValueSetInternal() {
        return this.valueSet;
    }

    @Override
    public IValueSet getNonTemplateValueSet() {
        return this.valueSet;
    }

    @Override
    public boolean hasTemplateForProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.hasTemplateForValue(this, IConfiguredValueSet.class);
    }

    @Override
    public PropertyValueType getPropertyValueType() {
        return PropertyValueType.CONFIGURED_VALUESET;
    }

    @Override
    public IValueSet getPropertyValue() {
        return this.getValueSet();
    }

    @Override
    protected void validateContent(MessageList list, IIpsProject ipsProject, IPolicyCmptTypeAttribute attribute) {
        String text;
        String msgCode;
        IValueSet valueSetToValidate = this.getValueSet();
        IValueSet modelValueSet = attribute.getValueSet();
        if (modelValueSet.validate(ipsProject).containsErrorMsg()) {
            String text2 = Messages.ConfiguredValueSet_msgInvalidAttributeValueset;
            list.add(new Message("CONFIGUREDVALUESET-InvalidAttirbuteValueSet", text2, Message.WARNING, (Object)this, new String[]{"valueSet"}));
            return;
        }
        if (valueSetToValidate.isAbstract()) {
            String text3 = Messages.ConfiguredValueSet_error_msg_abstractValueSet;
            list.add(new Message("", text3, Message.ERROR, (Object)this, new String[]{"valueSet"}));
            return;
        }
        if (valueSetToValidate.isEnum()) {
            MessageList valueValidationResult;
            if (modelValueSet.isStringLength() && !(valueValidationResult = this.validateEnumValueStringLength(ipsProject, (IEnumValueSet)valueSetToValidate, (IStringLengthValueSet)modelValueSet)).isEmpty()) {
                list.add(valueValidationResult);
                return;
            }
            if (valueSetToValidate.isEmpty() && !modelValueSet.isContainsNull() && !modelValueSet.isAbstract()) {
                String text4 = MessageFormat.format(Messages.ConfiguredValueSet_error_msg_mandatoryAttribute, this.getPolicyCmptTypeAttribute());
                list.add(new Message("CONFIGUREDVALUESET-MandatoryValueSetIsEmpty", text4, Message.ERROR, (Object)this, new String[]{"valueSet"}));
                return;
            }
        }
        if (valueSetToValidate.isDetailedSpecificationOf(modelValueSet)) {
            return;
        }
        this.validateNullIncompatible(list, modelValueSet, valueSetToValidate);
        if (!valueSetToValidate.isSameTypeOfValueSet(modelValueSet)) {
            msgCode = "CONFIGUREDVALUESET-ValueSetTypeMismatch";
            text = MessageFormat.format(Messages.ConfigElement_msgTypeMismatch, modelValueSet.getValueSetType().getName(), valueSetToValidate.getValueSetType().getName());
        } else if (!modelValueSet.containsValueSet(valueSetToValidate)) {
            msgCode = "CONFIGUREDVALUESET-ValueSetIsNotASubset";
            text = MessageFormat.format(Messages.ConfigElement_valueSetIsNotASubset, valueSetToValidate.toShortString(), modelValueSet.toShortString());
        } else {
            throw new RuntimeException();
        }
        ArrayList<ObjectProperty> invalidObjectProperties = new ArrayList<ObjectProperty>();
        invalidObjectProperties.add(new ObjectProperty((Object)this, "valueSet"));
        if (valueSetToValidate.isRange()) {
            invalidObjectProperties.add(new ObjectProperty((Object)valueSetToValidate, "lowerBound"));
            invalidObjectProperties.add(new ObjectProperty((Object)valueSetToValidate, "upperBound"));
            invalidObjectProperties.add(new ObjectProperty((Object)valueSetToValidate, "step"));
        }
        ObjectProperty[] invalidOP = invalidObjectProperties.toArray(new ObjectProperty[invalidObjectProperties.size()]);
        list.add(new Message(msgCode, text, Message.ERROR, invalidOP));
    }

    private void validateNullIncompatible(MessageList list, IValueSet modelValueSet, IValueSet valueSetToValidate) {
        new ValueSetNullIncompatibleValidator(modelValueSet, valueSetToValidate).validateAndAppendMessages(list);
    }

    private MessageList validateEnumValueStringLength(IIpsProject ipsProject, IEnumValueSet enumValueSet, IStringLengthValueSet stringLengthValueSet) {
        MessageList messages = new MessageList();
        String[] values = enumValueSet.getValues();
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            if (!stringLengthValueSet.containsValue(value, ipsProject)) {
                String msgCode = "CONFIGUREDVALUESET-StringTooLong";
                String text = MessageFormat.format(Messages.ConfigElement_stringTooLong, value, String.valueOf(stringLengthValueSet.getParsedMaximumLength()));
                messages.add(Message.newError((String)msgCode, (String)text, (ObjectProperty[])new ObjectProperty[]{new ObjectProperty((Object)this, "valueSet"), new ObjectProperty((Object)enumValueSet, "values", i)}));
            }
            ++i;
        }
        return messages;
    }

    private IValueSet findTemplateValueSet() {
        IConfiguredValueSet templateConfigElement = this.findTemplateProperty(this.getIpsProject());
        if (templateConfigElement == null) {
            return this.valueSet;
        }
        return new DelegatingValueSet((ValueSet)templateConfigElement.getValueSet(), this);
    }

    @Override
    public List<ValueSetType> getAllowedValueSetTypes(IIpsProject ipsProject) {
        IPolicyCmptTypeAttribute attribute = this.findPcTypeAttribute(ipsProject);
        ArrayList<ValueSetType> types = new ArrayList<ValueSetType>();
        if (attribute == null) {
            types.add(this.valueSet.getValueSetType());
        } else if (attribute.getValueSet().isUnrestricted() || attribute.getValueSet().isDerived()) {
            List<ValueSetType> valueSetTypes = ipsProject.getValueSetTypes(attribute.findDatatype(ipsProject));
            valueSetTypes.remove((Object)ValueSetType.STRINGLENGTH);
            types.addAll(valueSetTypes);
        } else {
            ValueSetType attributeValueSetType = attribute.getValueSet().getValueSetType();
            types.add(attributeValueSetType);
            if (attributeValueSetType == ValueSetType.STRINGLENGTH) {
                types.add(ValueSetType.ENUM);
            }
        }
        types.removeIf(ValueSetType::isDerived);
        if (types.isEmpty()) {
            types.add(ValueSetType.UNRESTRICTED);
        }
        return types;
    }

    @Override
    public IEnumValueSet convertValueSetToEnumType() {
        if (this.valueSet.getValueSetType().equals((Object)ValueSetType.ENUM)) {
            return (IEnumValueSet)this.valueSet;
        }
        this.setValueSetType(ValueSetType.ENUM);
        IEnumValueSet newValueSet = (IEnumValueSet)this.valueSet;
        ValueDatatype valueSetDatatype = this.findValueDatatype(this.getIpsProject());
        if (Datatype.BOOLEAN.equals((Object)valueSetDatatype) || Datatype.PRIMITIVE_BOOLEAN.equals((Object)valueSetDatatype)) {
            newValueSet.addValue(Boolean.TRUE.toString());
            newValueSet.addValue(Boolean.FALSE.toString());
            if (!valueSetDatatype.isPrimitive()) {
                newValueSet.addValue(null);
            }
        }
        return newValueSet;
    }

    @Override
    public IValueSet getValueSet() {
        if (this.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            return this.findTemplateValueSet();
        }
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return new UnrestrictedValueSet(this, this.getNextPartId());
        }
        return this.valueSet;
    }

    @Override
    public void setValueSetType(ValueSetType type) {
        IValueSet oldset = this.valueSet;
        IValueSet modelValueSet = this.findModelValueSet();
        this.valueSet = modelValueSet != null && modelValueSet.getValueSetType().equals((Object)type) ? modelValueSet.copy(this, this.getNextPartId()) : type.newValueSet(this, this.getNextPartId());
        this.valueChanged(oldset, this.valueSet);
    }

    private IValueSet findModelValueSet() {
        IPolicyCmptTypeAttribute attribute = this.findPcTypeAttribute(this.valueSet.getIpsProject());
        return attribute == null ? null : attribute.getValueSet();
    }

    @Override
    public IValueSet changeValueSetType(ValueSetType newType) {
        this.setValueSetType(newType);
        return this.valueSet;
    }

    @Override
    public void setValueSetCopy(IValueSet source) {
        IValueSet oldset = this.valueSet;
        this.valueSet = source.copy(this, this.getNextPartId());
        this.valueChanged(oldset, this.valueSet);
    }

    @Override
    public void setValueSet(IValueSet source) {
        this.setValueSetCopy(source);
    }

    @Override
    public boolean isValueSetUpdateable() {
        return true;
    }

    @Override
    public void templateValueChanged() {
        this.valueSet = this.getValueSet().copy(this, this.getNextPartId());
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement(TAG_NAME);
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if (LEGACY_TAG_NAME.equals(xmlTagName)) {
            this.valueSet = ValueSetType.newValueSet(xmlTag, this, id);
            return this.valueSet;
        }
        return null;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        if (LEGACY_TAG_NAME.equals(element.getNodeName())) {
            super.initPropertiesFromXml(element, this.getNextPartId());
            IIpsObjectPart newPart = this.newPart(element, id);
            newPart.initFromXml(element);
        } else {
            super.initPropertiesFromXml(element, id);
        }
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof IValueSet) {
            this.valueSet = null;
            return true;
        }
        return false;
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof IValueSet) {
            this.valueSet = (IValueSet)part;
            return true;
        }
        return false;
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        if (this.getValueSet() != null) {
            return new IIpsElement[]{this.getValueSet()};
        }
        return new IIpsElement[0];
    }

    @Override
    public String getCaption(Locale locale) {
        return MessageFormat.format(Messages.ConfiguredValueSet_caption, this.isDerivedAttribute() ? "/ " : "", this.getAttributeLabel(locale));
    }

    @Override
    public String getLastResortCaption() {
        return MessageFormat.format(Messages.ConfiguredValueSet_caption, this.isDerivedAttribute() ? "/ " : "", this.getAttributeLabel(null));
    }

    private boolean isDerivedAttribute() {
        IPolicyCmptTypeAttribute attribute = this.findPcTypeAttribute(this.getIpsProject());
        if (attribute != null) {
            IValueSet attributeValueSet = attribute.getValueSet();
            return attributeValueSet != null && attributeValueSet.isDerived();
        }
        return false;
    }
}

