/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ipsproject.IpsPackageFragment;
import org.faktorips.devtools.model.internal.productcmpt.IDeepCopyOperationFixup;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.tablecontents.TableContents;
import org.faktorips.devtools.model.ipsobject.IIpsObject;
import org.faktorips.devtools.model.ipsobject.IIpsObjectGeneration;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.ITimedIpsObject;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragmentRoot;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptStructureReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptStructureTblUsageReference;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptTypeAssociationReference;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.tablecontents.ITableContents;

public class DeepCopyOperation
implements ICoreRunnable {
    private final Set<IProductCmptStructureReference> copyElements;
    private final Set<IProductCmptStructureReference> linkElements;
    private final Map<IProductCmptStructureReference, IIpsSrcFile> handleMap;
    private boolean createEmptyTableContents = false;
    private boolean copyExistingGenerations = false;
    private IIpsPackageFragmentRoot ipsPackageFragmentRoot;
    private IIpsPackageFragment sourceIpsPackageFragment;
    private IIpsPackageFragment targetIpsPackageFragment;
    private final IProductCmptReference structureRoot;
    private final GregorianCalendar oldValidFrom;
    private final GregorianCalendar newValidFrom;

    public DeepCopyOperation(IProductCmptReference structureRoot, Set<IProductCmptStructureReference> copyElements, Set<IProductCmptStructureReference> linkElements, Map<IProductCmptStructureReference, IIpsSrcFile> handleMap, GregorianCalendar oldValidFrom, GregorianCalendar newValidFrom) {
        this.structureRoot = structureRoot;
        this.copyElements = copyElements;
        this.linkElements = linkElements;
        this.handleMap = handleMap;
        this.oldValidFrom = oldValidFrom;
        this.newValidFrom = newValidFrom;
    }

    public void setIpsPackageFragmentRoot(IIpsPackageFragmentRoot ipsPackageFragmentRoot) {
        this.ipsPackageFragmentRoot = ipsPackageFragmentRoot;
    }

    public void setSourceIpsPackageFragment(IIpsPackageFragment ipsPackageFragment) {
        this.sourceIpsPackageFragment = ipsPackageFragment;
    }

    public void setTargetIpsPackageFragment(IIpsPackageFragment ipsPackageFragment) {
        this.targetIpsPackageFragment = ipsPackageFragment;
    }

    public void setCreateEmptyTableContents(boolean createEmptyTableContents) {
        this.createEmptyTableContents = createEmptyTableContents;
    }

    public void setCopyExistingGenerations(boolean copyExistingGenerations) {
        this.copyExistingGenerations = copyExistingGenerations;
    }

    /*
     * WARNING - void declaration
     */
    public void run(IProgressMonitor progressMonitor) {
        IProgressMonitor monitor = progressMonitor;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.DeepCopyOperation_taskTitle, 2 + this.copyElements.size() * 2 + this.linkElements.size());
        monitor.worked(1);
        Set<Object> objectsToRefer = this.collectObjectsToRefer();
        HashMap<TblContentUsageData, String> tblContentData2newTableContentQName = new HashMap<TblContentUsageData, String>();
        HashMap<LinkData, String> linkData2newProductCmptQName = new HashMap<LinkData, String>();
        Hashtable<IProductCmpt, IProductCmpt> productNew2ProductOld = new Hashtable<IProductCmpt, IProductCmpt>();
        ArrayList<IIpsObject> newIpsObjects = new ArrayList<IIpsObject>();
        for (IProductCmptStructureReference element : this.copyElements) {
            IIpsObject newIpsObject = this.createNewIpsObjectIfNecessary(element, productNew2ProductOld, this.oldValidFrom, this.newValidFrom, monitor);
            newIpsObjects.add(newIpsObject);
            IProductCmptStructureReference iProductCmptStructureReference = element;
            if (iProductCmptStructureReference instanceof IProductCmptReference) {
                void productCmptReference;
                IProductCmptReference cfr_ignored_0 = (IProductCmptReference)iProductCmptStructureReference;
                IProductCmptReference cfr_ignored_1 = (IProductCmptReference)iProductCmptStructureReference;
                this.storeLinkToNewNewProductCmpt((IProductCmptReference)productCmptReference, newIpsObject.getQualifiedName(), linkData2newProductCmptQName);
            } else {
                IProductCmptStructureReference iProductCmptStructureReference2 = element;
                if (iProductCmptStructureReference2 instanceof IProductCmptStructureTblUsageReference) {
                    void productCmptStructureTblUsageReference;
                    IProductCmptStructureTblUsageReference cfr_ignored_2 = (IProductCmptStructureTblUsageReference)iProductCmptStructureReference2;
                    IProductCmptStructureTblUsageReference cfr_ignored_3 = (IProductCmptStructureTblUsageReference)iProductCmptStructureReference2;
                    this.storeTableUsageToNewTableContents((IProductCmptStructureTblUsageReference)productCmptStructureTblUsageReference, newIpsObject.getQualifiedName(), tblContentData2newTableContentQName);
                }
            }
            monitor.worked(1);
        }
        List<IDeepCopyOperationFixup> additionalFixups = this.getAdditionalFixups();
        for (Map.Entry entry : productNew2ProductOld.entrySet()) {
            final IProductCmpt productCmptNew = (IProductCmpt)entry.getKey();
            final IProductCmpt productCmptTemplate = (IProductCmpt)entry.getValue();
            this.fixLinks(productCmptNew, productCmptTemplate, linkData2newProductCmptQName, tblContentData2newTableContentQName, objectsToRefer);
            for (final IDeepCopyOperationFixup fixup : additionalFixups) {
                ISafeRunnable runnable = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        IpsLog.log(exception);
                    }

                    public void run() throws Exception {
                        fixup.fix(productCmptNew, productCmptTemplate);
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }
        for (IIpsObject iIpsObject : newIpsObjects) {
            IIpsSrcFile ipsSrcFile = iIpsObject.getIpsSrcFile();
            ipsSrcFile.save(monitor);
            monitor.worked(1);
        }
        if (newIpsObjects.size() == 0) {
            throw new RuntimeException("No copied root found!");
        }
        this.copySortOrder(productNew2ProductOld, monitor);
        monitor.done();
    }

    void copySortOrder(Map<IProductCmpt, IProductCmpt> productNew2ProductOld, IProgressMonitor monitor) {
        HashMap<IIpsSrcFile, IIpsSrcFile> old2NewSrcFile = new HashMap<IIpsSrcFile, IIpsSrcFile>(productNew2ProductOld.size());
        for (Map.Entry<IProductCmpt, IProductCmpt> entry : productNew2ProductOld.entrySet()) {
            old2NewSrcFile.put(entry.getValue().getIpsSrcFile(), entry.getKey().getIpsSrcFile());
        }
        try {
            this.copySortOrder(this.sourceIpsPackageFragment, this.targetIpsPackageFragment, old2NewSrcFile, monitor);
        }
        catch (IpsException e) {
            throw new IpsException("Exception occured during sort order copying.", e);
        }
    }

    private void copySortOrder(IIpsPackageFragment sourceParent, IIpsPackageFragment targetParent, Map<IIpsSrcFile, IIpsSrcFile> old2NewSrcFile, IProgressMonitor monitor) {
        Comparator<IIpsElement> targetComparator;
        Comparator<IIpsElement> sourceComparator = sourceParent.getChildOrderComparator();
        if (sourceComparator instanceof IpsPackageFragment.DefinedOrderComparator && !((targetComparator = targetParent.getChildOrderComparator()) instanceof IpsPackageFragment.DefinedOrderComparator)) {
            this.copySortOrder(((IpsPackageFragment.DefinedOrderComparator)sourceComparator).getElements(), old2NewSrcFile, targetParent);
        }
        IIpsPackageFragment[] iIpsPackageFragmentArray = sourceParent.getChildIpsPackageFragments();
        int n = iIpsPackageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragment fragment = iIpsPackageFragmentArray[n2];
            IIpsPackageFragment destination = targetParent.getSubPackage(fragment.getLastSegmentName());
            if (destination.exists()) {
                this.copySortOrder(fragment, destination, old2NewSrcFile, monitor);
            }
            ++n2;
        }
    }

    protected void copySortOrder(IIpsElement[] elements, Map<IIpsSrcFile, IIpsSrcFile> old2NewSrcFile, IIpsPackageFragment targetParent) {
        ArrayList<IIpsElement> copiedElements = new ArrayList<IIpsElement>(elements.length);
        IIpsElement[] iIpsElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsPackageFragment subPackage;
            IIpsElement element = iIpsElementArray[n2];
            if (element instanceof IIpsSrcFile) {
                IIpsElement newElement = old2NewSrcFile.get(element);
                if (newElement != null) {
                    copiedElements.add(newElement);
                }
            } else if (element instanceof IIpsPackageFragment && (subPackage = targetParent.getSubPackage(((IIpsPackageFragment)element).getLastSegmentName())).exists()) {
                copiedElements.add(subPackage);
            }
            ++n2;
        }
        if (!copiedElements.isEmpty()) {
            ((IpsPackageFragment)targetParent).setChildOrderComparator(new IpsPackageFragment.DefinedOrderComparator(copiedElements.toArray(new IIpsElement[copiedElements.size()])));
        }
    }

    public List<IDeepCopyOperationFixup> getAdditionalFixups() {
        return IIpsModelExtensions.get().getDeepCopyOperationFixups();
    }

    private IIpsObject createNewIpsObjectIfNecessary(IProductCmptStructureReference toCopyProductCmptStructureReference, Hashtable<IProductCmpt, IProductCmpt> productNew2ProductOld, GregorianCalendar oldValidFrom, GregorianCalendar newValidFrom, IProgressMonitor monitor) {
        IIpsObject newIpsObject;
        IIpsSrcFile file;
        IIpsObject templateObject;
        block8: {
            templateObject = toCopyProductCmptStructureReference.getWrappedIpsObject();
            file = this.handleMap.get(toCopyProductCmptStructureReference);
            if (!file.exists()) {
                IIpsPackageFragment targetPackage = this.createTargetPackage(file, monitor);
                String newName = file.getName().substring(0, file.getName().lastIndexOf(46));
                boolean createEmptyFile = false;
                if (this.createEmptyTableContents && IpsObjectType.TABLE_CONTENTS.equals(templateObject.getIpsObjectType())) {
                    createEmptyFile = true;
                }
                if (!createEmptyFile) {
                    try {
                        file = templateObject.createCopy(targetPackage, newName, false, monitor);
                        if (!(templateObject instanceof ITimedIpsObject)) break block8;
                        if (this.copyExistingGenerations) {
                            ((ITimedIpsObject)file.getIpsObject()).reassignGenerations(newValidFrom);
                            break block8;
                        }
                        ((ITimedIpsObject)file.getIpsObject()).retainOnlyGeneration(oldValidFrom, newValidFrom);
                    }
                    catch (IpsException e) {
                        createEmptyFile = true;
                    }
                } else {
                    file = targetPackage.createIpsFile(templateObject.getIpsObjectType(), newName, false, monitor);
                    TableContents ipsObject = (TableContents)file.getIpsObject();
                    this.setPropertiesFromTemplate(templateObject, ipsObject);
                }
            }
        }
        if ((newIpsObject = file.getIpsObject()) instanceof IProductCmpt) {
            productNew2ProductOld.put((IProductCmpt)newIpsObject, (IProductCmpt)templateObject);
        }
        return newIpsObject;
    }

    private void storeTableUsageToNewTableContents(IProductCmptStructureTblUsageReference productCmptStructureReference, String newTableContentsQName, Map<TblContentUsageData, String> tblContentData2newTableContentQName) {
        ITableContentUsage tblContentUsageOld = productCmptStructureReference.getTableContentUsage();
        tblContentData2newTableContentQName.put(new TblContentUsageData(tblContentUsageOld), newTableContentsQName);
    }

    private void storeLinkToNewNewProductCmpt(IProductCmptReference productCmptStructureReference, String newProductCmptQName, Map<LinkData, String> linkData2newProductCmptQName) {
        IProductCmptTypeAssociationReference parent = productCmptStructureReference.getParent();
        IProductCmpt productCmpt = productCmptStructureReference.getProductCmpt();
        if (parent instanceof IProductCmptTypeAssociationReference) {
            IProductCmptTypeAssociation productCmptTypeAssociationOld = parent.getAssociation();
            IProductCmpt parentProductCmpt = ((IProductCmptReference)parent.getParent()).getProductCmpt();
            linkData2newProductCmptQName.put(new LinkData(parentProductCmpt, productCmpt, productCmptTypeAssociationOld), newProductCmptQName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<Object> collectObjectsToRefer() {
        HashSet<Object> tblContentUsageAndLinkDataRefer = new HashSet<Object>();
        for (IProductCmptStructureReference productCmptStructureReference : this.linkElements) {
            IProductCmptStructureReference iProductCmptStructureReference = productCmptStructureReference;
            if (iProductCmptStructureReference instanceof IProductCmptStructureTblUsageReference) {
                void productCmptStructureTblUsageReference;
                IProductCmptStructureTblUsageReference cfr_ignored_0 = (IProductCmptStructureTblUsageReference)iProductCmptStructureReference;
                IProductCmptStructureTblUsageReference cfr_ignored_1 = (IProductCmptStructureTblUsageReference)iProductCmptStructureReference;
                IProductCmptStructureReference parent = productCmptStructureTblUsageReference.getParent();
                if (this.linkElements.contains(parent)) continue;
                tblContentUsageAndLinkDataRefer.add(new TblContentUsageData(productCmptStructureTblUsageReference.getTableContentUsage()));
                continue;
            }
            IProductCmptTypeAssociationReference parentTypeRel = (IProductCmptTypeAssociationReference)productCmptStructureReference.getParent();
            IProductCmptStructureReference parent = parentTypeRel.getParent();
            tblContentUsageAndLinkDataRefer.add(new LinkData((IProductCmpt)parent.getWrappedIpsObject(), (IProductCmpt)productCmptStructureReference.getWrappedIpsObject(), parentTypeRel.getAssociation()));
        }
        return tblContentUsageAndLinkDataRefer;
    }

    private void fixLinks(IProductCmpt productCmptNew, IProductCmpt productCmptTemplate, Map<LinkData, String> linkData2newProductCmptQName, Map<TblContentUsageData, String> tblContentData2newTableContentQName, Set<Object> objectsToRefer) {
        if (this.copyExistingGenerations) {
            IIpsObjectGeneration[] iIpsObjectGenerationArray = productCmptNew.getGenerationsOrderedByValidDate();
            int n = iIpsObjectGenerationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIpsObjectGeneration objectGeneration = iIpsObjectGenerationArray[n2];
                IProductCmptGeneration generation = (IProductCmptGeneration)objectGeneration;
                this.fixLinksToTableContents(productCmptNew, productCmptTemplate, tblContentData2newTableContentQName, objectsToRefer, generation.getTableContentUsages());
                this.fixLinksToProductCmpt(productCmptNew, productCmptTemplate, linkData2newProductCmptQName, objectsToRefer, generation);
                ++n2;
            }
        } else {
            IProductCmptGeneration generation = (IProductCmptGeneration)productCmptNew.getGenerationsOrderedByValidDate()[0];
            this.fixLinksToTableContents(productCmptNew, productCmptTemplate, tblContentData2newTableContentQName, objectsToRefer, generation.getTableContentUsages());
            this.fixLinksToProductCmpt(productCmptNew, productCmptTemplate, linkData2newProductCmptQName, objectsToRefer, generation);
        }
        this.fixLinksToTableContents(productCmptNew, productCmptTemplate, tblContentData2newTableContentQName, objectsToRefer, productCmptNew.getTableContentUsages());
    }

    private void fixLinksToTableContents(IProductCmpt productCmptNew, IProductCmpt productCmptTemplate, Map<TblContentUsageData, String> tblContentData2newTableContentQName, Set<Object> objectsToRefer, ITableContentUsage[] tableContentUsages) {
        ITableContentUsage[] iTableContentUsageArray = tableContentUsages;
        int n = tableContentUsages.length;
        int n2 = 0;
        while (n2 < n) {
            ITableContentUsage tableContentUsage = iTableContentUsageArray[n2];
            TblContentUsageData tblContentsData = new TblContentUsageData(productCmptTemplate, tableContentUsage.getTableContentName());
            if (!objectsToRefer.contains(tblContentsData)) {
                String newTarget = tblContentData2newTableContentQName.get(tblContentsData);
                tableContentUsage.setTableContentName(newTarget == null ? "" : newTarget);
            }
            ++n2;
        }
    }

    private void fixLinksToProductCmpt(IProductCmpt productCmptNew, IProductCmpt productCmptTemplate, Map<LinkData, String> linkData2newProductCmptQName, Set<Object> objectsToRefer, IProductCmptGeneration generation) {
        List<IProductCmptLink> links = generation.getLinksIncludingProductCmpt();
        for (IProductCmptLink link : links) {
            LinkData linkData;
            try {
                IIpsProject ipsProject = productCmptTemplate.getIpsProject();
                IProductCmpt oldTargetProductCmpt = link.findTarget(ipsProject);
                linkData = new LinkData(productCmptTemplate, oldTargetProductCmpt, link.findAssociation(ipsProject));
            }
            catch (IpsException e) {
                IpsLog.logAndShowErrorDialog((Exception)((Object)e));
                return;
            }
            String newTarget = linkData2newProductCmptQName.get(linkData);
            if (newTarget != null) {
                link.setTarget(newTarget);
                continue;
            }
            if (objectsToRefer.contains(linkData)) continue;
            link.delete();
        }
    }

    private void setPropertiesFromTemplate(IIpsObject template, IIpsObject newObject) {
        if (template instanceof IProductCmpt) {
            ((IProductCmpt)newObject).setProductCmptType(((IProductCmpt)template).getProductCmptType());
        } else if (template instanceof ITableContents) {
            ((ITableContents)newObject).setTableStructure(((ITableContents)template).getTableStructure());
            ((TableContents)newObject).setNumOfColumnsInternal(((ITableContents)template).getNumOfColumns());
        }
    }

    private IIpsPackageFragment createTargetPackage(IIpsSrcFile file, IProgressMonitor monitor) {
        String path = file.getIpsPackageFragment().getRelativePath().toString().replace('/', '.');
        return this.ipsPackageFragmentRoot.createPackageFragment(path, false, monitor);
    }

    public IIpsSrcFile getCopiedRoot() {
        return this.handleMap.get(this.structureRoot);
    }

    private class LinkData {
        private IProductCmpt sourceProductCmpt;
        private IProductCmpt targetProductCmpt;
        private IProductCmptTypeAssociation productCmptTypeAssociation;

        public LinkData(IProductCmpt sourceProductCmpt, IProductCmpt targetProductCmpt, IProductCmptTypeAssociation productCmptTypeAssociation) {
            this.sourceProductCmpt = sourceProductCmpt;
            this.targetProductCmpt = targetProductCmpt;
            this.productCmptTypeAssociation = productCmptTypeAssociation;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.productCmptTypeAssociation == null ? 0 : this.productCmptTypeAssociation.hashCode());
            result = 31 * result + (this.sourceProductCmpt == null ? 0 : this.sourceProductCmpt.hashCode());
            return 31 * result + (this.targetProductCmpt == null ? 0 : this.targetProductCmpt.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LinkData other = (LinkData)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return Objects.equals(this.productCmptTypeAssociation, other.productCmptTypeAssociation) && Objects.equals(this.sourceProductCmpt, other.sourceProductCmpt) && Objects.equals(this.targetProductCmpt, other.targetProductCmpt);
        }

        private DeepCopyOperation getOuterType() {
            return DeepCopyOperation.this;
        }
    }

    private static class TblContentUsageData {
        private IProductCmpt productCmpt;
        private String tableUsageName;

        public TblContentUsageData(ITableContentUsage tblContentUsage) {
            this(tblContentUsage.getProductCmpt(), tblContentUsage.getTableContentName());
        }

        public TblContentUsageData(IProductCmpt productCmpt, String tableUsageName) {
            this.productCmpt = productCmpt;
            this.tableUsageName = tableUsageName;
        }

        public IProductCmpt getProductCmpt() {
            return this.productCmpt;
        }

        public String getTableUsageName() {
            return this.tableUsageName;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            void castOther;
            Object object;
            if (this == other) {
                return true;
            }
            if (other == null || !((object = other) instanceof TblContentUsageData)) {
                return false;
            }
            TblContentUsageData tblContentUsageData = (TblContentUsageData)object;
            TblContentUsageData cfr_ignored_0 = (TblContentUsageData)object;
            return this.getProductCmpt() != null && this.getProductCmpt().equals(castOther.getProductCmpt()) && this.getTableUsageName() != null && this.getTableUsageName().equals(castOther.getTableUsageName());
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.productCmpt.hashCode();
            return 37 * result + this.tableUsageName.hashCode();
        }
    }
}

