/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.List;
import java.util.Objects;
import org.faktorips.devtools.model.internal.productcmpt.AbstractValueHolder;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.value.ValueType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.Severity;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DelegatingValueHolder<T>
implements IValueHolder<T> {
    private final IAttributeValue parent;
    private final AbstractValueHolder<T> delegate;

    public DelegatingValueHolder(IAttributeValue parent, AbstractValueHolder<T> delegate) {
        this.parent = Objects.requireNonNull(parent);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public Element toXml(Document doc) {
        return this.delegate.toXml(doc);
    }

    @Override
    public void initFromXml(Element element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(IIpsProject ipsProject) {
        return this.getValidationResultSeverity(ipsProject) != Severity.ERROR;
    }

    @Override
    public Severity getValidationResultSeverity(IIpsProject ipsProject) {
        return this.validate(ipsProject).getSeverity();
    }

    @Override
    public MessageList validate(IIpsProject ipsProject) {
        return this.delegate.newValidator(this.parent, ipsProject).validate();
    }

    @Override
    public IIpsProject getIpsProject() {
        return this.parent.getIpsProject();
    }

    @Override
    public int compareTo(IValueHolder<T> o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        return this.delegate.compareTo(o);
    }

    public int hashCode() {
        return 31 + this.delegate.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return this.delegate.equals(((DelegatingValueHolder)o).delegate);
    }

    @Override
    public boolean equalsValueHolder(IValueHolder<?> o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof DelegatingValueHolder) {
            return this.delegate.equals(((DelegatingValueHolder)o).delegate);
        }
        return this.delegate.equals(o);
    }

    @Override
    public IAttributeValue getParent() {
        return this.parent;
    }

    @Override
    public String getStringValue() {
        return this.delegate.getStringValue();
    }

    @Override
    public T getValue() {
        return this.delegate.getValue();
    }

    @Override
    public void setValue(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IValue<?>> getValueList() {
        return this.delegate.getValueList();
    }

    @Override
    public void setValueList(List<IValue<?>> values) {
        this.delegate.setValueList(values);
    }

    @Override
    public boolean isNullValue() {
        return this.delegate.isNullValue();
    }

    @Override
    public ValueType getValueType() {
        return this.delegate.getValueType();
    }

    @Override
    public boolean isMultiValue() {
        return this.delegate.isMultiValue();
    }

    public IValueHolder<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public IValueHolder<?> copy(IAttributeValue parent) {
        return this.delegate.copy(parent);
    }

    public static <U> DelegatingValueHolder<U> of(IAttributeValue parent, IValueHolder<U> delegate) {
        ArgumentCheck.isInstanceOf(delegate, AbstractValueHolder.class, (Object)"Can only delegate to AbstractValueHolder");
        return new DelegatingValueHolder(parent, (AbstractValueHolder)delegate);
    }
}

