/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.EnumDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.builder.ExtendedExprCompiler;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.internal.fl.TableUsageFunctionsResolver;
import org.faktorips.devtools.model.internal.ipsobject.BaseIpsObjectPart;
import org.faktorips.devtools.model.internal.productcmpt.ExpressionDependencyCollector;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.ILabeledElement;
import org.faktorips.devtools.model.ipsproject.IIpsArtefactBuilderSet;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.method.IBaseMethod;
import org.faktorips.devtools.model.method.IFormulaMethod;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.devtools.model.productcmpt.IExpressionDependencyDetail;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IOverridableLabeledElement;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.fl.CompilationResult;
import org.faktorips.fl.ExprCompiler;
import org.faktorips.fl.IdentifierResolver;
import org.faktorips.fl.JavaExprCompiler;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.ValueToXmlHelper;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Expression
extends BaseIpsObjectPart
implements IExpression {
    private String formulaSignature = "";
    private String expression = "";

    public Expression(IIpsObjectPartContainer parent, String id) {
        super(parent, id);
        this.addTagToIgnore("Expression");
    }

    public Expression(IIpsObjectPartContainer parent, String id, String formulaSignature) {
        super(parent, id);
        this.formulaSignature = formulaSignature;
        this.addTagToIgnore("Expression");
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Formula");
    }

    @Override
    public String getName() {
        return this.formulaSignature;
    }

    @Override
    public abstract IProductCmptType findProductCmptType(IIpsProject var1);

    @Override
    public List<IAttribute> findMatchingProductCmptTypeAttributes() {
        IProductCmptType productCmptType = this.findProductCmptType(this.getIpsProject());
        if (productCmptType != null) {
            return productCmptType.findAllAttributes(this.getIpsProject());
        }
        return Collections.emptyList();
    }

    @Override
    public String getFormulaSignature() {
        return this.formulaSignature;
    }

    @Override
    public void setFormulaSignature(String newName) {
        String oldName = this.formulaSignature;
        this.formulaSignature = newName;
        this.valueChanged(oldName, newName);
    }

    @Override
    public ValueDatatype findValueDatatype(IIpsProject ipsProject) {
        Datatype datatype;
        IFormulaMethod signature = this.findFormulaSignature(ipsProject);
        if (signature != null && (datatype = signature.findDatatype(ipsProject)).isValueDatatype()) {
            return (ValueDatatype)datatype;
        }
        return null;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String newExpression) {
        String oldExpr = this.expression;
        this.setExpressionInternal(newExpression);
        this.valueChanged(oldExpr, newExpression);
    }

    void setExpressionInternal(String newExpression) {
        this.expression = newExpression;
    }

    @Override
    public boolean isEmpty() {
        return IpsStringUtils.isEmpty((String)this.getExpression());
    }

    @Override
    public JavaExprCompiler newExprCompiler(IIpsProject ipsProject) {
        ExtendedExprCompiler compiler = ipsProject.newExpressionCompiler();
        compiler.add(new TableUsageFunctionsResolver(ipsProject, this.getTableContentUsages()));
        IIpsArtefactBuilderSet builderSet = ipsProject.getIpsArtefactBuilderSet();
        IFormulaMethod method = this.findFormulaSignature(ipsProject);
        if (method == null) {
            return compiler;
        }
        IdentifierResolver<JavaCodeFragment> resolver = builderSet.createFlIdentifierResolver(this, (ExprCompiler<JavaCodeFragment>)compiler);
        if (resolver == null) {
            return compiler;
        }
        compiler.setIdentifierResolver(resolver);
        return compiler;
    }

    protected abstract ITableContentUsage[] getTableContentUsages();

    @Override
    public EnumDatatype[] getEnumDatatypesAllowedInFormula() {
        HashMap<String, EnumDatatype> enumtypes = new HashMap<String, EnumDatatype>();
        this.collectAllEnumDatatypes(enumtypes);
        return enumtypes.values().toArray(new EnumDatatype[enumtypes.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private void collectAllEnumDatatypes(Map<String, EnumDatatype> nameToTypeMap) {
        Datatype[] datatypes;
        IIpsProject ipsProject = this.getIpsProject();
        Datatype[] datatypeArray = datatypes = ipsProject.findDatatypes(true, false);
        int n = datatypes.length;
        int n2 = 0;
        while (n2 < n) {
            Datatype datatype = datatypeArray[n2];
            Datatype datatype2 = datatype;
            if (datatype2 instanceof EnumDatatype) {
                void enumDatatyp;
                EnumDatatype cfr_ignored_0 = (EnumDatatype)datatype2;
                EnumDatatype cfr_ignored_1 = (EnumDatatype)datatype2;
                nameToTypeMap.put(enumDatatyp.getName(), (EnumDatatype)enumDatatyp);
            }
            ++n2;
        }
    }

    private void searchAndAdd(IIpsProject ipsProject, String datatypeName, Map<String, EnumDatatype> types) {
        if (types.containsKey(datatypeName)) {
            return;
        }
        ValueDatatype datatype = ipsProject.findValueDatatype(datatypeName);
        if (datatype instanceof EnumDatatype) {
            types.put(datatypeName, (EnumDatatype)datatype);
        }
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.formulaSignature = element.getAttribute("formulaSignature");
        this.expression = ValueToXmlHelper.getValueFromElement((Element)element, (String)"Expression");
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("formulaSignature", this.formulaSignature);
        ValueToXmlHelper.addValueToElement((String)(this.getExpression() == null ? "" : this.getExpression().trim()), (Element)element, (String)"Expression");
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        IFormulaMethod method = this.findFormulaSignature(ipsProject);
        if (method == null) {
            String text = Messages.Formula_msgFormulaSignatureMissing;
            list.add(new Message("CONFIGELEMENT-SignatureCantBeFound", text, Message.ERROR, (Object)this, new String[]{"expression"}));
            return;
        }
        String expressionToValidate = this.getExpression();
        if (IpsStringUtils.isEmpty((String)expressionToValidate)) {
            if (!this.isFormulaMandatory()) {
                return;
            }
            String text = MessageFormat.format(Messages.Formula_msgExpressionMissing, this.getFormulaSignature());
            list.add(new Message("CONFIGELEMENT-ExpressionIsEmpty", text, Message.ERROR, (Object)this, new String[]{"expression"}));
            return;
        }
        Datatype signatureDatatype = method.findDatatype(ipsProject);
        this.validateDatatype(list, signatureDatatype, method);
        if (list.containsErrorMsg()) {
            return;
        }
        JavaExprCompiler compiler = this.newExprCompiler(ipsProject);
        CompilationResult result = compiler.compile(expressionToValidate);
        this.validateCompilationResult(list, (CompilationResult<JavaCodeFragment>)result);
        if (list.containsErrorMsg() || signatureDatatype.equals(result.getDatatype()) || compiler.getConversionCodeGenerator().canConvert(result.getDatatype(), signatureDatatype)) {
            return;
        }
        String text = MessageFormat.format(Messages.Formula_msgWrongReturntype, signatureDatatype, result.getDatatype().getName());
        list.add(new Message("CONFIGELEMENT-WrongFormulaDatatype", text, Message.ERROR, (Object)this, new String[]{"expression"}));
    }

    private void validateDatatype(MessageList list, Datatype signatureDatatype, IBaseMethod method) {
        if (signatureDatatype == null) {
            String text = MessageFormat.format(Messages.FormulaElement_msgDatatypeMissing, method.getDatatype(), this.formulaSignature);
            list.add(new Message("CONFIGELEMENT-UnknownDatatypeFormula", text, Message.ERROR, (Object)this, new String[]{"expression"}));
        }
    }

    private void validateCompilationResult(MessageList list, CompilationResult<JavaCodeFragment> result) {
        if (!result.successfull()) {
            MessageList compilerMessageList = result.getMessages();
            int i = 0;
            while (i < compilerMessageList.size()) {
                Message msg = compilerMessageList.getMessage(i);
                list.add(new Message(msg.getCode(), msg.getText(), msg.getSeverity(), (Object)this, new String[]{"expression"}));
                ++i;
            }
        }
    }

    @Override
    public String getCaption(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        String caption = null;
        IFormulaMethod signature = this.findFormulaSignature(this.getIpsProject());
        if (signature != null) {
            caption = signature instanceof IOverridableLabeledElement ? ((IOverridableLabeledElement)((Object)signature)).getLabelValueFromThisOrSuper(locale) : (signature instanceof ILabeledElement ? ((ILabeledElement)signature).getLabelValue(locale) : signature.getSignatureString());
        }
        return caption;
    }

    @Override
    public String getLastResortCaption() {
        return StringUtils.capitalize((String)this.formulaSignature);
    }

    @Override
    public Map<IDependency, IExpressionDependencyDetail> dependsOn() {
        return this.createDependencyCollector().collectDependencies();
    }

    protected ExpressionDependencyCollector createDependencyCollector() {
        return new ExpressionDependencyCollector(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Expression: ");
        builder.append(this.getFormulaSignature());
        builder.append(" : ");
        builder.append(this.getExpression());
        return builder.toString();
    }

    class EnumDatatypesCollector
    extends TypeHierarchyVisitor<IPolicyCmptType> {
        private IIpsProject project;
        private Map<String, EnumDatatype> enumtypes;

        public EnumDatatypesCollector(IIpsProject project, Map<String, EnumDatatype> enumtypes) {
            super(project);
            this.project = project;
            this.enumtypes = enumtypes;
        }

        @Override
        protected boolean visit(IPolicyCmptType currentType) {
            List<IPolicyCmptTypeAttribute> attr = currentType.getPolicyCmptTypeAttributes();
            for (IPolicyCmptTypeAttribute element : attr) {
                Expression.this.searchAndAdd(this.project, element.getDatatype(), this.enumtypes);
            }
            return true;
        }
    }
}

