/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.internal.builder.flidentifier.IdentifierParser;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.IdentifierNode;
import org.faktorips.devtools.model.internal.builder.flidentifier.ast.QualifierNode;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.fl.IdentifierVisitor;
import org.faktorips.devtools.model.internal.productcmpt.Expression;
import org.faktorips.devtools.model.internal.productcmpt.ExpressionDependencyDetail;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.devtools.model.productcmpt.IExpressionDependencyDetail;
import org.faktorips.devtools.model.util.TextRegion;
import org.faktorips.fl.parser.FlParser;
import org.faktorips.fl.parser.FlParserVisitor;
import org.faktorips.fl.parser.ParseException;
import org.faktorips.fl.parser.SimpleNode;

public class ExpressionDependencyCollector {
    private final Expression expression;
    private final Map<IDependency, IExpressionDependencyDetail> result = new HashMap<IDependency, IExpressionDependencyDetail>();
    private final IdentifierVisitor identifierVisitor;

    protected ExpressionDependencyCollector(Expression expression, IdentifierVisitor identifierVisitor) {
        this.expression = expression;
        this.identifierVisitor = identifierVisitor;
    }

    protected ExpressionDependencyCollector(Expression expression) {
        this(expression, ExpressionDependencyCollector.newIdentifierVisitor(expression));
    }

    private static IdentifierVisitor newIdentifierVisitor(IExpression expression) {
        IdentifierParser identifierParser = new IdentifierParser(expression, expression.getIpsProject(), IIpsModelExtensions.get().getIdentifierFilter());
        return new IdentifierVisitor(expression.getExpression(), identifierParser);
    }

    Map<IDependency, IExpressionDependencyDetail> getResult() {
        return this.result;
    }

    public Map<IDependency, IExpressionDependencyDetail> collectDependencies() {
        SimpleNode node = this.parseExpression();
        if (node != null) {
            return this.collectDependencies(node);
        }
        return new HashMap<IDependency, IExpressionDependencyDetail>();
    }

    protected SimpleNode parseExpression() {
        try {
            return this.parseExpressionInternal();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private SimpleNode parseExpressionInternal() throws ParseException {
        StringReader reader = new StringReader(this.expression.getExpression());
        FlParser parser = new FlParser((Reader)reader);
        return parser.start();
    }

    public Map<IDependency, IExpressionDependencyDetail> collectDependencies(SimpleNode node) {
        node.jjtAccept((FlParserVisitor)this.identifierVisitor, null);
        Map<IdentifierNode, Integer> identifiers = this.identifierVisitor.getIdentifiers();
        for (Map.Entry<IdentifierNode, Integer> identifierEntry : identifiers.entrySet()) {
            this.collectDependencies(identifierEntry.getKey(), identifierEntry.getValue());
        }
        return this.getResult();
    }

    void collectDependencies(IdentifierNode identifierNode, int identifierOffset) {
        if (identifierNode instanceof QualifierNode) {
            IpsObjectDependency dependency = this.createQualifiedNodeDependency(identifierNode);
            TextRegion textRegion = this.getTextRegion(identifierNode, identifierOffset, 1, -2);
            this.getDependencyDetail(dependency).addTextRegion(textRegion);
        }
        if (identifierNode.hasSuccessor()) {
            this.collectDependencies(identifierNode.getSuccessor(), identifierOffset);
        }
    }

    private IpsObjectDependency createQualifiedNodeDependency(IdentifierNode identifierNode) {
        QualifierNode qualifierNode = (QualifierNode)identifierNode;
        return IpsObjectDependency.createReferenceDependency(this.expression.getIpsObject().getQualifiedNameType(), qualifierNode.getProductCmpt().getQualifiedNameType());
    }

    TextRegion getTextRegion(IdentifierNode identifierNode, int identifierOffset, int startOffset, int endOffset) {
        TextRegion identiferRegion = identifierNode.getTextRegion().offset(identifierOffset);
        return identiferRegion.startOffset(startOffset).endOffset(endOffset);
    }

    private IExpressionDependencyDetail getDependencyDetail(IpsObjectDependency dependency) {
        return this.getResult().computeIfAbsent(dependency, $ -> new ExpressionDependencyDetail(this.expression));
    }
}

