/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.SortedSet;
import java.util.TreeSet;
import org.faktorips.devtools.model.internal.dependency.DependencyDetail;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.productcmpt.IExpression;
import org.faktorips.devtools.model.productcmpt.IExpressionDependencyDetail;
import org.faktorips.devtools.model.util.TextRegion;

public class ExpressionDependencyDetail
extends DependencyDetail
implements IExpressionDependencyDetail {
    private final SortedSet<TextRegion> textRegions = new TreeSet<TextRegion>();

    public ExpressionDependencyDetail(IExpression expression) {
        super(expression, "expression");
    }

    @Override
    public IExpression getPart() {
        return (IExpression)super.getPart();
    }

    @Override
    public void addTextRegion(TextRegion textRegion) {
        this.textRegions.add(textRegion);
    }

    @Override
    public void refactorAfterRename(IIpsPackageFragment targetIpsPackageFragment, String newName) {
        String expressionText = this.getPart().getExpression();
        int offset = 0;
        for (TextRegion textRegion : this.getTextRegions()) {
            int expressionLength = expressionText.length();
            expressionText = textRegion.offset(offset).replaceTextRegion(expressionText, newName);
            offset += expressionText.length() - expressionLength;
        }
        this.getPart().setExpression(expressionText);
    }

    SortedSet<TextRegion> getTextRegions() {
        return this.textRegions;
    }
}

