/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.faktorips.devtools.model.internal.productcmpt.Expression;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueFinder;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueSettings;
import org.faktorips.devtools.model.internal.productcmpttype.ProductCmptTypeAttribute;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IFormula;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValue;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueIdentifier;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeMethod;
import org.faktorips.devtools.model.type.IAttribute;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Formula
extends Expression
implements IFormula {
    private final TemplateValueSettings templateValueSettings = new TemplateValueSettings(this);

    public Formula(IPropertyValueContainer parent, String id) {
        this(parent, id, "");
    }

    public Formula(IPropertyValueContainer parent, String id, String formulaSignature) {
        super(parent, id, formulaSignature);
    }

    @Override
    public final IPropertyValueContainer getPropertyValueContainer() {
        return (IPropertyValueContainer)this.getParent();
    }

    @Override
    public IPropertyValueContainer getTemplatedValueContainer() {
        return this.getPropertyValueContainer();
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Formula");
    }

    @Override
    public String getName() {
        return this.getFormulaSignature();
    }

    @Override
    public String getPropertyName() {
        return this.getFormulaSignature();
    }

    @Override
    public IProductCmptProperty findProperty(IIpsProject ipsProject) {
        return this.findFormulaSignature(ipsProject);
    }

    @Override
    public PropertyValueType getPropertyValueType() {
        return PropertyValueType.FORMULA;
    }

    @Override
    public ProductCmptPropertyType getProductCmptPropertyType() {
        return this.getPropertyValueType().getCorrespondingPropertyType();
    }

    @Override
    public String getPropertyValue() {
        return this.getExpression();
    }

    @Override
    public String getExpression() {
        if (this.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            return this.findTemplateExpression();
        }
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return "";
        }
        return super.getExpression();
    }

    public String getExpressionInternal() {
        return super.getExpression();
    }

    private String findTemplateExpression() {
        IFormula templateFormula = this.findTemplateProperty(this.getIpsProject());
        if (templateFormula == null) {
            return super.getExpression();
        }
        return templateFormula.getExpression();
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return this.getPropertyValueContainer().findProductCmptType(ipsProject);
    }

    @Override
    public List<IAttribute> findMatchingProductCmptTypeAttributes() {
        List<IAttribute> allAttributes = super.findMatchingProductCmptTypeAttributes();
        if (!this.getPropertyValueContainer().isChangingOverTimeContainer()) {
            ArrayList<IAttribute> notChangingOverTimeAttributes = new ArrayList<IAttribute>();
            for (IAttribute attribute : allAttributes) {
                if (((ProductCmptTypeAttribute)attribute).isChangingOverTime()) continue;
                notChangingOverTimeAttributes.add(attribute);
            }
            return notChangingOverTimeAttributes;
        }
        return allAttributes;
    }

    @Override
    protected ITableContentUsage[] getTableContentUsages() {
        List<ITableContentUsage> usages = this.getPropertyValueContainer().getPropertyValues(ITableContentUsage.class);
        if (this.getPropertyValueContainer() instanceof IProductCmptGeneration) {
            usages.addAll(this.getPropertyValueContainer().getProductCmpt().getPropertyValues(ITableContentUsage.class));
        }
        return usages.toArray(new ITableContentUsage[usages.size()]);
    }

    @Override
    public IProductCmptTypeMethod findFormulaSignature(IIpsProject ipsProject) {
        if (IpsStringUtils.isEmpty((String)this.getFormulaSignature())) {
            return null;
        }
        IProductCmptType type = this.findProductCmptType(ipsProject);
        if (type == null) {
            return null;
        }
        return type.findFormulaSignature(this.getFormulaSignature(), ipsProject);
    }

    @Override
    public boolean isFormulaMandatory() {
        if (this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED) {
            return false;
        }
        IProductCmptTypeMethod formulaSignature = this.findFormulaSignature(this.getIpsProject());
        if (formulaSignature != null) {
            return formulaSignature.isFormulaMandatory();
        }
        return true;
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.templateValueSettings.initPropertiesFromXml(element);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        this.templateValueSettings.propertiesToXml(element);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        list.add(this.templateValueSettings.validate(this, ipsProject));
    }

    @Override
    public void setTemplateValueStatus(TemplateValueStatus newStatus) {
        if (newStatus == TemplateValueStatus.DEFINED) {
            this.setExpressionInternal(this.getExpression());
        }
        TemplateValueStatus oldStatus = this.templateValueSettings.getStatus();
        this.templateValueSettings.setStatus(newStatus);
        this.objectHasChanged(new PropertyChangeEvent(this, "templateValueStatus", (Object)oldStatus, (Object)newStatus));
    }

    @Override
    public TemplateValueStatus getTemplateValueStatus() {
        return this.templateValueSettings.getStatus();
    }

    @Override
    public void switchTemplateValueStatus() {
        this.setTemplateValueStatus(this.getTemplateValueStatus().getNextStatus(this));
    }

    @Override
    public IFormula findTemplateProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.findTemplateValue(this, IFormula.class);
    }

    @Override
    public boolean hasTemplateForProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.hasTemplateForValue(this, IFormula.class);
    }

    @Override
    public boolean isPartOfTemplateHierarchy() {
        return this.getTemplatedValueContainer().isUsingTemplate() && this.findTemplateProperty(this.getIpsProject()) != null || this.getTemplatedValueContainer().isProductTemplate();
    }

    @Override
    public Comparator<Object> getValueComparator() {
        return this.getPropertyValueType().getValueComparator();
    }

    public Function<IPropertyValue, Object> getValueGetter() {
        return this.getPropertyValueType().getValueGetter();
    }

    @Override
    public Function<? extends ITemplatedValue, Object> getInternalValueGetter() {
        return this.getPropertyValueType().getInternalValueGetter();
    }

    public BiConsumer<IPropertyValue, Object> getValueSetter() {
        return this.getPropertyValueType().getValueSetter();
    }

    @Override
    public ITemplatedValueIdentifier getIdentifier() {
        return new IPropertyValue.PropertyValueIdentifier(this);
    }

    @Override
    public boolean isConcreteValue() {
        return this.getTemplateValueStatus() == TemplateValueStatus.DEFINED;
    }
}

