/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.productcmpt.AbstractValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.MultiValueHolderValidator;
import org.faktorips.devtools.model.internal.productcmpt.SingleValueHolder;
import org.faktorips.devtools.model.internal.value.StringValue;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.AttributeValueType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IAttributeValueHolderFactory;
import org.faktorips.devtools.model.productcmpt.IMultiValueHolder;
import org.faktorips.devtools.model.productcmpt.ISingleValueHolder;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.value.ValueType;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.collections.ListComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MultiValueHolder
extends AbstractValueHolder<List<ISingleValueHolder>>
implements IMultiValueHolder {
    public static final String SEPARATOR = "|";
    public static final String XML_TYPE_NAME = "MultiValue";
    public static final String MSGCODE_PREFIX = "MULTIVALUEHOLDER-";
    public static final String MSGCODE_CONTAINS_INVALID_VALUE = "MULTIVALUEHOLDER-ContainsInvalidValue";
    public static final String MSGCODE_CONTAINS_DUPLICATE_VALUE = "MULTIVALUEHOLDER-ContainsDuplicateValue";
    private List<ISingleValueHolder> values = new ArrayList<ISingleValueHolder>();

    public MultiValueHolder(IAttributeValue attributeValue) {
        super(attributeValue);
    }

    public MultiValueHolder(IAttributeValue attributeValue, List<ISingleValueHolder> defaultValue) {
        this(attributeValue);
        this.values = defaultValue;
    }

    @Override
    protected AttributeValueType getType() {
        return AttributeValueType.MULTI_VALUE;
    }

    @Override
    public List<ISingleValueHolder> getValue() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ISingleValueHolder>(this.values);
    }

    @Override
    public void setValue(List<ISingleValueHolder> values) {
        List<ISingleValueHolder> oldValue = this.values;
        this.values = values;
        this.objectHasChanged(oldValue, values);
    }

    @Override
    public List<IValue<?>> getValueList() {
        return this.getValue().stream().map(IValueHolder::getValue).collect(Collectors.toList());
    }

    @Override
    public void setValueList(List<IValue<?>> values) {
        this.setValue(values.stream().map(input -> new SingleValueHolder(this.getParent(), (IValue<?>)input)).collect(Collectors.toList()));
    }

    @Override
    protected void contentToXml(Element valueEl, Document doc) {
        Element multiValueElement = doc.createElement(AttributeValueType.MULTI_VALUE.getXmlTypeName());
        for (ISingleValueHolder value : this.values) {
            Element valueElement = value.toXml(doc);
            multiValueElement.appendChild(valueElement);
        }
        valueEl.appendChild(multiValueElement);
    }

    @Override
    public void initFromXml(Element element) {
        NodeList multiValueElementList = element.getElementsByTagName(AttributeValueType.MULTI_VALUE.getXmlTypeName());
        if (multiValueElementList.getLength() > 0 && multiValueElementList.item(0) instanceof Element) {
            Element multiValueElement = (Element)multiValueElementList.item(0);
            this.values = new ArrayList<ISingleValueHolder>();
            NodeList childNodes = multiValueElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                if (childNodes.item(i) instanceof Element) {
                    Element child = (Element)childNodes.item(i);
                    SingleValueHolder stringValueHolder = new SingleValueHolder(this.getParent());
                    stringValueHolder.initFromXml(child);
                    this.values.add(stringValueHolder);
                }
                ++i;
            }
        }
    }

    @Override
    public MessageList validate(IIpsProject ipsProject) {
        return new MultiValueHolderValidator(this, this.getParent(), ipsProject).validate();
    }

    @Override
    public int compareTo(IValueHolder<List<ISingleValueHolder>> o) {
        if (o == null) {
            return 1;
        }
        Comparator naturalComparator = Comparator.naturalOrder();
        return ListComparator.listComparator(naturalComparator).compare(this.values, o.getValue());
    }

    @Override
    public String getStringValue() {
        ArrayList<String> stringList = new ArrayList<String>();
        for (ISingleValueHolder holder : this.values) {
            stringList.add(holder.getStringValue());
        }
        return ((Object)stringList).toString();
    }

    @Override
    public boolean isNullValue() {
        return false;
    }

    @Override
    public ValueType getValueType() {
        if (!this.values.isEmpty()) {
            return this.getValueTypeFromFirstEntry();
        }
        return this.getValueTypeForNoEntries();
    }

    @Override
    public boolean isMultiValue() {
        return true;
    }

    private ValueType getValueTypeForNoEntries() {
        IProductCmptTypeAttribute attribute = this.getParent().findAttribute(this.getIpsProject());
        if (attribute != null) {
            return this.getValueTypeFromAttribute(attribute);
        }
        return ValueType.STRING;
    }

    private ValueType getValueTypeFromFirstEntry() {
        return this.values.get(0).getValueType();
    }

    private ValueType getValueTypeFromAttribute(IProductCmptTypeAttribute attribute) {
        if (attribute.isMultilingual()) {
            return ValueType.INTERNATIONAL_STRING;
        }
        return ValueType.STRING;
    }

    @Override
    protected MultiValueHolderValidator newValidator(IAttributeValue parent, IIpsProject ipsProject) {
        return new MultiValueHolderValidator(this, parent, ipsProject);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MultiValueHolder other = (MultiValueHolder)obj;
        return Objects.equals(this.values, other.values);
    }

    public static class Factory
    implements IAttributeValueHolderFactory<List<ISingleValueHolder>> {
        private static final String MULTI_VALUE_SPLIT_REGEX = "\\s*\\|\\s*";

        @Override
        public IValueHolder<List<ISingleValueHolder>> createValueHolder(IAttributeValue parent) {
            return new MultiValueHolder(parent);
        }

        @Override
        public IValueHolder<List<ISingleValueHolder>> createValueHolder(IAttributeValue parent, IValue<?> defaultValue) {
            ArrayList<ISingleValueHolder> values;
            if (defaultValue instanceof StringValue) {
                values = this.splitMultiDefaultValues(parent, (StringValue)defaultValue);
            } else {
                values = new ArrayList();
                if (defaultValue.getContent() != null) {
                    SingleValueHolder singleValueHolder = new SingleValueHolder(parent, defaultValue);
                    values.add(singleValueHolder);
                }
            }
            return new MultiValueHolder(parent, values);
        }

        ArrayList<ISingleValueHolder> splitMultiDefaultValues(IAttributeValue parent, StringValue defaultValue) {
            ArrayList<ISingleValueHolder> values = new ArrayList<ISingleValueHolder>();
            String content = defaultValue.getContent();
            if (content != null) {
                String[] splittedMultiValues;
                String[] stringArray = splittedMultiValues = Factory.getSplitMultiValue(content);
                int n = splittedMultiValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    values.add(new SingleValueHolder(parent, new StringValue(string)));
                    ++n2;
                }
            }
            return values;
        }

        public static String[] getSplitMultiValue(String content) {
            if (content == null) {
                return new String[1];
            }
            if (IpsStringUtils.isBlank((String)content)) {
                return new String[0];
            }
            String nullPresentation = IIpsModelExtensions.get().getModelPreferences().getNullPresentation();
            return (String[])Arrays.stream(content.split(MULTI_VALUE_SPLIT_REGEX)).map(s -> nullPresentation.equalsIgnoreCase(s.trim()) ? null : s.trim()).toArray(String[]::new);
        }
    }
}

