/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.faktorips.devtools.model.internal.productcmpt.IValueHolderValidator;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.MultiValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.SingleValueHolder;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.ISingleValueHolder;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;

public class MultiValueHolderValidator
implements IValueHolderValidator {
    private final MultiValueHolder valueHolder;
    private final IAttributeValue parent;
    private final IIpsProject ipsProject;

    public MultiValueHolderValidator(MultiValueHolder valueHolder, IAttributeValue parent, IIpsProject ipsProject) {
        this.valueHolder = valueHolder;
        this.parent = parent;
        this.ipsProject = ipsProject;
    }

    @Override
    public MessageList validate() {
        MessageList messages = new MessageList();
        Object values = this.valueHolder.getValue();
        if (values == null) {
            return messages;
        }
        Set<ISingleValueHolder> duplicateValueHolders = this.getDuplicateValueHolders((List<ISingleValueHolder>)values);
        for (ISingleValueHolder duplicateValueHolder : duplicateValueHolders) {
            messages.newError("MULTIVALUEHOLDER-ContainsDuplicateValue", Messages.MultiValueHolder_DuplicateValueMessageText, (Object)duplicateValueHolder, new String[]{"value"});
        }
        Iterator<ISingleValueHolder> iterator = values.iterator();
        while (iterator.hasNext()) {
            ISingleValueHolder singleValueHolder = iterator.next();
            messages.add(((SingleValueHolder)singleValueHolder).newValidator(this.parent, this.ipsProject).validate());
        }
        if (messages.containsErrorMsg()) {
            messages.newError("MULTIVALUEHOLDER-ContainsInvalidValue", Messages.MultiValueHolder_AtLeastOneInvalidValueMessageText, new ObjectProperty[]{new ObjectProperty((Object)this.parent, "valueHolder"), new ObjectProperty((Object)this.valueHolder, "value")});
        }
        this.validateEmptyMultiValue(messages, (List<ISingleValueHolder>)values);
        return messages;
    }

    private Set<ISingleValueHolder> getDuplicateValueHolders(List<ISingleValueHolder> values) {
        HashSet<ISingleValueHolder> duplicates = new HashSet<ISingleValueHolder>();
        HashSet<ISingleValueHolder> processedValues = new HashSet<ISingleValueHolder>();
        for (ISingleValueHolder element : values) {
            if (processedValues.contains(element)) {
                duplicates.add(element);
                continue;
            }
            processedValues.add(element);
        }
        return duplicates;
    }

    private void validateEmptyMultiValue(MessageList messages, List<ISingleValueHolder> values) {
        IValueSet valueSet;
        if (this.parent.findAttribute(this.ipsProject) != null && (valueSet = this.parent.findAttribute(this.ipsProject).getValueSet()) != null && values.isEmpty() && !valueSet.isContainsNull()) {
            String text = MessageFormat.format(Messages.AttributeValue_MultiValueMustNotBeEmpty, this.parent.getName().toString());
            messages.newError("ATTRIBUTEVALUE-MandatoryValueNotDefined", text, new ObjectProperty[]{new ObjectProperty((Object)this.parent, "valueHolder"), new ObjectProperty((Object)this.valueHolder, "value")});
        }
    }
}

