/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.IpsModel;
import org.faktorips.devtools.model.internal.SingleEventModification;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectGeneration;
import org.faktorips.devtools.model.internal.ipsobject.TimedIpsObject;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptGeneration;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptKind;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLink;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLinkCollection;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLinkContainerUtil;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLinkContainerValidator;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptToTypeDelta;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptValidations;
import org.faktorips.devtools.model.internal.productcmpt.ProductPartCollection;
import org.faktorips.devtools.model.internal.productcmpt.PropertyValueCollection;
import org.faktorips.devtools.model.internal.productcmpt.template.RemoveTemplateOperation;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValidations;
import org.faktorips.devtools.model.internal.productcmpt.treestructure.ProductCmptTreeStructure;
import org.faktorips.devtools.model.internal.type.TypeValidations;
import org.faktorips.devtools.model.ipsobject.IIpsObjectGeneration;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.ISupportedLanguage;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IExpressionDependencyDetail;
import org.faktorips.devtools.model.productcmpt.IFormula;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptKind;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptNamingStrategy;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainerToTypeDelta;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.productcmpt.IValidationRuleConfig;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.treestructure.CycleInProductStructureException;
import org.faktorips.devtools.model.productcmpt.treestructure.IProductCmptTreeStructure;
import org.faktorips.devtools.model.productcmpttype.IProductCmptCategory;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.Severity;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.runtime.internal.XmlUtil;
import org.faktorips.values.DateUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProductCmpt
extends TimedIpsObject
implements IProductCmpt {
    public static final String XML_ATTRIBUTE_VALID_FROM = "validFrom";
    private final ProductCmptLinkCollection linkCollection = new ProductCmptLinkCollection();
    private final PropertyValueCollection propertyValueCollection = new PropertyValueCollection(this);
    private final ProductPartCollection productPartCollection = new ProductPartCollection(this.propertyValueCollection, this.linkCollection);
    private final IpsObjectType ipsObjectType;
    private String productCmptType = "";
    private String runtimeId = "";
    private String template = null;

    public ProductCmpt(IIpsSrcFile file) {
        super(file);
        this.ipsObjectType = file.getIpsObjectType();
    }

    public ProductCmpt() {
        this.ipsObjectType = IpsObjectType.PRODUCT_CMPT;
    }

    @Override
    public IpsObjectType getIpsObjectType() {
        return this.ipsObjectType;
    }

    @Override
    public IProductCmptGeneration getProductCmptGeneration(int index) {
        return (IProductCmptGeneration)this.getGeneration(index);
    }

    @Override
    public IProductCmptGeneration getFirstGeneration() {
        return (IProductCmptGeneration)super.getFirstGeneration();
    }

    @Override
    public IProductCmptGeneration getLatestProductCmptGeneration() {
        IIpsObjectGeneration latestGeneration = this.getLatestGeneration();
        return latestGeneration == null ? null : (IProductCmptGeneration)latestGeneration;
    }

    @Override
    public IProductCmptKind getKindId() {
        return ProductCmptKind.createProductCmptKind(this.getName(), this.getIpsProject());
    }

    @Override
    public String getVersionId() {
        try {
            return this.getIpsProject().getProductCmptNamingStrategy().getVersionId(this.getName());
        }
        catch (IllegalArgumentException e) {
            throw new IpsException((IStatus)new IpsStatus("Can't get version id for " + this, e));
        }
    }

    @Override
    public IPolicyCmptType findPolicyCmptType(IIpsProject ipsProject) {
        IProductCmptType foundProductCmptType = this.findProductCmptType(ipsProject);
        if (foundProductCmptType == null) {
            return null;
        }
        return foundProductCmptType.findPolicyCmptType(ipsProject);
    }

    @Override
    public String getProductCmptType() {
        return this.productCmptType;
    }

    @Override
    public void setProductCmptType(String newType) {
        String oldType = this.productCmptType;
        this.productCmptType = newType;
        this.valueChanged(oldType, newType);
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return ipsProject.findProductCmptType(this.productCmptType);
    }

    @Override
    public boolean isUsingTemplate() {
        return IpsStringUtils.isNotEmpty((String)this.getTemplate());
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(String newTemplate) {
        if (IpsStringUtils.isEmpty((String)newTemplate)) {
            this.resetTemplateStatus();
        }
        String oldTemplate = this.template;
        this.template = newTemplate;
        this.valueChanged(oldTemplate, this.template, "template");
    }

    @Override
    public void resetTemplateStatus() {
        if (this.isUsingTemplate()) {
            try {
                this.getEnclosingResource().getWorkspace().run((ICoreRunnable)new RemoveTemplateOperation(this), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IpsException e) {
                IpsLog.log(e);
            }
        }
    }

    @Override
    public IProductCmpt findTemplate(IIpsProject ipsProject) {
        if (this.isUsingTemplate()) {
            return ipsProject.findProductTemplate(this.template);
        }
        return null;
    }

    @Override
    protected IpsObjectGeneration createNewGeneration(String id) {
        return new ProductCmptGeneration(this, id);
    }

    @Override
    public boolean isChangingOverTimeContainer() {
        return false;
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        IProductCmptType type = ProductCmptValidations.validateProductCmptType(this, this.productCmptType, list, ipsProject);
        if (type == null || !this.validateTypeHierarchy(list, ipsProject, type)) {
            return;
        }
        this.validateUniqueVersionIdKindId(list, ipsProject);
        this.validateName(list, ipsProject);
        if (this.isProductTemplate()) {
            TemplateValidations.validateTemplateCycle(this, list, ipsProject);
        } else {
            this.validateRuntimeId(list, ipsProject);
        }
        this.validateLinks(list, ipsProject, type);
        this.validateDifferencesToModel(list, ipsProject);
        ProductCmptValidations.validateTemplate(this, type, list, ipsProject);
    }

    private void validateUniqueVersionIdKindId(MessageList list, IIpsProject ipsProject) {
        Severity duplicateProductComponentSeverity = ipsProject.getReadOnlyProperties().getDuplicateProductComponentSeverity();
        if (!Severity.NONE.equals((Object)duplicateProductComponentSeverity) && ipsProject.findProductCmptByUnqualifiedName(this.getName()).size() > 1) {
            list.add(new Message("PRODUCT_CMPT-IdsNotUnique", MessageFormat.format(Messages.ProductCmpt_Error_IdsNotUnique, IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getVersionConceptNameSingular()), duplicateProductComponentSeverity, (Object)this));
        }
    }

    private boolean validateTypeHierarchy(MessageList list, IIpsProject ipsProject, IProductCmptType type) {
        Message message = TypeValidations.validateTypeHierachy(type, ipsProject);
        if (message != null) {
            String typeLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(type);
            String msg = MessageFormat.format(Messages.ProductCmpt_msgInvalidTypeHierarchy, typeLabel);
            list.add(new Message("PRODUCT_CMPT-InconsistTypeHierarchy", msg, Message.ERROR, (Object)type, new String[]{"productCmptType"}));
            return false;
        }
        return true;
    }

    private void validateName(MessageList list, IIpsProject ipsProject) {
        IProductCmptNamingStrategy strategy = ipsProject.getProductCmptNamingStrategy();
        MessageList list2 = strategy.validate(this.getName());
        for (Message msg : list2) {
            Message msgNew = new Message(msg.getCode(), msg.getText(), msg.getSeverity(), (Object)this, new String[]{"name"});
            list.add(msgNew);
        }
    }

    private void validateRuntimeId(MessageList list, IIpsProject ipsProject) {
        IProductCmptNamingStrategy strategy = ipsProject.getProductCmptNamingStrategy();
        MessageList list2 = strategy.validateRuntimeId(this.getRuntimeId());
        for (Message msg : list2) {
            Message msgNew = new Message(msg.getCode(), msg.getText(), msg.getSeverity(), (Object)this, new String[]{"runtimeId"});
            list.add(msgNew);
        }
        list2 = this.getIpsProject().checkForDuplicateRuntimeIds(this.getIpsSrcFile());
        list.add(list2);
    }

    private void validateLinks(MessageList list, IIpsProject ipsProject, IProductCmptType type) {
        new ProductCmptLinkContainerValidator(ipsProject, this).startAndAddMessagesToList(type, list);
    }

    private void validateDifferencesToModel(MessageList list, IIpsProject ipsProject) {
        if (this.containsDifferenceToModel(ipsProject)) {
            list.newError("PRODUCT_CMPT-DifferencesToModel", Messages.ProductCmpt_Error_DifferencesToModel0, (Object)this, new String[0]);
        }
    }

    @Override
    public boolean containsGenerationFormula() {
        IIpsObjectGeneration[] generations;
        IIpsObjectGeneration[] iIpsObjectGenerationArray = generations = this.getGenerationsOrderedByValidDate();
        int n = generations.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectGeneration generation = iIpsObjectGenerationArray[n2];
            if (((ProductCmptGeneration)generation).containsFormula()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected IDependency[] dependsOn(Map<IDependency, List<IDependencyDetail>> details) {
        IIpsObjectGeneration[] generations;
        IpsObjectDependency dependency;
        HashSet<IDependency> dependencySet = new HashSet<IDependency>();
        if (!IpsStringUtils.isEmpty((String)this.productCmptType)) {
            dependency = IpsObjectDependency.createInstanceOfDependency(this.getQualifiedNameType(), new QualifiedNameType(this.productCmptType, IpsObjectType.PRODUCT_CMPT_TYPE));
            dependencySet.add(dependency);
            this.addDetails(details, dependency, this, "productCmptType");
        }
        if (this.isUsingTemplate()) {
            dependency = IpsObjectDependency.createInstanceOfDependency(this.getQualifiedNameType(), new QualifiedNameType(this.template, IpsObjectType.PRODUCT_TEMPLATE));
            dependencySet.add(dependency);
            this.addDetails(details, dependency, this, "template");
        }
        this.linkCollection.addRelatedProductCmptQualifiedNameTypes(dependencySet, details);
        IIpsObjectGeneration[] iIpsObjectGenerationArray = generations = this.getGenerationsOrderedByValidDate();
        int n = generations.length;
        int n2 = 0;
        while (n2 < n) {
            IIpsObjectGeneration generation = iIpsObjectGenerationArray[n2];
            ((ProductCmptGeneration)generation).dependsOn(dependencySet, details);
            ++n2;
        }
        this.addRelatedTableContentsQualifiedNameTypes(dependencySet, details);
        this.addDependenciesFromFormulaExpressions(dependencySet, details);
        return dependencySet.toArray(new IDependency[dependencySet.size()]);
    }

    private void addRelatedTableContentsQualifiedNameTypes(Set<IDependency> qaTypes, Map<IDependency, List<IDependencyDetail>> details) {
        ITableContentUsage[] tableContentUsages;
        ITableContentUsage[] iTableContentUsageArray = tableContentUsages = this.getTableContentUsages();
        int n = tableContentUsages.length;
        int n2 = 0;
        while (n2 < n) {
            ITableContentUsage tableContentUsage = iTableContentUsageArray[n2];
            IpsObjectDependency dependency = IpsObjectDependency.createReferenceDependency(this.getIpsObject().getQualifiedNameType(), new QualifiedNameType(tableContentUsage.getTableContentName(), IpsObjectType.TABLE_CONTENTS));
            qaTypes.add(dependency);
            this.addDetails(details, dependency, tableContentUsage, "tableContentName");
            ++n2;
        }
    }

    private void addDependenciesFromFormulaExpressions(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        IFormula[] iFormulaArray = this.getFormulas();
        int n = iFormulaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormula formula = iFormulaArray[n2];
            Map formulaDependencies = formula.dependsOn();
            dependencies.addAll(formulaDependencies.keySet());
            if (details != null) {
                this.mergeDependencyDetails(details, formulaDependencies);
            }
            ++n2;
        }
    }

    private void mergeDependencyDetails(Map<IDependency, List<IDependencyDetail>> details, Map<IDependency, IExpressionDependencyDetail> formulaDependencies) {
        for (Map.Entry<IDependency, IExpressionDependencyDetail> entry : formulaDependencies.entrySet()) {
            List dependenciesDetailsList = details.computeIfAbsent(entry.getKey(), $ -> new ArrayList());
            dependenciesDetailsList.add((IDependencyDetail)entry.getValue());
        }
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        element.setAttribute("productCmptType", this.productCmptType);
        if (IpsStringUtils.isNotBlank((String)this.productCmptType)) {
            element.setAttribute("implementationClass", IIpsModelExtensions.get().getImplementationClassProvider().getImplementationClassQualifiedName(this));
        }
        element.setAttribute("runtimeId", this.runtimeId);
        if (IpsStringUtils.isNotEmpty((String)this.template)) {
            element.setAttribute("template", this.template);
        }
        element.setAttribute(XML_ATTRIBUTE_VALID_FROM, DateUtil.gregorianCalendarToIsoDateString((GregorianCalendar)this.getValidFrom()));
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        super.initPropertiesFromXml(element, id);
        this.productCmptType = element.getAttribute("productCmptType");
        this.runtimeId = element.getAttribute("runtimeId");
        this.template = org.faktorips.devtools.model.util.XmlUtil.getAttributeOrEmptyString(element, "template");
    }

    @Override
    public IProductCmptTreeStructure getStructure(GregorianCalendar date, IIpsProject ipsProject) throws CycleInProductStructureException {
        return new ProductCmptTreeStructure(this, date, ipsProject);
    }

    @Override
    public String getRuntimeId() {
        return this.runtimeId;
    }

    @Override
    public void setRuntimeId(String runtimeId) {
        String oldId = this.runtimeId;
        this.runtimeId = runtimeId;
        this.valueChanged(oldId, runtimeId, "runtimeId");
    }

    @Override
    public String getCaption(Locale locale) {
        IProductCmptType cmptType = this.findProductCmptType(this.getIpsProject());
        if (cmptType != null) {
            return IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(cmptType);
        }
        return this.getProductCmptType();
    }

    @Override
    public boolean containsDifferenceToModel(IIpsProject ipsProject) {
        return !this.computeDeltaToModel(ipsProject).isEmpty();
    }

    @Override
    public void fixAllDifferencesToModel(final IIpsProject ipsProject) {
        ((IpsModel)this.getIpsModel()).executeModificationsWithSingleEvent(new SingleEventModification<Object>(this.getIpsSrcFile()){

            @Override
            protected boolean execute() {
                ProductCmpt.this.computeDeltaToModel(ipsProject).fixAllDifferencesToModel();
                return true;
            }
        });
    }

    @Override
    public IPropertyValueContainerToTypeDelta computeDeltaToModel(IIpsProject ipsProject) {
        return new ProductCmptToTypeDelta(this, ipsProject);
    }

    @Override
    public boolean isReferencingProductCmpt(IIpsProject ipsProjectToSearch, IProductCmpt productCmptCandidate) {
        List<IProductCmptLink> links = this.getLinksIncludingGenerations();
        for (IProductCmptLink link : links) {
            if (!productCmptCandidate.getQualifiedName().equals(link.getTarget())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IIpsSrcFile findMetaClassSrcFile(IIpsProject ipsProject) {
        return ipsProject.findIpsSrcFile(IpsObjectType.PRODUCT_CMPT_TYPE, this.getProductCmptType());
    }

    @Override
    public String getMetaClass() {
        return this.getProductCmptType();
    }

    @Override
    public <T extends IPropertyValue> T getPropertyValue(IProductCmptProperty property, Class<T> type) {
        return this.propertyValueCollection.getPropertyValue(property, type);
    }

    @Override
    public List<IPropertyValue> getPropertyValues(IProductCmptProperty property) {
        return this.propertyValueCollection.getPropertyValues(property);
    }

    @Override
    public boolean hasPropertyValue(IProductCmptProperty property, PropertyValueType propertyValueType) {
        return this.getPropertyValue(property, propertyValueType.getInterfaceClass()) != null;
    }

    @Override
    public List<IPropertyValue> getPropertyValues(String propertyName) {
        return this.propertyValueCollection.getPropertyValues(propertyName);
    }

    @Override
    public <T extends IPropertyValue> T getPropertyValue(String propertyName, Class<T> type) {
        return this.propertyValueCollection.getPropertyValue(propertyName, type);
    }

    @Override
    public <T extends IIpsObjectPart> List<T> getProductParts(Class<T> type) {
        return this.productPartCollection.getProductParts(type);
    }

    @Override
    public <T extends IPropertyValue> List<T> getPropertyValues(Class<T> type) {
        return this.propertyValueCollection.getPropertyValues(type);
    }

    @Override
    public List<IPropertyValue> getAllPropertyValues() {
        return this.propertyValueCollection.getAllPropertyValues();
    }

    @Override
    public <T extends IPropertyValue> T newPropertyValue(IProductCmptProperty property, Class<T> type) {
        T newPropertyValue = this.propertyValueCollection.newPropertyValue(property, this.getNextPartId(), type);
        this.objectHasChanged();
        return newPropertyValue;
    }

    @Override
    public List<IPropertyValue> newPropertyValues(IProductCmptProperty property) {
        List<IPropertyValue> newPropertyValues = this.propertyValueCollection.newPropertyValues(this, property, this.getNextPartId());
        this.objectHasChanged();
        return newPropertyValues;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        IIpsObjectPart part = super.newPartThis(xmlTag, id);
        if (part != null) {
            return part;
        }
        String xmlTagName = xmlTag.getNodeName();
        if (xmlTagName.equals("Generation")) {
            return this.newGenerationInternal(id);
        }
        if (xmlTagName.equals("Link")) {
            return this.createAndAddNewLinkInternal(id);
        }
        return this.propertyValueCollection.newPropertyValue(xmlTagName, id);
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        IIpsObjectPart part = super.newPartThis(partType);
        if (part != null) {
            return part;
        }
        if (IPolicyCmptTypeAssociation.class.isAssignableFrom(partType)) {
            return this.createAndAddNewLinkInternal(this.getNextPartId());
        }
        if (IPropertyValue.class.isAssignableFrom(partType)) {
            Class<IPropertyValue> propertyValueType = partType.asSubclass(IPropertyValue.class);
            return this.propertyValueCollection.newPropertyValue(this.getNextPartId(), propertyValueType);
        }
        return null;
    }

    private IProductCmptLink createAndAddNewLinkInternal(String id) {
        ProductCmptLink newLink = new ProductCmptLink(this, id);
        this.linkCollection.addLink(newLink);
        return newLink;
    }

    @Override
    public List<IAttributeValue> getAttributeValues() {
        return this.propertyValueCollection.getPropertyValues(IAttributeValue.class);
    }

    @Override
    public IAttributeValue getAttributeValue(String attribute) {
        return this.propertyValueCollection.getPropertyValue(attribute, IAttributeValue.class);
    }

    @Override
    public boolean isContainerFor(IProductCmptProperty property) {
        return property.isChangingOverTime() == this.isChangingOverTimeContainer();
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        ArrayList<IIpsElement> children = new ArrayList<IIpsElement>();
        if (this.allowGenerations()) {
            IIpsElement[] childrenThis = super.getChildrenThis();
            children.addAll(Arrays.asList(childrenThis));
        }
        children.addAll(this.propertyValueCollection.getAllPropertyValues());
        children.addAll(this.getLinksAsList());
        return children.toArray(new IIpsElement[children.size()]);
    }

    @Override
    public Element toXml(Document doc) {
        Element xmlElement = super.toXml(doc);
        this.updateInternationalStringDefaultLocale(this.getDefaultLocale(), xmlElement);
        this.updateGenerations(doc, xmlElement);
        this.compileFormulas(this, doc, xmlElement);
        return xmlElement;
    }

    private Locale getDefaultLocale() {
        return this.getIpsProject().getReadOnlyProperties().getDefaultLanguage().getLocale();
    }

    private void updateInternationalStringDefaultLocale(Locale defaultLocale, Element root) {
        Set<String> supportedLanguages = this.getIpsProject().getReadOnlyProperties().getSupportedLanguages().stream().map(ISupportedLanguage::getLocale).map(Locale::toLanguageTag).collect(Collectors.toSet());
        NodeList internationalStrings = root.getElementsByTagName("InternationalString");
        int i = 0;
        while (i < internationalStrings.getLength()) {
            Element internationalString = (Element)internationalStrings.item(i);
            internationalString.setAttribute("defaultLocale", defaultLocale.getLanguage());
            for (String language : this.findMissingLocalizedStringsForEachInternationalString(supportedLanguages, internationalString)) {
                Element localizedString = internationalString.getOwnerDocument().createElement("LocalizedString");
                localizedString.setAttribute("locale", language);
                localizedString.setAttribute("text", "");
                internationalString.appendChild(localizedString);
            }
            ++i;
        }
    }

    private Set<String> findMissingLocalizedStringsForEachInternationalString(Set<String> supportedLanguages, Element internationalString) {
        NodeList localizedStrings = internationalString.getElementsByTagName("LocalizedString");
        LinkedHashSet<String> missingLanguages = new LinkedHashSet<String>(supportedLanguages);
        int m = 0;
        while (m < localizedStrings.getLength()) {
            Element localizedString = (Element)localizedStrings.item(m);
            String language = localizedString.getAttribute("locale");
            if (missingLanguages.contains(language)) {
                missingLanguages.remove(language);
            }
            ++m;
        }
        return missingLanguages;
    }

    private void updateGenerations(Document document, Element root) {
        List generationNodes = XmlUtil.getElements((Node)root, (String)"Generation");
        if (this.allowGenerations()) {
            IIpsObjectGeneration[] generations = this.getGenerationsOrderedByValidDate();
            int i = 0;
            while (i < generations.length && i < generationNodes.size()) {
                IProductCmptGeneration generation = (IProductCmptGeneration)generations[i];
                Element generationElement = (Element)generationNodes.get(i);
                this.compileFormulas(generation, document, generationElement);
                ++i;
            }
        } else {
            this.writeDummyGeneration(document, root);
        }
    }

    private void writeDummyGeneration(Document doc, Element rootElement) {
        IProductCmptGeneration generation = this.getFirstGeneration();
        Element generationElement = generation.toXml(doc);
        Node lastDescriptionOfProductCmpt = null;
        NodeList childNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if ("Description".equals(item.getNodeName())) {
                lastDescriptionOfProductCmpt = item;
            }
            ++i;
        }
        if (lastDescriptionOfProductCmpt != null) {
            rootElement.insertBefore(generationElement, lastDescriptionOfProductCmpt.getNextSibling());
        } else {
            rootElement.appendChild(generationElement);
        }
    }

    private void compileFormulas(IPropertyValueContainer propertyValueContainer, Document document, Element node) {
        IIpsModelExtensions.get().getFormulaCompiler().compileFormulas(propertyValueContainer, document, node);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (super.addPartThis(part)) {
            return true;
        }
        if (part instanceof IProductCmptLink) {
            return this.linkCollection.addLink((IProductCmptLink)part);
        }
        IIpsObjectPart iIpsObjectPart = part;
        if (iIpsObjectPart instanceof IPropertyValue) {
            void propertyValue;
            IPropertyValue iPropertyValue = (IPropertyValue)iIpsObjectPart;
            IPropertyValue cfr_ignored_0 = (IPropertyValue)iIpsObjectPart;
            return this.propertyValueCollection.addPropertyValue((IPropertyValue)propertyValue);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (super.removePartThis(part)) {
            return true;
        }
        if (part instanceof IProductCmptLink) {
            return this.linkCollection.remove((IProductCmptLink)part);
        }
        IIpsObjectPart iIpsObjectPart = part;
        if (iIpsObjectPart instanceof IPropertyValue) {
            void propertyValue;
            IPropertyValue iPropertyValue = (IPropertyValue)iIpsObjectPart;
            IPropertyValue cfr_ignored_0 = (IPropertyValue)iIpsObjectPart;
            return this.propertyValueCollection.removePropertyValue((IPropertyValue)propertyValue);
        }
        return false;
    }

    @Override
    protected void reinitPartCollectionsThis() {
        super.reinitPartCollectionsThis();
        this.propertyValueCollection.clear();
        this.linkCollection.clear();
    }

    @Override
    public List<IProductCmptGeneration> getProductCmptGenerations() {
        ArrayList<IProductCmptGeneration> generations = new ArrayList<IProductCmptGeneration>();
        List<IIpsObjectGeneration> ipsObjectGenerations = this.getGenerations();
        for (IIpsObjectGeneration ipsObjectGeneration : ipsObjectGenerations) {
            generations.add((IProductCmptGeneration)ipsObjectGeneration);
        }
        return generations;
    }

    @Override
    public IProductCmptGeneration getGenerationEffectiveOn(GregorianCalendar date) {
        return (IProductCmptGeneration)super.getGenerationEffectiveOn(date);
    }

    @Override
    public IProductCmptGeneration getBestMatchingGenerationEffectiveOn(GregorianCalendar date) {
        return (IProductCmptGeneration)super.getBestMatchingGenerationEffectiveOn(date);
    }

    @Override
    public IProductCmptGeneration getGenerationByEffectiveDate(GregorianCalendar date) {
        return (IProductCmptGeneration)super.getGenerationByEffectiveDate(date);
    }

    @Override
    public List<IPropertyValue> findPropertyValues(IProductCmptCategory category, GregorianCalendar effectiveDate, IIpsProject ipsProject) {
        IProductCmptGeneration generation = this.getGenerationByEffectiveDate(effectiveDate);
        return category != null ? this.findPropertyValuesForSpecificCategory(generation, category, ipsProject) : this.findPropertyValuesForNoCategory(generation);
    }

    private List<IPropertyValue> findPropertyValuesForSpecificCategory(IProductCmptGeneration generation, IProductCmptCategory category, IIpsProject ipsProject) {
        ArrayList<IPropertyValue> propertyValues = new ArrayList<IPropertyValue>();
        IProductCmptType contextType = this.findProductCmptType(ipsProject);
        if (contextType == null) {
            return propertyValues;
        }
        for (IProductCmptProperty property : category.findProductCmptProperties(contextType, true, ipsProject)) {
            propertyValues.addAll(this.getPropertyValues(property));
            if (generation == null) continue;
            propertyValues.addAll(generation.getPropertyValues(property));
        }
        return propertyValues;
    }

    private List<IPropertyValue> findPropertyValuesForNoCategory(IProductCmptGeneration generation) {
        ArrayList<IPropertyValue> propertyValues = new ArrayList<IPropertyValue>();
        propertyValues.addAll(this.getAllPropertyValues());
        propertyValues.addAll(generation.getAllPropertyValues());
        return propertyValues;
    }

    @Override
    public boolean isContainerFor(IProductCmptTypeAssociation association) {
        return association.isChangingOverTime() == this.isChangingOverTimeContainer();
    }

    @Override
    public int getNumOfLinks() {
        return this.linkCollection.size();
    }

    @Override
    public IProductCmptLink newLink(IProductCmptTypeAssociation association) {
        return this.newLink(association.getName());
    }

    @Override
    public IProductCmptLink newLink(String associationName) {
        IProductCmptLink newLink = this.linkCollection.createAndAddNewLink(this, associationName, this.getNextPartId());
        this.objectHasChanged();
        return newLink;
    }

    @Override
    public IProductCmptLink newLink(String associationName, IProductCmptLink insertAbove) {
        IProductCmptLink newLink = this.linkCollection.createAndInsertNewLink(this, associationName, this.getNextPartId(), insertAbove);
        this.objectHasChanged();
        return newLink;
    }

    @Override
    public boolean canCreateValidLink(IProductCmpt target, IProductCmptTypeAssociation association, IIpsProject ipsProject) {
        return ProductCmptLinkContainerUtil.canCreateValidLink(this, target, association, ipsProject);
    }

    @Override
    public boolean moveLink(IProductCmptLink toMove, IProductCmptLink target, boolean above) {
        boolean moved = this.linkCollection.moveLink(toMove, target, above);
        if (moved) {
            this.objectHasChanged();
        }
        return moved;
    }

    @Override
    public List<IProductCmptLink> getLinksAsList() {
        return this.linkCollection.getLinks();
    }

    @Override
    public List<IProductCmptLink> getLinksAsList(String associationName) {
        return this.linkCollection.getLinks(associationName);
    }

    @Override
    public List<IProductCmptLink> getLinksIncludingGenerations() {
        List<IProductCmptLink> linksAsList = this.getLinksAsList();
        for (IProductCmptGeneration generation : this.getProductCmptGenerations()) {
            linksAsList.addAll(generation.getLinksAsList());
        }
        return linksAsList;
    }

    @Override
    public IProductCmpt getProductCmpt() {
        return this;
    }

    @Override
    public ITableContentUsage getTableContentUsage(String rolename) {
        return this.propertyValueCollection.getPropertyValue(rolename, ITableContentUsage.class);
    }

    @Override
    public ITableContentUsage[] getTableContentUsages() {
        List<ITableContentUsage> usages = this.propertyValueCollection.getPropertyValues(ITableContentUsage.class);
        return usages.toArray(new ITableContentUsage[usages.size()]);
    }

    @Override
    public IFormula[] getFormulas() {
        List<IFormula> formulas = this.propertyValueCollection.getPropertyValues(IFormula.class);
        return formulas.toArray(new IFormula[formulas.size()]);
    }

    @Override
    public IFormula getFormula(String formulaName) {
        return this.propertyValueCollection.getPropertyValue(formulaName, IFormula.class);
    }

    @Override
    public boolean allowGenerations() {
        IProductCmptType productComponentType = this.findProductCmptType(this.getIpsProject());
        return productComponentType == null ? true : productComponentType.isChangingOverTime();
    }

    @Override
    public boolean isProductTemplate() {
        return this.getIpsObjectType().equals(IpsObjectType.PRODUCT_TEMPLATE);
    }

    @Override
    public boolean isPartOfTemplateHierarchy() {
        return this.isProductTemplate() || this.isUsingTemplate();
    }

    @Override
    public void removeUndefinedLinks() {
        this.linkCollection.removeUndefinedLinks();
    }

    @Override
    public int getNumOfValidationRules() {
        return this.getValidationRuleConfigs().size();
    }

    @Override
    public IValidationRuleConfig getValidationRuleConfig(String validationRuleName) {
        return this.propertyValueCollection.getPropertyValue(validationRuleName, IValidationRuleConfig.class);
    }

    @Override
    public List<IValidationRuleConfig> getValidationRuleConfigs() {
        return this.propertyValueCollection.getPropertyValues(IValidationRuleConfig.class);
    }

    @Override
    public IValidationRuleConfig newValidationRuleConfig(IValidationRule ruleToBeConfigured) {
        IValidationRuleConfig ruleConfig = this.propertyValueCollection.newPropertyValue(ruleToBeConfigured, this.getNextPartId(), IValidationRuleConfig.class);
        this.objectHasChanged();
        return ruleConfig;
    }
}

