/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectGeneration;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptGenerationToTypeDelta;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLink;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLinkCollection;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLinkContainerUtil;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLinkContainerValidator;
import org.faktorips.devtools.model.internal.productcmpt.ProductPartCollection;
import org.faktorips.devtools.model.internal.productcmpt.PropertyValueCollection;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.ITimedIpsObject;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IConfiguredDefault;
import org.faktorips.devtools.model.productcmpt.IConfiguredValueSet;
import org.faktorips.devtools.model.productcmpt.IExpressionDependencyDetail;
import org.faktorips.devtools.model.productcmpt.IFormula;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptGeneration;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainerToTypeDelta;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.productcmpt.IValidationRuleConfig;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValue;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeMethod;
import org.faktorips.devtools.model.productcmpttype.ITableStructureUsage;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.w3c.dom.Element;

public class ProductCmptGeneration
extends IpsObjectGeneration
implements IProductCmptGeneration {
    private final ProductCmptLinkCollection linkCollection = new ProductCmptLinkCollection();
    private final PropertyValueCollection propertyValueCollection = new PropertyValueCollection(this);
    private final ProductPartCollection productPartCollection = new ProductPartCollection(this.propertyValueCollection, this.linkCollection);

    public ProductCmptGeneration(ITimedIpsObject ipsObject, String id) {
        super(ipsObject, id);
    }

    public ProductCmptGeneration() {
    }

    @Override
    public IProductCmpt getProductCmpt() {
        return (IProductCmpt)this.getParent();
    }

    @Override
    public IProductCmptType findProductCmptType(IIpsProject ipsProject) {
        return this.getProductCmpt().findProductCmptType(ipsProject);
    }

    @Override
    public IPolicyCmptType findPolicyCmptType(IIpsProject ipsProject) {
        return this.getProductCmpt().findPolicyCmptType(ipsProject);
    }

    void dependsOn(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        this.linkCollection.addRelatedProductCmptQualifiedNameTypes(dependencies, details);
        this.addRelatedTableContentsQualifiedNameTypes(dependencies, details);
        this.addDependenciesFromFormulaExpressions(dependencies, details);
    }

    private void addRelatedTableContentsQualifiedNameTypes(Set<IDependency> qaTypes, Map<IDependency, List<IDependencyDetail>> details) {
        ITableContentUsage[] tableContentUsages;
        ITableContentUsage[] iTableContentUsageArray = tableContentUsages = this.getTableContentUsages();
        int n = tableContentUsages.length;
        int n2 = 0;
        while (n2 < n) {
            ITableContentUsage tableContentUsage = iTableContentUsageArray[n2];
            IpsObjectDependency dependency = IpsObjectDependency.createReferenceDependency(this.getIpsObject().getQualifiedNameType(), new QualifiedNameType(tableContentUsage.getTableContentName(), IpsObjectType.TABLE_CONTENTS));
            qaTypes.add(dependency);
            this.addDetails(details, dependency, tableContentUsage, "tableContentName");
            ++n2;
        }
    }

    void addDependenciesFromFormulaExpressions(Set<IDependency> dependencies, Map<IDependency, List<IDependencyDetail>> details) {
        IFormula[] formulas;
        IFormula[] iFormulaArray = formulas = this.getFormulas();
        int n = formulas.length;
        int n2 = 0;
        while (n2 < n) {
            IFormula formula = iFormulaArray[n2];
            Map formulaDependencies = formula.dependsOn();
            dependencies.addAll(formulaDependencies.keySet());
            if (details != null) {
                this.mergeDependencyDetails(details, formulaDependencies);
            }
            ++n2;
        }
    }

    private void mergeDependencyDetails(Map<IDependency, List<IDependencyDetail>> details, Map<IDependency, IExpressionDependencyDetail> formulaDependencies) {
        for (Map.Entry<IDependency, IExpressionDependencyDetail> entry : formulaDependencies.entrySet()) {
            List dependenciesDetailsList = details.computeIfAbsent(entry.getKey(), $ -> new ArrayList());
            dependenciesDetailsList.add((IDependencyDetail)entry.getValue());
        }
    }

    @Override
    public boolean isChangingOverTimeContainer() {
        return true;
    }

    @Override
    public List<IPropertyValue> getPropertyValues(IProductCmptProperty property) {
        return this.propertyValueCollection.getPropertyValues(property);
    }

    @Override
    public boolean hasPropertyValue(IProductCmptProperty property, PropertyValueType type) {
        return this.getPropertyValue(property, type.getInterfaceClass()) != null;
    }

    @Override
    public List<IPropertyValue> getPropertyValues(String propertyName) {
        return this.propertyValueCollection.getPropertyValues(propertyName);
    }

    @Override
    public <T extends IPropertyValue> T getPropertyValue(IProductCmptProperty property, Class<T> type) {
        return this.propertyValueCollection.getPropertyValue(property, type);
    }

    @Override
    public <T extends IPropertyValue> T getPropertyValue(String propertyName, Class<T> type) {
        return this.propertyValueCollection.getPropertyValue(propertyName, type);
    }

    @Override
    public <T extends IPropertyValue> List<T> getPropertyValues(Class<T> type) {
        return this.propertyValueCollection.getPropertyValues(type);
    }

    @Override
    public List<IPropertyValue> getAllPropertyValues() {
        return this.propertyValueCollection.getAllPropertyValues();
    }

    @Override
    public <T extends IPropertyValue> T newPropertyValue(IProductCmptProperty property, Class<T> type) {
        T newPropertyValue = this.propertyValueCollection.newPropertyValue(property, this.getNextPartId(), type);
        this.objectHasChanged();
        return newPropertyValue;
    }

    @Override
    public List<IPropertyValue> newPropertyValues(IProductCmptProperty property) {
        List<IPropertyValue> newPropertyValues = this.propertyValueCollection.newPropertyValues(this, property, this.getNextPartId());
        this.objectHasChanged();
        return newPropertyValues;
    }

    @Override
    public <T extends IIpsObjectPart> List<T> getProductParts(Class<T> type) {
        return this.productPartCollection.getProductParts(type);
    }

    public IPropertyValueContainerToTypeDelta computeDeltaToModel(IIpsProject ipsProject) {
        return new ProductCmptGenerationToTypeDelta(this, ipsProject);
    }

    @Override
    public IAttributeValue[] getAttributeValues() {
        List<IAttributeValue> attributeValues = this.propertyValueCollection.getPropertyValues(IAttributeValue.class);
        return attributeValues.toArray(new IAttributeValue[attributeValues.size()]);
    }

    @Override
    public IAttributeValue getAttributeValue(String attribute) {
        return this.propertyValueCollection.getPropertyValue(attribute, IAttributeValue.class);
    }

    @Override
    public int getNumOfAttributeValues() {
        return this.getAttributeValues().length;
    }

    @Override
    public IAttributeValue newAttributeValue() {
        IAttributeValue value = this.propertyValueCollection.newPropertyValue(this.getNextPartId(), IAttributeValue.class);
        this.objectHasChanged();
        return value;
    }

    @Override
    public IAttributeValue newAttributeValue(IProductCmptTypeAttribute attribute) {
        IAttributeValue newPropertyValue = this.propertyValueCollection.newPropertyValue(attribute, this.getNextPartId(), IAttributeValue.class);
        this.objectHasChanged();
        return newPropertyValue;
    }

    @Override
    public IConfiguredDefault[] getConfiguredDefaults() {
        List<IConfiguredDefault> configuredDefaults = this.propertyValueCollection.getPropertyValues(IConfiguredDefault.class);
        return configuredDefaults.toArray(new IConfiguredDefault[configuredDefaults.size()]);
    }

    @Override
    public IConfiguredValueSet[] getConfiguredValueSets() {
        List<IConfiguredValueSet> configuredValueSets = this.propertyValueCollection.getPropertyValues(IConfiguredValueSet.class);
        return configuredValueSets.toArray(new IConfiguredValueSet[configuredValueSets.size()]);
    }

    @Override
    public IConfiguredDefault getConfiguredDefault(String attributeName) {
        return this.propertyValueCollection.getPropertyValue(attributeName, IConfiguredDefault.class);
    }

    @Override
    public IConfiguredValueSet getConfiguredValueSet(String attributeName) {
        return this.propertyValueCollection.getPropertyValue(attributeName, IConfiguredValueSet.class);
    }

    @Override
    public int getNumOfConfigElements() {
        return this.getConfiguredDefaults().length + this.getConfiguredValueSets().length;
    }

    @Override
    public IProductCmptLink[] getLinks() {
        List<IProductCmptLink> result = this.getLinksAsList();
        return result.toArray(new ProductCmptLink[result.size()]);
    }

    @Override
    public IProductCmptLink[] getLinks(String typeLink) {
        List<IProductCmptLink> result = this.getLinksAsList(typeLink);
        return result.toArray(new ProductCmptLink[result.size()]);
    }

    @Override
    public int getNumOfLinks() {
        return this.linkCollection.size();
    }

    @Override
    public IProductCmptLink newLink(IProductCmptTypeAssociation association) {
        return this.newLink(association.getName());
    }

    @Override
    public IProductCmptLink newLink(String associationName) {
        IProductCmptLink newLink = this.linkCollection.createAndAddNewLink(this, associationName, this.getNextPartId());
        this.objectHasChanged();
        return newLink;
    }

    @Override
    public IProductCmptLink newLink(String associationName, IProductCmptLink insertAbove) {
        IProductCmptLink newLink = this.linkCollection.createAndInsertNewLink(this, associationName, this.getNextPartId(), insertAbove);
        this.objectHasChanged();
        return newLink;
    }

    @Override
    public boolean canCreateValidLink(IProductCmpt target, IProductCmptTypeAssociation association, IIpsProject ipsProject) {
        return ProductCmptLinkContainerUtil.canCreateValidLink(this, target, association, ipsProject);
    }

    @Override
    public boolean moveLink(IProductCmptLink toMove, IProductCmptLink target, boolean above) {
        boolean moved = this.linkCollection.moveLink(toMove, target, above);
        if (moved) {
            this.objectHasChanged();
        }
        return moved;
    }

    @Override
    public ITableContentUsage newTableContentUsage() {
        ITableContentUsage value = this.propertyValueCollection.newPropertyValue(this.getNextPartId(), ITableContentUsage.class);
        this.objectHasChanged();
        return value;
    }

    @Override
    public ITableContentUsage newTableContentUsage(ITableStructureUsage structureUsage) {
        ITableContentUsage tableUsage = this.propertyValueCollection.newPropertyValue(structureUsage, this.getNextPartId(), ITableContentUsage.class);
        this.objectHasChanged();
        return tableUsage;
    }

    @Override
    public int getNumOfTableContentUsages() {
        return this.getTableContentUsages().length;
    }

    @Override
    public ITableContentUsage[] getTableContentUsages() {
        List<ITableContentUsage> usages = this.propertyValueCollection.getPropertyValues(ITableContentUsage.class);
        return usages.toArray(new ITableContentUsage[usages.size()]);
    }

    public boolean containsFormula() {
        return this.getNumOfFormulas() > 0;
    }

    @Override
    public int getNumOfFormulas() {
        return this.getFormulas().length;
    }

    @Override
    public IFormula[] getFormulas() {
        List<IFormula> formulae = this.propertyValueCollection.getPropertyValues(IFormula.class);
        return formulae.toArray(new IFormula[formulae.size()]);
    }

    @Override
    public IFormula getFormula(String formulaName) {
        return this.propertyValueCollection.getPropertyValue(formulaName, IFormula.class);
    }

    @Override
    public IFormula newFormula() {
        IFormula value = this.propertyValueCollection.newPropertyValue(this.getNextPartId(), IFormula.class);
        this.objectHasChanged();
        return value;
    }

    @Override
    public IFormula newFormula(IProductCmptTypeMethod signature) {
        IFormula newPropertyValue = this.propertyValueCollection.newPropertyValue(signature, this.getNextPartId(), IFormula.class);
        this.objectHasChanged();
        return newPropertyValue;
    }

    @Override
    protected IIpsElement[] getChildrenThis() {
        int size = this.getNumOfAttributeValues() + this.getNumOfConfigElements() + this.getNumOfTableContentUsages() + this.getNumOfFormulas() + this.getNumOfValidationRules() + this.getNumOfLinks();
        ArrayList<ITemplatedValue> children = new ArrayList<ITemplatedValue>(size);
        children.addAll(this.propertyValueCollection.getAllPropertyValues());
        children.addAll(this.getLinksAsList());
        return children.toArray(new IIpsElement[children.size()]);
    }

    @Override
    protected IIpsObjectPart newPartThis(Class<? extends IIpsObjectPart> partType) {
        if (IPolicyCmptTypeAssociation.class.isAssignableFrom(partType)) {
            return this.createAndAddNewLinkInternal(this.getNextPartId());
        }
        if (IPropertyValue.class.isAssignableFrom(partType)) {
            Class<IPropertyValue> propertyValueType = partType.asSubclass(IPropertyValue.class);
            return this.propertyValueCollection.newPropertyValue(this.getNextPartId(), propertyValueType);
        }
        return null;
    }

    @Override
    protected IIpsObjectPart newPartThis(Element xmlTag, String id) {
        String xmlTagName = xmlTag.getNodeName();
        if (xmlTagName.equals("Link")) {
            return this.createAndAddNewLinkInternal(id);
        }
        return this.propertyValueCollection.newPropertyValue(xmlTagName, id);
    }

    private IProductCmptLink createAndAddNewLinkInternal(String id) {
        ProductCmptLink newLink = new ProductCmptLink(this, id);
        this.linkCollection.addLink(newLink);
        return newLink;
    }

    @Override
    protected boolean addPartThis(IIpsObjectPart part) {
        if (part instanceof IProductCmptLink) {
            return this.linkCollection.addLink((IProductCmptLink)part);
        }
        if (part instanceof IPropertyValue) {
            return this.propertyValueCollection.addPropertyValue((IPropertyValue)part);
        }
        return false;
    }

    @Override
    protected boolean removePartThis(IIpsObjectPart part) {
        if (part instanceof IProductCmptLink) {
            return this.linkCollection.remove((IProductCmptLink)part);
        }
        if (part instanceof IPropertyValue) {
            return this.propertyValueCollection.removePropertyValue((IPropertyValue)part);
        }
        return false;
    }

    @Override
    protected void reinitPartCollectionsThis() {
        this.propertyValueCollection.clear();
        this.linkCollection.clear();
    }

    @Override
    public boolean isContainerFor(IProductCmptProperty property) {
        return property.isChangingOverTime();
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        super.validateThis(list, ipsProject);
        IProductCmptType type = this.findProductCmptType(ipsProject);
        if (type == null) {
            list.add(new Message("PRODUCTCMPTGEN-NoTemplate", Messages.ProductCmptGeneration_msgTemplateNotFound, Message.ERROR, (Object)this));
            return;
        }
        new ProductCmptLinkContainerValidator(ipsProject, this).startAndAddMessagesToList(type, list);
    }

    @Override
    public ITableContentUsage getTableContentUsage(String rolename) {
        return this.propertyValueCollection.getPropertyValue(rolename, ITableContentUsage.class);
    }

    @Override
    public int getNumOfValidationRules() {
        return this.getValidationRuleConfigs().size();
    }

    @Override
    public IValidationRuleConfig getValidationRuleConfig(String validationRuleName) {
        return this.propertyValueCollection.getPropertyValue(validationRuleName, IValidationRuleConfig.class);
    }

    @Override
    public List<IValidationRuleConfig> getValidationRuleConfigs() {
        return this.propertyValueCollection.getPropertyValues(IValidationRuleConfig.class);
    }

    @Override
    public IValidationRuleConfig newValidationRuleConfig(IValidationRule ruleToBeConfigured) {
        IValidationRuleConfig ruleConfig = this.propertyValueCollection.newPropertyValue(ruleToBeConfigured, this.getNextPartId(), IValidationRuleConfig.class);
        this.objectHasChanged();
        return ruleConfig;
    }

    @Override
    public String getProductCmptType() {
        return this.getProductCmpt().getProductCmptType();
    }

    @Override
    public boolean isContainerFor(IProductCmptTypeAssociation association) {
        return association.isChangingOverTime();
    }

    @Override
    public List<IProductCmptLink> getLinksAsList() {
        return this.linkCollection.getLinks();
    }

    @Override
    public List<IProductCmptLink> getLinksAsList(String associationName) {
        return this.linkCollection.getLinks(associationName);
    }

    @Override
    public List<IProductCmptLink> getLinksIncludingProductCmpt() {
        List linksAsList = this.getProductCmpt().getLinksAsList();
        linksAsList.addAll(this.getLinksAsList());
        return linksAsList;
    }

    @Override
    public <T extends IPropertyValue> List<T> getPropertyValuesIncludingProductCmpt(Class<T> type) {
        List values = this.getProductCmpt().getPropertyValues(type);
        values.addAll(this.getPropertyValues(type));
        return values;
    }

    @Override
    public boolean isProductTemplate() {
        return this.getProductCmpt().isProductTemplate();
    }

    @Override
    public IProductCmptGeneration findTemplate(IIpsProject ipsProject) {
        IProductCmpt template = this.getProductCmpt().findTemplate(ipsProject);
        if (template == null) {
            return null;
        }
        return template.getGenerationEffectiveOn(this.getValidFrom());
    }

    @Override
    public boolean isUsingTemplate() {
        return this.getProductCmpt().isUsingTemplate();
    }

    @Override
    public String getTemplate() {
        return this.getProductCmpt().getTemplate();
    }

    @Override
    public boolean isPartOfTemplateHierarchy() {
        return this.getProductCmpt().isPartOfTemplateHierarchy();
    }

    @Override
    public void removeUndefinedLinks() {
        this.linkCollection.removeUndefinedLinks();
    }
}

