/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.Objects;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmptKind;
import org.faktorips.devtools.model.productcmpt.IProductCmptNamingStrategy;
import org.faktorips.util.ArgumentCheck;

public class ProductCmptKind
implements IProductCmptKind {
    private final String name;
    private final String runtimeId;

    public ProductCmptKind(String name, String runtimeId) {
        ArgumentCheck.notNull((Object)name);
        ArgumentCheck.notNull((Object)runtimeId);
        this.name = name;
        this.runtimeId = runtimeId;
    }

    public static IProductCmptKind createProductCmptKind(String name, IIpsProject ipsProject) {
        IProductCmptNamingStrategy stratgey = ipsProject.getProductCmptNamingStrategy();
        try {
            String kindName = stratgey.getKindId(name);
            return new ProductCmptKind(kindName, String.valueOf(ipsProject.getRuntimeIdPrefix()) + kindName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ProductCmptKind [name=" + this.name + ", runtimeId=" + this.runtimeId + "]";
    }

    public int hashCode() {
        return Objects.hash(this.name, this.runtimeId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProductCmptKind other = (ProductCmptKind)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.runtimeId, other.runtimeId);
    }

    @Override
    public String getRuntimeId() {
        return this.runtimeId;
    }
}

