/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.model.HierarchyVisitor;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.ValidationUtils;
import org.faktorips.devtools.model.internal.ipsobject.AtomicIpsObjectPart;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueFinder;
import org.faktorips.devtools.model.internal.productcmpt.template.TemplateValueSettings;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.productcmpt.Cardinality;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.util.NullSafeComparableComparator;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProductCmptLink
extends AtomicIpsObjectPart
implements IProductCmptLink {
    private static final Cardinality DEFAULT_CARDINALITY = new Cardinality(0, 1, 0);
    private String association = "";
    private String target = "";
    private String targetRuntimeId = "";
    private Cardinality cardinality = DEFAULT_CARDINALITY;
    private final TemplateValueSettings templateValueSettings = new TemplateValueSettings(this);

    public ProductCmptLink(IProductCmptLinkContainer parent, String id) {
        super(parent, id);
    }

    @Override
    public IProductCmpt getProductCmpt() {
        return this.getProductCmptLinkContainer().getProductCmpt();
    }

    @Override
    public IProductCmptLinkContainer getProductCmptLinkContainer() {
        return (IProductCmptLinkContainer)this.getParent();
    }

    @Override
    public IProductCmptLinkContainer getTemplatedValueContainer() {
        return this.getProductCmptLinkContainer();
    }

    @Override
    public String getName() {
        return this.target;
    }

    @Override
    public String getAssociation() {
        return this.association;
    }

    @Override
    public IProductCmptTypeAssociation findAssociation(IIpsProject ipsProject) {
        IProductCmptType productCmptType = this.getProductCmpt().findProductCmptType(ipsProject);
        if (productCmptType == null) {
            return null;
        }
        return (IProductCmptTypeAssociation)productCmptType.findAssociation(this.association, ipsProject);
    }

    @Override
    public void setAssociation(String association) {
        String oldAsso = this.association;
        this.association = association;
        this.valueChanged(oldAsso, association);
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public IProductCmpt findTarget(IIpsProject ipsProject) {
        return ipsProject.findProductCmpt(this.target);
    }

    @Override
    public void setTarget(String newTarget) {
        String oldTarget = this.target;
        this.target = newTarget;
        this.valueChanged(oldTarget, this.target);
        IProductCmpt targetProductCmpt = this.findTarget(this.getIpsProject());
        if (targetProductCmpt != null) {
            this.setTargetRuntimeId(targetProductCmpt.getRuntimeId());
        } else {
            this.setTargetRuntimeId(null);
        }
    }

    @Override
    public String getTargetRuntimeId() {
        return this.targetRuntimeId;
    }

    @Override
    public void setTargetRuntimeId(String newTargetRuntimeId) {
        String oldTargetRuntimeId = this.targetRuntimeId;
        this.targetRuntimeId = newTargetRuntimeId;
        this.valueChanged(oldTargetRuntimeId, this.targetRuntimeId);
    }

    @Override
    public Cardinality getCardinality() {
        if (this.getTemplateValueStatus() == TemplateValueStatus.INHERITED) {
            return this.findTemplateCardinality();
        }
        return this.cardinality;
    }

    private Cardinality findTemplateCardinality() {
        IProductCmptLink templateLink = this.findTemplateProperty(this.getIpsProject());
        if (templateLink == null) {
            return this.cardinality;
        }
        return templateLink.getCardinality();
    }

    @Override
    public void setCardinality(Cardinality cardinality) {
        Cardinality oldValue = this.cardinality;
        this.cardinality = cardinality;
        this.valueChanged(oldValue, cardinality, "cardinality");
    }

    @Override
    public int getMinCardinality() {
        return this.getCardinality().getMin();
    }

    @Override
    public void setMinCardinality(int newValue) {
        int oldValue = this.getMinCardinality();
        this.cardinality = this.getCardinality().withMin(newValue);
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public int getDefaultCardinality() {
        return this.getCardinality().getDefault();
    }

    @Override
    public void setDefaultCardinality(int newValue) {
        int oldValue = this.getDefaultCardinality();
        this.cardinality = this.getCardinality().withDefault(newValue);
        this.valueChanged(oldValue, newValue);
    }

    @Override
    public int getMaxCardinality() {
        return this.getCardinality().getMax();
    }

    @Override
    public void setMaxCardinality(int newValue) {
        int oldValue = this.getMaxCardinality();
        this.cardinality = this.getCardinality().withMax(newValue);
        this.valueChanged(oldValue, newValue);
    }

    @Override
    protected void validateThis(MessageList list, IIpsProject ipsProject) {
        if (this.isDeleted()) {
            return;
        }
        super.validateThis(list, ipsProject);
        ValidationUtils.checkIpsObjectReference(this.target, IpsObjectType.PRODUCT_CMPT, "target", this, "target", "PRODUCTCMPT_RELATION-UnknownTarget", list);
        IProductCmptTypeAssociation associationObj = this.findAssociation(ipsProject);
        if (associationObj == null) {
            String typeLabel = this.getProductCmpt().getProductCmptType();
            IProductCmptType productCmptType = this.getProductCmpt().findProductCmptType(ipsProject);
            if (productCmptType != null) {
                typeLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(productCmptType);
            }
            String text = MessageFormat.format(Messages.ProductCmptRelation_msgNoRelationDefined, this.association, typeLabel);
            list.add(new Message("PRODUCTCMPT_RELATION-UnknownAssociation", text, Message.ERROR, (Object)this, new String[]{"association"}));
        } else {
            this.validateCardinalityForMatchingAssociation(list, ipsProject, associationObj);
            IProductCmpt targetObj = this.findTarget(ipsProject);
            if (!this.willBeValid(targetObj, associationObj, ipsProject)) {
                String associationLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(associationObj);
                String msg = MessageFormat.format(Messages.ProductCmptRelation_msgInvalidTarget, this.target, associationLabel);
                list.add(new Message("PRODUCTCMPT_RELATION-InvalidTarget", msg, Message.ERROR, (Object)this, new String[]{"target"}));
            }
            this.validateChangingOverTimeProperty(list, associationObj);
        }
        list.add(this.templateValueSettings.validate(this, ipsProject));
    }

    protected void validateCardinalityForMatchingAssociation(MessageList list, IIpsProject ipsProject, IProductCmptTypeAssociation associationObj) {
        IPolicyCmptTypeAssociation polAssociation = associationObj.findMatchingPolicyCmptTypeAssociation(ipsProject);
        if (polAssociation != null) {
            this.validateCardinality(list, polAssociation);
        }
    }

    private void validateChangingOverTimeProperty(MessageList list, IProductCmptTypeAssociation associationObj) {
        if (!this.getProductCmptLinkContainer().isContainerFor(associationObj)) {
            String associationLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(associationObj);
            String msg = associationObj.isChangingOverTime() ? MessageFormat.format(Messages.ProductCmptLink_msgChaningOverTimeMismatch_partOfComponent, associationLabel, this.getName()) : MessageFormat.format(Messages.ProductCmptLink_msgChaningOverTimeMismatch_partOfGeneration, associationLabel, this.getName(), IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNameSingular(true));
            ObjectProperty prop1 = new ObjectProperty((Object)this, "association");
            ObjectProperty prop2 = new ObjectProperty((Object)associationObj.getTargetRoleSingular(), null);
            list.add(new Message("PRODUCTCMPT_RELATION-ChangingOverTimeMismatch", msg, Message.ERROR, new ObjectProperty[]{prop1, prop2}));
        }
    }

    private void validateCardinality(MessageList list, IPolicyCmptTypeAssociation associationObj) {
        MessageList cardinalityValidation = this.getCardinality().validate(this);
        list.add(cardinalityValidation);
        if (!cardinalityValidation.containsErrorMsg() && associationObj.isQualified() && this.getMaxCardinality() > associationObj.getMaxCardinality()) {
            String text = MessageFormat.format(Messages.ProductCmptLink_msgMaxCardinalityExceedsModelMaxQualified, this.getMaxCardinality(), associationObj.getMaxCardinality());
            list.add(new Message("PRODUCTCMPT_RELATION-MaxCardinalityExceedsModelMax", text, Message.ERROR, (Object)this, new String[]{"maxCardinality"}));
        }
    }

    @Override
    protected Element createElement(Document doc) {
        return doc.createElement("Link");
    }

    @Override
    protected void initPropertiesFromXml(Element element, String id) {
        int maxCardinality;
        int defaultCardinality;
        int minCardinality;
        super.initPropertiesFromXml(element, id);
        this.association = element.getAttribute("association");
        this.target = element.getAttribute("target");
        this.targetRuntimeId = element.getAttribute("targetRuntimeId");
        try {
            minCardinality = Integer.parseInt(element.getAttribute("minCardinality"));
        }
        catch (NumberFormatException e) {
            minCardinality = 0;
        }
        try {
            defaultCardinality = Integer.parseInt(element.getAttribute("defaultCardinality"));
        }
        catch (NumberFormatException e) {
            defaultCardinality = minCardinality;
        }
        String max = element.getAttribute("maxCardinality");
        if ("*".equals(max)) {
            maxCardinality = Integer.MAX_VALUE;
        } else {
            try {
                maxCardinality = Integer.parseInt(max);
            }
            catch (NumberFormatException e) {
                maxCardinality = 0;
            }
        }
        this.cardinality = minCardinality == 0 && maxCardinality == 0 && defaultCardinality == 0 ? Cardinality.UNDEFINED : new Cardinality(minCardinality, maxCardinality, defaultCardinality);
        this.templateValueSettings.initPropertiesFromXml(element);
    }

    @Override
    protected void propertiesToXml(Element element) {
        super.propertiesToXml(element);
        Cardinality card = this.getCardinality();
        element.setAttribute("association", this.association);
        element.setAttribute("target", this.target);
        element.setAttribute("targetRuntimeId", this.targetRuntimeId);
        element.setAttribute("minCardinality", Integer.toString(card.getMin()));
        element.setAttribute("defaultCardinality", Integer.toString(card.getDefault()));
        if (card.isToMany()) {
            element.setAttribute("maxCardinality", "*");
        } else {
            element.setAttribute("maxCardinality", Integer.toString(card.getMax()));
        }
        this.templateValueSettings.propertiesToXml(element);
    }

    @Override
    public boolean constrainsPolicyCmptTypeAssociation(IIpsProject ipsProject) {
        if (this.isDeleted()) {
            return false;
        }
        IProductCmptTypeAssociation assoc = this.findAssociation(ipsProject);
        if (assoc == null) {
            return false;
        }
        IPolicyCmptTypeAssociation matchingPolicyCmptTypeAssociation = assoc.findMatchingPolicyCmptTypeAssociation(ipsProject);
        return matchingPolicyCmptTypeAssociation != null && matchingPolicyCmptTypeAssociation.isConfigurable();
    }

    @Override
    public boolean isMandatory() {
        return this.getMinCardinality() == 1 && this.getMaxCardinality() == 1;
    }

    @Override
    public boolean isOptional() {
        return this.getMinCardinality() == 0 && this.getMaxCardinality() == 1;
    }

    @Override
    public boolean is1ToMany() {
        return this.getMaxCardinality() > 1;
    }

    @Override
    public String getCaption(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        String caption = null;
        IProductCmptTypeAssociation assoc = this.findAssociation(this.getIpsProject());
        if (assoc != null) {
            caption = assoc.getLabelValue(locale);
        }
        return caption;
    }

    @Override
    public String getPluralCaption(Locale locale) {
        ArgumentCheck.notNull((Object)locale);
        String pluralCaption = null;
        IProductCmptTypeAssociation assoc = this.findAssociation(this.getIpsProject());
        if (assoc != null) {
            pluralCaption = assoc.getPluralLabelValue(locale);
        }
        return pluralCaption;
    }

    @Override
    public String getLastResortCaption() {
        return StringUtils.capitalize((String)this.association);
    }

    @Override
    public String getLastResortPluralCaption() {
        return StringUtils.capitalize((String)this.association);
    }

    @Override
    public boolean isLinkOfAssociation(IAssociation association, IIpsProject ipsProject) {
        DerivedUnionVisitor hierarchyVisitor = new DerivedUnionVisitor(association, ipsProject);
        hierarchyVisitor.start(this.findAssociation(ipsProject));
        return hierarchyVisitor.found;
    }

    private boolean willBeValid(IProductCmpt target, IAssociation association, IIpsProject ipsProject) {
        if (target == null || association == null) {
            return false;
        }
        IProductCmptType actualTargetType = target.findProductCmptType(ipsProject);
        if (actualTargetType == null) {
            return false;
        }
        return actualTargetType.isSubtypeOrSameType(association.findTarget(ipsProject), ipsProject);
    }

    @Override
    public void setTemplateValueStatus(TemplateValueStatus newStatus) {
        TemplateValueStatus oldValue = this.templateValueSettings.getStatus();
        if (oldValue == newStatus) {
            return;
        }
        if (newStatus == TemplateValueStatus.DEFINED) {
            this.cardinality = Optional.ofNullable(this.findTemplateCardinality()).orElse(DEFAULT_CARDINALITY);
        } else if (newStatus == TemplateValueStatus.UNDEFINED) {
            this.cardinality = Cardinality.UNDEFINED;
        }
        this.templateValueSettings.setStatus(newStatus);
        this.objectHasChanged(new PropertyChangeEvent(this, "templateValueStatus", (Object)oldValue, (Object)newStatus));
    }

    @Override
    public TemplateValueStatus getTemplateValueStatus() {
        return this.templateValueSettings.getStatus();
    }

    @Override
    public void switchTemplateValueStatus() {
        this.setTemplateValueStatus(this.getTemplateValueStatus().getNextStatus(this));
    }

    @Override
    public IProductCmptLink findTemplateProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.findTemplateValue(this, IProductCmptLink.class);
    }

    @Override
    public boolean hasTemplateForProperty(IIpsProject ipsProject) {
        return TemplateValueFinder.hasTemplateForValue(this, IProductCmptLink.class);
    }

    @Override
    public boolean isPartOfTemplateHierarchy() {
        return this.getTemplatedValueContainer().isPartOfTemplateHierarchy() && (this.getTemplatedValueContainer().isProductTemplate() || this.isAssociationConfiguredInTemplate());
    }

    public boolean isAssociationConfiguredInTemplate() {
        IProductCmptLinkContainer template;
        IProductCmptLinkContainer templatedValueContainer = this.getTemplatedValueContainer();
        if (templatedValueContainer.isUsingTemplate() && (template = templatedValueContainer.findTemplate(this.getIpsProject())) != null) {
            IProductCmpt templateCmpt = template.getProductCmpt();
            IProductCmptType templateProductCmptType = templateCmpt.findProductCmptType(this.getIpsProject());
            return templateProductCmptType.findAssociation(this.association, this.getIpsProject()) != null;
        }
        return false;
    }

    @Override
    public void delete() {
        if (this.findTemplateProperty(this.getIpsProject()) != null) {
            this.setTemplateValueStatus(TemplateValueStatus.UNDEFINED);
        } else {
            super.delete();
        }
    }

    @Override
    public Comparator<Object> getValueComparator() {
        return new NullSafeComparableComparator<Object>();
    }

    @Override
    public Function<IProductCmptLink, Object> getValueGetter() {
        return IProductCmptLink::getCardinality;
    }

    @Override
    public Function<IProductCmptLink, Object> getInternalValueGetter() {
        return o -> {
            IProductCmptLink iProductCmptLink = o;
            if (iProductCmptLink instanceof ProductCmptLink) {
                void productCmptLink;
                ProductCmptLink productCmptLink2 = (ProductCmptLink)iProductCmptLink;
                ProductCmptLink cfr_ignored_0 = (ProductCmptLink)iProductCmptLink;
                return productCmptLink.cardinality;
            }
            throw new IllegalArgumentException("Illegal parameter " + o);
        };
    }

    public BiConsumer<IProductCmptLink, Object> getValueSetter() {
        return (productCmptLink, obj) -> {
            ArgumentCheck.isInstanceOf((Object)obj, Cardinality.class);
            productCmptLink.setCardinality((Cardinality)obj);
        };
    }

    @Override
    public IProductCmptLink.LinkIdentifier getIdentifier() {
        return new IProductCmptLink.LinkIdentifier(this);
    }

    @Override
    public boolean isConcreteValue() {
        return this.getTemplateValueStatus() == TemplateValueStatus.DEFINED || this.getTemplateValueStatus() == TemplateValueStatus.UNDEFINED;
    }

    @Override
    public boolean isConfiguringPolicyAssociation() {
        IProductCmptTypeAssociation productAsssociation = this.findAssociation(this.getIpsProject());
        return productAsssociation != null && productAsssociation.findMatchingPolicyCmptTypeAssociation(this.getIpsProject()) != null;
    }

    private static class DerivedUnionVisitor
    extends HierarchyVisitor<IAssociation> {
        private final IAssociation association;
        private boolean found;

        public DerivedUnionVisitor(IAssociation association, IIpsProject ipsProject) {
            super(ipsProject);
            this.association = association;
        }

        @Override
        protected IAssociation findSupertype(IAssociation currentAssociation, IIpsProject ipsProject) {
            return currentAssociation.findSubsettedDerivedUnion(ipsProject);
        }

        @Override
        protected boolean visit(IAssociation currentAssociation) {
            if (currentAssociation.equals(this.association)) {
                this.found = true;
                return false;
            }
            return true;
        }
    }
}

