/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.faktorips.devtools.model.dependency.IDependency;
import org.faktorips.devtools.model.dependency.IDependencyDetail;
import org.faktorips.devtools.model.internal.dependency.DependencyDetail;
import org.faktorips.devtools.model.internal.dependency.IpsObjectDependency;
import org.faktorips.devtools.model.internal.productcmpt.ProductCmptLink;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.ipsobject.QualifiedNameType;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;

public class ProductCmptLinkCollection {
    private final List<IProductCmptLink> links = new ArrayList<IProductCmptLink>();

    public List<IProductCmptLink> getLinks(String associationName) {
        return this.links.stream().filter(l -> associationName.equals(l.getAssociation())).collect(Collectors.toList());
    }

    public Map<String, List<IProductCmptLink>> getLinksAsMap() {
        LinkedHashMap<String, List<IProductCmptLink>> associationNameToLinksMap = new LinkedHashMap<String, List<IProductCmptLink>>();
        for (IProductCmptLink link : this.links) {
            associationNameToLinksMap.computeIfAbsent(link.getAssociation(), $ -> new ArrayList()).add(link);
        }
        return associationNameToLinksMap;
    }

    public List<IProductCmptLink> getLinks() {
        ArrayList<IProductCmptLink> allLinks = new ArrayList<IProductCmptLink>();
        for (List<IProductCmptLink> linkList : this.getLinksAsMap().values()) {
            allLinks.addAll(linkList);
        }
        return allLinks;
    }

    public boolean addLink(IProductCmptLink link) {
        this.throwExceptionIfLinkCannotBeAdded(link);
        return this.addLinkInternal(link);
    }

    private void throwExceptionIfLinkCannotBeAdded(IProductCmptLink link) {
        if (link == null) {
            throw new IllegalArgumentException("Cannot add \"null\" to a ProductCmptLinkCollection");
        }
    }

    public IProductCmptLink createAndAddNewLink(IProductCmptLinkContainer container, String associationName, String partId) {
        IProductCmptLink link = this.createLink(container, associationName, partId);
        this.addLink(link);
        return link;
    }

    public IProductCmptLink createAndInsertNewLink(IProductCmptLinkContainer container, String associationName, String partId, IProductCmptLink insertAbove) {
        IProductCmptLink link = this.createLink(container, associationName, partId);
        this.insertLink(link, insertAbove);
        return link;
    }

    protected IProductCmptLink createLink(IProductCmptLinkContainer container, String associationName, String partId) {
        ProductCmptLink link = new ProductCmptLink(container, partId);
        link.setAssociation(associationName);
        return link;
    }

    private boolean addLinkInternal(IProductCmptLink link) {
        return this.links.add(link);
    }

    public void insertLink(IProductCmptLink link, IProductCmptLink insertAbove) {
        if (insertAbove == null) {
            this.links.add(link);
        } else {
            int index = this.links.indexOf(insertAbove);
            if (index == -1) {
                this.links.add(link);
            } else {
                this.links.add(index, link);
            }
        }
    }

    public boolean moveLink(IProductCmptLink toMove, IProductCmptLink target, boolean above) {
        if (toMove == target) {
            return true;
        }
        if (toMove == null || target == null || !this.links.contains(target)) {
            return false;
        }
        boolean removed = this.links.remove(toMove);
        if (!removed) {
            return false;
        }
        int index = this.links.indexOf(target);
        if (!above) {
            ++index;
        }
        this.links.add(index, toMove);
        toMove.setAssociation(target.getAssociation());
        return true;
    }

    public boolean remove(IProductCmptLink link) {
        if (link == null) {
            return false;
        }
        return this.removeInternal(link);
    }

    private boolean removeInternal(IProductCmptLink link) {
        return this.links.remove(link);
    }

    public void clear() {
        this.links.clear();
    }

    public boolean containsLink(IProductCmptLink link) {
        if (link == null) {
            return false;
        }
        return this.containsLinkInternal(link);
    }

    private boolean containsLinkInternal(IProductCmptLink link) {
        return this.links.contains(link);
    }

    public void addRelatedProductCmptQualifiedNameTypes(Set<IDependency> qaTypes, Map<IDependency, List<IDependencyDetail>> details) {
        for (IProductCmptLink link : this.links) {
            IpsObjectDependency dependency = IpsObjectDependency.createReferenceDependency(link.getIpsObject().getQualifiedNameType(), new QualifiedNameType(link.getTarget(), IpsObjectType.PRODUCT_CMPT));
            qaTypes.add(dependency);
            if (details == null) continue;
            List detailList = details.computeIfAbsent(dependency, $ -> new ArrayList());
            detailList.add(new DependencyDetail(link, "target"));
        }
    }

    public int size() {
        return this.links.size();
    }

    public void removeUndefinedLinks() {
        for (IProductCmptLink link : new CopyOnWriteArrayList<IProductCmptLink>(this.links)) {
            if (link.getTemplateValueStatus() != TemplateValueStatus.UNDEFINED) continue;
            this.remove(link);
        }
    }
}

