/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.IAssociation;

public class ProductCmptLinkContainerUtil {
    private ProductCmptLinkContainerUtil() {
    }

    public static boolean canCreateValidLink(IProductCmptLinkContainer linkContainer, IProductCmpt target, IProductCmptTypeAssociation association, IIpsProject ipsProject) {
        if (association == null || target == null || !linkContainer.getProductCmpt().getIpsSrcFile().isMutable() || linkContainer.getLinksAsList(association.getName()).size() >= association.getMaxCardinality()) {
            return false;
        }
        if (!linkContainer.isContainerFor(association) || ProductCmptLinkContainerUtil.isLinkExisting(linkContainer, association, target, ipsProject) || !ProductCmptLinkContainerUtil.isTypeCorrect(target, association, ipsProject)) {
            return false;
        }
        return ProductCmptLinkContainerUtil.isProjectCorrect(linkContainer, target);
    }

    private static boolean isProjectCorrect(IProductCmptLinkContainer linkContainer, IProductCmpt target) {
        IIpsProject targetProject;
        IIpsProject linkContainerProject = linkContainer.getIpsProject();
        if (linkContainerProject.equals(targetProject = target.getIpsProject())) {
            return true;
        }
        return linkContainerProject.isReferencing(targetProject);
    }

    private static boolean isTypeCorrect(IProductCmpt target, IProductCmptTypeAssociation association, IIpsProject ipsProject) {
        IProductCmptType targetType = target.findProductCmptType(ipsProject);
        if (targetType == null) {
            return false;
        }
        return targetType.isSubtypeOrSameType(association.findTarget(ipsProject), ipsProject);
    }

    private static boolean isLinkExisting(IProductCmptLinkContainer linkContainer, IAssociation association, IProductCmpt target, IIpsProject ipsProject) {
        for (IProductCmptLink link : linkContainer.getLinksAsList()) {
            if (!link.findAssociation(ipsProject).equals(association) || !link.getTarget().equals(target.getQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

