/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.internal.productcmpt;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAssociation;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpt.template.TemplateValueStatus;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.ObjectProperty;
import org.faktorips.runtime.Severity;

public class ProductCmptLinkContainerValidator
extends TypeHierarchyVisitor<IProductCmptType> {
    private MessageList list;
    private final IProductCmptLinkContainer linkContainer;

    public ProductCmptLinkContainerValidator(IIpsProject ipsProject, IProductCmptLinkContainer linkContainer) {
        super(ipsProject);
        this.linkContainer = linkContainer;
        this.list = new MessageList();
    }

    public void startAndAddMessagesToList(IProductCmptType type, MessageList parentList) {
        this.list = new MessageList();
        this.start(type);
        parentList.add(this.list);
    }

    @Override
    protected boolean visit(IProductCmptType currentType) {
        List<IProductCmptTypeAssociation> associations = currentType.getProductCmptTypeAssociations();
        for (IProductCmptTypeAssociation association : associations) {
            if (association.isDerivedUnion() || !this.linkContainer.isContainerFor(association)) continue;
            this.validateAssociation(association);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void validateAssociation(IAssociation association) {
        IAssociation iAssociation;
        List<IProductCmptLink> relations = this.linkContainer.getLinksAsList(association.getTargetRoleSingular()).stream().filter(relation -> relation.getTemplateValueStatus() != TemplateValueStatus.UNDEFINED).collect(Collectors.toList());
        this.addMessageIfAssociationHasValidationMessages(association, this.list);
        this.addMessageIfDuplicateTargetPresent(association, relations, this.list);
        this.addMessageIfLessLinksThanMinCard(association, relations, this.list);
        this.addMessageIfMoreLinksThanMaxCard(association, relations, this.list);
        IIpsProjectProperties props = this.getIpsProject().getReadOnlyProperties();
        if (props.isReferencedProductComponentsAreValidOnThisGenerationsValidFromDateRuleEnabled()) {
            this.addMessageIfTargetNotValidOnValidFromDate(association, relations, this.list);
        }
        if ((iAssociation = association) instanceof IProductCmptTypeAssociation) {
            void productAssociation;
            IProductCmptTypeAssociation iProductCmptTypeAssociation = (IProductCmptTypeAssociation)iAssociation;
            IProductCmptTypeAssociation cfr_ignored_0 = (IProductCmptTypeAssociation)iAssociation;
            IPolicyCmptTypeAssociation policyCmptTypeAssociation = productAssociation.findMatchingPolicyCmptTypeAssociation(this.getIpsProject());
            this.validateCardinality(policyCmptTypeAssociation, relations, this.list);
        }
    }

    private void validateCardinality(IPolicyCmptTypeAssociation policyCmptTypeAssociation, List<IProductCmptLink> relations, MessageList list) {
        if (policyCmptTypeAssociation != null && !policyCmptTypeAssociation.isQualified()) {
            this.validateTotalMax(relations, list, policyCmptTypeAssociation);
            if (!this.linkContainer.isProductTemplate()) {
                this.validateTotalMin(relations, list, policyCmptTypeAssociation);
            }
        }
    }

    private void validateTotalMax(List<IProductCmptLink> relations, MessageList list, IPolicyCmptTypeAssociation associationObj) {
        int maxType = associationObj.getMaxCardinality();
        if (maxType != Integer.MAX_VALUE) {
            int sumMinCardinality = relations.stream().mapToInt(IProductCmptLink::getMinCardinality).sum();
            for (IProductCmptLink productCmptLink : relations) {
                int sumCardinality;
                if (productCmptLink.getMaxCardinality() < Integer.MAX_VALUE) {
                    sumCardinality = sumMinCardinality;
                    sumCardinality += productCmptLink.getMaxCardinality();
                    sumCardinality -= productCmptLink.getMinCardinality();
                } else {
                    sumCardinality = Integer.MAX_VALUE;
                }
                if (sumCardinality <= maxType) continue;
                String text = MessageFormat.format(Messages.ProductCmptLink_msgMaxCardinalityExceedsModelMax, productCmptLink.getMaxCardinality(), Integer.toString(maxType));
                list.add(new Message("PRODUCTCMPT_RELATION-MaxCardinalityExceedsModelMax", text, Message.ERROR, (Object)productCmptLink, new String[]{"maxCardinality"}));
            }
        }
    }

    private void validateTotalMin(List<IProductCmptLink> relations, MessageList list, IPolicyCmptTypeAssociation associationObj) {
        int minType = associationObj.getMinCardinality();
        for (IProductCmptLink productCmptLink : relations) {
            int sumMaxCardinality = productCmptLink.getMinCardinality();
            for (IProductCmptLink link : relations) {
                if (productCmptLink.equals(link)) continue;
                if (link.getMaxCardinality() == Integer.MAX_VALUE) {
                    sumMaxCardinality = Integer.MAX_VALUE;
                    break;
                }
                sumMaxCardinality += link.getMaxCardinality();
            }
            if (sumMaxCardinality >= minType) continue;
            this.addTotalMinMessage(list, minType, productCmptLink);
        }
    }

    private void addTotalMinMessage(MessageList list, int minType, IProductCmptLink link) {
        String text = MessageFormat.format(Messages.ProductCmptLink_msgMinCardinalityExceedsModelMin, link.getMinCardinality(), Integer.toString(minType));
        list.newError("PRODUCTCMPT_RELATION-MinCardinalityFallsBelowModelMin", text, (Object)link, new String[]{"minCardinality"});
    }

    protected void addMessageIfDuplicateTargetPresent(IAssociation association, List<IProductCmptLink> relations, MessageList messageList) {
        HashSet<String> targets = new HashSet<String>();
        String msg = null;
        for (IProductCmptLink relation : relations) {
            String target = relation.getTarget();
            if (targets.add(target)) continue;
            if (msg == null) {
                String associationLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(association);
                msg = MessageFormat.format(Messages.ProductCmptGeneration_msgDuplicateTarget, associationLabel, target);
            }
            messageList.add(new Message("ProductCmptLinkContainerDuplicateRelationTarget", msg, Message.ERROR, (Object)association.getTargetRoleSingular()));
        }
    }

    protected void addMessageIfMoreLinksThanMaxCard(IAssociation association, List<IProductCmptLink> relations, MessageList messageList) {
        int maxCardinality = association.getMaxCardinality();
        if (maxCardinality < relations.size()) {
            String associationLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(association);
            Object[] params = new Object[]{relations.size(), "" + maxCardinality, associationLabel};
            String msg = MessageFormat.format(Messages.ProductCmptGeneration_msgTooManyRelations, params);
            ObjectProperty prop1 = new ObjectProperty((Object)this, null);
            ObjectProperty prop2 = new ObjectProperty((Object)association.getTargetRoleSingular(), null);
            messageList.add(new Message("ProductCmptLinkContainerToManyRelations", msg, Message.ERROR, new ObjectProperty[]{prop1, prop2}));
        }
    }

    protected void addMessageIfLessLinksThanMinCard(IAssociation association, List<IProductCmptLink> relations, MessageList messageList) {
        int minCardinality = association.getMinCardinality();
        if (!this.linkContainer.isProductTemplate() && minCardinality > relations.size()) {
            this.addBelowMinCardinalityErrorMessage(association, relations, messageList, minCardinality);
        }
    }

    protected void addBelowMinCardinalityErrorMessage(IAssociation association, List<IProductCmptLink> relations, MessageList messageList, int minCardinality) {
        String associationLabel = IIpsModel.get().getMultiLanguageSupport().getLocalizedLabel(association);
        Object[] params = new Object[]{relations.size(), associationLabel, minCardinality};
        String msg = MessageFormat.format(Messages.ProductCmptGeneration_msgNotEnoughRelations, params);
        ObjectProperty prop1 = new ObjectProperty((Object)this, null);
        ObjectProperty prop2 = new ObjectProperty((Object)association.getTargetRoleSingular(), null);
        messageList.add(new Message("ProductCmptLinkContainerNotEnoughRelations", msg, Message.ERROR, new ObjectProperty[]{prop1, prop2}));
    }

    protected void addMessageIfAssociationHasValidationMessages(IAssociation association, MessageList messageList) {
        MessageList relMessages = this.getErrorMessagesFor(association);
        if (!relMessages.isEmpty()) {
            messageList.add(relMessages, new ObjectProperty((Object)association.getTargetRoleSingular(), null), true);
        }
    }

    protected void addMessageIfTargetNotValidOnValidFromDate(IAssociation association, List<IProductCmptLink> links, MessageList msgList) {
        for (IProductCmptLink link : links) {
            IProductCmpt productCmpt;
            if (association == null || association.isAssoziation() || (productCmpt = link.findTarget(this.linkContainer.getIpsProject())) == null || this.linkContainer.getValidFrom() == null || productCmpt.getGenerationEffectiveOn(this.linkContainer.getValidFrom()) != null) continue;
            String dateString = IIpsModelExtensions.get().getModelPreferences().getDateFormat().format(this.linkContainer.getValidFrom().getTime());
            String generationName = IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNameSingular();
            String text = productCmpt.findProductCmptType(this.getIpsProject()).isChangingOverTime() ? MessageFormat.format(Messages.ProductCmptGeneration_msgNoGenerationInLinkedTargetForEffectiveDate, productCmpt.getQualifiedName(), generationName, dateString) : MessageFormat.format(Messages.ProductCmptGeneration_msgEffectiveDateInLinkedTargetAfterEffectiveDate, productCmpt.getQualifiedName(), dateString);
            msgList.add(new Message("ProductCmptLinkContainerLinksWithWrongEffectivDate", text, Message.ERROR, (Object)link));
        }
    }

    private MessageList getErrorMessagesFor(IAssociation association) {
        MessageList errorList = association.validate(this.getIpsProject());
        return errorList.getMessagesBySeverity(Severity.ERROR);
    }
}

